/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.extraboats.entity;

import com.markus1002.extraboats.Reference;
import com.markus1002.extraboats.client.renderer.entity.LargeBoatRenderer;
import com.markus1002.extraboats.client.renderer.entity.ModBoatRenderer;
import com.markus1002.extraboats.entity.item.boat.ChestBoatEntity;
import com.markus1002.extraboats.entity.item.boat.FurnaceBoatEntity;
import com.markus1002.extraboats.entity.item.boat.LargeBoatEntity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEntities {
    public static final EntityType<ChestBoatEntity> CHEST_BOAT = EntityType.Builder.func_220322_a(ChestBoatEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.375f, 0.5625f).setCustomClientFactory((spawnEntity, worldIn) -> new ChestBoatEntity((FMLPlayMessages.SpawnEntity)spawnEntity, (World)worldIn)).func_206830_a(Reference.location("chest_boat").toString());
    public static final EntityType<FurnaceBoatEntity> FURNACE_BOAT = EntityType.Builder.func_220322_a(FurnaceBoatEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.375f, 0.5625f).setCustomClientFactory((spawnEntity, worldIn) -> new FurnaceBoatEntity((FMLPlayMessages.SpawnEntity)spawnEntity, (World)worldIn)).func_206830_a(Reference.location("furnace_boat").toString());
    public static final EntityType<LargeBoatEntity> LARGE_BOAT = EntityType.Builder.func_220322_a(LargeBoatEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(2.4f, 0.5625f).setCustomClientFactory((spawnEntity, worldIn) -> new LargeBoatEntity((FMLPlayMessages.SpawnEntity)spawnEntity, (World)worldIn)).func_206830_a(Reference.location("large_boat").toString());

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        ModEntities.registerEntity(CHEST_BOAT, "chest_boat");
        ModEntities.registerEntity(FURNACE_BOAT, "furnace_boat");
        ModEntities.registerEntity(LARGE_BOAT, "large_boat");
    }

    private static void registerEntity(EntityType<?> entity, String name) {
        entity.setRegistryName(Reference.location(name));
        ForgeRegistries.ENTITIES.register(entity);
    }

    public static void setupEntitiesClient() {
        RenderingRegistry.registerEntityRenderingHandler(ChestBoatEntity.class, ModBoatRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(FurnaceBoatEntity.class, ModBoatRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(LargeBoatEntity.class, LargeBoatRenderer::new);
    }
}

