/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.extraboats.client.renderer.entity;

import com.markus1002.extraboats.entity.item.boat.ModBoatEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.BoatModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModBoatRenderer<T extends ModBoatEntity>
extends EntityRenderer<T> {
    private static final ResourceLocation[] BOAT_TEXTURES = new ResourceLocation[]{new ResourceLocation("textures/entity/boat/oak.png"), new ResourceLocation("textures/entity/boat/spruce.png"), new ResourceLocation("textures/entity/boat/birch.png"), new ResourceLocation("textures/entity/boat/jungle.png"), new ResourceLocation("textures/entity/boat/acacia.png"), new ResourceLocation("textures/entity/boat/dark_oak.png"), new ResourceLocation("biomesoplenty", "textures/entity/boat/cherry.png"), new ResourceLocation("biomesoplenty", "textures/entity/boat/dead.png"), new ResourceLocation("biomesoplenty", "textures/entity/boat/ethereal.png"), new ResourceLocation("biomesoplenty", "textures/entity/boat/fir.png"), new ResourceLocation("biomesoplenty", "textures/entity/boat/hellbark.png"), new ResourceLocation("biomesoplenty", "textures/entity/boat/jacaranda.png"), new ResourceLocation("biomesoplenty", "textures/entity/boat/magic.png"), new ResourceLocation("biomesoplenty", "textures/entity/boat/mahogany.png"), new ResourceLocation("biomesoplenty", "textures/entity/boat/palm.png"), new ResourceLocation("biomesoplenty", "textures/entity/boat/redwood.png"), new ResourceLocation("biomesoplenty", "textures/entity/boat/umbran.png"), new ResourceLocation("biomesoplenty", "textures/entity/boat/willow.png"), new ResourceLocation("upgrade_aquatic", "textures/entity/boat/driftwood_boat.png"), new ResourceLocation("bambooblocks", "textures/entity/boat/bamboo_boat.png"), new ResourceLocation("endergetic", "textures/entity/boat/poise_boat.png"), new ResourceLocation("bloomful", "textures/entity/boat/wisteria_boat.png"), new ResourceLocation("swampexpansion", "textures/entity/boat/willow_boat.png"), new ResourceLocation("atmospheric", "textures/entity/boat/rosewood_boat.png"), new ResourceLocation("atmospheric", "textures/entity/boat/aspen_boat.png"), new ResourceLocation("atmospheric", "textures/entity/boat/kousa_boat.png"), new ResourceLocation("atmospheric", "textures/entity/boat/yucca_boat.png"), new ResourceLocation("autumnity", "textures/entity/boat/maple.png")};
    protected final BoatModel field_76998_a = new BoatModel();

    public ModBoatRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
        this.field_76989_e = 0.8f;
    }

    public void doRender(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.pushMatrix();
        this.setupTranslation(x, y, z);
        this.setupRotation(entity, entityYaw, partialTicks);
        this.func_180548_c((Entity)entity);
        BlockState blockstate = ((ModBoatEntity)((Object)entity)).getDisplayTile();
        if (blockstate.func_185901_i() != BlockRenderType.INVISIBLE) {
            GlStateManager.pushMatrix();
            this.func_110776_a(AtlasTexture.field_110575_b);
            GlStateManager.scalef((float)-0.75f, (float)-0.75f, (float)0.75f);
            GlStateManager.rotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.translatef((float)-1.1f, (float)-0.1875f, (float)0.5f);
            this.renderBoatContents(entity, partialTicks, blockstate);
            GlStateManager.popMatrix();
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_180548_c((Entity)entity);
        }
        if (this.field_188301_f) {
            GlStateManager.enableColorMaterial();
            GlStateManager.setupSolidRenderingTextureCombine((int)this.func_188298_c((Entity)entity));
        }
        this.field_76998_a.func_78088_a(entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        if (this.field_188301_f) {
            GlStateManager.tearDownSolidRenderingTextureCombine();
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.popMatrix();
        super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
    }

    public void setupRotation(T entityIn, float entityYaw, float partialTicks) {
        float f2;
        GlStateManager.rotatef((float)(180.0f - entityYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        float f = (float)entityIn.func_70268_h() - partialTicks;
        float f1 = entityIn.func_70271_g() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            GlStateManager.rotatef((float)(MathHelper.func_76126_a((float)f) * f * f1 / 10.0f * (float)entityIn.func_70267_i()), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (!MathHelper.func_180185_a((float)(f2 = entityIn.func_203056_b(partialTicks)), (float)0.0f)) {
            GlStateManager.rotatef((float)entityIn.func_203056_b(partialTicks), (float)1.0f, (float)0.0f, (float)1.0f);
        }
        GlStateManager.scalef((float)-1.0f, (float)-1.0f, (float)1.0f);
    }

    protected void renderBoatContents(T boat, float partialTicks, BlockState contents) {
        GlStateManager.pushMatrix();
        Minecraft.func_71410_x().func_175602_ab().func_175016_a(contents, boat.func_70013_c());
        GlStateManager.popMatrix();
    }

    public void setupTranslation(double x, double y, double z) {
        GlStateManager.translatef((float)((float)x), (float)((float)y + 0.375f), (float)((float)z));
    }

    protected ResourceLocation getEntityTexture(T entity) {
        return BOAT_TEXTURES[((ModBoatEntity)((Object)entity)).getModBoatType().ordinal()];
    }

    public boolean func_188295_H_() {
        return true;
    }

    public void renderMultipass(T entityIn, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.pushMatrix();
        this.setupTranslation(x, y, z);
        this.setupRotation(entityIn, entityYaw, partialTicks);
        this.func_180548_c((Entity)entityIn);
        this.field_76998_a.func_187054_b(entityIn, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.popMatrix();
    }
}

