/*
 * Decompiled with CFR 0.152.
 */
package com.markus1002.extraboats.client.renderer.entity;

import com.markus1002.extraboats.Reference;
import com.markus1002.extraboats.client.renderer.entity.model.LargeBoatModel;
import com.markus1002.extraboats.entity.item.boat.LargeBoatEntity;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LargeBoatRenderer
extends EntityRenderer<LargeBoatEntity> {
    private static final ResourceLocation[] LARGE_BOAT_TEXTURES = new ResourceLocation[]{Reference.location("textures/entity/large_boat/oak.png"), Reference.location("textures/entity/large_boat/spruce.png"), Reference.location("textures/entity/large_boat/birch.png"), Reference.location("textures/entity/large_boat/jungle.png"), Reference.location("textures/entity/large_boat/acacia.png"), Reference.location("textures/entity/large_boat/dark_oak.png"), Reference.location("textures/entity/large_boat/cherry.png"), Reference.location("textures/entity/large_boat/dead.png"), Reference.location("textures/entity/large_boat/ethereal.png"), Reference.location("textures/entity/large_boat/fir.png"), Reference.location("textures/entity/large_boat/hellbark.png"), Reference.location("textures/entity/large_boat/jacaranda.png"), Reference.location("textures/entity/large_boat/magic.png"), Reference.location("textures/entity/large_boat/mahogany.png"), Reference.location("textures/entity/large_boat/palm.png"), Reference.location("textures/entity/large_boat/redwood.png"), Reference.location("textures/entity/large_boat/umbran.png"), Reference.location("textures/entity/large_boat/willow.png"), Reference.location("textures/entity/large_boat/driftwood.png"), Reference.location("textures/entity/large_boat/bamboo.png"), Reference.location("textures/entity/large_boat/poise.png"), Reference.location("textures/entity/large_boat/wisteria.png"), Reference.location("textures/entity/large_boat/se_willow.png"), Reference.location("textures/entity/large_boat/rosewood.png"), Reference.location("textures/entity/large_boat/aspen.png"), Reference.location("textures/entity/large_boat/kousa.png"), Reference.location("textures/entity/large_boat/yucca.png"), Reference.location("textures/entity/large_boat/maple.png")};
    protected final LargeBoatModel largeBoatModel = new LargeBoatModel();

    public LargeBoatRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
        this.field_76989_e = 0.8f;
    }

    public void doRender(LargeBoatEntity entity, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.pushMatrix();
        this.setupTranslation(x, y, z);
        this.setupRotation(entity, entityYaw, partialTicks);
        this.func_180548_c((Entity)entity);
        if (this.field_188301_f) {
            GlStateManager.enableColorMaterial();
            GlStateManager.setupSolidRenderingTextureCombine((int)this.func_188298_c((Entity)entity));
        }
        this.largeBoatModel.render(entity, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        if (this.field_188301_f) {
            GlStateManager.tearDownSolidRenderingTextureCombine();
            GlStateManager.disableColorMaterial();
        }
        GlStateManager.popMatrix();
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    public void setupRotation(LargeBoatEntity entityIn, float entityYaw, float partialTicks) {
        float f2;
        GlStateManager.rotatef((float)(180.0f - entityYaw), (float)0.0f, (float)1.0f, (float)0.0f);
        float f = (float)entityIn.func_70268_h() - partialTicks;
        float f1 = entityIn.func_70271_g() - partialTicks;
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        if (f > 0.0f) {
            GlStateManager.rotatef((float)(MathHelper.func_76126_a((float)f) * f * f1 / 10.0f * (float)entityIn.func_70267_i()), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        if (!MathHelper.func_180185_a((float)(f2 = entityIn.func_203056_b(partialTicks)), (float)0.0f)) {
            GlStateManager.rotatef((float)entityIn.func_203056_b(partialTicks), (float)1.0f, (float)0.0f, (float)1.0f);
        }
        GlStateManager.scalef((float)-1.0f, (float)-1.0f, (float)1.0f);
    }

    public void setupTranslation(double x, double y, double z) {
        GlStateManager.translatef((float)((float)x), (float)((float)y + 0.375f), (float)((float)z));
    }

    protected ResourceLocation getEntityTexture(LargeBoatEntity entity) {
        return LARGE_BOAT_TEXTURES[entity.getModBoatType().ordinal()];
    }

    public boolean func_188295_H_() {
        return true;
    }

    public void renderMultipass(LargeBoatEntity entityIn, double x, double y, double z, float entityYaw, float partialTicks) {
        GlStateManager.pushMatrix();
        this.setupTranslation(x, y, z);
        this.setupRotation(entityIn, entityYaw, partialTicks);
        this.func_180548_c((Entity)entityIn);
        this.largeBoatModel.renderMultipass((Entity)entityIn, partialTicks, 0.0f, -0.1f, 0.0f, 0.0f, 0.0625f);
        GlStateManager.popMatrix();
    }
}

