/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.letsleepingdogslie.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.ichun.letsleepingdogslie.client.core.EventHandler;
import me.ichun.letsleepingdogslie.client.model.WolfModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.WolfRenderer;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@Mod(value="dogslie")
public class LetSleepingDogsLie {
    public static final String MOD_ID = "dogslie";
    public static final String MOD_NAME = "Let Sleeping Dogs Lie";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker INIT = MarkerManager.getMarker((String)"Init");
    private static final Marker MOD_WOLF_SUPPORT = MarkerManager.getMarker((String)"ModWolfSupport");
    public static Config config;
    public static EventHandler eventHandler;

    public LetSleepingDogsLie() {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            this.setupConfig();
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        });
        DistExecutor.runWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> LOGGER.log(Level.ERROR, "You are loading Let Sleeping Dogs Lie on a server. Let Sleeping Dogs Lie is a client only mod!"));
    }

    private void setupConfig() {
        ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
        config = new Config(configBuilder);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, configBuilder.build(), "dogslie.toml");
    }

    @OnlyIn(value=Dist.CLIENT)
    private void processIMC(InterModProcessEvent event) {
        EntityRenderer renderer;
        if (ModList.get().isLoaded("doggytalents")) {
            LOGGER.error(INIT, "Detected Doggy Talents installed, they have their own lying down mechanic, meaning we're incompatible with them, so we won't do anything!");
            return;
        }
        boolean replaced = false;
        if (((Boolean)LetSleepingDogsLie.config.attemptModWolfSupport.get()).booleanValue()) {
            Map renderers = Minecraft.func_71410_x().func_175598_ae().field_78729_o;
            for (Map.Entry e : renderers.entrySet()) {
                if (e.getKey() == WolfEntity.class || !(e.getValue() instanceof WolfRenderer) || !((net.minecraft.client.renderer.entity.model.WolfModel)((WolfRenderer)e.getValue()).field_77045_g).getClass().equals(net.minecraft.client.renderer.entity.model.WolfModel.class)) continue;
                ((WolfRenderer)e.getValue()).field_77045_g = new WolfModel();
                replaced = true;
                LOGGER.info(MOD_WOLF_SUPPORT, "Overrode " + ((EntityRenderer)e.getValue()).getClass().getSimpleName() + " model.");
            }
        }
        if ((renderer = Minecraft.func_71410_x().func_175598_ae().func_78715_a(WolfEntity.class)) instanceof WolfRenderer) {
            WolfRenderer renderWolf = (WolfRenderer)renderer;
            if (((net.minecraft.client.renderer.entity.model.WolfModel)renderWolf.field_77045_g).getClass().equals(net.minecraft.client.renderer.entity.model.WolfModel.class)) {
                renderWolf.field_77045_g = new WolfModel();
                replaced = true;
                LOGGER.info(INIT, "Overrode Vanilla Wolf model. We are ready!");
            } else {
                LOGGER.error(INIT, "RenderWolf model is not ModelWolf, so we won't do anything!");
            }
        } else {
            LOGGER.error(INIT, "Wolf renderer isn't RenderWolf, so we won't do anything!");
        }
        if (replaced) {
            eventHandler = new EventHandler();
            MinecraftForge.EVENT_BUS.register((Object)eventHandler);
        }
    }

    public class Config {
        public final ForgeConfigSpec.BooleanValue dogsSpawnLying;
        public final ForgeConfigSpec.IntValue timeBeforeLie;
        public final ForgeConfigSpec.DoubleValue rangeBeforeGettingUp;
        public final ForgeConfigSpec.EnumValue<GetsUpFor> getsUpTo;
        public final ForgeConfigSpec.BooleanValue attemptModWolfSupport;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> enabledPoses;

        public Config(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings").push("general");
            this.dogsSpawnLying = builder.comment("Do dogs spawn into the world lying down if they are already sitting.").translation("config.dogslie.prop.dogsSpawnLying.desc").define("dogsSpawnLying", true);
            this.timeBeforeLie = builder.comment("Time to spend sitting (in ticks) before dogs lie down.").translation("config.dogslie.prop.timeBeforeLie.desc").defineInRange("timeBeforeLie", 300, 1, 6000000);
            this.rangeBeforeGettingUp = builder.comment("Range for target to get to dog before dog gets up (in blocks)").translation("config.dogslie.prop.rangeBeforeGettingUp.desc").defineInRange("rangeBeforeGettingUp", 3.0, 0.0, 32.0);
            this.getsUpTo = builder.comment("Who the dog gets up to").translation("config.dogslie.prop.getsUpTo.desc").defineEnum("getsUpTo", (Enum)GetsUpFor.OWNER);
            this.attemptModWolfSupport = builder.comment("Allow the mod to attempt to add support for mod wolves? (Still doesn't allow support for Doggy Talents)").translation("config.dogslie.prop.attemptModWolfSupport.desc").define("attemptModWolfSupport", true);
            ArrayList<String> defaultPoses = new ArrayList<String>();
            defaultPoses.add("forelegStraight");
            defaultPoses.add("forelegSprawled");
            defaultPoses.add("forelegSprawledBack");
            defaultPoses.add("forelegSkewed");
            defaultPoses.add("forelegSide");
            defaultPoses.add("hindlegStraight");
            defaultPoses.add("hindlegStraightBack");
            defaultPoses.add("hindlegSprawled");
            defaultPoses.add("hindlegSprawledBack");
            defaultPoses.add("hindlegSide");
            this.enabledPoses = builder.comment("Poses for lying down that are enabled. If the mod can't find compatible poses, it will randomly pick one set.").translation("config.dogslie.prop.enabledPoses.desc").defineList("enabledPoses", defaultPoses, x -> x instanceof String && defaultPoses.contains(x));
            builder.pop();
        }
    }

    public static enum GetsUpFor {
        NOBODY,
        OWNER,
        PLAYERS,
        ANY_LIVING_ENTITY;

    }
}

