/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.settings;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.settings.ModOptions;

public class ModSettings {
    public static int ignoreUpdate;
    public static final String format = "\u00a7";
    public static boolean updateNotification;
    public boolean debug = false;
    public boolean detailed_debug = false;
    public boolean lighting = true;
    public boolean loadChunks = true;
    public boolean updateChunks = true;
    public boolean terrainSlopes = true;
    public boolean terrainDepth = true;
    public boolean footsteps = true;
    public boolean flowers = true;
    public boolean compression = false;
    public boolean coordinates = true;
    public int colours = 0;
    public String[] colourNames = new String[]{"gui.xaero_accurate", "gui.xaero_vanilla"};
    public boolean biomeColorsVanillaMode = false;
    public boolean differentiateByServerAddress = true;
    public boolean waypoints = true;

    public void saveSettings() throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(WorldMap.optionsFile));
        writer.println("ignoreUpdate:" + ignoreUpdate);
        writer.println("updateNotification:" + updateNotification);
        writer.println("differentiateByServerAddress:" + this.differentiateByServerAddress);
        writer.println("debug:" + this.debug);
        writer.println("lighting:" + this.lighting);
        writer.println("colours:" + this.colours);
        writer.println("loadChunks:" + this.loadChunks);
        writer.println("updateChunks:" + this.updateChunks);
        writer.println("terrainSlopes:" + this.terrainSlopes);
        writer.println("terrainDepth:" + this.terrainDepth);
        writer.println("footsteps:" + this.footsteps);
        writer.println("flowers:" + this.flowers);
        writer.println("compression:" + this.compression);
        writer.println("coordinates:" + this.coordinates);
        writer.println("biomeColorsVanillaMode:" + this.biomeColorsVanillaMode);
        writer.println("waypoints:" + this.waypoints);
        writer.println("globalVersion:" + WorldMap.globalVersion);
        writer.close();
    }

    public void loadSettings() throws IOException {
        String s;
        if (!WorldMap.optionsFile.exists()) {
            this.saveSettings();
            return;
        }
        BufferedReader reader = new BufferedReader(new FileReader(WorldMap.optionsFile));
        while ((s = reader.readLine()) != null) {
            String[] args = s.split(":");
            try {
                if (args[0].equalsIgnoreCase("ignoreUpdate")) {
                    ignoreUpdate = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("updateNotification")) {
                    updateNotification = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("differentiateByServerAddress")) {
                    this.differentiateByServerAddress = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("debug")) {
                    this.debug = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("lighting")) {
                    this.lighting = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("colours")) {
                    this.colours = Integer.parseInt(args[1]);
                    continue;
                }
                if (args[0].equalsIgnoreCase("loadChunks")) {
                    this.loadChunks = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("updateChunks")) {
                    this.updateChunks = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("terrainSlopes")) {
                    this.terrainSlopes = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("terrainDepth")) {
                    this.terrainDepth = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("footsteps")) {
                    this.footsteps = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("flowers")) {
                    this.flowers = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("compression")) {
                    this.compression = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("coordinates")) {
                    this.coordinates = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("biomeColorsVanillaMode")) {
                    this.biomeColorsVanillaMode = args[1].equals("true");
                    continue;
                }
                if (args[0].equalsIgnoreCase("waypoints")) {
                    this.waypoints = args[1].equals("true");
                    continue;
                }
                if (!args[0].equalsIgnoreCase("globalVersion")) continue;
                WorldMap.globalVersion = Integer.parseInt(args[1]);
            }
            catch (Exception e) {
                WorldMap.LOGGER.info("Skipping setting:" + args[0]);
            }
        }
    }

    public String getKeyBinding(ModOptions par1EnumOptions) {
        String s = par1EnumOptions.getEnumString() + ": ";
        if (par1EnumOptions.getEnumDouble()) {
            double f1 = this.getOptionDoubleValue(par1EnumOptions);
            return s + f1;
        }
        if (par1EnumOptions == ModOptions.COLOURS) {
            s = s + I18n.func_135052_a((String)this.colourNames[this.colours], (Object[])new Object[0]);
        } else {
            boolean clientSetting = this.getClientBooleanValue(par1EnumOptions);
            s = s + ModSettings.getTranslation(clientSetting);
        }
        return s;
    }

    public boolean getClientBooleanValue(ModOptions o) {
        if (o == ModOptions.DEBUG) {
            return this.debug;
        }
        if (o == ModOptions.LIGHTING) {
            return this.lighting;
        }
        if (o == ModOptions.LOAD) {
            return this.loadChunks;
        }
        if (o == ModOptions.UPDATE) {
            return this.updateChunks;
        }
        if (o == ModOptions.DEPTH) {
            return this.terrainDepth;
        }
        if (o == ModOptions.SLOPES) {
            return this.terrainSlopes;
        }
        if (o == ModOptions.STEPS) {
            return this.footsteps;
        }
        if (o == ModOptions.FLOWERS) {
            return this.flowers;
        }
        if (o == ModOptions.COMPRESSION) {
            return this.compression;
        }
        if (o == ModOptions.COORDINATES) {
            return this.coordinates;
        }
        if (o == ModOptions.BIOMES) {
            return this.biomeColorsVanillaMode;
        }
        if (o == ModOptions.WAYPOINTS) {
            return this.waypoints;
        }
        return false;
    }

    private static String getTranslation(boolean o) {
        return I18n.func_135052_a((String)("gui.xaero_" + (o ? "on" : "off")), (Object[])new Object[0]);
    }

    public void setOptionValue(ModOptions par1EnumOptions) {
        if (par1EnumOptions == ModOptions.DEBUG) {
            boolean bl = this.debug = !this.debug;
        }
        if (par1EnumOptions == ModOptions.COLOURS) {
            this.colours = (this.colours + 1) % 2;
            MapProcessor.instance.incrementGlobalVersion();
        }
        if (par1EnumOptions == ModOptions.LIGHTING) {
            boolean bl = this.lighting = !this.lighting;
        }
        if (par1EnumOptions == ModOptions.LOAD) {
            boolean bl = this.loadChunks = !this.loadChunks;
        }
        if (par1EnumOptions == ModOptions.UPDATE) {
            boolean bl = this.updateChunks = !this.updateChunks;
        }
        if (par1EnumOptions == ModOptions.DEPTH) {
            this.terrainDepth = !this.terrainDepth;
            MapProcessor.instance.incrementGlobalVersion();
        }
        if (par1EnumOptions == ModOptions.SLOPES) {
            this.terrainSlopes = !this.terrainSlopes;
            MapProcessor.instance.incrementGlobalVersion();
        }
        if (par1EnumOptions == ModOptions.STEPS) {
            boolean bl = this.footsteps = !this.footsteps;
        }
        if (par1EnumOptions == ModOptions.FLOWERS) {
            boolean bl = this.flowers = !this.flowers;
        }
        if (par1EnumOptions == ModOptions.COMPRESSION) {
            this.compression = !this.compression;
            MapProcessor.instance.incrementGlobalVersion();
        }
        if (par1EnumOptions == ModOptions.COORDINATES) {
            boolean bl = this.coordinates = !this.coordinates;
        }
        if (par1EnumOptions == ModOptions.BIOMES) {
            boolean bl = this.biomeColorsVanillaMode = !this.biomeColorsVanillaMode;
            if (this.colours == 1) {
                MapProcessor.instance.incrementGlobalVersion();
            }
        }
        if (par1EnumOptions == ModOptions.WAYPOINTS) {
            this.waypoints = !this.waypoints;
        }
        try {
            this.saveSettings();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (Minecraft.func_71410_x().field_71462_r != null) {
            Minecraft.func_71410_x().func_147108_a(Minecraft.func_71410_x().field_71462_r);
        }
    }

    public void setOptionDoubleValue(ModOptions options, double f) {
        try {
            this.saveSettings();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public double getOptionDoubleValue(ModOptions options) {
        return 1.0;
    }

    static {
        updateNotification = true;
    }
}

