/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.IceBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.World;
import xaero.map.MapProcessor;
import xaero.map.region.MapBlock;
import xaero.map.region.Overlay;
import xaero.map.region.OverlayManager;

public class OverlayBuilder {
    private static final int MAX_OVERLAYS = 10;
    private Overlay[] overlayBuildingSet;
    private int currentOverlayIndex;
    private OverlayManager overlayManager;
    private TextureAtlasSprite prevIcon;
    private BlockState prevOverlay;
    private int overlayBiome;

    public OverlayBuilder(OverlayManager overlayManager) {
        this.overlayManager = overlayManager;
        this.overlayBuildingSet = new Overlay[10];
        for (int i = 0; i < this.overlayBuildingSet.length; ++i) {
            this.overlayBuildingSet[i] = new Overlay(Blocks.field_150350_a.func_176223_P(), new int[3], 0, 0, false);
        }
        this.currentOverlayIndex = -1;
    }

    public void startBuilding() {
        this.currentOverlayIndex = -1;
        this.prevOverlay = null;
        this.setOverlayBiome(-1);
    }

    public void build(BlockState state, int[] biome, int opacity, byte light, World world) {
        Overlay currentOverlay = null;
        if (this.currentOverlayIndex >= 0) {
            currentOverlay = this.overlayBuildingSet[this.currentOverlayIndex];
        }
        Overlay nextOverlay = null;
        if (this.currentOverlayIndex < this.overlayBuildingSet.length - 1) {
            nextOverlay = this.overlayBuildingSet[this.currentOverlayIndex + 1];
        }
        TextureAtlasSprite icon = null;
        boolean changed = false;
        if (currentOverlay == null || currentOverlay.getState() != state) {
            icon = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(state);
            boolean bl = changed = icon != this.prevIcon;
        }
        if (nextOverlay != null && (currentOverlay == null || changed)) {
            int intensity = state.func_177230_c() instanceof FlowingFluidBlock ? 2 : (state.func_177230_c() instanceof IceBlock ? 5 : 1);
            boolean glowing = false;
            try {
                glowing = MapProcessor.instance.getMapWriter().isGlowing(state);
            }
            catch (Exception exception) {
                // empty catch block
            }
            nextOverlay.write(state, biome, intensity, light, glowing);
            currentOverlay = nextOverlay;
            ++this.currentOverlayIndex;
        }
        currentOverlay.increaseOpacity(opacity);
        if (changed) {
            this.prevIcon = icon;
        }
    }

    public void finishBuilding(MapBlock block) {
        for (int i = 0; i <= this.currentOverlayIndex; ++i) {
            Overlay o = this.overlayBuildingSet[i];
            Overlay original = this.overlayManager.getOriginal(o);
            if (o == original) {
                this.overlayBuildingSet[i] = new Overlay(Blocks.field_150350_a.func_176223_P(), new int[3], 0, 0, false);
            }
            block.addOverlay(original);
        }
    }

    public BlockState getPrevOverlay() {
        return this.prevOverlay;
    }

    public void setPrevOverlay(BlockState prevOverlay) {
        this.prevOverlay = prevOverlay;
    }

    public int getOverlayBiome() {
        return this.overlayBiome;
    }

    public void setOverlayBiome(int overlayBiome) {
        this.overlayBiome = overlayBiome;
    }
}

