/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region;

import com.mojang.blaze3d.platform.GlStateManager;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.exception.OpenGLException;
import xaero.map.file.IOHelper;
import xaero.map.graphics.TextureUploader;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;

public class MapTileChunk {
    public static final int SIDE_LENGTH = 4;
    private static final int PBO_UNPACK_LENGTH = 16384;
    public static final int PBO_PACK_LENGTH = 16384;
    private MapRegion inRegion;
    private byte loadState = 0;
    private int X;
    private int Z;
    private MapTile[][] tiles = new MapTile[4][4];
    private byte[][] tileGridsCache = new byte[this.tiles.length][this.tiles.length];
    private int glColorTexture;
    private int glLightTexture;
    private ByteBuffer colorBuffer;
    private ByteBuffer lightBuffer;
    private boolean toUpload;
    private boolean lightBufferPrepared;
    private int colorBufferFormat;
    private boolean colorBufferIsCompressed;
    private byte[][] heightValues;
    private int heightValueMask;
    private byte topTileSuccessMask;
    private boolean cachePrepared;
    private boolean updatingBuffers;
    private boolean changed;
    private Object updateBuffersSync;
    private int packPbo;
    private int[] unpackPbo;
    private boolean shouldDownloadFromPBO;
    private int timer;
    private boolean includeInSave;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapTileChunk(MapRegion r, int x, int z) {
        this.X = x;
        this.Z = z;
        this.inRegion = r;
        this.updateBuffersSync = new Object();
        this.unpackPbo = new int[2];
        this.glColorTexture = -1;
        this.glLightTexture = -1;
        this.colorBufferFormat = -1;
        this.heightValues = new byte[64][64];
        MapRegion mapRegion = r;
        synchronized (mapRegion) {
            r.setAllCachePrepared(false);
        }
    }

    public ByteBuffer createBuffer() {
        return BufferUtils.createByteBuffer((int)16384);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateBuffers(World world) {
        Object object = this.updateBuffersSync;
        synchronized (object) {
            Object object2 = this;
            synchronized (object2) {
                this.updatingBuffers = true;
            }
            if (WorldMap.settings.detailed_debug) {
                WorldMap.LOGGER.info("Updating buffers: " + this.X + " " + this.Z + " " + this.loadState);
            }
            object2 = this.inRegion;
            synchronized (object2) {
                this.cachePrepared = false;
                this.shouldDownloadFromPBO = false;
                this.inRegion.setAllCachePrepared(false);
            }
            if (this.colorBuffer != null) {
                this.colorBuffer.clear();
                BufferUtils.zeroBuffer((ByteBuffer)this.colorBuffer);
            } else {
                this.colorBuffer = this.createBuffer();
            }
            if (this.lightBuffer != null) {
                this.lightBuffer.clear();
                BufferUtils.zeroBuffer((ByteBuffer)this.lightBuffer);
            } else {
                this.lightBuffer = this.createBuffer();
            }
            int[] result = this.inRegion.getPixelResultBuffer();
            boolean hasLight = false;
            BlockPos.MutableBlockPos mutableGlobalPos = this.inRegion.getMutableGlobalPos();
            this.topTileSuccessMask = (byte)15;
            MapTileChunk prevTileChunk = null;
            for (int o = 0; o < this.tiles.length; ++o) {
                int offX = o * 16;
                for (int p = 0; p < this.tiles.length; ++p) {
                    MapTile tile = this.tiles[o][p];
                    if (tile == null || !tile.isLoaded()) continue;
                    int offZ = p * 16;
                    if (tile.getPrevTile() == null || p == 0 && (this.Z & 7) == 0) {
                        prevTileChunk = this.findPrevTile(null, tile, o, p);
                    }
                    for (int z = 0; z < 16; ++z) {
                        for (int x = 0; x < 16; ++x) {
                            tile.getBlock(x, z).getPixelColour(result, MapProcessor.instance.getMapWriter(), world, this, prevTileChunk, tile.getPrevTile(), tile, x, z, mutableGlobalPos);
                            this.putColour(offX + x, offZ + z, result[0], result[1], result[2], this.colorBuffer, 64);
                            if (result[3] != 0) {
                                hasLight = true;
                            }
                            this.putColour(offX + x, offZ + z, result[3], result[3], result[3], this.lightBuffer, 64);
                        }
                    }
                }
            }
            if (!hasLight) {
                this.deleteLightBuffer();
            }
            this.colorBufferFormat = -1;
            this.colorBufferIsCompressed = false;
            this.toUpload = true;
            this.lightBufferPrepared = hasLight;
            MapTileChunk mapTileChunk = this;
            synchronized (mapTileChunk) {
                this.updatingBuffers = false;
            }
        }
    }

    public boolean bindColorTexture(boolean create, int magFilter) {
        boolean result = false;
        if (this.glColorTexture == -1) {
            if (create) {
                this.glColorTexture = GL11.glGenTextures();
                result = true;
            } else {
                return false;
            }
        }
        GlStateManager.bindTexture((int)this.glColorTexture);
        if (result) {
            this.setupTextureParameters();
        }
        GL11.glTexParameteri((int)3553, (int)10240, (int)magFilter);
        return true;
    }

    public void bindLightTexture(boolean create, int magFilter) {
        boolean result = false;
        if (this.glLightTexture == -1) {
            if (create) {
                this.glLightTexture = GL11.glGenTextures();
                result = true;
            } else {
                GlStateManager.bindTexture((int)0);
                return;
            }
        }
        GlStateManager.bindTexture((int)this.glLightTexture);
        if (result) {
            this.setupTextureParameters();
        }
        GL11.glTexParameteri((int)3553, (int)10240, (int)magFilter);
    }

    private void setupTextureParameters() {
        GL11.glTexParameteri((int)3553, (int)33084, (int)0);
        GL11.glTexParameteri((int)3553, (int)33085, (int)1);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)1.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        if (!GL.getCapabilities().OpenGL30) {
            GL11.glTexParameteri((int)3553, (int)33169, (int)1);
        }
        GL11.glTexParameteri((int)3553, (int)10241, (int)9984);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
    }

    public long uploadBuffer(TextureUploader textureUploader) throws OpenGLException, IllegalArgumentException, IllegalAccessException {
        if (WorldMap.settings.detailed_debug) {
            System.out.println("Uploading buffer: " + this.X + " " + this.Z + " " + this.colorBufferFormat + " " + this.colorBufferIsCompressed);
        }
        if (this.colorBufferFormat != -1) {
            int length = this.colorBuffer.remaining();
            this.writeToUnpackPBO(0, this.colorBuffer);
            boolean isCompressed = this.colorBufferIsCompressed;
            int internalFormat = this.colorBufferFormat;
            this.colorBufferIsCompressed = false;
            this.colorBufferFormat = -1;
            this.bindColorTexture(true, 9728);
            OpenGLException.checkGLError();
            long totalEstimatedTime = 0L;
            totalEstimatedTime = isCompressed ? textureUploader.requestCompressed(this.glColorTexture, this.unpackPbo[0], 3553, 0, internalFormat, 64, 64, 0, 0L, length) : textureUploader.requestNormal(this.glColorTexture, this.unpackPbo[0], 3553, 0, internalFormat, 64, 64, 0, 0L, 32993, 32821);
            return totalEstimatedTime += this.requestLightBufferUpload(textureUploader);
        }
        if (!this.shouldDownloadFromPBO) {
            long totalEstimatedTime;
            this.writeToUnpackPBO(0, this.colorBuffer);
            if (WorldMap.settings.compression) {
                this.timer = 5;
                this.shouldDownloadFromPBO = true;
                this.bindPackPBO();
                this.unbindPackPBO();
                this.bindColorTexture(true, 9728);
                OpenGLException.checkGLError();
                totalEstimatedTime = textureUploader.requestNormalWithDownload(this.glColorTexture, this.unpackPbo[0], 3553, 0, 34029, 64, 64, 0, 0L, 32993, 32821, this.packPbo);
            } else {
                this.colorBuffer.position(0);
                this.colorBufferFormat = 32856;
                this.bindColorTexture(true, 9728);
                OpenGLException.checkGLError();
                totalEstimatedTime = textureUploader.requestNormal(this.glColorTexture, this.unpackPbo[0], 3553, 0, 32856, 64, 64, 0, 0L, 32993, 32821);
            }
            return totalEstimatedTime += this.requestLightBufferUpload(textureUploader);
        }
        int glTexture = this.glColorTexture;
        GlStateManager.bindTexture((int)glTexture);
        int isCompressed = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)34465);
        int length = isCompressed == 1 ? GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)34464) : 16384;
        OpenGLException.checkGLError();
        this.bindPackPBO();
        ByteBuffer mappedPBO = GL15.glMapBuffer((int)35051, (int)35000);
        OpenGLException.checkGLError();
        this.colorBuffer.clear();
        mappedPBO.limit(length);
        this.colorBuffer.put(mappedPBO);
        this.colorBuffer.flip();
        GL15.glUnmapBuffer((int)35051);
        OpenGLException.checkGLError();
        this.unbindPackPBO();
        OpenGLException.checkGLError();
        int format = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4099);
        OpenGLException.checkGLError();
        this.colorBufferFormat = format;
        if (format == -1) {
            throw new RuntimeException("Invalid texture internal format returned by the driver.");
        }
        this.colorBufferIsCompressed = isCompressed == 1;
        this.shouldDownloadFromPBO = false;
        return 0L;
    }

    private long requestLightBufferUpload(TextureUploader textureUploader) throws OpenGLException {
        if (this.lightBufferPrepared) {
            this.writeToUnpackPBO(1, this.lightBuffer);
            this.lightBuffer.position(0);
            this.bindLightTexture(true, 9728);
            this.lightBufferPrepared = false;
            return textureUploader.requestNormal(this.glLightTexture, this.unpackPbo[1], 3553, 0, 6408, 64, 64, 0, 0L, 32993, 32821);
        }
        if (this.glLightTexture != -1) {
            MapProcessor.instance.requestTextureDeletion(this.glLightTexture);
            this.glLightTexture = -1;
        }
        return 0L;
    }

    private void writeToUnpackPBO(int pboIndex, ByteBuffer buffer) throws OpenGLException {
        this.bindUnpackPBO(pboIndex);
        ByteBuffer mappedPBO = GL15.glMapBuffer((int)35052, (int)35001);
        OpenGLException.checkGLError();
        mappedPBO.put(buffer);
        GL15.glUnmapBuffer((int)35052);
        this.unbindUnpackPBO();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCacheData(DataOutputStream output, byte[] usableBuffer, byte[] integerByteBuffer) throws IOException {
        output.write(this.colorBufferIsCompressed ? 1 : 0);
        output.writeInt(this.colorBufferFormat);
        int length = this.colorBuffer.remaining();
        output.writeInt(length);
        this.colorBuffer.get(usableBuffer, 0, length);
        output.write(usableBuffer, 0, length);
        if (this.lightBuffer != null) {
            int lightLength = this.lightBuffer.remaining();
            output.writeInt(lightLength);
            this.lightBuffer.get(usableBuffer, 0, lightLength);
            output.write(usableBuffer, 0, lightLength);
        } else {
            output.writeInt(0);
        }
        output.writeInt(this.heightValueMask);
        for (int i = 0; i < 64; ++i) {
            output.write(this.heightValues[i], 0, 64);
        }
        if ((this.Z & 7) == 0) {
            output.write(this.topTileSuccessMask);
        }
        this.deleteBuffers();
        MapRegion mapRegion = this.inRegion;
        synchronized (mapRegion) {
            this.cachePrepared = false;
            this.inRegion.setAllCachePrepared(false);
        }
    }

    public void readCacheData(int cacheSaveVersion, DataInputStream input, byte[] usableBuffer, byte[] integerByteBuffer) throws IOException {
        int lightLength;
        int i;
        int lightLevelsInCache = cacheSaveVersion < 3 ? 4 : 1;
        for (i = 0; i < lightLevelsInCache; ++i) {
            if (i == 0) {
                this.colorBufferIsCompressed = true;
                if (cacheSaveVersion > 1) {
                    this.colorBufferIsCompressed = input.read() == 1;
                }
                this.colorBufferFormat = input.readInt();
            } else {
                if (cacheSaveVersion > 1) {
                    input.read();
                }
                input.readInt();
            }
            int length = input.readInt();
            IOHelper.readToBuffer(usableBuffer, length, input);
            if (i != 0) continue;
            if (this.colorBuffer == null) {
                this.colorBuffer = this.createBuffer();
            }
            if (length == 16384 && this.colorBufferIsCompressed) {
                this.colorBufferIsCompressed = false;
                this.colorBufferFormat = 32856;
                this.inRegion.setShouldCache(true, "broken texture compression fix");
                this.colorBuffer.clear();
                this.colorBuffer.limit(16384);
                continue;
            }
            this.colorBuffer.put(usableBuffer, 0, length);
            this.colorBuffer.flip();
        }
        if (cacheSaveVersion > 2 && (lightLength = input.readInt()) > 0) {
            IOHelper.readToBuffer(usableBuffer, lightLength, input);
            if (this.lightBuffer == null) {
                this.lightBuffer = this.createBuffer();
            }
            this.lightBuffer.put(usableBuffer, 0, lightLength);
            this.lightBuffer.flip();
            this.lightBufferPrepared = true;
        }
        if (cacheSaveVersion == 4) {
            boolean hasBottomHeightValues;
            boolean bl = hasBottomHeightValues = input.read() == 1;
            if (hasBottomHeightValues) {
                this.heightValueMask = (input.readByte() & 0xFF) << 12;
                byte[] bottomHeights = new byte[64];
                IOHelper.readToBuffer(bottomHeights, 64, input);
                for (int i2 = 0; i2 < 64; ++i2) {
                    this.heightValues[i2][63] = bottomHeights[i2];
                }
            }
        } else if (cacheSaveVersion >= 5) {
            this.heightValueMask = input.readInt();
            for (i = 0; i < 64; ++i) {
                IOHelper.readToBuffer(this.heightValues[i], 64, input);
            }
        }
        if (cacheSaveVersion >= 4 && (this.Z & 7) == 0) {
            this.topTileSuccessMask = input.readByte();
        }
        this.toUpload = true;
        this.loadState = (byte)2;
    }

    public void putColour(int x, int y, int red, int green, int blue, ByteBuffer buffer, int size) {
        int pos = (y * size + x) * 4;
        buffer.putInt(pos, blue << 24 | green << 16 | red << 8 | 0xFF);
    }

    public MapTileChunk findPrevTile(MapRegion prevRegion, MapTile tile, int o, int p) {
        if (p > 0) {
            tile.setPrevTile(this.tiles[o][p - 1]);
        } else {
            int chunkXInsideRegion = this.X & 7;
            int chunkZInsideRegion = this.Z & 7;
            MapTileChunk prevTileChunk = null;
            if (chunkZInsideRegion <= 0) {
                if (prevRegion == null) {
                    prevRegion = MapProcessor.instance.getMapRegion(this.inRegion.getRegionX(), this.inRegion.getRegionZ() - 1, false);
                }
                if (prevRegion != null) {
                    prevTileChunk = prevRegion.getChunk(chunkXInsideRegion, 7);
                }
                return prevTileChunk;
            }
            prevTileChunk = this.inRegion.getChunk(chunkXInsideRegion, chunkZInsideRegion - 1);
            if (prevTileChunk != null) {
                tile.setPrevTile(prevTileChunk.tiles[o][prevTileChunk.tiles.length - 1]);
            }
        }
        return null;
    }

    private void bindPackPBO() {
        boolean created = false;
        if (this.packPbo == 0) {
            this.packPbo = GL15.glGenBuffers();
            created = true;
        }
        GL15.glBindBuffer((int)35051, (int)this.packPbo);
        if (created) {
            GL15.glBufferData((int)35051, (long)16384L, (int)35041);
        }
    }

    private void bindUnpackPBO(int index) {
        boolean created = false;
        if (this.unpackPbo[index] == 0) {
            this.unpackPbo[index] = GL15.glGenBuffers();
            created = true;
        }
        GL15.glBindBuffer((int)35052, (int)this.unpackPbo[index]);
        if (created) {
            GL15.glBufferData((int)35052, (long)16384L, (int)35040);
        }
    }

    private void unbindPackPBO() {
        GL15.glBindBuffer((int)35051, (int)0);
    }

    private void unbindUnpackPBO() {
        GL15.glBindBuffer((int)35052, (int)0);
    }

    public void deletePBOs() {
        if (this.packPbo > 0) {
            MapProcessor.instance.requestBufferToDelete(this.packPbo);
        }
        this.packPbo = 0;
        for (int i = 0; i < this.unpackPbo.length; ++i) {
            if (this.unpackPbo[i] <= 0) continue;
            MapProcessor.instance.requestBufferToDelete(this.unpackPbo[i]);
            this.unpackPbo[i] = 0;
        }
    }

    public void clean() {
        for (int o = 0; o < 4; ++o) {
            for (int p = 0; p < 4; ++p) {
                MapTile tile = this.tiles[o][p];
                if (tile == null) continue;
                if (tile.getPrevTile() != null) {
                    tile.setPrevTile(null);
                }
                MapProcessor.instance.getTilePool().addToPool(tile);
                this.tiles[o][p] = null;
            }
        }
        this.includeInSave = false;
    }

    public int getX() {
        return this.X;
    }

    public int getZ() {
        return this.Z;
    }

    public byte[][] getTileGridsCache() {
        return this.tileGridsCache;
    }

    public int getLoadState() {
        return this.loadState;
    }

    public void setLoadState(byte loadState) {
        this.loadState = loadState;
    }

    public boolean shouldUpload() {
        return this.toUpload;
    }

    public void setToUpload(boolean value) {
        this.toUpload = value;
    }

    public ByteBuffer getColorBuffer() {
        return this.colorBuffer;
    }

    public void deleteBuffers() {
        MapProcessor.instance.getBufferDeallocator().deallocate(this.colorBuffer, WorldMap.settings.debug);
        this.colorBuffer = null;
        this.deleteLightBuffer();
    }

    private void deleteLightBuffer() {
        if (this.lightBuffer != null) {
            MapProcessor.instance.getBufferDeallocator().deallocate(this.lightBuffer, WorldMap.settings.debug);
            this.lightBuffer = null;
        }
    }

    public boolean isCachePrepared() {
        return this.cachePrepared;
    }

    public void setCachePrepared(boolean cachePrepared) {
        this.cachePrepared = cachePrepared;
    }

    public boolean isUpdatingBuffers() {
        return this.updatingBuffers;
    }

    public MapTile getTile(int x, int z) {
        return this.tiles[x][z];
    }

    public void setTile(int x, int z, MapTile tile) {
        if (tile != null) {
            this.includeInSave = true;
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    this.heightValues[x * 16 + i][z * 16 + j] = tile.getBlock(i, j).getSignedHeight();
                }
            }
            this.heightValueMask |= 1 << x + (z << 2);
        } else if (this.tiles[x][z] != null) {
            this.heightValueMask ^= 1 << x + (z << 2);
        }
        this.tiles[x][z] = tile;
    }

    public MapRegion getInRegion() {
        return this.inRegion;
    }

    public byte getSuccessMask() {
        return this.topTileSuccessMask;
    }

    public void setUnsuccessful(int x) {
        if ((this.topTileSuccessMask >> x & 1) != 0) {
            this.topTileSuccessMask = (byte)(this.topTileSuccessMask - (1 << x));
        }
    }

    public boolean wasChanged() {
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    public int getGlColorTexture() {
        return this.glColorTexture;
    }

    public boolean getColorBufferIsCompressed() {
        return this.colorBufferIsCompressed;
    }

    public int getColorBufferFormat() {
        return this.colorBufferFormat;
    }

    public int getTimer() {
        return this.timer;
    }

    public void decTimer() {
        --this.timer;
    }

    public boolean shouldDownloadFromPBO() {
        return this.shouldDownloadFromPBO;
    }

    public boolean includeInSave() {
        return this.includeInSave;
    }

    public void unincludeInSave() {
        this.includeInSave = false;
    }

    public ByteBuffer getLightBuffer() {
        return this.lightBuffer;
    }

    public int getGlLightTexture() {
        return this.glLightTexture;
    }

    public void resetMasks() {
        this.heightValueMask = 0;
        this.topTileSuccessMask = 0;
    }

    public int getHeight(int x, int z) {
        if (this.heightValueMask == 0 || (this.heightValueMask & 1 << (x >> 4) + (z >> 4 << 2)) == 0) {
            return -1;
        }
        return this.heightValues[x][z] & 0xFF;
    }

    public int getHeightValueMask() {
        return this.heightValueMask;
    }

    public boolean tileChunkShouldTriggerUpdate(MapTileChunk topChunk) {
        if (this.topTileSuccessMask == 15) {
            return false;
        }
        if (this.topTileSuccessMask != topChunk.heightValueMask >> 12) {
            for (int i = 0; i < 4; ++i) {
                if ((topChunk.heightValueMask >> 12 + i & 1) <= (this.topTileSuccessMask >> i & 1)) continue;
                return true;
            }
        }
        return false;
    }
}

