/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.Color;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.opengl.GL11;
import xaero.map.MapProcessor;
import xaero.map.Misc;
import xaero.map.WorldMap;
import xaero.map.animation.Animation;
import xaero.map.animation.SinAnimation;
import xaero.map.animation.SlowingAnimation;
import xaero.map.controls.ControlsHandler;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.Waypoint;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;

public class GuiMap
extends Screen {
    public static final VertexFormat POSITION_TEX_TEX_TEX = new VertexFormat();
    public static final VertexFormatElement TEX_2F_1 = new VertexFormatElement(1, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.UV, 2);
    public static final VertexFormatElement TEX_2F_2 = new VertexFormatElement(2, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.UV, 2);
    public static final VertexFormatElement TEX_2F_3 = new VertexFormatElement(3, VertexFormatElement.Type.FLOAT, VertexFormatElement.Usage.UV, 2);
    protected static FloatBuffer brightnessBuffer;
    private static final double ZOOM_STEP = 1.2;
    public static final int WAYPOINT_MENU_SIZE = 7;
    private static final Color white;
    private static final Color whiteTrans;
    private static final Color redTrans;
    private static final Color black;
    private static int errorCounter;
    private static int lastAmountOfRegionsViewed;
    private long loadingAnimationStart;
    private PlayerEntity player;
    private double screenScale = 0.0;
    private int mouseDownPosX = -1;
    private int mouseDownPosY = -1;
    private int prevMouseDownPosX = -1;
    private int prevMouseDownPosY = -1;
    private float mouseDownCameraX = -1.0f;
    private float mouseDownCameraZ = -1.0f;
    private long mouseDownStartTimeNano = -1L;
    private long prevMouseDownStartTimeNano = -1L;
    private float cameraX = 0.0f;
    private float cameraZ = 0.0f;
    private int[] cameraDestination = null;
    private SlowingAnimation cameraDestinationAnimX = null;
    private SlowingAnimation cameraDestinationAnimZ = null;
    private double scale = 6.0;
    private double destScale = 3.0;
    private Waypoint viewed = null;
    private float waypointHintAlpha = 0.0f;
    private float waypointHintAlphaDest = 0.0f;
    private Animation zoomAnim = new SlowingAnimation(this.scale, this.destScale, 0.88, 0.001);
    private SlowingAnimation waypointHintAlphaAnim = null;
    private boolean waypointMenu = false;
    private boolean shouldRenderWaypointMenu = false;
    private int waypointMenuSelected = 0;
    private int waypointMenuOffset = 0;
    private Waypoint waypointMenuSelectedObject = null;
    private Animation waypointMenuAnimation = null;
    private StringBuilder waypointMenuSearch = new StringBuilder();
    private Pattern waypointMenuSearchPattern = null;
    private Pattern waypointMenuSearchStartPattern = null;
    private static ImprovedFramebuffer primaryScaleFBO;
    private float[] colourBuffer = new float[4];
    private ArrayList<MapRegion> regionBuffer = new ArrayList();
    private int pressedAtX = -1;
    private int pressedAtY = -1;
    public boolean mouseDown;
    private int mouseBlockPosX;
    private int mouseBlockPosY;
    private int mouseBlockPosZ;
    private long lastStartTime;

    public GuiMap(PlayerEntity player) {
        super((ITextComponent)new TranslationTextComponent("gui.xaero_world_map_screen", new Object[0]));
        this.player = player;
        this.cameraX = (float)player.field_70165_t;
        this.cameraZ = (float)player.field_70161_v;
    }

    public void init() {
        super.init();
        this.loadingAnimationStart = System.currentTimeMillis();
        if (SupportMods.minimap()) {
            SupportMods.xaeroMinimap.requestWaypointsRefresh();
        }
        this.screenScale = Minecraft.func_71410_x().field_195558_d.func_198100_s();
    }

    public boolean mouseClicked(double par1, double par2, int par3) {
        MapProcessor.instance.getMinecraftScheduledTasks().add(() -> {
            if (par3 == 0) {
                this.mouseDown = true;
            }
            this.pressedAtX = (int)this.minecraft.field_71417_B.func_198024_e();
            this.pressedAtY = (int)this.minecraft.field_71417_B.func_198026_f();
        });
        return super.mouseClicked(par1, par2, par3);
    }

    public boolean mouseReleased(double par1, double par2, int par3) {
        MapProcessor.instance.getMinecraftScheduledTasks().add(() -> {
            if (par3 == 0) {
                this.mouseDown = false;
            }
            int mouseX = (int)this.minecraft.field_71417_B.func_198024_e();
            int mouseY = (int)this.minecraft.field_71417_B.func_198026_f();
            if (Math.abs(this.pressedAtX - mouseX) < 5 && Math.abs(this.pressedAtY - mouseY) < 5) {
                this.mapClicked(this.pressedAtX, this.pressedAtY);
            }
            this.pressedAtX = -1;
            this.pressedAtY = -1;
        });
        return super.mouseReleased(par1, par2, par3);
    }

    public boolean mouseScrolled(double par1, double par2, double wheel) {
        MapProcessor.instance.getMinecraftScheduledTasks().add(() -> {
            int direction;
            int n = direction = wheel > 0.0 ? 1 : -1;
            if (this.waypointMenu) {
                this.scrollWaypoints(direction);
            } else {
                this.changeZoom(wheel);
            }
        });
        return super.mouseScrolled(par1, par2, wheel);
    }

    private void scrollWaypoints(int direction) {
        this.waypointMenuSelected += direction;
        if (this.waypointMenuSelected < 0) {
            this.waypointMenuSelected = 0;
        }
        if (this.waypointMenuSelected == this.waypointMenuOffset + 7 - 1) {
            ++this.waypointMenuOffset;
        }
        if (this.waypointMenuOffset > 0 && this.waypointMenuSelected == this.waypointMenuOffset) {
            --this.waypointMenuOffset;
        }
    }

    private void changeZoom(double factor) {
        this.cameraDestinationAnimX = null;
        this.cameraDestinationAnimZ = null;
        this.destScale *= Math.pow(1.2, factor);
        if (this.destScale < 0.5) {
            this.destScale = 0.5;
        } else if (this.destScale > 5.0) {
            this.destScale = 5.0;
        }
    }

    public void removed() {
        super.removed();
        this.mouseDown = false;
    }

    public int getTextureSize(double scale) {
        if (scale >= 1.0) {
            return 16;
        }
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(int scaledMouseX, int scaledMouseY, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        long startTime = System.currentTimeMillis();
        if (!this.waypointMenu) {
            int direction;
            long passed = this.lastStartTime == 0L ? 16L : startTime - this.lastStartTime;
            double passedScrolls = (float)passed / 64.0f;
            int n = ControlsHandler.isDown(ControlsHandler.keyZoomIn) ? 1 : (direction = ControlsHandler.isDown(ControlsHandler.keyZoomOut) ? -1 : 0);
            if (direction != 0) {
                this.changeZoom((double)direction * passedScrolls);
            }
        }
        this.lastStartTime = startTime;
        if (this.cameraDestination != null) {
            this.cameraDestinationAnimX = new SlowingAnimation(this.cameraX, this.cameraDestination[0], 0.9, 0.01);
            this.cameraDestinationAnimZ = new SlowingAnimation(this.cameraZ, this.cameraDestination[1], 0.9, 0.01);
            this.cameraDestination = null;
        }
        if (this.cameraDestinationAnimX != null) {
            this.cameraX = (float)this.cameraDestinationAnimX.getCurrent();
            if ((double)this.cameraX == this.cameraDestinationAnimX.getDestination()) {
                this.cameraDestinationAnimX = null;
            }
        }
        if (this.cameraDestinationAnimZ != null) {
            this.cameraZ = (float)this.cameraDestinationAnimZ.getCurrent();
            if ((double)this.cameraZ == this.cameraDestinationAnimZ.getDestination()) {
                this.cameraDestinationAnimZ = null;
            }
        }
        Object object = MapProcessor.instance.renderThreadPauseSync;
        synchronized (object) {
            if (!MapProcessor.instance.isRenderingPaused()) {
                if (MapProcessor.instance.getCurrentWorldString() != null) {
                    MapRegion region;
                    MapTileChunk chunk;
                    int mouseXPos = (int)(mc.field_71417_B.func_198024_e() * (double)mc.field_195558_d.func_198109_k() / (double)mc.field_195558_d.func_198105_m());
                    int mouseYPos = (int)(mc.field_71417_B.func_198026_f() * (double)mc.field_195558_d.func_198091_l() / (double)mc.field_195558_d.func_198083_n());
                    if (!this.mouseDown) {
                        if (this.mouseDownPosX != -1) {
                            double downTime = System.nanoTime() - this.mouseDownStartTimeNano;
                            int draggedX = mouseXPos - this.mouseDownPosX;
                            int draggedY = mouseYPos - this.mouseDownPosY;
                            if (downTime < 1.6E7 && this.prevMouseDownStartTimeNano != -1L) {
                                downTime = System.nanoTime() - this.prevMouseDownStartTimeNano;
                                draggedX = mouseXPos - this.prevMouseDownPosX;
                                draggedY = mouseYPos - this.prevMouseDownPosY;
                            }
                            double frameTime60FPS = 1.6666666666666666E7;
                            double speedScale = downTime / frameTime60FPS;
                            double speed_x = (double)(-draggedX) / this.scale / speedScale;
                            double speed_z = (double)(-draggedY) / this.scale / speedScale;
                            this.mouseDownPosX = -1;
                            this.prevMouseDownPosX = -1;
                            this.mouseDownPosY = -1;
                            this.prevMouseDownPosX = -1;
                            this.prevMouseDownStartTimeNano = -1L;
                            double speed = Math.sqrt(speed_x * speed_x + speed_z * speed_z);
                            if (speed > 0.0) {
                                double cos = speed_x / speed;
                                double sin = speed_z / speed;
                                speed = Math.abs(speed) > 500.0 ? Math.copySign(500.0, speed) : speed;
                                double speed_factor = 0.9;
                                double ln = Math.log(speed_factor);
                                double move_distance = -speed / ln;
                                double moveX = cos * move_distance;
                                double moveZ = sin * move_distance;
                                this.cameraDestinationAnimX = new SlowingAnimation(this.cameraX, (double)this.cameraX + moveX, 0.9, 0.1);
                                this.cameraDestinationAnimZ = new SlowingAnimation(this.cameraZ, (double)this.cameraZ + moveZ, 0.9, 0.1);
                            }
                        }
                    } else {
                        if (this.mouseDownPosX != -1) {
                            this.cameraX = (float)((double)(this.mouseDownPosX - mouseXPos) / this.scale + (double)this.mouseDownCameraX);
                            this.cameraZ = (float)((double)(this.mouseDownPosY - mouseYPos) / this.scale + (double)this.mouseDownCameraZ);
                        }
                        if (this.mouseDownPosX == -1 || System.nanoTime() - this.mouseDownStartTimeNano > 30000000L) {
                            this.prevMouseDownPosX = this.mouseDownPosX;
                            this.prevMouseDownPosY = this.mouseDownPosY;
                            this.prevMouseDownStartTimeNano = this.mouseDownStartTimeNano;
                            this.mouseDownPosX = mouseXPos;
                            this.mouseDownPosY = mouseYPos;
                            this.mouseDownCameraX = this.cameraX;
                            this.mouseDownCameraZ = this.cameraZ;
                            this.mouseDownStartTimeNano = System.nanoTime();
                            this.cameraDestinationAnimX = null;
                            this.cameraDestinationAnimZ = null;
                        }
                    }
                    int mouseFromCentreX = mouseXPos - mc.field_195558_d.func_198109_k() / 2;
                    int mouseFromCentreY = mouseYPos - mc.field_195558_d.func_198091_l() / 2;
                    double oldMousePosX = (double)mouseFromCentreX / this.scale + (double)this.cameraX;
                    double oldMousePosZ = (double)mouseFromCentreY / this.scale + (double)this.cameraZ;
                    double preScale = this.scale;
                    if (this.destScale != this.scale) {
                        if (this.zoomAnim != null) {
                            this.scale = this.zoomAnim.getCurrent();
                        }
                        if (this.zoomAnim == null || Misc.round(this.zoomAnim.getDestination(), 4) != Misc.round(this.destScale, 4)) {
                            this.zoomAnim = new SinAnimation(this.scale, this.destScale, 100L);
                        }
                    }
                    if (this.scale > preScale) {
                        this.cameraX = (float)(oldMousePosX - (double)mouseFromCentreX / this.scale);
                        this.cameraZ = (float)(oldMousePosZ - (double)mouseFromCentreY / this.scale);
                    }
                    GlStateManager.pushMatrix();
                    double mousePosX = (double)mouseFromCentreX / this.scale + (double)this.cameraX;
                    double mousePosZ = (double)mouseFromCentreY / this.scale + (double)this.cameraZ;
                    GlStateManager.pushMatrix();
                    GlStateManager.translatef((float)0.0f, (float)0.0f, (float)500.0f);
                    this.drawString(mc.field_71466_p, (double)Math.round(this.destScale * 100.0) / 100.0 + "x", 2, 2, white.hashCode());
                    this.mouseBlockPosX = (int)Math.floor(mousePosX);
                    this.mouseBlockPosZ = (int)Math.floor(mousePosZ);
                    int mouseRegX = this.mouseBlockPosX >> 9;
                    int mouseRegZ = this.mouseBlockPosZ >> 9;
                    MapRegion reg = MapProcessor.instance.getMapRegion(mouseRegX, mouseRegZ, false);
                    MapTileChunk mapTileChunk = chunk = reg != null ? reg.getChunk(this.mouseBlockPosX >> 6 & 7, this.mouseBlockPosZ >> 6 & 7) : null;
                    if (WorldMap.settings.debug) {
                        if (reg != null) {
                            if (chunk != null) {
                                MapBlock block;
                                this.drawString(mc.field_71466_p, chunk.getX() + " " + chunk.getZ(), 5, 15, white.hashCode());
                                this.drawString(mc.field_71466_p, "loadState: " + chunk.getLoadState(), 5, 25, white.hashCode());
                                this.drawString(mc.field_71466_p, "shouldUpload: " + chunk.shouldUpload(), 5, 35, white.hashCode());
                                this.drawString(mc.field_71466_p, String.format("buffers exist: %s, %s", chunk.getColorBuffer() != null, chunk.getLightBuffer() != null), 5, 45, white.hashCode());
                                this.drawString(mc.field_71466_p, "glColorTexture: " + chunk.getGlColorTexture() + " glLightTexture: " + chunk.getGlLightTexture(), 5, 55, white.hashCode());
                                this.drawString(mc.field_71466_p, String.format("success mask: %s bhv mask: %d", chunk.getSuccessMask(), chunk.getHeightValueMask() >> 12), 5, 65, white.hashCode());
                                this.drawString(mc.field_71466_p, String.format("changed: %s include: %s", chunk.wasChanged(), chunk.includeInSave()), 5, 75, white.hashCode());
                                this.drawString(mc.field_71466_p, "cachePrepared: " + chunk.isCachePrepared(), 5, 85, white.hashCode());
                                MapTile mouseTile = chunk.getTile(this.mouseBlockPosX >> 4 & 3, this.mouseBlockPosZ >> 4 & 3);
                                if (mouseTile != null && (block = mouseTile.getBlock(this.mouseBlockPosX & 0xF, this.mouseBlockPosZ & 0xF)) != null) {
                                    this.drawCenteredString(mc.field_71466_p, block.toString(), this.width / 2, 12, white.hashCode());
                                    if (block.getNumberOfOverlays() != 0) {
                                        for (int i = 0; i < block.getOverlays().size(); ++i) {
                                            this.drawCenteredString(mc.field_71466_p, block.getOverlays().get(i).toString(), this.width / 2, 22 + i * 10, white.hashCode());
                                        }
                                    }
                                }
                            }
                            this.drawString(mc.field_71466_p, "paused: " + reg.isWritingPaused(), 5, 105, white.hashCode());
                            this.drawString(mc.field_71466_p, String.format("writing: %s refreshing: %s", reg.isBeingWritten(), reg.isRefreshing()), 5, 115, white.hashCode());
                            this.drawString(mc.field_71466_p, "shouldCache: " + reg.shouldCache(), 5, 125, white.hashCode());
                            this.drawString(mc.field_71466_p, "saveExists: " + reg.getSaveExists(), 5, 135, white.hashCode());
                            this.drawString(mc.field_71466_p, mouseRegX + " " + mouseRegZ, 5, 145, white.hashCode());
                            this.drawString(mc.field_71466_p, String.format("reg loadState: %s version: %d/%d", reg.getLoadState(), reg.getVersion(), MapProcessor.instance.getGlobalVersion()), 5, 155, white.hashCode());
                            this.drawString(mc.field_71466_p, "processed: " + MapProcessor.instance.getToProcess().contains(reg), 5, 165, white.hashCode());
                            this.drawString(mc.field_71466_p, String.format("recache: %s reload: %s", reg.recacheHasBeenRequested(), reg.reloadHasBeenRequested()), 5, 175, white.hashCode());
                        }
                        if (MapProcessor.instance.getCurrentWorldString().split("_").length > 3) {
                            this.drawString(mc.field_71466_p, "MultiWorld ID: " + MapProcessor.instance.getCurrentWorldString().split("_")[3], 5, 185, white.hashCode());
                        }
                        this.drawString(mc.field_71466_p, String.format("regions: %d processed: %d viewed: %d", MapProcessor.instance.getCurrentMapList(MapProcessor.instance.getCurrentDimension()).size(), MapProcessor.instance.getToProcess().size(), lastAmountOfRegionsViewed), 5, 195, white.hashCode());
                        this.drawString(mc.field_71466_p, String.format("toLoad: %d toSave: %d tile pool: %d overlays: %d", MapProcessor.instance.getMapSaveLoad().getSizeOfToLoad(), MapProcessor.instance.getMapSaveLoad().getToSave().size(), MapProcessor.instance.getTilePool().size(), MapProcessor.instance.getOverlayManager().getNumberOfUniqueOverlays()), 5, 205, white.hashCode());
                        long i = Runtime.getRuntime().maxMemory();
                        long j = Runtime.getRuntime().totalMemory();
                        long k = Runtime.getRuntime().freeMemory();
                        long l = j - k;
                        this.drawString(mc.field_71466_p, String.format("FPS: %d", Minecraft.func_175610_ah()), 5, 225, white.hashCode());
                        this.drawString(mc.field_71466_p, String.format("Mem: % 2d%% %03d/%03dMB", l * 100L / i, GuiMap.bytesToMb(l), GuiMap.bytesToMb(i)), 5, 235, white.hashCode());
                        this.drawString(mc.field_71466_p, String.format("Allocated: % 2d%% %03dMB", j * 100L / i, GuiMap.bytesToMb(j)), 5, 245, white.hashCode());
                        this.drawString(mc.field_71466_p, String.format("Available VRAM: %dMB", MapProcessor.instance.getMapLimiter().getAvailableVRAM() / 1024), 5, 255, white.hashCode());
                    }
                    this.mouseBlockPosY = chunk != null ? chunk.getHeight(this.mouseBlockPosX & 0x3F, this.mouseBlockPosZ & 0x3F) : -1;
                    if (WorldMap.settings.coordinates) {
                        String coordsString = "X: " + this.mouseBlockPosX;
                        if (this.mouseBlockPosY != -1) {
                            coordsString = coordsString + " Y: " + this.mouseBlockPosY;
                        }
                        coordsString = coordsString + " Z: " + this.mouseBlockPosZ;
                        this.drawCenteredString(mc.field_71466_p, coordsString, this.width / 2, 2, white.hashCode());
                    }
                    GlStateManager.popMatrix();
                    int preferredTextureSize = this.getTextureSize(this.scale);
                    if (primaryScaleFBO == null || GuiMap.primaryScaleFBO.field_147621_c != mc.field_195558_d.func_198109_k() || GuiMap.primaryScaleFBO.field_147618_d != mc.field_195558_d.func_198091_l()) {
                        primaryScaleFBO = new ImprovedFramebuffer(mc.field_195558_d.func_198109_k(), mc.field_195558_d.func_198091_l(), false);
                    }
                    double fboScale = 0.5;
                    if (preferredTextureSize > 8) {
                        fboScale = Math.max(1.0, Math.floor(this.scale));
                    }
                    double secondaryScale = this.scale / fboScale;
                    if (GuiMap.primaryScaleFBO.field_147616_f == -1) {
                        GlStateManager.popMatrix();
                        return;
                    }
                    primaryScaleFBO.func_147610_a(false);
                    GuiMap.fill((int)0, (int)0, (int)mc.field_195558_d.func_198109_k(), (int)mc.field_195558_d.func_198091_l(), (int)black.hashCode());
                    GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.scaled((double)(1.0f / (float)this.screenScale), (double)(1.0f / (float)this.screenScale), (double)1.0);
                    GlStateManager.translatef((float)(mc.field_195558_d.func_198109_k() / 2), (float)(mc.field_195558_d.func_198091_l() / 2), (float)0.0f);
                    GlStateManager.pushMatrix();
                    GlStateManager.disableCull();
                    int flooredCameraX = (int)Math.floor(this.cameraX);
                    int flooredCameraY = (int)Math.floor(this.cameraZ);
                    double secondaryOffsetX = (double)(this.cameraX - (float)flooredCameraX) * fboScale;
                    double secondaryOffsetY = (double)(this.cameraZ - (float)flooredCameraY) * fboScale;
                    if (fboScale == 0.5) {
                        if ((flooredCameraX & 1) != 0) {
                            --flooredCameraX;
                            secondaryOffsetX += 0.5;
                        }
                        if ((flooredCameraY & 1) != 0) {
                            --flooredCameraY;
                            secondaryOffsetY += 0.5;
                        }
                    } else {
                        int offset;
                        if (secondaryOffsetX >= 1.0) {
                            offset = (int)secondaryOffsetX;
                            GlStateManager.translatef((float)(-offset), (float)0.0f, (float)0.0f);
                            secondaryOffsetX -= (double)offset;
                        }
                        if (secondaryOffsetY >= 1.0) {
                            offset = (int)secondaryOffsetY;
                            GlStateManager.translatef((float)0.0f, (float)offset, (float)0.0f);
                            secondaryOffsetY -= (double)offset;
                        }
                    }
                    GlStateManager.scaled((double)fboScale, (double)(-fboScale), (double)1.0);
                    GlStateManager.translatef((float)(-flooredCameraX), (float)(-flooredCameraY), (float)0.0f);
                    GL11.glEnable((int)3553);
                    double leftBorder = (double)this.cameraX - (double)(mc.field_195558_d.func_198109_k() / 2) / this.scale;
                    double rightBorder = leftBorder + (double)mc.field_195558_d.func_198109_k() / this.scale;
                    double topBorder = (double)this.cameraZ - (double)(mc.field_195558_d.func_198091_l() / 2) / this.scale;
                    double bottomBorder = topBorder + (double)mc.field_195558_d.func_198091_l() / this.scale;
                    int minRegX = (int)leftBorder >> 9;
                    int maxRegX = (int)rightBorder >> 9;
                    int minRegZ = (int)topBorder >> 9;
                    int maxRegZ = (int)bottomBorder >> 9;
                    lastAmountOfRegionsViewed = (maxRegX - minRegX + 1) * (maxRegZ - minRegZ + 1);
                    if (MapProcessor.instance.getMapLimiter().getMostRegionsAtATime() < lastAmountOfRegionsViewed) {
                        MapProcessor.instance.getMapLimiter().setMostRegionsAtATime(lastAmountOfRegionsViewed);
                    }
                    GlStateManager.disableBlend();
                    GlStateManager.disableAlphaTest();
                    this.regionBuffer.clear();
                    for (int regX = minRegX; regX <= maxRegX; ++regX) {
                        for (int regZ = minRegZ; regZ <= maxRegZ; ++regZ) {
                            region = MapProcessor.instance.getMapRegion(regX, regZ, MapProcessor.instance.regionExists(regX, regZ));
                            if (region == null) continue;
                            MapRegion mapRegion = region;
                            synchronized (mapRegion) {
                                if (!region.recacheHasBeenRequested() && !region.reloadHasBeenRequested() && (region.getVersion() != MapProcessor.instance.getGlobalVersion() || region.getLoadState() == 4 && region.shouldCache())) {
                                    if (region.isBeingWritten() && region.getLoadState() == 2) {
                                        region.requestRefresh();
                                    } else {
                                        if (WorldMap.settings.detailed_debug) {
                                            WorldMap.LOGGER.info("Added to buffer: " + region + " " + region.getVersion() + " " + MapProcessor.instance.getGlobalVersion());
                                        }
                                        this.regionBuffer.add(region);
                                    }
                                }
                            }
                            if (!MapProcessor.instance.isUploadingPaused()) {
                                List<MapRegion> regions = MapProcessor.instance.getCurrentMapList(MapProcessor.instance.getCurrentDimension());
                                regions.remove(region);
                                regions.add(region);
                            }
                            if (region.getLoadState() < 2) {
                                GlStateManager.pushMatrix();
                                GlStateManager.translatef((float)(512 * region.getRegionX() + 256), (float)(512 * region.getRegionZ() + 256), (float)0.0f);
                                float loadingAnimationPassed = System.currentTimeMillis() - this.loadingAnimationStart;
                                if (loadingAnimationPassed > 0.0f) {
                                    int period = 2000;
                                    int numbersOfActors = 3;
                                    float loadingAnimation = loadingAnimationPassed % (float)period / (float)period * 360.0f;
                                    float step = 360.0f / (float)numbersOfActors;
                                    GlStateManager.rotatef((float)loadingAnimation, (float)0.0f, (float)0.0f, (float)1.0f);
                                    int numberOfVisibleActors = 1 + (int)loadingAnimationPassed % (3 * period) / period;
                                    for (int i = 0; i < numberOfVisibleActors; ++i) {
                                        GlStateManager.rotatef((float)step, (float)0.0f, (float)0.0f, (float)1.0f);
                                        GuiMap.fill((int)16, (int)-8, (int)32, (int)8, (int)white.hashCode());
                                    }
                                }
                                GlStateManager.popMatrix();
                            }
                            for (int o = 0; o < 8; ++o) {
                                for (int p = 0; p < 8; ++p) {
                                    chunk = region.getChunk(o, p);
                                    if (chunk == null || chunk.getGlColorTexture() == -1 || (double)((chunk.getX() + 1) * 64) < leftBorder || (double)(chunk.getX() * 64) > rightBorder || (double)(chunk.getZ() * 64) > bottomBorder || (double)((chunk.getZ() + 1) * 64) < topBorder || chunk.getGlColorTexture() == -1) continue;
                                    GuiMap.bindMapTextureWithLighting(chunk, 9728, preferredTextureSize == 8 ? 1 : 0);
                                    GuiMap.renderTexturedModalRectWithLighting(64.0f * (float)chunk.getX(), 64.0f * (float)chunk.getZ(), 0, 0, 64.0f, 64.0f);
                                    if (!WorldMap.settings.debug || p != 0 || chunk.getSuccessMask() == 15) continue;
                                    GuiMap.restoreTextureStates();
                                    GuiMap.fill((int)(64 * chunk.getX()), (int)(64 * chunk.getZ()), (int)(64 * (chunk.getX() + 1)), (int)(64 * (chunk.getZ() + 1)), (int)redTrans.hashCode());
                                }
                            }
                            GuiMap.restoreTextureStates();
                            if (!WorldMap.settings.debug) continue;
                            GlStateManager.pushMatrix();
                            GlStateManager.translatef((float)(512 * region.getRegionX() + 32), (float)(512 * region.getRegionZ() + 32), (float)0.0f);
                            GlStateManager.scaled((double)10.0, (double)10.0, (double)1.0);
                            this.drawString(mc.field_71466_p, "" + region.getLoadState(), 0, 0, white.hashCode());
                            GlStateManager.popMatrix();
                        }
                    }
                    MapRegion nextToLoad = MapProcessor.instance.getMapSaveLoad().getNextToLoadByViewing();
                    boolean shouldRequest = false;
                    if (nextToLoad != null) {
                        region = nextToLoad;
                        synchronized (region) {
                            if (!nextToLoad.reloadHasBeenRequested()) {
                                shouldRequest = true;
                            }
                        }
                    } else {
                        shouldRequest = true;
                    }
                    if (shouldRequest) {
                        int toRequest = 1;
                        int counter = 0;
                        MapRegion.setComparison(this.mouseBlockPosX >> 9, this.mouseBlockPosZ >> 9);
                        Collections.sort(this.regionBuffer);
                        for (int i = 0; i < this.regionBuffer.size() && counter < toRequest; ++i) {
                            MapRegion region2 = this.regionBuffer.get(i);
                            if (region2 == nextToLoad) continue;
                            MapRegion loadingAnimation = region2;
                            synchronized (loadingAnimation) {
                                if (region2.reloadHasBeenRequested() || region2.recacheHasBeenRequested() || region2.getLoadState() != 0 && region2.getLoadState() != 4) {
                                    continue;
                                }
                                MapProcessor.instance.getMapSaveLoad().requestLoad(region2, "Gui");
                                if (counter == 0) {
                                    MapProcessor.instance.getMapSaveLoad().setNextToLoadByViewing(region2);
                                }
                                ++counter;
                                if (region2.getLoadState() == 4) {
                                    break;
                                }
                                continue;
                            }
                        }
                    }
                    GuiMap.fill((int)((this.mouseBlockPosX >> 4) * 16), (int)((this.mouseBlockPosZ >> 4) * 16), (int)(((this.mouseBlockPosX >> 4) + 1) * 16), (int)(((this.mouseBlockPosZ >> 4) + 1) * 16), (int)whiteTrans.hashCode());
                    GlStateManager.enableBlend();
                    GlStateManager.enableAlphaTest();
                    GlStateManager.disableBlend();
                    GlStateManager.disableAlphaTest();
                    primaryScaleFBO.func_147609_e();
                    Minecraft.func_71410_x().func_147110_a().func_147610_a(false);
                    GlStateManager.enableCull();
                    GlStateManager.popMatrix();
                    GlStateManager.pushMatrix();
                    GlStateManager.scaled((double)secondaryScale, (double)secondaryScale, (double)1.0);
                    primaryScaleFBO.func_147612_c();
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                    int lineX = -mc.field_195558_d.func_198109_k() / 2;
                    int lineY = mc.field_195558_d.func_198091_l() / 2 - 5;
                    int lineW = mc.field_195558_d.func_198109_k();
                    int lineH = 6;
                    GuiMap.fill((int)lineX, (int)lineY, (int)(lineX + lineW), (int)(lineY + lineH), (int)black.hashCode());
                    lineX = mc.field_195558_d.func_198109_k() / 2 - 5;
                    lineY = -mc.field_195558_d.func_198091_l() / 2;
                    lineW = 6;
                    lineH = mc.field_195558_d.func_198091_l();
                    GuiMap.fill((int)lineX, (int)lineY, (int)(lineX + lineW), (int)(lineY + lineH), (int)black.hashCode());
                    GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    GuiMap.renderTexturedModalRect((float)(-mc.field_195558_d.func_198109_k() / 2) - (float)secondaryOffsetX, (float)(-mc.field_195558_d.func_198091_l() / 2) - (float)secondaryOffsetY, 0, 0, mc.field_195558_d.func_198109_k(), mc.field_195558_d.func_198091_l(), mc.field_195558_d.func_198109_k(), mc.field_195558_d.func_198091_l());
                    GlStateManager.popMatrix();
                    GlStateManager.scaled((double)this.scale, (double)this.scale, (double)1.0);
                    GlStateManager.translatef((float)(-this.cameraX), (float)(-this.cameraZ), (float)0.0f);
                    GlStateManager.enableBlend();
                    GlStateManager.enableAlphaTest();
                    ArrayList<Waypoint> renderResult = null;
                    if (SupportMods.minimap() && WorldMap.settings.waypoints) {
                        boolean waypointMenuReal;
                        GlStateManager.disableCull();
                        Waypoint oldViewed = this.viewed;
                        renderResult = SupportMods.xaeroMinimap.renderWaypoints(this, flooredCameraX, flooredCameraY, mc.field_195558_d.func_198109_k(), mc.field_195558_d.func_198091_l(), this.screenScale, this.scale, mousePosX, mousePosZ, this.waypointMenuSearchPattern, this.waypointMenuSearchStartPattern);
                        boolean bl = waypointMenuReal = renderResult != null && (renderResult.size() > 1 || this.waypointMenu) && scaledMouseX > this.width - 20 && scaledMouseY > this.height - 20;
                        if (this.waypointMenu != waypointMenuReal) {
                            int animationEnd;
                            this.waypointMenu = waypointMenuReal;
                            int animationStart = this.waypointMenuAnimation != null ? (int)this.waypointMenuAnimation.getCurrent() : (this.waypointMenu ? 500 : 0);
                            int n = animationEnd = this.waypointMenu ? 0 : 500;
                            if (this.waypointMenu) {
                                this.waypointMenuAnimation = new SlowingAnimation(animationStart, animationEnd, 0.7, 0.001);
                                this.shouldRenderWaypointMenu = true;
                            } else {
                                this.waypointMenuAnimation = new Animation(animationStart, animationEnd, 500L);
                            }
                        }
                        if (!this.shouldRenderWaypointMenu) {
                            this.waypointMenuSelected = 0;
                            this.waypointMenuOffset = 0;
                        }
                        Waypoint waypoint = this.viewed = renderResult != null ? renderResult.remove(0) : null;
                        if (this.viewed != oldViewed) {
                            this.waypointHintAlphaDest = this.viewed != null ? 255.0f : 0.0f;
                            this.waypointHintAlphaAnim = new SlowingAnimation(this.waypointHintAlpha, this.waypointHintAlphaDest, this.waypointHintAlpha < this.waypointHintAlphaDest ? 0.9 : 0.95, 1.0);
                        }
                        if (this.waypointHintAlphaAnim != null) {
                            this.waypointHintAlpha = (float)this.waypointHintAlphaAnim.getCurrent();
                        }
                        GlStateManager.enableCull();
                        GlStateManager.enableBlend();
                    } else {
                        this.viewed = null;
                    }
                    if (WorldMap.settings.footsteps) {
                        for (int i = 0; i < MapProcessor.instance.getFootprints().size(); ++i) {
                            Double[] coords = MapProcessor.instance.getFootprints().get(i);
                            this.setColourBuffer(1.0f, 0.1f, 0.1f, 1.0f);
                            this.drawDotOnMap(coords[0], coords[1], 0.0f, 1.0 / this.scale);
                        }
                    }
                    boolean toTheLeft = this.player.field_70165_t < leftBorder;
                    boolean toTheRight = this.player.field_70165_t > rightBorder;
                    boolean down = this.player.field_70161_v > bottomBorder;
                    boolean up = this.player.field_70161_v < topBorder;
                    GlStateManager.enableBlend();
                    if (toTheLeft || toTheRight || up || down) {
                        double arrowX = this.player.field_70165_t;
                        double arrowZ = this.player.field_70161_v;
                        float a = 0.0f;
                        if (toTheLeft) {
                            a = up ? 1.5f : (down ? 0.5f : 1.0f);
                            arrowX = leftBorder;
                        } else if (toTheRight) {
                            a = up ? 2.5f : (down ? 3.5f : 3.0f);
                            arrowX = rightBorder;
                        }
                        if (down) {
                            arrowZ = bottomBorder;
                        } else if (up) {
                            if (a == 0.0f) {
                                a = 2.0f;
                            }
                            arrowZ = topBorder;
                        }
                        this.setColourBuffer(0.0f, 0.0f, 0.0f, 0.9f);
                        this.drawFarArrowOnMap(arrowX, arrowZ + 2.0 / this.scale, a, 1.0 / this.scale);
                        this.setColourBuffer(0.8f, 0.1f, 0.1f, 1.0f);
                        this.drawFarArrowOnMap(arrowX, arrowZ, a, 1.0 / this.scale);
                    } else {
                        this.setColourBuffer(0.0f, 0.0f, 0.0f, 0.9f);
                        this.drawArrowOnMap(this.player.field_70165_t, this.player.field_70161_v + 2.0 / this.scale, this.player.field_70177_z, 1.0 / this.scale);
                        this.setColourBuffer(0.8f, 0.1f, 0.1f, 1.0f);
                        this.drawArrowOnMap(this.player.field_70165_t, this.player.field_70161_v, this.player.field_70177_z, 1.0 / this.scale);
                    }
                    GlStateManager.popMatrix();
                    if (this.shouldRenderWaypointMenu && renderResult != null) {
                        if (this.waypointMenuSelected >= renderResult.size()) {
                            this.waypointMenuSelected = renderResult.size() - 1;
                            this.waypointMenuOffset = Math.max(this.waypointMenuSelected - 7 + 2, 0);
                        }
                        if (this.waypointMenuSelected < 0) {
                            this.waypointMenuSelected = 0;
                        }
                        this.waypointMenuSelectedObject = renderResult.size() > 0 ? renderResult.get(this.waypointMenuSelected) : null;
                        SupportMods.xaeroMinimap.renderSideWaypoints(this, renderResult, this.scale, this.width + (int)this.waypointMenuAnimation.getCurrent(), this.height, this.waypointMenuOffset, this.waypointMenuSelected);
                        if (this.waypointMenu && this.waypointMenuSearch != null && this.waypointMenuSearch.length() > 0) {
                            this.drawCenteredString(mc.field_71466_p, this.waypointMenuSearch.toString(), this.width / 2, this.height - 15, Waypoint.white);
                        }
                        if (!this.waypointMenu && this.waypointMenuAnimation.getCurrent() == this.waypointMenuAnimation.getDestination()) {
                            this.shouldRenderWaypointMenu = false;
                            this.waypointMenuSearch = new StringBuilder();
                            this.waypointMenuSearchPattern = null;
                            this.waypointMenuSearchStartPattern = null;
                        }
                    }
                    if ((int)this.waypointHintAlpha > 3) {
                        int hintColour = (int)this.waypointHintAlpha << 24 | 0xFF0000 | 0xFF00 | 0xFF;
                        GlStateManager.enableBlend();
                        GlStateManager.enableAlphaTest();
                        if (SupportMods.xaeroMinimap.canTeleport()) {
                            this.drawCenteredString(mc.field_71466_p, "Edit - Right Click     Teleport - T     Disable - H     Delete - Delete", this.width / 2, this.height - 25, hintColour);
                        } else {
                            this.drawCenteredString(mc.field_71466_p, "Edit - Right Click     Disable - H     Delete - Delete", this.width / 2, this.height - 25, hintColour);
                        }
                    }
                    GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    errorCounter = 0;
                } else {
                    if (errorCounter > 100) {
                        GlStateManager.pushMatrix();
                        GlStateManager.translatef((float)0.0f, (float)0.0f, (float)500.0f);
                        this.drawCenteredString(mc.field_71466_p, "Something went wrong... Please make a screenshot (F2)", mc.field_195558_d.func_198107_o() / 2, mc.field_195558_d.func_198087_p() / 2, white.hashCode());
                        this.drawCenteredString(mc.field_71466_p, "and report it to xaero96 on PlanetMinecraft/MinecraftForum!", mc.field_195558_d.func_198107_o() / 2, mc.field_195558_d.func_198087_p() / 2 + 10, white.hashCode());
                        this.drawCenteredString(mc.field_71466_p, MapProcessor.instance.getCurrentWorldString(), mc.field_195558_d.func_198107_o() / 2, mc.field_195558_d.func_198087_p() / 2 + 25, white.hashCode());
                        GlStateManager.popMatrix();
                    }
                    ++errorCounter;
                }
                mc.func_110434_K().func_110577_a(WorldMap.guiTextures);
                this.blit(this.width - 35, 2, 0, 37, 32, 32);
            }
        }
        super.render(scaledMouseX, scaledMouseY, partialTicks);
    }

    public void drawDotOnMap(double x, double z, float angle, double sc) {
        this.drawObjectOnMap(x, z, angle, sc, 2.5f, 2.5f, 0, 69, 5, 5, 9729);
    }

    public void drawArrowOnMap(double x, double z, float angle, double sc) {
        this.drawObjectOnMap(x, z, angle, sc, 13.0f, 5.0f, 0, 0, 28, 29, 9729);
    }

    public void drawFarArrowOnMap(double x, double z, float angle, double sc) {
        this.drawObjectOnMap(x, z, angle * 90.0f, sc, 27.0f, 13.0f, 26, 0, 54, 13, 9729);
    }

    public void drawObjectOnMap(double x, double z, float angle, double sc, float offX, float offY, int textureX, int textureY, int w, int h, int filter) {
        GlStateManager.pushMatrix();
        GlStateManager.color4f((float)this.colourBuffer[0], (float)this.colourBuffer[1], (float)this.colourBuffer[2], (float)this.colourBuffer[3]);
        GlStateManager.translated((double)x, (double)z, (double)0.0);
        GlStateManager.scaled((double)sc, (double)sc, (double)1.0);
        if (angle != 0.0f) {
            GlStateManager.rotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        this.minecraft.func_110434_K().func_110577_a(WorldMap.guiTextures);
        GL11.glTexParameteri((int)3553, (int)10240, (int)filter);
        GL11.glTexParameteri((int)3553, (int)10241, (int)filter);
        GuiMap.renderTexturedModalRect(-offX, -offY, textureX, textureY, w, h, 256.0f, 256.0f);
        if (filter != 9728) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }

    public static void renderTexturedModalRectWithLighting(float x, float y, int textureX, int textureY, float width, float height) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, POSITION_TEX_TEX_TEX);
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + height), 0.0).func_187315_a(0.0, 1.0).func_187315_a(0.0, 1.0).func_187315_a(0.0, 1.0).func_187315_a(0.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a(1.0, 1.0).func_187315_a(1.0, 1.0).func_187315_a(1.0, 1.0).func_187315_a(1.0, 1.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + 0.0f), 0.0).func_187315_a(1.0, 0.0).func_187315_a(1.0, 0.0).func_187315_a(1.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), 0.0).func_187315_a(0.0, 0.0).func_187315_a(0.0, 0.0).func_187315_a(0.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderTexturedModalRect(float x, float y, int textureX, int textureY, float width, float height, float textureWidth, float textureHeight) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float normalizedTextureX = (float)textureX / textureWidth;
        float normalizedTextureY = (float)textureY / textureHeight;
        float normalizedTextureX2 = ((float)textureX + width) / textureWidth;
        float normalizedTextureY2 = ((float)textureY + height) / textureHeight;
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + height), 0.0).func_187315_a((double)normalizedTextureX, (double)normalizedTextureY2).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_187315_a((double)normalizedTextureX2, (double)normalizedTextureY2).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + width), (double)(y + 0.0f), 0.0).func_187315_a((double)normalizedTextureX2, (double)normalizedTextureY).func_181675_d();
        vertexBuffer.func_181662_b((double)(x + 0.0f), (double)(y + 0.0f), 0.0).func_187315_a((double)normalizedTextureX, (double)normalizedTextureY).func_181675_d();
        tessellator.func_78381_a();
    }

    public void mapClicked(int x, int y) {
        if (!this.waypointMenu && this.viewed != null) {
            SupportMods.xaeroMinimap.openWaypoint(this, this.viewed);
            this.mouseDownPosX = -1;
            this.mouseDownPosY = -1;
        }
        if (this.waypointMenu && this.waypointMenuSelectedObject != null) {
            this.cameraDestination = new int[]{this.waypointMenuSelectedObject.getX(), this.waypointMenuSelectedObject.getZ()};
        }
    }

    private void setSearch(String search, String preChange) {
        try {
            this.waypointMenuSearchPattern = Pattern.compile(search.toLowerCase());
            if (search.length() > 0) {
                this.waypointMenuSearchStartPattern = search.charAt(0) == '^' ? this.waypointMenuSearchPattern : Pattern.compile('^' + search.toString().toLowerCase());
            } else {
                this.waypointMenuSearchPattern = null;
                this.waypointMenuSearchStartPattern = null;
            }
        }
        catch (PatternSyntaxException e) {
            if (preChange != null) {
                this.waypointMenuSearch = new StringBuilder(preChange);
                this.setSearch(preChange, null);
            }
            throw e;
        }
    }

    public boolean charTyped(char par1, int par2) {
        if (this.waypointMenu) {
            String preChange = this.waypointMenuSearch.toString();
            this.waypointMenuSearch.append(par1);
            this.setSearch(this.waypointMenuSearch.toString(), preChange);
        }
        return super.charTyped(par1, par2);
    }

    public boolean keyPressed(int par1, int par2, int par3) {
        if (this.waypointMenu) {
            if (par1 != 0) {
                if (par1 == ControlsHandler.keyZoomIn.getKey().func_197937_c()) {
                    this.scrollWaypoints(1);
                } else if (par1 == ControlsHandler.keyZoomOut.getKey().func_197937_c()) {
                    this.scrollWaypoints(-1);
                } else {
                    String preChange = this.waypointMenuSearch.toString();
                    if (par1 == 259) {
                        if (this.waypointMenuSearch.length() > 0) {
                            this.waypointMenuSearch.deleteCharAt(this.waypointMenuSearch.length() - 1);
                        }
                    } else if (par1 == 257) {
                        this.waypointMenuSearch = new StringBuilder();
                    }
                    this.setSearch(this.waypointMenuSearch.toString(), preChange);
                }
            }
        } else {
            if (par1 == ControlsHandler.keyOpenMap.getKey().func_197937_c()) {
                return super.keyPressed(256, 1, par3);
            }
            if (this.viewed != null) {
                switch (par1) {
                    case 72: {
                        SupportMods.xaeroMinimap.disableWaypoint(this.viewed);
                        break;
                    }
                    case 261: {
                        SupportMods.xaeroMinimap.deleteWaypoint(this.viewed);
                    }
                }
            }
        }
        return super.keyPressed(par1, par2, par3);
    }

    public boolean func_223281_a_(int par1, int par2, int par3) {
        if (!this.waypointMenu) {
            if (this.viewed != null) {
                switch (par1) {
                    case 84: {
                        SupportMods.xaeroMinimap.teleportToWaypoint(this, this.viewed);
                    }
                }
            }
            if (SupportMods.minimap() && par1 == SupportMods.xaeroMinimap.getWaypointKeyCode() && WorldMap.settings.waypoints && this.mouseBlockPosY != -1) {
                SupportMods.xaeroMinimap.createWaypoint(this, this.mouseBlockPosX, this.mouseBlockPosY + 1, this.mouseBlockPosZ);
            }
            if (SupportMods.minimap() && par1 == SupportMods.xaeroMinimap.getTempWaypointKeyCode() && WorldMap.settings.waypoints && this.mouseBlockPosY != -1) {
                SupportMods.xaeroMinimap.createTempWaypoint(this.mouseBlockPosX, this.mouseBlockPosY + 1, this.mouseBlockPosZ);
            }
        }
        return super.func_223281_a_(par1, par2, par3);
    }

    public static void bindMapTextureWithLighting(MapTileChunk chunk, int magFilter, int lod) {
        int glLightTexture = chunk.getGlLightTexture();
        float brightness = MapProcessor.instance.getBrightness();
        GlStateManager.activeTexture((int)33984);
        GlStateManager.enableTexture();
        if (glLightTexture != -1) {
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            chunk.bindLightTexture(false, magFilter);
            GL11.glTexParameterf((int)3553, (int)33082, (float)lod);
            float toSubtract = 1.0f - brightness;
            brightnessBuffer.position(0);
            brightnessBuffer.put(toSubtract);
            brightnessBuffer.put(toSubtract);
            brightnessBuffer.put(toSubtract);
            brightnessBuffer.put(1.0f);
            brightnessBuffer.flip();
            GlStateManager.texEnv((int)8960, (int)8705, (FloatBuffer)brightnessBuffer);
            GlStateManager.texEnv((int)8960, (int)8704, (int)34160);
            GlStateManager.texEnv((int)8960, (int)34161, (int)34023);
            GlStateManager.texEnv((int)8960, (int)34176, (int)5890);
            GlStateManager.texEnv((int)8960, (int)34192, (int)769);
            GlStateManager.texEnv((int)8960, (int)34177, (int)34166);
            GlStateManager.texEnv((int)8960, (int)34193, (int)768);
            GlStateManager.texEnv((int)8960, (int)34162, (int)7681);
            GlStateManager.texEnv((int)8960, (int)34184, (int)34166);
            GlStateManager.texEnv((int)8960, (int)34200, (int)770);
        } else {
            GlStateManager.color4f((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
            chunk.bindColorTexture(false, magFilter);
            GL11.glTexParameterf((int)3553, (int)33082, (float)lod);
            GlStateManager.texEnv((int)8960, (int)8704, (int)8448);
        }
        GlStateManager.activeTexture((int)33985);
        GlStateManager.disableTexture();
        GlStateManager.activeTexture((int)33986);
        if (glLightTexture != -1) {
            GlStateManager.enableTexture();
            chunk.bindLightTexture(false, magFilter);
            GlStateManager.texEnv((int)8960, (int)8704, (int)260);
        } else {
            GlStateManager.disableTexture();
        }
        GlStateManager.activeTexture((int)33987);
        if (glLightTexture != -1) {
            GlStateManager.enableTexture();
            chunk.bindColorTexture(false, magFilter);
            GL11.glTexParameterf((int)3553, (int)33082, (float)lod);
            GlStateManager.texEnv((int)8960, (int)8704, (int)8448);
        } else {
            GlStateManager.disableTexture();
        }
    }

    public static void restoreTextureStates() {
        GlStateManager.activeTexture((int)33987);
        GlStateManager.disableTexture();
        GlStateManager.activeTexture((int)33986);
        GlStateManager.disableTexture();
        GlStateManager.activeTexture((int)33985);
        GlStateManager.texEnv((int)8960, (int)8704, (int)8448);
        GlStateManager.disableTexture();
        GlStateManager.activeTexture((int)33984);
        GlStateManager.texEnv((int)8960, (int)8704, (int)8448);
    }

    private static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    private void setColourBuffer(float r, float g, float b, float a) {
        this.colourBuffer[0] = r;
        this.colourBuffer[1] = g;
        this.colourBuffer[2] = b;
        this.colourBuffer[3] = a;
    }

    static {
        POSITION_TEX_TEX_TEX.func_181721_a(DefaultVertexFormats.field_181713_m).func_181721_a(DefaultVertexFormats.field_181715_o).func_181721_a(TEX_2F_1).func_181721_a(TEX_2F_2).func_181721_a(TEX_2F_3);
        brightnessBuffer = GLAllocation.func_74529_h((int)4);
        white = new Color(255, 255, 255);
        whiteTrans = new Color(255, 255, 255, 40);
        redTrans = new Color(255, 0, 0, 40);
        black = new Color(0, 0, 0, 255);
        errorCounter = 0;
        lastAmountOfRegionsViewed = 1;
        primaryScaleFBO = null;
    }
}

