/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file.worldsave;

import com.mojang.datafixers.DataFixer;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.fluid.IFluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BitArray;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.chunk.BlockStatePaletteHashMap;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IBlockStatePalette;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;

public class WorldDataReader {
    private Method loadFileMethod;
    private boolean[] underair;
    private boolean[] blockFound;
    private byte[] lightLevels;
    private int[] biomeBuffer;
    private MapBlock buildingObject = new MapBlock();
    private OverlayBuilder[] overlayBuilders;
    private BlockState[] prevOverlays;
    private boolean[] overlayNeedsBiome;
    private BlockPos.MutableBlockPos mutableBlockPos;
    private IBlockStatePalette<BlockState> blockStatePalette;
    private BitArray heightMapBitArray;
    private BitArray blockStatesBitArray;
    private int currentBits;
    private RegionFileSupplier regionFileSupplier;
    public Object taskCreationSync;
    private boolean preventServerThreadUsage;

    public WorldDataReader(OverlayManager overlayManager) {
        this.underair = new boolean[256];
        this.blockFound = new boolean[256];
        this.lightLevels = new byte[256];
        this.biomeBuffer = new int[3];
        this.prevOverlays = new BlockState[256];
        this.overlayNeedsBiome = new boolean[256];
        this.overlayBuilders = new OverlayBuilder[256];
        this.mutableBlockPos = new BlockPos.MutableBlockPos();
        this.blockStatePalette = new BlockStatePaletteHashMap(Block.field_176229_d, 32, null, NBTUtil::func_190008_d, NBTUtil::func_190009_a);
        this.heightMapBitArray = new BitArray(9, 256);
        this.regionFileSupplier = new RegionFileSupplier();
        this.taskCreationSync = new Object();
        for (int i = 0; i < this.overlayBuilders.length; ++i) {
            this.overlayBuilders[i] = new OverlayBuilder(overlayManager);
        }
        try {
            this.loadFileMethod = RegionFileCache.class.getDeclaredMethod("func_219098_a", ChunkPos.class);
        }
        catch (NoSuchMethodException e) {
            try {
                this.loadFileMethod = RegionFileCache.class.getDeclaredMethod("loadFile", ChunkPos.class);
            }
            catch (NoSuchMethodException e1) {
                throw new RuntimeException(e1);
            }
            catch (SecurityException e1) {
                throw e1;
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean buildRegion(MapRegion region, ServerWorld worldServer, World world, boolean loading, int[] chunkCountDest) {
        boolean regionIsResting;
        if (!loading) {
            region.pushWriterPause();
        }
        boolean result = true;
        int prevRegX = region.getRegionX();
        int prevRegZ = region.getRegionZ() - 1;
        MapRegion prevRegion = MapProcessor.instance.getMapRegion(prevRegX, prevRegZ, false);
        MapRegion mapRegion = region;
        synchronized (mapRegion) {
            regionIsResting = region.isResting();
            if (!loading && regionIsResting) {
                region.setBeingWritten(true);
                region.setShouldCache(false, "world save");
                region.setReloadHasBeenRequested(false, "world save");
                region.setVersion(MapProcessor.instance.getGlobalVersion());
                if (region.getLoadState() != 2) {
                    if (region.getLoadState() == 4) {
                        region.restoreBufferUpdateObjects();
                    }
                    region.setLoadState((byte)2);
                    region.setLastSaveTime(System.currentTimeMillis() + 100000L);
                    MapProcessor.instance.addToProcess(region);
                } else {
                    MapProcessor.instance.removeToRefresh(region);
                    region.setRefreshing(false);
                }
            }
        }
        int caveStart = MapProcessor.instance.getCaveStart();
        if (loading || region.getLoadState() == 2 && regionIsResting) {
            ChunkManager chunkManager = worldServer.func_72863_F().field_217237_a;
            MinecraftServer server = worldServer.func_73046_m();
            RegionFile regionFile = this.getRegionFile(region.getRegionX(), region.getRegionZ(), chunkManager, server);
            if (regionFile != null) {
                for (int i = 0; i < 8; ++i) {
                    for (int j = 0; j < 8; ++j) {
                        MapTileChunk tileChunk = region.getChunk(i, j);
                        if (tileChunk == null) {
                            tileChunk = new MapTileChunk(region, (region.getRegionX() << 3) + i, (region.getRegionZ() << 3) + j);
                            region.setChunk(i, j, tileChunk);
                        }
                        this.buildTileChunk(regionFile, tileChunk, caveStart, prevRegion, world);
                        tileChunk.setLoadState((byte)2);
                        if (!tileChunk.includeInSave()) {
                            tileChunk = null;
                            region.setChunk(i, j, null);
                            continue;
                        }
                        chunkCountDest[0] = chunkCountDest[0] + 1;
                    }
                }
                if (region.isMultiplayer()) {
                    region.setLastSaveTime(System.currentTimeMillis() - 60000L + 1500L);
                }
            } else {
                result = false;
            }
        } else {
            result = false;
        }
        if (!loading) {
            region.popWriterPause();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionFile getRegionFile(int regionX, int regionZ, ChunkManager chunkManager, MinecraftServer server) {
        CompletableFuture<RegionFile> serverThreadTask;
        Object object = this.taskCreationSync;
        synchronized (object) {
            this.regionFileSupplier.chunkManager = chunkManager;
            this.regionFileSupplier.chunkPos = new ChunkPos(regionX << 5, regionZ << 5);
            serverThreadTask = this.preventServerThreadUsage ? CompletableFuture.completedFuture(this.regionFileSupplier.get()) : CompletableFuture.supplyAsync(this.regionFileSupplier, (Executor)server);
        }
        try {
            return serverThreadTask.get();
        }
        catch (InterruptedException | ExecutionException e) {
            WorldMap.LOGGER.error(String.format("Error loading region file for region %d %d!", regionX, regionZ));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopUsingServerThread(MinecraftServer server) {
        Object object = this.taskCreationSync;
        synchronized (object) {
            while (server.func_213168_p()) {
            }
            this.preventServerThreadUsage = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeUsingServerThread() {
        Object object = this.taskCreationSync;
        synchronized (object) {
            this.preventServerThreadUsage = false;
        }
    }

    public CompoundNBT readChunk(RegionFile regionFile, ChunkPos pos) throws IOException {
        try (DataInputStream datainputstream = regionFile.func_222666_a(pos);){
            if (datainputstream != null) {
                CompoundNBT compoundNBT = CompressedStreamTools.func_74794_a((DataInputStream)datainputstream);
                return compoundNBT;
            }
            CompoundNBT compoundNBT = null;
            return compoundNBT;
        }
    }

    private void buildTileChunk(RegionFile regionFile, MapTileChunk tileChunk, int caveStart, MapRegion prevRegion, World world) {
        tileChunk.unincludeInSave();
        tileChunk.resetMasks();
        for (int insideX = 0; insideX < 4; ++insideX) {
            for (int insideZ = 0; insideZ < 4; ++insideZ) {
                int i;
                DataFixer fixer;
                CompoundNBT nbttagcompound;
                MapTile tile = tileChunk.getTile(insideX, insideZ);
                int chunkX = (tileChunk.getX() << 2) + insideX;
                int chunkZ = (tileChunk.getZ() << 2) + insideZ;
                try {
                    nbttagcompound = this.readChunk(regionFile, new ChunkPos(chunkX, chunkZ));
                }
                catch (IOException e) {
                    nbttagcompound = null;
                }
                if (nbttagcompound == null) {
                    if (tile == null) continue;
                    tileChunk.setChanged(true);
                    tileChunk.setTile(insideX, insideZ, null);
                    MapProcessor.instance.getTilePool().addToPool(tile);
                    continue;
                }
                boolean createdTile = false;
                if (tile == null) {
                    tile = MapProcessor.instance.getTilePool().get(MapProcessor.instance.getCurrentDimension(), chunkX, chunkZ);
                    createdTile = true;
                }
                if (tile.getPrevTile() == null) {
                    tileChunk.findPrevTile(prevRegion, tile, insideX, insideZ);
                }
                if (this.buildTile(nbttagcompound = NBTUtil.func_210822_a((DataFixer)(fixer = Minecraft.func_71410_x().func_184126_aj()), (DefaultTypeReferences)DefaultTypeReferences.CHUNK, (CompoundNBT)nbttagcompound, (int)(i = nbttagcompound.func_150297_b("DataVersion", 99) ? nbttagcompound.func_74762_e("DataVersion") : -1)), tile, tileChunk, chunkX, chunkZ, caveStart, world)) {
                    tileChunk.setTile(insideX, insideZ, tile);
                    if (!createdTile) continue;
                    tileChunk.setChanged(true);
                    continue;
                }
                tileChunk.setTile(insideX, insideZ, null);
                MapProcessor.instance.getTilePool().addToPool(tile);
            }
        }
        if (tileChunk.wasChanged()) {
            tileChunk.updateBuffers(world);
            tileChunk.setChanged(false);
        }
    }

    private boolean buildTile(CompoundNBT nbttagcompound, MapTile tile, MapTileChunk tileChunk, int chunkX, int chunkZ, int caveStart, World world) {
        boolean heightMapExists;
        CompoundNBT levelCompound = nbttagcompound.func_74775_l("Level");
        String status = levelCompound.func_74779_i("Status");
        if (ChunkStatus.func_222591_a((String)status).func_222584_c() < ChunkStatus.field_222614_j.func_222584_c()) {
            return false;
        }
        int fillCounter = 256;
        for (int i = 0; i < this.blockFound.length; ++i) {
            this.overlayBuilders[i].startBuilding();
            this.overlayNeedsBiome[i] = false;
            this.blockFound[i] = false;
            this.underair[i] = false;
            this.prevOverlays[i] = null;
        }
        boolean oldHeightMap = !levelCompound.func_150297_b("Heightmaps", 10);
        int[] oldHeightMapArray = null;
        if (oldHeightMap) {
            oldHeightMapArray = levelCompound.func_74759_k("HeightMap");
            heightMapExists = oldHeightMapArray.length == 256;
        } else {
            long[] heightMapArray = levelCompound.func_74775_l("Heightmaps").func_197645_o("WORLD_SURFACE");
            boolean bl = heightMapExists = heightMapArray.length == 36;
            if (heightMapExists) {
                System.arraycopy(heightMapArray, 0, this.heightMapBitArray.func_188143_a(), 0, heightMapArray.length);
            }
        }
        int[] biomes = null;
        boolean biomesDataExists = false;
        if (levelCompound.func_150297_b("Biomes", 11)) {
            biomes = levelCompound.func_74759_k("Biomes");
            biomesDataExists = biomes.length == 256;
        }
        boolean lightIsOn = !levelCompound.func_150297_b("isLightOn", 1) || levelCompound.func_74767_n("isLightOn");
        boolean cave = caveStart != -1;
        ListNBT sectionsList = levelCompound.func_150295_c("Sections", 10);
        if (sectionsList.size() == 0) {
            return false;
        }
        for (int i = sectionsList.size() - 1; i >= 0 && fillCounter > 0; --i) {
            CompoundNBT sectionCompound = sectionsList.func_150305_b(i);
            boolean hasBlocks = sectionCompound.func_150297_b("BlockStates", 12);
            if (hasBlocks) {
                ListNBT paletteList = sectionCompound.func_150295_c("Palette", 10);
                this.blockStatePalette.func_196968_a(paletteList);
                long[] blockStatesArray = sectionCompound.func_197645_o("BlockStates");
                int bits = blockStatesArray.length * 64 / 4096;
                if (this.blockStatesBitArray == null || this.currentBits != bits) {
                    this.blockStatesBitArray = new BitArray(bits, 4096);
                    this.currentBits = bits;
                }
                System.arraycopy(blockStatesArray, 0, this.blockStatesBitArray.func_188143_a(), 0, blockStatesArray.length);
            }
            byte[] lightMap = null;
            if (lightIsOn && sectionCompound.func_150297_b("BlockLight", 7) && (lightMap = sectionCompound.func_74770_j("BlockLight")).length != 2048) {
                lightMap = null;
            }
            int sectionHeight = sectionCompound.func_74771_c("Y") * 16;
            for (int z = 0; z < 16; ++z) {
                block3: for (int x = 0; x < 16; ++x) {
                    int pos_2d = (z << 4) + x;
                    if (this.blockFound[pos_2d]) continue;
                    int height = heightMapExists ? (oldHeightMap ? oldHeightMapArray[pos_2d] : this.heightMapBitArray.func_188142_a(pos_2d)) : 256;
                    int startHeight = height + 3;
                    if (cave) {
                        startHeight = caveStart;
                    }
                    if (i > 0 && startHeight < sectionHeight) continue;
                    int biome = biomesDataExists ? biomes[pos_2d] & 0xFF : 0;
                    int localStartHeight = 15;
                    if (!cave) {
                        this.underair[pos_2d] = true;
                    }
                    if (startHeight >> 4 << 4 == sectionHeight) {
                        localStartHeight = startHeight & 0xF;
                    }
                    for (int y = localStartHeight; y >= 0; --y) {
                        int h = sectionHeight + y;
                        int pos = y << 8 | pos_2d;
                        BlockState state = hasBlocks ? (BlockState)this.blockStatePalette.func_186039_a(this.blockStatesBitArray.func_188142_a(pos)) : Blocks.field_150350_a.func_176223_P();
                        this.mutableBlockPos.func_181079_c(chunkX << 4 | x, sectionHeight | y, chunkZ << 4 | z);
                        boolean buildResult = this.buildPixel(this.buildingObject, state, x, h, z, pos_2d, this.biomeBuffer, this.lightLevels[pos_2d], biome, cave, this.overlayBuilders[pos_2d], world, this.mutableBlockPos);
                        if (!buildResult && y == 0 && i == 0) {
                            this.buildingObject.prepareForWriting();
                            buildResult = true;
                        }
                        if (buildResult) {
                            MapBlock currentPixel = tile.getBlock(x, z);
                            if (!this.buildingObject.equals(currentPixel)) {
                                tile.setBlock(x, z, this.buildingObject);
                                this.buildingObject = currentPixel != null ? currentPixel : new MapBlock();
                                tileChunk.setChanged(true);
                            }
                            this.blockFound[pos_2d] = true;
                            --fillCounter;
                            continue block3;
                        }
                        this.lightLevels[pos_2d] = lightMap == null ? (byte)0 : this.nibbleValue(lightMap, pos);
                    }
                }
            }
        }
        tile.setWrittenOnce(true);
        tile.setLoaded(true);
        return true;
    }

    private boolean buildPixel(MapBlock pixel, BlockState state, int x, int h, int z, int pos_2d, int[] biomeBuffer, byte light, int biome, boolean cave, OverlayBuilder overlayBuilder, World world, BlockPos.MutableBlockPos mutableBlockPos) {
        Block b;
        IFluidState fluidFluidState = state.func_204520_s();
        BlockState fluidState = fluidFluidState.func_206883_i();
        if (!fluidFluidState.func_206888_e()) {
            this.underair[pos_2d] = true;
            if (this.buildPixelHelp(pixel, fluidState, fluidState.func_177230_c(), fluidFluidState.func_180664_k(), pos_2d, h, cave, light, biome, overlayBuilder, world)) {
                return true;
            }
        }
        if ((b = state.func_177230_c()) instanceof AirBlock) {
            this.underair[pos_2d] = true;
            return false;
        }
        if (!this.underair[pos_2d]) {
            return false;
        }
        if (b == fluidState.func_177230_c()) {
            return false;
        }
        return this.buildPixelHelp(pixel, state, state.func_177230_c(), state.func_177230_c().func_180664_k(), pos_2d, h, cave, light, biome, overlayBuilder, world);
    }

    private boolean buildPixelHelp(MapBlock pixel, BlockState state, Block b, BlockRenderLayer renderLayer, int pos_2d, int h, boolean cave, byte light, int biome, OverlayBuilder overlayBuilder, World world) {
        if (MapProcessor.instance.getMapWriter().shouldOverlay(renderLayer, b, state.func_200016_a((IBlockReader)world, (BlockPos)this.mutableBlockPos))) {
            if (state != this.prevOverlays[pos_2d]) {
                this.getOverlayBiomeColour(world, state, b, (BlockPos)this.mutableBlockPos, this.biomeBuffer);
                this.prevOverlays[pos_2d] = state;
                if (this.biomeBuffer[1] == 1) {
                    this.overlayNeedsBiome[pos_2d] = true;
                }
            }
            overlayBuilder.build(state, this.biomeBuffer, state.func_200016_a((IBlockReader)world, (BlockPos)this.mutableBlockPos), light, world);
            return false;
        }
        if (MapProcessor.instance.getMapWriter().isInvisible(world, state, b)) {
            return false;
        }
        pixel.prepareForWriting();
        overlayBuilder.finishBuilding(pixel);
        MapProcessor.instance.getMapWriter().getBlockBiomeColour(world, null, state, (BlockPos)this.mutableBlockPos, this.biomeBuffer, biome);
        if (this.overlayNeedsBiome[pos_2d]) {
            this.biomeBuffer[1] = biome;
        }
        boolean glowing = MapProcessor.instance.getMapWriter().isGlowing(state);
        pixel.write(state, h, this.biomeBuffer, light, glowing, cave);
        return true;
    }

    public void getOverlayBiomeColour(World world, BlockState state, Block b, BlockPos pos, int[] dest) {
        dest[2] = 0;
        dest[0] = 0;
        dest[1] = -1;
        if (b == Blocks.field_150355_j) {
            dest[0] = 1;
            dest[1] = 1;
        } else {
            int customColour = Minecraft.func_71410_x().func_184125_al().func_216860_a(state, (IEnviromentBlockReader)world, pos, 0);
            if (customColour != 0xFFFFFF && customColour != -1) {
                dest[0] = 2;
                dest[2] = customColour;
            }
        }
    }

    private byte nibbleValue(byte[] array, int index) {
        byte b = array[index >> 1];
        if ((index & 1) == 0) {
            return (byte)(b & 0xF);
        }
        return (byte)(b >> 4 & 0xF);
    }

    class RegionFileSupplier
    implements Supplier<RegionFile> {
        public ChunkManager chunkManager;
        public ChunkPos chunkPos;

        RegionFileSupplier() {
        }

        @Override
        public RegionFile get() {
            WorldDataReader.this.loadFileMethod.setAccessible(true);
            RegionFile regionFile = null;
            try {
                regionFile = (RegionFile)WorldDataReader.this.loadFileMethod.invoke((Object)this.chunkManager, this.chunkPos);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            WorldDataReader.this.loadFileMethod.setAccessible(false);
            return regionFile;
        }
    }
}

