/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file.worldsave;

import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.LazyOptional;
import xaero.map.MapProcessor;
import xaero.map.capabilities.ServerWorldCapabilities;
import xaero.map.capabilities.ServerWorldLoaded;
import xaero.map.file.worldsave.WorldDataReader;
import xaero.map.region.MapRegion;

public class WorldDataHandler {
    private WorldDataReader worldDataReader;
    private ServerWorld worldServer;
    private File worldDir;

    public WorldDataHandler(WorldDataReader worldDataReader) {
        this.worldDataReader = worldDataReader;
    }

    public void prepareSingleplayer(World world, MapProcessor mapProcessor) {
        String worldString = mapProcessor.getCurrentWorldString();
        if (world != null && !mapProcessor.isWorldMultiplayer(mapProcessor.isWorldRealms(worldString), worldString)) {
            this.worldServer = DimensionManager.getWorld((MinecraftServer)Minecraft.func_71410_x().func_71401_C(), (DimensionType)world.func_201675_m().func_186058_p(), (boolean)false, (boolean)false);
            if (this.worldServer != null) {
                File overworldDir = Minecraft.func_71410_x().field_71412_D.toPath().resolve("saves").resolve(this.worldServer.func_73046_m().func_71270_I()).toFile();
                this.worldDir = this.worldServer.func_201675_m().func_186058_p().func_212679_a(overworldDir);
            } else {
                this.worldDir = null;
            }
        } else {
            this.worldServer = null;
            this.worldDir = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result buildRegion(MapRegion region, World world, boolean loading, int[] chunkCountDest) throws IOException {
        if (this.worldServer == null) {
            System.out.println("Tried loading a region for a null server world!");
            return Result.CANCEL;
        }
        LazyOptional capabilityValue = this.worldServer.getCapability(ServerWorldCapabilities.LOADED_CAP);
        if (capabilityValue.isPresent()) {
            ServerWorldLoaded loadedCap = (ServerWorldLoaded)capabilityValue.orElse(null);
            boolean shouldCancel = false;
            ServerWorldLoaded serverWorldLoaded = loadedCap;
            synchronized (serverWorldLoaded) {
                if (loadedCap.loaded) {
                    boolean buildResult = this.worldDataReader.buildRegion(region, this.worldServer, world, loading, chunkCountDest);
                    Result result = buildResult ? Result.SUCCESS : Result.FAIL;
                    return result;
                }
                shouldCancel = true;
            }
            if (shouldCancel) {
                System.out.println("Tried loading a region for an unloaded server world!");
                return Result.CANCEL;
            }
        }
        System.out.println("Server world capability required for Xaero's World Map not present!");
        return Result.FAIL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onServerWorldUnload(ServerWorld sw) {
        LazyOptional capabilityValue = sw.getCapability(ServerWorldCapabilities.LOADED_CAP);
        if (capabilityValue.isPresent()) {
            ServerWorldLoaded loadedCap;
            if (sw == this.worldServer) {
                this.worldDataReader.stopUsingServerThread(sw.func_73046_m());
            }
            ServerWorldLoaded serverWorldLoaded = loadedCap = (ServerWorldLoaded)capabilityValue.orElse(null);
            synchronized (serverWorldLoaded) {
                loadedCap.loaded = false;
            }
            this.worldDataReader.resumeUsingServerThread();
        }
    }

    public ServerWorld getWorldServer() {
        return this.worldServer;
    }

    public WorldDataReader getWorldDataReader() {
        return this.worldDataReader;
    }

    public File getWorldDir() {
        return this.worldDir;
    }

    public static enum Result {
        SUCCESS,
        FAIL,
        CANCEL;

    }
}

