/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file;

import com.mojang.blaze3d.platform.GlStateManager;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Hashtable;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL30;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.exception.OpenGLException;
import xaero.map.file.MapRegionInfo;
import xaero.map.file.RegionDetection;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.gui.GuiMap;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTileChunk;

public class PNGExporter {
    private Path destinationPath;

    public PNGExporter(Path destinationPath) {
        this.destinationPath = destinationPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export() throws IllegalArgumentException, IllegalAccessException, OpenGLException {
        int n;
        if (!MapProcessor.instance.getMapSaveLoad().isRegionDetectionComplete()) {
            WorldMap.LOGGER.info("Can't export the PNG just yet!");
            return;
        }
        Hashtable<Integer, Hashtable<Integer, MapRegion>> map = MapProcessor.instance.getCurrentMap(MapProcessor.instance.getCurrentDimension());
        Integer minX = null;
        Integer maxX = null;
        Integer minZ = null;
        Integer maxZ = null;
        for (Hashtable<Integer, MapRegion> hashtable : map.values()) {
            for (MapRegion mapRegion : hashtable.values()) {
                if (minX == null || mapRegion.getRegionX() < minX) {
                    minX = mapRegion.getRegionX();
                }
                if (maxX == null || mapRegion.getRegionX() > maxX) {
                    maxX = mapRegion.getRegionX();
                }
                if (minZ == null || mapRegion.getRegionZ() < minZ) {
                    minZ = mapRegion.getRegionZ();
                }
                if (maxZ != null && mapRegion.getRegionZ() <= maxZ) continue;
                maxZ = mapRegion.getRegionZ();
            }
        }
        for (Hashtable<Integer, MapRegionInfo> hashtable : MapProcessor.instance.getDetectedRegions(MapProcessor.instance.getCurrentDimension()).values()) {
            for (RegionDetection regionDetection : hashtable.values()) {
                if (minX == null || regionDetection.getRegionX() < minX) {
                    minX = regionDetection.getRegionX();
                }
                if (maxX == null || regionDetection.getRegionX() > maxX) {
                    maxX = regionDetection.getRegionX();
                }
                if (minZ == null || regionDetection.getRegionZ() < minZ) {
                    minZ = regionDetection.getRegionZ();
                }
                if (maxZ != null && regionDetection.getRegionZ() <= maxZ) continue;
                maxZ = regionDetection.getRegionZ();
            }
        }
        int exportWidthInRegions = maxX - minX + 1;
        float scale = exportWidthInRegions * (n = maxZ - minZ + 1) < 400 ? 1.0f : (float)Math.sqrt(400.0 / (double)(exportWidthInRegions * n));
        float f = 512.0f * scale;
        int exportWidth = (int)((float)exportWidthInRegions * f);
        int exportHeight = (int)((float)n * f);
        int maxTextureSize = GL11.glGetInteger((int)3379);
        OpenGLException.checkGLError();
        int frameWidth = Math.min(1024, Math.min(maxTextureSize, exportWidth));
        int frameHeight = Math.min(1024, Math.min(maxTextureSize, exportHeight));
        int horizontalFrames = (int)Math.ceil((double)exportWidth / (double)frameWidth);
        int verticalFrames = (int)Math.ceil((double)exportHeight / (double)frameHeight);
        if (WorldMap.settings.debug) {
            WorldMap.LOGGER.info(String.format("Exporting PNG of size %dx%d using a framebuffer of size %dx%d.", exportWidth, exportHeight, frameWidth, frameHeight));
        }
        ImprovedFramebuffer exportFrameBuffer = new ImprovedFramebuffer(frameWidth, frameHeight, false);
        ByteBuffer frameDataBuffer = BufferUtils.createByteBuffer((int)(frameWidth * frameHeight * 4));
        int[] bufferArray = new int[frameWidth * frameHeight];
        BufferedImage image = new BufferedImage(exportWidth, exportHeight, 1);
        if (exportFrameBuffer.field_147616_f == -1) {
            WorldMap.LOGGER.info("Can't export PNG because FBOs are not supported.");
            return;
        }
        GlStateManager.pushLightingAttributes();
        GlStateManager.disableLighting();
        GlStateManager.matrixMode((int)5889);
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        GlStateManager.ortho((double)0.0, (double)frameWidth, (double)0.0, (double)frameHeight, (double)0.0, (double)1000.0);
        GlStateManager.matrixMode((int)5888);
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        GlStateManager.disableCull();
        exportFrameBuffer.func_147610_a(true);
        GlStateManager.pushMatrix();
        GlStateManager.scalef((float)scale, (float)scale, (float)1.0f);
        for (int i = 0; i < horizontalFrames; ++i) {
            for (int j = 0; j < verticalFrames; ++j) {
                GlStateManager.bindTexture((int)0);
                GlStateManager.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.clear((int)16640, (boolean)Minecraft.field_142025_a);
                GlStateManager.pushMatrix();
                float frameLeft = (float)minX.intValue() * 512.0f + (float)(i * frameWidth) / scale;
                float frameRight = (float)minX.intValue() * 512.0f + (float)((i + 1) * frameWidth) / scale;
                float frameTop = (float)minZ.intValue() * 512.0f + (float)(j * frameHeight) / scale;
                float frameBottom = (float)minZ.intValue() * 512.0f + (float)((j + 1) * frameHeight) / scale;
                int minTileChunkX = (int)Math.floor(frameLeft) >> 6;
                int maxTileChunkX = (int)Math.floor(frameRight) >> 6;
                int minTileChunkZ = (int)Math.floor(frameTop) >> 6;
                int maxTileChunkZ = (int)Math.floor(frameBottom) >> 6;
                int minRegionX = minTileChunkX >> 3;
                int minRegionZ = minTileChunkZ >> 3;
                int maxRegionX = maxTileChunkX >> 3;
                int maxRegionZ = maxTileChunkZ >> 3;
                GlStateManager.translatef((float)(-frameLeft), (float)(-frameTop), (float)0.0f);
                for (int regionX = minRegionX; regionX <= maxRegionX; ++regionX) {
                    for (int regionZ = minRegionZ; regionZ <= maxRegionZ; ++regionZ) {
                        boolean specialRegion = false;
                        MapRegion region = MapProcessor.instance.getMapRegion(regionX, regionZ, false);
                        if (region == null || region.getLoadState() < 4 && (!region.isBeingWritten() || region.getLoadState() != 2)) {
                            File cacheFile = null;
                            if (region != null) {
                                cacheFile = region.getCacheFile();
                            } else if (MapProcessor.instance.regionExists(regionX, regionZ)) {
                                cacheFile = MapProcessor.instance.getRegionDetection(regionX, regionZ).getCacheFile();
                            }
                            if (cacheFile == null) continue;
                            region = new MapRegion("png", "export", regionX, regionZ);
                            region.setCacheFile(cacheFile);
                            region.loadCacheTextures();
                            specialRegion = true;
                        }
                        for (int localChunkX = 0; localChunkX < 8; ++localChunkX) {
                            for (int localChunkZ = 0; localChunkZ < 8; ++localChunkZ) {
                                MapTileChunk tileChunk = region.getChunk(localChunkX, localChunkZ);
                                if (tileChunk == null) continue;
                                if (tileChunk.getX() < minTileChunkX || tileChunk.getX() > maxTileChunkX || tileChunk.getZ() < minTileChunkZ || tileChunk.getZ() > maxTileChunkZ) {
                                    if (!specialRegion) continue;
                                    tileChunk.deleteBuffers();
                                    continue;
                                }
                                if (specialRegion) {
                                    tileChunk.bindColorTexture(true, 9728);
                                    if (tileChunk.getColorBufferIsCompressed()) {
                                        GL13.glCompressedTexImage2D((int)3553, (int)0, (int)tileChunk.getColorBufferFormat(), (int)64, (int)64, (int)0, (ByteBuffer)tileChunk.getColorBuffer());
                                    } else {
                                        GL11.glTexImage2D((int)3553, (int)0, (int)tileChunk.getColorBufferFormat(), (int)64, (int)64, (int)0, (int)32993, (int)32821, (ByteBuffer)tileChunk.getColorBuffer());
                                    }
                                    if (GL.getCapabilities().OpenGL30) {
                                        GL30.glGenerateMipmap((int)3553);
                                    }
                                    tileChunk.deleteBuffers();
                                } else {
                                    if (tileChunk.getGlColorTexture() == -1) continue;
                                    tileChunk.bindColorTexture(false, 9728);
                                }
                                GlStateManager.texParameter((int)3553, (int)33082, (float)0.0f);
                                GlStateManager.texParameter((int)3553, (int)10241, (int)9987);
                                GuiMap.renderTexturedModalRect(tileChunk.getX() * 64, tileChunk.getZ() * 64, 0, 0, 64.0f, 64.0f, 64.0f, 64.0f);
                                GlStateManager.texParameter((int)3553, (int)10241, (int)9984);
                                if (!specialRegion) continue;
                                GlStateManager.deleteTexture((int)tileChunk.getGlColorTexture());
                            }
                        }
                    }
                }
                GlStateManager.popMatrix();
                GlStateManager.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                exportFrameBuffer.func_147612_c();
                frameDataBuffer.clear();
                GL11.glGetTexImage((int)3553, (int)0, (int)32993, (int)33639, (ByteBuffer)frameDataBuffer);
                frameDataBuffer.asIntBuffer().get(bufferArray);
                int actualFrameWidth = Math.min(frameWidth, exportWidth - i * frameWidth);
                int actualFrameHeight = Math.min(frameHeight, exportHeight - j * frameWidth);
                image.setRGB(i * frameWidth, j * frameHeight, actualFrameWidth, actualFrameHeight, bufferArray, 0, frameWidth);
            }
        }
        GlStateManager.popMatrix();
        GlStateManager.popAttributes();
        exportFrameBuffer.func_147609_e();
        GlStateManager.enableCull();
        GlStateManager.popMatrix();
        GlStateManager.matrixMode((int)5889);
        GlStateManager.popMatrix();
        GlStateManager.matrixMode((int)5888);
        GlStateManager.bindTexture((int)0);
        exportFrameBuffer.func_147608_a();
        MapProcessor.instance.getBufferDeallocator().deallocate(frameDataBuffer, WorldMap.settings.debug);
        Stream<Path> exports = null;
        try {
            Object[] exportsArray;
            Files.createDirectories(this.destinationPath, new FileAttribute[0]);
            int exportNumber = 1;
            exports = Files.list(this.destinationPath);
            if (exports == null) {
                return;
            }
            for (Object o : exportsArray = exports.toArray()) {
                Path path = (Path)o;
                if (!path.getFileName().toString().endsWith("png")) continue;
                try {
                    int currentNumber = Integer.parseInt(path.getFileName().toString().split("\\.")[0].split("_")[1]);
                    if (currentNumber < exportNumber) continue;
                    exportNumber = currentNumber + 1;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            ImageIO.write((RenderedImage)image, "png", this.destinationPath.resolve("export_" + exportNumber + ".png").toFile());
        }
        catch (IOException e1) {
            WorldMap.LOGGER.info("Failed to export PNG: ");
            e1.printStackTrace();
        }
        finally {
            if (exports != null) {
                exports.close();
            }
            image.flush();
        }
    }
}

