/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.util.ResourceLocation;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;

public class OldFormatSupport {
    private ResourceLocation vanillaStatesResource = new ResourceLocation("xaeroworldmap", "vanilla_states.dat");
    private boolean vanillaStatesLoaded;
    private HashMap<Integer, HashMap<Integer, BlockState>> vanilla_states = new HashMap();
    private ImmutableMap<String, String> blockRename1314 = ImmutableMap.of((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab", (Object)"minecraft:sign", (Object)"minecraft:oak_sign", (Object)"minecraft:wall_sign", (Object)"minecraft:oak_wall_sign");

    public void loadVanillaStates() throws IOException, CommandSyntaxException {
        if (WorldMap.settings.debug) {
            WorldMap.LOGGER.info("Loading vanilla states...");
        }
        this.loadStates(this.vanilla_states, Minecraft.func_71410_x().func_195551_G().func_199002_a(this.vanillaStatesResource).func_199027_b());
        this.vanillaStatesLoaded = true;
    }

    public void loadModdedStates(String world) throws FileNotFoundException, IOException, CommandSyntaxException {
        if (world == null) {
            return;
        }
        if (WorldMap.settings.debug) {
            WorldMap.LOGGER.info("Loading modded states for the world...");
        }
        boolean realms = world.startsWith("Realms_");
        boolean multiplayer = world.startsWith("Multiplayer_") || realms;
        Path mainFolder = MapProcessor.instance.getMapSaveLoad().getMainFolder(world, multiplayer);
        Path subFolder = MapProcessor.instance.getMapSaveLoad().getSubFolder(world, mainFolder, multiplayer);
        Path inputPath = subFolder.resolve("states.dat");
        Files.createDirectories(inputPath.getParent(), new FileAttribute[0]);
    }

    private void loadStates(HashMap<Integer, HashMap<Integer, BlockState>> stateMap, InputStream inputStream) throws IOException, CommandSyntaxException {
        DataInputStream input = new DataInputStream(new BufferedInputStream(inputStream));
        try {
            while (true) {
                int stateId = input.readInt();
                int blockId = stateId & 0xFFF;
                int meta = stateId >> 12 & 0xFFFFF;
                CompoundNBT nbtCompound = CompressedStreamTools.func_74794_a((DataInputStream)input);
                this.fixBlockName1314(nbtCompound);
                BlockState blockState = MapProcessor.instance.getMapSaveLoad().getBlockStateFromNBT(nbtCompound);
                this.putState(stateMap, blockId, meta, blockState);
            }
        }
        catch (EOFException eOFException) {
            if (WorldMap.settings.debug) {
                WorldMap.LOGGER.info("Done.");
            }
            input.close();
            return;
        }
    }

    public void loadStates(String currentWorldString) throws IOException, CommandSyntaxException {
        if (!this.vanillaStatesLoaded) {
            this.loadVanillaStates();
        }
    }

    private void putState(HashMap<Integer, HashMap<Integer, BlockState>> stateMap, int blockId, int meta, BlockState blockState) {
        HashMap<Integer, Object> blockStates = stateMap.get(blockId);
        if (blockStates == null) {
            blockStates = new HashMap();
            stateMap.put(blockId, blockStates);
        }
        blockStates.put(meta, blockState);
    }

    private BlockState getStateForId(int stateId, HashMap<Integer, HashMap<Integer, BlockState>> stateMap) {
        int blockId = stateId & 0xFFF;
        HashMap<Integer, BlockState> blockStates = stateMap.get(blockId);
        if (blockStates == null) {
            return null;
        }
        int meta = stateId >> 12 & 0xFFFFF;
        return blockStates.getOrDefault(meta, null);
    }

    public BlockState getStateForId(int stateId) {
        BlockState vanillaState = this.getStateForId(stateId, this.vanilla_states);
        if (vanillaState != null) {
            return vanillaState;
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public void fixBlockName1314(CompoundNBT nbt) {
        String name = nbt.func_74779_i("Name");
        nbt.func_74778_a("Name", (String)this.blockRename1314.getOrDefault((Object)name, (Object)name));
    }
}

