/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.gui.screens.RealmsLongRunningMcoTaskScreen;
import com.mojang.realmsclient.util.RealmsTasks;
import java.lang.reflect.Field;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.DeathScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WorldSelectionScreen;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.realms.RealmsScreenProxy;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.capabilities.ServerWorldCapabilities;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiUpdate;
import xaero.patreon.GuiUpdateAll;
import xaero.patreon.Patreon4;

public class Events {
    private RealmsServer latestRealm;
    private Field realmsTaskField;
    private Field realmsTaskServerField;
    private Screen lastClickOn;
    private static boolean askedToUpdate = false;

    @SubscribeEvent
    public void guiButtonClick(GuiScreenEvent.ActionPerformedEvent event) {
        if (event.getGui() instanceof DeathScreen || event.getGui() instanceof ConfirmScreen && this.lastClickOn instanceof DeathScreen) {
            MapProcessor.instance.onPlayerDied();
        }
        this.lastClickOn = event.getGui();
    }

    @SubscribeEvent
    public void guiOpen(GuiOpenEvent event) {
        if (event.getGui() instanceof WorldSelectionScreen) {
            // empty if block
        }
        if (event.getGui() instanceof RealmsScreenProxy && ((RealmsScreenProxy)event.getGui()).getScreen() instanceof RealmsLongRunningMcoTaskScreen) {
            try {
                RealmsTasks.RealmsGetServerDetailsTask realmsTask;
                RealmsServer realm;
                RealmsLongRunningMcoTaskScreen realmsTaskScreen;
                Object task;
                if (this.realmsTaskField == null) {
                    this.realmsTaskField = RealmsLongRunningMcoTaskScreen.class.getDeclaredField("field_224248_l");
                    this.realmsTaskField.setAccessible(true);
                }
                if (this.realmsTaskServerField == null) {
                    this.realmsTaskServerField = RealmsTasks.RealmsGetServerDetailsTask.class.getDeclaredField("field_225007_b");
                    this.realmsTaskServerField.setAccessible(true);
                }
                if ((task = this.realmsTaskField.get(realmsTaskScreen = (RealmsLongRunningMcoTaskScreen)((RealmsScreenProxy)event.getGui()).getScreen())) instanceof RealmsTasks.RealmsGetServerDetailsTask && (realm = (RealmsServer)this.realmsTaskServerField.get(realmsTask = (RealmsTasks.RealmsGetServerDetailsTask)task)) != null && (this.latestRealm == null || realm.id != this.latestRealm.id)) {
                    this.latestRealm = realm;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) throws Exception {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.END) {
            MapProcessor.instance.onRenderProcess(mc);
            mc.field_71454_w = false;
            MapProcessor.instance.resetRenderStartTime();
            Queue<Runnable> minecraftScheduledTasks = MapProcessor.instance.getMinecraftScheduledTasks();
            Runnable task = MapProcessor.instance.getRenderStartTimeUpdater();
            Runnable[] currentTasks = minecraftScheduledTasks.toArray(new Runnable[0]);
            minecraftScheduledTasks.clear();
            minecraftScheduledTasks.add(task);
            for (Runnable t : currentTasks) {
                minecraftScheduledTasks.add(t);
            }
        } else if (event.phase == TickEvent.Phase.START) {
            if (mc.field_71462_r instanceof GuiMap) {
                GlStateManager.enableDepthTest();
                mc.field_71460_t.func_195458_a(1.0f, Util.func_211178_c(), false);
                mc.field_71454_w = true;
            }
            if (MapProcessor.instance != null) {
                MapProcessor.instance.setMainValues();
            }
        }
    }

    @SubscribeEvent
    public void renderTick(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (event.getGui() instanceof GuiUpdate) {
            askedToUpdate = true;
        } else if (!askedToUpdate && WorldMap.isOutdated && event.getGui() instanceof MainMenuScreen) {
            if (Patreon4.patronPledge >= 5) {
                Minecraft.func_71410_x().func_147108_a((Screen)new GuiUpdateAll());
            } else {
                Minecraft.func_71410_x().func_147108_a((Screen)new GuiUpdate());
            }
            WorldMap.LOGGER.info("World Map is outdated!");
        } else if (WorldMap.isOutdated) {
            WorldMap.isOutdated = false;
        }
    }

    @SubscribeEvent
    public void renderPlayer(RenderPlayerEvent.Post event) {
        Patreon4.renderCape(WorldMap.fileLayoutID, event);
    }

    @SubscribeEvent
    public void spawnSet(PlayerSetSpawnEvent event) {
        if (event.getPlayer().field_70170_p instanceof ClientWorld) {
            MapProcessor.instance.updateWorldSpawn(event.getNewSpawn(), event.getPlayer().field_70170_p);
        }
    }

    @SubscribeEvent
    public void worldCapabilities(AttachCapabilitiesEvent<World> event) {
        if (event.getObject() instanceof ServerWorld) {
            event.addCapability(new ResourceLocation("xaeroworldmap", "server_world_caps"), (ICapabilityProvider)new ServerWorldCapabilities());
        }
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        if (Minecraft.func_71410_x().field_71439_g != null && event.getWorld() == MapProcessor.instance.mainWorld) {
            MapProcessor.instance.onWorldUnload();
        }
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld sw = (ServerWorld)event.getWorld();
            MapProcessor.instance.getWorldDataHandler().onServerWorldUnload(sw);
        }
    }

    public RealmsServer getLatestRealm() {
        return this.latestRealm;
    }
}

