/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xaero.deallocator.ByteBufferDeallocator;
import xaero.map.MapLimiter;
import xaero.map.MapProcessor;
import xaero.map.MapWriter;
import xaero.map.capabilities.ServerWorldCapabilities;
import xaero.map.controls.ControlsHandler;
import xaero.map.events.Events;
import xaero.map.events.FMLEvents;
import xaero.map.events.ModEvents;
import xaero.map.file.MapSaveLoad;
import xaero.map.file.OldFormatSupport;
import xaero.map.file.PNGExporter;
import xaero.map.file.worldsave.WorldDataHandler;
import xaero.map.file.worldsave.WorldDataReader;
import xaero.map.graphics.TextureUploadBenchmark;
import xaero.map.graphics.TextureUploader;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.WaypointSymbolCreator;
import xaero.map.pool.MapTilePool;
import xaero.map.pool.TextureUploadPool;
import xaero.map.region.OverlayManager;
import xaero.map.settings.ModOptions;
import xaero.map.settings.ModSettings;
import xaero.patreon.Patreon4;
import xaero.patreon.PatreonMod2;

@Mod(value="xaeroworldmap")
public class WorldMap {
    public static Logger LOGGER = LogManager.getLogger();
    public static final String versionID = "1.14.4_1.5.7";
    public static int newestUpdateID;
    public static boolean isOutdated;
    public static String fileLayout;
    public static String fileLayoutID;
    public static String latestVersion;
    public static Events events;
    public static FMLEvents fmlEvents;
    public static ControlsHandler ch;
    public static WaypointSymbolCreator waypointSymbolCreator;
    public static final ResourceLocation guiTextures;
    public static File oldOptionsFile;
    public static File oldSaveFolder;
    public static File oldSaveFolder2;
    public static ModSettings settings;
    public static int globalVersion;
    public static File modJAR;
    public static File configFolder;
    public static File optionsFile;
    public static File saveFolder;
    public static Thread mapProcessorThread;
    public static Thread mapWriterThread;

    public static PatreonMod2 getPatreon() {
        return Patreon4.mods.get(fileLayoutID);
    }

    public WorldMap() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadClient);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void loadClient(FMLClientSetupEvent event) {
        try {
            LOGGER.info("Loading Xaero's World Map - Stage 1/2");
            ModOptions.init();
            ModFile modFile = FMLLoader.getLoadingModList().getModFileById("xaeroworldmap").getFile();
            String fileName = modFile.getFileName();
            if (fileName.endsWith(".jar")) {
                modJAR = modFile.getFilePath().toFile();
            }
            Path gameDir = FMLPaths.GAMEDIR.get();
            configFolder = FMLPaths.CONFIGDIR.get().toFile();
            optionsFile = configFolder.toPath().resolve("xaeroworldmap.txt").toFile();
            saveFolder = gameDir.resolve("XaeroWorldMap").toFile();
            Path oldSaveFolder3 = configFolder.toPath().getParent().resolve("XaeroWorldMap");
            if (oldOptionsFile.exists() && !optionsFile.exists()) {
                Files.move(oldOptionsFile.toPath(), optionsFile.toPath(), new CopyOption[0]);
            }
            if (oldSaveFolder.exists() && !saveFolder.exists()) {
                Files.move(oldSaveFolder.toPath(), saveFolder.toPath(), new CopyOption[0]);
            }
            if (oldSaveFolder2.exists() && !saveFolder.exists()) {
                Files.move(oldSaveFolder2.toPath(), saveFolder.toPath(), new CopyOption[0]);
            }
            if (oldSaveFolder3.toFile().exists() && !saveFolder.exists()) {
                Files.move(oldSaveFolder3, saveFolder.toPath(), new CopyOption[0]);
            }
            if (!saveFolder.exists()) {
                Files.createDirectories(saveFolder.toPath(), new FileAttribute[0]);
            }
            Patreon4.checkPatreon();
            Patreon4.rendersCapes = fileLayoutID;
            settings = new ModSettings();
            settings.loadSettings();
            this.checkModVersion();
            if (Patreon4.patronPledge >= 5 && isOutdated) {
                WorldMap.getPatreon().modJar = modJAR;
                WorldMap.getPatreon().currentVersion = versionID;
                WorldMap.getPatreon().latestVersion = latestVersion;
                Patreon4.addOutdatedMod(WorldMap.getPatreon());
            }
            waypointSymbolCreator = new WaypointSymbolCreator();
            ch = new ControlsHandler();
            events = new Events();
            fmlEvents = new FMLEvents();
            ModEvents modEvents = new ModEvents();
            MinecraftForge.EVENT_BUS.register((Object)events);
            MinecraftForge.EVENT_BUS.register((Object)fmlEvents);
            modEvents.addListeners(FMLJavaModLoadingContext.get().getModEventBus());
            ServerWorldCapabilities.registerCapabilities();
            ByteBufferDeallocator bufferDeallocator = new ByteBufferDeallocator();
            MapTilePool tilePool = new MapTilePool();
            OverlayManager overlayManager = new OverlayManager();
            OldFormatSupport oldFormatSupport = new OldFormatSupport();
            PNGExporter pngExporter = new PNGExporter(configFolder.toPath().getParent().resolve("map exports"));
            MapSaveLoad mapSaveLoad = new MapSaveLoad(overlayManager, pngExporter, oldFormatSupport);
            MapWriter mapWriter = new MapWriter(overlayManager);
            MapLimiter mapLimiter = new MapLimiter();
            TextureUploadPool.Normal normalTextureUploadPool = new TextureUploadPool.Normal(256);
            TextureUploadPool.NormalWithDownload normalWithDownloadTextureUploadPool = new TextureUploadPool.NormalWithDownload(256);
            TextureUploadPool.Compressed compressedTextureUploadPool = new TextureUploadPool.Compressed(256);
            TextureUploadBenchmark textureUploadBenchmark = new TextureUploadBenchmark(512, 512, 512);
            TextureUploader textureUploader = new TextureUploader(normalTextureUploadPool, normalWithDownloadTextureUploadPool, compressedTextureUploadPool, textureUploadBenchmark);
            WorldDataHandler worldDataHandler = new WorldDataHandler(new WorldDataReader(overlayManager));
            MapProcessor mapProcessor = new MapProcessor(mapSaveLoad, mapWriter, mapLimiter, bufferDeallocator, tilePool, overlayManager, textureUploader, worldDataHandler);
            mapProcessorThread = new Thread(mapProcessor);
            mapProcessorThread.start();
            mapWriterThread = new Thread(mapWriter);
            mapWriterThread.start();
            DeferredWorkQueue.runLater(this::loadLater);
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadLater() {
        LOGGER.info("Loading Xaero's World Map - Stage 2/2");
        SupportMods.load();
    }

    public void checkModVersion() {
        String s = "http://data.chocolateminecraft.com/Versions/WorldMap.txt";
        s = s.replaceAll(" ", "%20");
        try {
            URL url = new URL(s);
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(900);
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = reader.readLine();
            if (line != null) {
                newestUpdateID = Integer.parseInt(line);
                if (!ModSettings.updateNotification || newestUpdateID == ModSettings.ignoreUpdate) {
                    isOutdated = false;
                    reader.close();
                    return;
                }
            }
            String[] current = versionID.split("_");
            while ((line = reader.readLine()) != null) {
                String[] args;
                if (line.equals(versionID)) {
                    isOutdated = false;
                    break;
                }
                if (Patreon4.patronPledge < 5 || !line.startsWith(current[0]) || current.length != 2 && !line.endsWith(current[2]) || (args = line.split("_")).length != current.length) continue;
                latestVersion = args[1];
            }
            reader.close();
        }
        catch (Exception e) {
            isOutdated = false;
        }
    }

    static {
        isOutdated = true;
        fileLayout = "XaerosWorldMap_&mod_Forge_&mc.jar";
        fileLayoutID = "worldmap";
        guiTextures = new ResourceLocation("xaeroworldmap", "gui/gui.png");
        oldOptionsFile = new File("./xaeroworldmap.txt");
        oldSaveFolder = new File("./mods/XaeroWorldMap");
        oldSaveFolder2 = new File("./config/XaeroWorldMap");
        globalVersion = 1;
        modJAR = null;
    }
}

