/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FlowerBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.GlassBlock;
import net.minecraft.block.OreBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.IFluidState;
import net.minecraft.resources.IResource;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.registries.GameData;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.Overlay;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;

public class MapWriter
implements Runnable {
    public static final String[] DEFAULT_RESOURCE = new String[]{"minecraft", ""};
    private int X;
    private int Z;
    private int playerChunkX;
    private int playerChunkZ;
    private int insideX;
    private int insideZ;
    private long updateCounter;
    private boolean clearCachedColours;
    private MapBlock loadingObject;
    private OverlayBuilder overlayBuilder;
    private BlockPos.MutableBlockPos mutableLocalPos;
    private BlockPos.MutableBlockPos mutableGlobalPos;
    private int[] biomeBuffer;
    private int grassColor;
    private int foliageColor;
    private SimpleRegistry<Biome> biomeRegistry;
    private Random usedRandom = new Random(0L);
    private HashMap<String, Integer> textureColours;
    private HashMap<BlockState, Integer> blockColours;

    public MapWriter(OverlayManager overlayManager) {
        this.loadingObject = new MapBlock();
        this.textureColours = new HashMap();
        this.blockColours = new HashMap();
        this.overlayBuilder = new OverlayBuilder(overlayManager);
        this.mutableLocalPos = new BlockPos.MutableBlockPos();
        this.mutableGlobalPos = new BlockPos.MutableBlockPos();
        this.biomeBuffer = new int[3];
        this.biomeRegistry = GameData.getWrapper(Biome.class);
        this.updateGrassColor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block12: while (true) {
            try {
                while (MapProcessor.instance.getCrashedBy() == null) {
                    long startTime = System.currentTimeMillis();
                    int totalTime = 2000000;
                    int sleepTime = 10;
                    while (totalTime > 0) {
                        try {
                            Object object = MapProcessor.instance.writerThreadPauseSync;
                            synchronized (object) {
                                if (!MapProcessor.instance.isWritingPaused() && !MapProcessor.instance.isWaitingForWorldUpdate() && MapProcessor.instance.getMapSaveLoad().isRegionDetectionComplete()) {
                                    double playerZ;
                                    double playerY;
                                    double playerX;
                                    long processStart;
                                    if (MapProcessor.instance.getWorld() == null || !MapProcessor.instance.caveStartIsDetermined()) {
                                        sleepTime = 100;
                                        break;
                                    }
                                    if (MapProcessor.instance.getCurrentWorldString() != null && !MapProcessor.instance.ignoreWorld(MapProcessor.instance.getWorld()) && (WorldMap.settings.updateChunks || WorldMap.settings.loadChunks)) {
                                        processStart = System.nanoTime();
                                        Object object2 = MapProcessor.instance.mainStuffSync;
                                        synchronized (object2) {
                                            if (MapProcessor.instance.mainWorld != MapProcessor.instance.getWorld()) {
                                                sleepTime = 100;
                                                break;
                                            }
                                            playerX = MapProcessor.instance.mainPlayerX;
                                            playerY = MapProcessor.instance.mainPlayerY;
                                            playerZ = MapProcessor.instance.mainPlayerZ;
                                        }
                                    }
                                    break;
                                    this.writeMap(MapProcessor.instance.getWorld(), playerX, playerY, playerZ);
                                    totalTime = (int)((long)totalTime - (System.nanoTime() - processStart));
                                    if (this.insideX == 0 && this.insideZ == 0 && this.X == 0 && this.Z == 0) {
                                        sleepTime = 200;
                                        break;
                                    }
                                } else {
                                    break;
                                }
                            }
                        }
                        catch (ConcurrentModificationException concurrentModificationException) {
                        }
                    }
                    int passed = (int)(System.currentTimeMillis() - startTime);
                    try {
                        if (passed >= sleepTime) continue block12;
                        Thread.sleep(sleepTime - passed);
                        continue block12;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                break;
            }
            catch (Throwable e) {
                MapProcessor.instance.setCrashedBy(e);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMap(World world, double playerX, double playerY, double playerZ) {
        int loadDistance = Minecraft.func_71410_x().field_71474_y.field_151451_c;
        World world2 = world;
        synchronized (world2) {
            if (this.insideX == 0 && this.insideZ == 0) {
                this.playerChunkX = (int)Math.floor(playerX) >> 4;
                this.playerChunkZ = (int)Math.floor(playerZ) >> 4;
            }
            this.writeChunk(world, loadDistance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChunk(World world, int distance) {
        boolean onlyLoad = WorldMap.settings.loadChunks && (!WorldMap.settings.updateChunks || this.updateCounter % 5L != 0L);
        int playerTileChunkX = this.playerChunkX >> 2;
        int playerTileChunkZ = this.playerChunkZ >> 2;
        int distanceInTileChunks = playerTileChunkX - (this.playerChunkX - distance >> 2);
        int tileChunkX = playerTileChunkX - distanceInTileChunks + this.X;
        int tileChunkZ = playerTileChunkZ - distanceInTileChunks + this.Z;
        int regionX = tileChunkX >> 3;
        int regionZ = tileChunkZ >> 3;
        MapRegion region = MapProcessor.instance.getMapRegion(regionX, regionZ, true);
        MapTileChunk tileChunk = null;
        Object object = region.writerThreadPauseSync;
        synchronized (object) {
            if (!region.isWritingPaused()) {
                boolean regionIsResting;
                MapRegion mapRegion = region;
                synchronized (mapRegion) {
                    if (region.getLoadState() == 2) {
                        region.registerVisit();
                    }
                    if (regionIsResting = region.isResting()) {
                        region.setBeingWritten(true);
                        int tileChunkLocalX = tileChunkX & 7;
                        int tileChunkLocalZ = tileChunkZ & 7;
                        tileChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ);
                        if (region.getLoadState() == 2 && tileChunk == null) {
                            tileChunk = new MapTileChunk(region, tileChunkX, tileChunkZ);
                            region.setChunk(tileChunkLocalX, tileChunkLocalZ, tileChunk);
                            tileChunk.setLoadState((byte)2);
                        } else if (!(region.reloadHasBeenRequested() || region.recacheHasBeenRequested() || region.getLoadState() != 0 && region.getLoadState() != 4)) {
                            MapProcessor.instance.getMapSaveLoad().requestLoad(region, "writing");
                        }
                    }
                }
                if (regionIsResting && region.getLoadState() == 2 && tileChunk != null && tileChunk.getLoadState() == 2) {
                    if (!tileChunk.shouldUpload()) {
                        Chunk chunk;
                        int caveStart = MapProcessor.instance.getCaveStart();
                        int chunkX = tileChunkX * 4 + this.insideX;
                        int chunkZ = tileChunkZ * 4 + this.insideZ;
                        if (chunkX >= this.playerChunkX - distance && chunkX < this.playerChunkX + distance && chunkZ >= this.playerChunkZ - distance && chunkZ < this.playerChunkZ + distance && (chunk = (Chunk)world.func_217353_a(chunkX, chunkZ, ChunkStatus.field_222617_m, false)) != null && !(chunk instanceof EmptyChunk)) {
                            boolean connectedToOthers = false;
                            block12: for (int i = -1; i < 2; ++i) {
                                for (int j = -1; j < 2; ++j) {
                                    Chunk neighbor;
                                    if (i == 0 && j == 0 || (neighbor = world.func_212866_a_(chunkX + i, chunkZ + j)) == null || neighbor instanceof EmptyChunk) continue;
                                    connectedToOthers = true;
                                    break block12;
                                }
                            }
                            if (connectedToOthers) {
                                MapTile mapTile = tileChunk.getTile(this.insideX, this.insideZ);
                                MapTileChunk prevTileChunk = null;
                                if (mapTile == null && WorldMap.settings.loadChunks || mapTile != null && WorldMap.settings.updateChunks && !onlyLoad) {
                                    if (mapTile == null) {
                                        mapTile = MapProcessor.instance.getTilePool().get(MapProcessor.instance.getCurrentDimension(), chunkX, chunkZ);
                                        tileChunk.setChanged(true);
                                    }
                                    if (mapTile.getPrevTile() == null) {
                                        prevTileChunk = tileChunk.findPrevTile(null, mapTile, this.insideX, this.insideZ);
                                    }
                                    for (int x = 0; x < 16; ++x) {
                                        for (int z = 0; z < 16; ++z) {
                                            int startHeight = chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, x, z) + 3;
                                            if (caveStart != -1) {
                                                startHeight = caveStart;
                                            }
                                            MapBlock currentPixel = mapTile.getBlock(x, z);
                                            this.loadPixel(world, this.loadingObject, currentPixel, chunk, x, z, startHeight, 0, caveStart != -1, mapTile.wasWrittenOnce());
                                            this.loadingObject.fixHeightType(world, x, z, mapTile.getPrevTile(), mapTile, tileChunk, prevTileChunk);
                                            if (this.loadingObject.equals(currentPixel)) continue;
                                            mapTile.setBlock(x, z, this.loadingObject);
                                            this.loadingObject = currentPixel != null ? currentPixel : new MapBlock();
                                            tileChunk.setChanged(true);
                                        }
                                    }
                                    tileChunk.setTile(this.insideX, this.insideZ, mapTile);
                                    mapTile.setWrittenOnce(true);
                                    mapTile.setLoaded(true);
                                }
                            }
                        }
                    }
                    if (!tileChunk.includeInSave()) {
                        tileChunk = null;
                        region.setChunk(tileChunkX & 7, tileChunkZ & 7, null);
                    }
                }
            }
        }
        ++this.insideZ;
        if (this.insideZ > 3) {
            this.insideZ = 0;
            ++this.insideX;
            if (this.insideX > 3) {
                this.insideX = 0;
                object = region.writerThreadPauseSync;
                synchronized (object) {
                    if (tileChunk != null && !region.isWritingPaused()) {
                        boolean regionIsStillWritable = false;
                        MapRegion caveStart = region;
                        synchronized (caveStart) {
                            boolean bl = regionIsStillWritable = region.isResting() && region.getLoadState() == 2;
                            if (regionIsStillWritable) {
                                region.setBeingWritten(true);
                            }
                        }
                        if (tileChunk.wasChanged()) {
                            if (regionIsStillWritable) {
                                MapTileChunk nextChunk;
                                tileChunk.updateBuffers(world);
                                int localTileChunkZ = tileChunkZ & 7;
                                if (localTileChunkZ < 7) {
                                    nextChunk = region.getChunk(tileChunkX & 7, localTileChunkZ + 1);
                                    if (nextChunk != null && nextChunk.tileChunkShouldTriggerUpdate(tileChunk)) {
                                        nextChunk.updateBuffers(world);
                                    }
                                } else {
                                    int nextRegionVersion;
                                    MapRegion nextRegion = MapProcessor.instance.getMapRegion(region.getRegionX(), region.getRegionZ() + 1, false);
                                    if (nextRegion != null && (nextRegionVersion = nextRegion.getVersion()) > 0 && (nextChunk = nextRegion.getChunk(tileChunkX & 7, 0)) != null && nextChunk.tileChunkShouldTriggerUpdate(tileChunk)) {
                                        nextRegion.setVersion(nextRegionVersion - 1);
                                    }
                                }
                            }
                            tileChunk.setChanged(false);
                        }
                    }
                }
                ++this.Z;
                if (this.Z > distanceInTileChunks * 2) {
                    this.Z = 0;
                    ++this.X;
                    if (this.X > distanceInTileChunks * 2) {
                        this.X = 0;
                        ++this.updateCounter;
                    }
                }
            }
        }
    }

    public int getBiomeColor(int type, BlockPos.MutableBlockPos pos, MapTile tile, World world) {
        int i = 0;
        int j = 0;
        int k = 0;
        int total = 0;
        int initX = pos.func_177958_n();
        int initZ = pos.func_177952_p();
        for (int o = -1; o < 2; ++o) {
            for (int p = -1; p < 2; ++p) {
                pos.func_181079_c(initX + o, pos.func_177956_o(), initZ + p);
                Integer b = this.getBiomeAtPos((BlockPos)pos, tile);
                if (b == null) continue;
                if (b == -1 && type == 2) {
                    b = this.biomeRegistry.func_148757_b((Object)Biomes.field_76781_i);
                }
                if (b == -1) continue;
                int l = 0;
                Biome gen = (Biome)this.biomeRegistry.func_148745_a(b.intValue());
                if (gen == null) {
                    gen = world.func_72863_F().func_201711_g().func_202090_b().func_222364_a((BlockPos)pos);
                }
                if (gen == null) continue;
                l = type == 0 ? gen.func_180627_b((BlockPos)pos) : (type == 1 ? gen.func_180625_c((BlockPos)pos) : gen.func_185361_o());
                i += l >> 16 & 0xFF;
                j += l >> 8 & 0xFF;
                k += l & 0xFF;
                ++total;
            }
        }
        pos.func_181079_c(initX, pos.func_177956_o(), initZ);
        if (total == 0) {
            return 0;
        }
        return (i / total & 0xFF) << 16 | (j / total & 0xFF) << 8 | k / total & 0xFF;
    }

    public Integer getBiomeAtPos(BlockPos pos, MapTile centerTile) {
        MapTile tile;
        int tileX = pos.func_177958_n() >> 4;
        int tileZ = pos.func_177952_p() >> 4;
        MapTile mapTile = tile = tileX == centerTile.getChunkX() && tileZ == centerTile.getChunkZ() ? centerTile : MapProcessor.instance.getMapTile(tileX, tileZ);
        if (tile != null && tile.isLoaded()) {
            return tile.getBlock(pos.func_177958_n() & 0xF, pos.func_177952_p() & 0xF).getBiome();
        }
        return null;
    }

    public boolean isGlowing(BlockState state) {
        return (double)state.func_185906_d() >= 0.5;
    }

    public boolean shouldOverlay(BlockRenderLayer renderLayer, Block b, int lightOpacity) {
        return renderLayer == BlockRenderLayer.TRANSLUCENT && lightOpacity != 255 || b instanceof GlassBlock;
    }

    public boolean isInvisible(World world, BlockState state, Block b) {
        if (!(b instanceof FlowingFluidBlock) && state.func_185901_i() == BlockRenderType.INVISIBLE) {
            return true;
        }
        if (b == Blocks.field_150478_aa) {
            return true;
        }
        if (b == Blocks.field_150349_c) {
            return true;
        }
        if (b instanceof DoublePlantBlock) {
            return true;
        }
        if ((b instanceof FlowerBlock || b instanceof DoublePlantBlock) && !WorldMap.settings.flowers) {
            return true;
        }
        MaterialColor materialColor = state.func_185909_g((IBlockReader)world, (BlockPos)this.mutableGlobalPos);
        return materialColor == null || materialColor.field_76291_p == 0;
    }

    public void loadPixel(World world, MapBlock pixel, MapBlock currentPixel, Chunk bchunk, int insideX, int insideZ, int highY, int lowY, boolean cave, boolean canReuseBiomeColours) {
        pixel.prepareForWriting();
        pixel.setHeight(highY);
        this.overlayBuilder.startBuilding();
        boolean underair = !cave;
        for (int h = highY; h >= lowY; --h) {
            Block b;
            this.mutableLocalPos.func_181079_c(insideX, h, insideZ);
            BlockState state = bchunk.func_180495_p((BlockPos)this.mutableLocalPos);
            IFluidState fluidFluidState = bchunk.func_204610_c((BlockPos)this.mutableLocalPos);
            BlockState fluidState = fluidFluidState.func_206883_i();
            if (!fluidFluidState.func_206888_e()) {
                underair = true;
                if (this.loadPixelHelp(pixel, currentPixel, world, fluidState, bchunk, insideX, insideZ, h, fluidFluidState.func_180664_k(), canReuseBiomeColours, cave)) {
                    return;
                }
            }
            if ((b = state.func_177230_c()) instanceof AirBlock) {
                underair = true;
                continue;
            }
            if (!underair || state == null || state.func_177230_c() == fluidState.func_177230_c() || !this.loadPixelHelp(pixel, currentPixel, world, state, bchunk, insideX, insideZ, h, state.func_177230_c().func_180664_k(), canReuseBiomeColours, cave)) continue;
            return;
        }
    }

    private boolean loadPixelHelp(MapBlock pixel, MapBlock currentPixel, World world, BlockState state, Chunk bchunk, int insideX, int insideZ, int h, BlockRenderLayer renderLayer, boolean canReuseBiomeColours, boolean cave) {
        Block b = state.func_177230_c();
        this.mutableGlobalPos.func_181079_c(bchunk.func_76632_l().field_77276_a * 16 + insideX, h, bchunk.func_76632_l().field_77275_b * 16 + insideZ);
        this.mutableLocalPos.func_181079_c(insideX, Math.min(h + 1, 255), insideZ);
        this.mutableGlobalPos.func_185336_p(h + 1);
        byte light = (byte)world.func_175642_b(LightType.BLOCK, (BlockPos)this.mutableGlobalPos);
        this.mutableGlobalPos.func_185336_p(h);
        if (this.shouldOverlay(renderLayer, b, state.func_200016_a((IBlockReader)world, (BlockPos)this.mutableGlobalPos))) {
            if (state != this.overlayBuilder.getPrevOverlay()) {
                if (canReuseBiomeColours && currentPixel != null && currentPixel.getNumberOfOverlays() > 0 && currentPixel.getOverlays().get(0).getState() == state) {
                    Overlay currentTopOverlay = currentPixel.getOverlays().get(0);
                    this.biomeBuffer[0] = currentTopOverlay.getColourType();
                    this.biomeBuffer[1] = currentTopOverlay.getColourType() == 1 ? currentPixel.getBiome() : -1;
                    this.biomeBuffer[2] = currentTopOverlay.getCustomColour();
                } else {
                    this.getOverlayBiomeColour(world, bchunk, state, b, (BlockPos)this.mutableGlobalPos, this.biomeBuffer);
                }
                if (this.overlayBuilder.getOverlayBiome() == -1) {
                    this.overlayBuilder.setOverlayBiome(this.biomeBuffer[1]);
                }
                this.overlayBuilder.setPrevOverlay(state);
            }
            this.overlayBuilder.build(state, this.biomeBuffer, state.func_200016_a((IBlockReader)world, (BlockPos)this.mutableGlobalPos), light, world);
            return false;
        }
        if (this.isInvisible(world, state, b)) {
            return false;
        }
        this.overlayBuilder.finishBuilding(pixel);
        if (!canReuseBiomeColours || currentPixel == null || currentPixel.getState() != state) {
            this.getBlockBiomeColour(world, bchunk, state, (BlockPos)this.mutableGlobalPos, this.biomeBuffer, -1);
        } else {
            this.biomeBuffer[0] = currentPixel.getColourType();
            this.biomeBuffer[1] = currentPixel.getBiome();
            this.biomeBuffer[2] = currentPixel.getCustomColour();
        }
        if (this.overlayBuilder.getOverlayBiome() != -1) {
            this.biomeBuffer[1] = this.overlayBuilder.getOverlayBiome();
        }
        boolean glowing = this.isGlowing(state);
        pixel.write(state, h, this.biomeBuffer, light, glowing, cave);
        return true;
    }

    public void updateGrassColor() {
        this.grassColor = Minecraft.func_71410_x().func_184125_al().func_216860_a(Blocks.field_196658_i.func_176223_P(), null, null, 0);
        this.foliageColor = Minecraft.func_71410_x().func_184125_al().func_216860_a(Blocks.field_196642_W.func_176223_P(), null, null, 0);
        if (WorldMap.settings.debug) {
            System.out.println("Default grass colour: " + this.grassColor);
        }
    }

    public void getBlockBiomeColour(World world, Chunk bchunk, BlockState state, BlockPos pos, int[] dest, int biomeId) {
        Material material;
        dest[2] = 0;
        dest[0] = 0;
        dest[1] = -1;
        int customColour = -1;
        boolean gotFullCC = false;
        try {
            customColour = Minecraft.func_71410_x().func_184125_al().func_216860_a(state, null, null, 0);
        }
        catch (Throwable t) {
            customColour = 0;
        }
        if (customColour != -1 && customColour != this.grassColor && customColour != this.foliageColor && (material = state.func_185904_a()) != null && (material.func_151565_r() == MaterialColor.field_151661_c || material.func_151565_r() == MaterialColor.field_151669_i)) {
            customColour = Minecraft.func_71410_x().func_184125_al().func_216860_a(state, (IEnviromentBlockReader)world, pos, 0);
            gotFullCC = true;
            if (material.func_151565_r() == MaterialColor.field_151661_c && customColour == BiomeColors.func_217613_a((IEnviromentBlockReader)world, (BlockPos)pos)) {
                customColour = this.grassColor;
            } else if (material.func_151565_r() == MaterialColor.field_151669_i && customColour == BiomeColors.func_217615_b((IEnviromentBlockReader)world, (BlockPos)pos)) {
                customColour = this.foliageColor;
            }
        }
        if (customColour == this.grassColor) {
            dest[0] = 1;
            dest[1] = biomeId == -1 ? this.biomeRegistry.func_148757_b((Object)bchunk.func_217309_c(pos)) : biomeId;
        } else if (customColour == this.foliageColor) {
            dest[0] = 2;
            dest[1] = biomeId == -1 ? this.biomeRegistry.func_148757_b((Object)bchunk.func_217309_c(pos)) : biomeId;
        } else {
            if (!gotFullCC) {
                customColour = Minecraft.func_71410_x().func_184125_al().func_216860_a(state, (IEnviromentBlockReader)world, pos, 0);
            }
            if (customColour != 0xFFFFFF && customColour != -1) {
                dest[0] = 3;
                dest[2] = customColour;
            }
        }
    }

    public void getOverlayBiomeColour(World world, Chunk bchunk, BlockState state, Block b, BlockPos pos, int[] dest) {
        dest[2] = 0;
        dest[0] = 0;
        dest[1] = -1;
        int customColour = Minecraft.func_71410_x().func_184125_al().func_216860_a(state, (IEnviromentBlockReader)world, pos, 0);
        if (customColour != 0xFFFFFF && customColour != -1) {
            int waterColour = BiomeColors.func_217612_c((IEnviromentBlockReader)world, (BlockPos)pos);
            if (b == Blocks.field_150355_j || customColour == waterColour) {
                dest[0] = 1;
                Biome biome = world.func_175726_f(pos).func_217309_c(pos);
                dest[1] = this.biomeRegistry.func_148757_b((Object)biome);
            } else {
                dest[0] = 2;
                dest[2] = customColour;
            }
        }
    }

    public int loadBlockColourFromTexture(BlockState state, boolean convert, World world, BlockPos globalPos) {
        if (this.clearCachedColours) {
            this.textureColours.clear();
            this.blockColours.clear();
            this.clearCachedColours = false;
            if (WorldMap.settings.debug) {
                WorldMap.LOGGER.info("Xaero's World Map cache cleared!");
            }
        }
        Integer c = this.blockColours.get(state);
        int red = 0;
        int green = 0;
        int blue = 0;
        Block b = state.func_177230_c();
        if (c == null) {
            String name = null;
            try {
                Integer cachedColour;
                List upQuads = null;
                BlockModelShapes bms = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
                if (convert) {
                    upQuads = bms.func_178125_b(state).func_200117_a(state, Direction.UP, this.usedRandom);
                }
                TextureAtlasSprite missingTexture = Minecraft.func_71410_x().func_147117_R().func_195424_a(null);
                TextureAtlasSprite texture = upQuads == null || upQuads.isEmpty() || ((BakedQuad)upQuads.get(0)).func_187508_a() == missingTexture ? bms.func_178122_a(state) : ((BakedQuad)upQuads.get(0)).func_187508_a();
                name = texture.func_195668_m() + ".png";
                if (b instanceof OreBlock && b != Blocks.field_196766_fg) {
                    name = "minecraft:block/stone.png";
                }
                c = -1;
                String[] args = name.split(":");
                if (args.length < 2) {
                    MapWriter.DEFAULT_RESOURCE[1] = args[0];
                    args = DEFAULT_RESOURCE;
                }
                if ((cachedColour = this.textureColours.get(name)) == null) {
                    ResourceLocation location = new ResourceLocation(args[0], "textures/" + args[1]);
                    IResource resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(location);
                    InputStream input = resource.func_199027_b();
                    BufferedImage img = ImageIO.read(input);
                    red = 0;
                    green = 0;
                    blue = 0;
                    int total = 64;
                    int tw = img.getWidth();
                    int diff = tw / 8;
                    for (int i = 0; i < 8; ++i) {
                        for (int j = 0; j < 8; ++j) {
                            int rgb = img.getRGB(i * diff, j * diff);
                            int alpha = rgb >> 24 & 0xFF;
                            if (rgb == 0 || alpha == 0) {
                                --total;
                                continue;
                            }
                            red += rgb >> 16 & 0xFF;
                            green += rgb >> 8 & 0xFF;
                            blue += rgb & 0xFF;
                        }
                    }
                    input.close();
                    if (total == 0) {
                        total = 1;
                    }
                    if (convert && (red /= total) == 0 && (green /= total) == 0 && (blue /= total) == 0) {
                        throw new Exception("Black texture");
                    }
                    c = 0xFF000000 | red << 16 | green << 8 | blue;
                    this.textureColours.put(name, c);
                } else {
                    c = cachedColour;
                }
            }
            catch (FileNotFoundException e) {
                if (convert) {
                    return this.loadBlockColourFromTexture(state, false, world, globalPos);
                }
                c = state.func_185909_g((IBlockReader)world, (BlockPos)globalPos).field_76291_p;
                if (name != null) {
                    this.textureColours.put(name, c);
                }
                WorldMap.LOGGER.info("Block file not found: " + b.getRegistryName());
            }
            catch (Exception e) {
                c = state.func_185909_g((IBlockReader)world, (BlockPos)globalPos).field_76291_p;
                if (name != null) {
                    this.textureColours.put(name, c);
                }
                WorldMap.LOGGER.info("Block " + b.getRegistryName() + " has no texture, using material colour.");
            }
            if (c != null) {
                this.blockColours.put(state, c);
            }
        }
        return c;
    }

    public long getUpdateCounter() {
        return this.updateCounter;
    }

    public void resetPosition() {
        this.X = 0;
        this.Z = 0;
        this.insideX = 0;
        this.insideZ = 0;
    }

    public void requestCachedColoursClear() {
        this.clearCachedColours = true;
    }
}

