/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;
import xaero.deallocator.ByteBufferDeallocator;
import xaero.map.MapLimiter;
import xaero.map.MapWriter;
import xaero.map.WorldMap;
import xaero.map.file.MapSaveLoad;
import xaero.map.file.RegionDetection;
import xaero.map.file.worldsave.WorldDataHandler;
import xaero.map.graphics.TextureUploader;
import xaero.map.gui.GuiMap;
import xaero.map.mods.SupportMods;
import xaero.map.pool.MapTilePool;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayManager;

public class MapProcessor
implements Runnable {
    public static final int DEFAULT_LIGHT_LEVELS = 4;
    public static MapProcessor instance;
    private Throwable crashedBy;
    private MapSaveLoad mapSaveLoad;
    private MapWriter mapWriter;
    private MapLimiter mapLimiter;
    private WorldDataHandler worldDataHandler;
    private ByteBufferDeallocator bufferDeallocator;
    private TextureUploader textureUploader;
    private final Hashtable<String, Hashtable<Integer, Hashtable<Integer, MapRegion>>> currentMap = new Hashtable();
    private final Hashtable<String, List<MapRegion>> currentMapLists = new Hashtable();
    private final Hashtable<String, Hashtable<Integer, Hashtable<Integer, RegionDetection>>> detectedRegions = new Hashtable();
    private World world;
    private World newWorld;
    public final Object mainStuffSync;
    public World mainWorld;
    public double mainPlayerX;
    public double mainPlayerY;
    public double mainPlayerZ;
    private boolean mainWorldUnloaded;
    private ArrayList<Double[]> footprints = new ArrayList();
    private int footprintsTimer;
    private String lastWorld;
    private String lastWorldMainId;
    private String currentWorldString;
    private String currentWorldStringNoDim;
    private String currentDimension;
    private String currentWorldStringNoDimMainId;
    private String currentWorldStringNoDimMultiworldId;
    private Hashtable<Integer, BlockPos> usedSpawn;
    private Hashtable<Integer, BlockPos> latestSpawn;
    private String newWorldStringNoDimMainId;
    private String newWorldStringNoDimMultiworldId;
    private String newDimension;
    private boolean caveStartDetermined;
    private int caveStart;
    public final Object renderThreadPauseSync = new Object();
    private int pauseUploading;
    private int pauseRendering;
    public final Object writerThreadPauseSync = new Object();
    private int pauseWriting;
    public final Object processorThreadPauseSync = new Object();
    private int pauseProcessing;
    public final Object loadingSync = new Object();
    private boolean waitingForWorldUpdate;
    private ArrayList<MapRegion> toProcess = new ArrayList();
    private ArrayList<MapRegion> toRefresh = new ArrayList();
    private ArrayList<Integer> texturesToDelete = new ArrayList();
    private ArrayList<Integer> buffersToDelete = new ArrayList();
    private ArrayList<Runnable> tasks = new ArrayList();
    private static final int SPAWNPOINT_TIMEOUT = 3000;
    private BlockPos spawnToRestore;
    private long mainWorldChangedTime = -1L;
    private long playerDeathTime = -1L;
    private MapTilePool tilePool;
    private OverlayManager overlayManager;
    private long renderStartTime;
    private Field scheduledTasksField;
    private Runnable renderStartTimeUpdaterRunnable;
    private String[] dimensionsToIgnore = new String[]{"FZHammer"};
    private String lastDimension = null;
    public Field selectedField = null;
    private HashMap<String, String> multiworldPointers = new HashMap();

    public MapProcessor(MapSaveLoad mapSaveLoad, MapWriter mapWriter, MapLimiter mapLimiter, ByteBufferDeallocator bufferDeallocator, MapTilePool tilePool, OverlayManager overlayManager, TextureUploader textureUploader, WorldDataHandler worldDataHandler) throws NoSuchFieldException {
        this.mapSaveLoad = mapSaveLoad;
        this.mapWriter = mapWriter;
        this.mapLimiter = mapLimiter;
        this.bufferDeallocator = bufferDeallocator;
        this.tilePool = tilePool;
        this.overlayManager = overlayManager;
        this.textureUploader = textureUploader;
        this.worldDataHandler = worldDataHandler;
        instance = this;
        try {
            this.scheduledTasksField = Minecraft.class.getDeclaredField("field_213275_aU");
        }
        catch (NoSuchFieldException e) {
            throw e;
        }
        catch (SecurityException se) {
            throw se;
        }
        this.renderStartTimeUpdaterRunnable = new Runnable(){

            @Override
            public void run() {
                MapProcessor.this.updateRenderStartTime();
            }
        };
        this.mainStuffSync = new Object();
        this.caveStart = -1;
        this.latestSpawn = new Hashtable();
        this.usedSpawn = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (this.crashedBy == null) {
                Object object = this.processorThreadPauseSync;
                synchronized (object) {
                    if (!this.isProcessingPaused()) {
                        this.updateWorld();
                        if (this.world != null) {
                            this.updateCaveStart(this.mainPlayerX, this.mainPlayerZ, this.world);
                            this.updateFootprints(this.world, Minecraft.func_71410_x().field_71462_r instanceof GuiMap ? 1 : 10);
                        }
                        if (this.currentWorldString != null) {
                            this.mapLimiter.applyLimit(this.getCurrentMapList(this.currentDimension));
                            for (int i = 0; i < this.toProcess.size(); ++i) {
                                MapRegion region = this.toProcess.get(i);
                                this.mapSaveLoad.updateSave(region);
                            }
                        }
                        this.mapSaveLoad.run(this.world);
                        this.handleRefresh(this.world);
                        while (!this.tasks.isEmpty()) {
                            Runnable task;
                            ArrayList<Runnable> arrayList = this.tasks;
                            synchronized (arrayList) {
                                if (this.tasks.isEmpty()) {
                                    break;
                                }
                                task = this.tasks.remove(0);
                            }
                            task.run();
                        }
                    }
                }
                try {
                    Thread.sleep(this.world == null || Minecraft.func_71410_x().field_71462_r instanceof GuiMap ? 100L : 1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Throwable e) {
            this.setCrashedBy(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRenderProcess(Minecraft mc) throws RuntimeException {
        try {
            IntBuffer bufferIntView;
            ArrayList<Integer> arrayList = this.renderThreadPauseSync;
            synchronized (arrayList) {
                if (this.pauseUploading == 0 && this.currentDimension != null) {
                    while (GL11.glGetError() != 0) {
                    }
                    GlStateManager.pixelStore((int)3317, (int)4);
                    GlStateManager.pixelStore((int)3316, (int)0);
                    GlStateManager.pixelStore((int)3315, (int)0);
                    GlStateManager.pixelStore((int)3314, (int)0);
                    int debugFPS = Minecraft.func_175610_ah();
                    long uploadStart = System.nanoTime();
                    long passed = uploadStart - this.renderStartTime;
                    long time60FPS = 16666666L;
                    long totalTime = debugFPS <= 0 || debugFPS > 50 && debugFPS < 65 ? time60FPS : (long)(1000000000 / debugFPS);
                    long timeAvailable = Math.max(3000000L, totalTime - passed);
                    long uploadUntil = uploadStart + timeAvailable / 4L;
                    long gpuLimit = Minecraft.func_71410_x().field_71462_r instanceof GuiMap ? Math.max(1000000L, totalTime * 5L / 12L) : Math.min(totalTime / 5L, timeAvailable);
                    for (int i = 0; i < this.toProcess.size() && System.nanoTime() < uploadUntil; ++i) {
                        MapRegion region;
                        Object object = this.toProcess;
                        synchronized (object) {
                            if (i >= this.toProcess.size()) {
                                break;
                            }
                            region = this.toProcess.get(i);
                        }
                        if (region == null || region.getWorld() == null || !region.getWorld().equals(this.currentWorldString)) continue;
                        object = region;
                        synchronized (object) {
                            if (region.getLoadState() < 4) {
                                boolean allCleaned = true;
                                boolean allCached = true;
                                boolean allUploaded = true;
                                boolean isEmpty = true;
                                for (int x = 0; x < 8; ++x) {
                                    for (int z = 0; z < 8; ++z) {
                                        MapTileChunk chunk = region.getChunk(x, z);
                                        if (chunk == null) continue;
                                        isEmpty = false;
                                        if (chunk.getLoadState() >= 2) {
                                            if (gpuLimit > 0L) {
                                                MapTileChunk mapTileChunk = chunk;
                                                synchronized (mapTileChunk) {
                                                    if (!chunk.isUpdatingBuffers() && chunk.shouldUpload()) {
                                                        if (chunk.getTimer() == 0) {
                                                            long estimatedGPUTime = chunk.uploadBuffer(this.textureUploader);
                                                            gpuLimit -= estimatedGPUTime;
                                                            if (!chunk.shouldDownloadFromPBO()) {
                                                                chunk.setToUpload(false);
                                                                if (chunk.getColorBufferFormat() == -1) {
                                                                    chunk.deleteBuffers();
                                                                } else {
                                                                    chunk.setCachePrepared(true);
                                                                }
                                                            }
                                                        } else {
                                                            chunk.decTimer();
                                                        }
                                                    }
                                                }
                                            }
                                            if (!(region.getLoadState() < 2 || region.isBeingWritten() || region.getLastVisited() != 0L && region.getTimeSinceVisit() <= 1000L || region.isRefreshing() || chunk.getLoadState() == 3)) {
                                                region.setLoadState((byte)3);
                                                chunk.setLoadState((byte)3);
                                                chunk.clean();
                                            }
                                        }
                                        if (chunk.getLoadState() != 3) {
                                            allCleaned = false;
                                        }
                                        if (!chunk.isCachePrepared()) {
                                            allCached = false;
                                        }
                                        if (!chunk.shouldUpload()) continue;
                                        allUploaded = false;
                                    }
                                }
                                allUploaded = allUploaded && region.getLoadState() >= 2;
                                boolean bl = allCached = allCached && allUploaded && !isEmpty;
                                if ((!region.shouldCache() || !region.recacheHasBeenRequested()) && region.getLoadState() == 3 && allCleaned && allUploaded) {
                                    region.setLoadState((byte)4);
                                    region.destroyBufferUpdateObjects();
                                    region.deleteGLBuffers();
                                    ArrayList<MapRegion> arrayList2 = this.toProcess;
                                    synchronized (arrayList2) {
                                        if (i < this.toProcess.size()) {
                                            this.toProcess.remove(i);
                                            --i;
                                        }
                                    }
                                    if (WorldMap.settings.debug) {
                                        WorldMap.LOGGER.info("Region freed: " + region + " " + region.getWorld() + ", " + region.getRegionX() + "_" + region.getRegionZ() + " " + this.mapWriter.getUpdateCounter() + " " + this.currentWorldString);
                                    }
                                }
                                if (allCached && !region.isAllCachePrepared()) {
                                    region.setAllCachePrepared(true);
                                }
                                if (region.shouldCache() && region.isAllCachePrepared() && !region.isRefreshing()) {
                                    instance.getMapSaveLoad().requestCache(region);
                                }
                            }
                            continue;
                        }
                    }
                    this.textureUploader.uploadTextures();
                }
            }
            this.mapLimiter.updateAvailableVRAM();
            if (!this.texturesToDelete.isEmpty()) {
                arrayList = this.texturesToDelete;
                synchronized (arrayList) {
                    int[] obs = ArrayUtils.toPrimitive((Integer[])this.texturesToDelete.toArray(new Integer[0]));
                    ByteBuffer buffer = BufferUtils.createByteBuffer((int)(obs.length * 4));
                    bufferIntView = buffer.asIntBuffer();
                    bufferIntView.put(obs);
                    bufferIntView.flip();
                    GL11.glDeleteTextures((IntBuffer)bufferIntView);
                    this.bufferDeallocator.deallocate(buffer, WorldMap.settings.debug);
                    this.texturesToDelete.clear();
                }
            }
            if (!this.buffersToDelete.isEmpty()) {
                arrayList = this.buffersToDelete;
                synchronized (arrayList) {
                    int[] obs = ArrayUtils.toPrimitive((Integer[])this.buffersToDelete.toArray(new Integer[0]));
                    ByteBuffer buffer = BufferUtils.createByteBuffer((int)(obs.length * 4));
                    bufferIntView = buffer.asIntBuffer();
                    bufferIntView.put(obs);
                    bufferIntView.flip();
                    GL15.glDeleteBuffers((IntBuffer)bufferIntView);
                    this.bufferDeallocator.deallocate(buffer, WorldMap.settings.debug);
                    this.buffersToDelete.clear();
                }
            }
            if (!SupportMods.optifine && Minecraft.func_71410_x().field_195558_d.func_198113_j() && Minecraft.func_71410_x().field_71474_y.field_74352_v) {
                GL11.glFinish();
            }
        }
        catch (Throwable e) {
            this.setCrashedBy(e);
        }
        this.checkForCrashes();
    }

    public boolean ignoreWorld(World world) {
        for (int i = 0; i < this.dimensionsToIgnore.length; ++i) {
            if (!this.dimensionsToIgnore[i].equals(MapProcessor.getDimensionKey(world.func_201675_m().func_186058_p()).func_110623_a())) continue;
            return true;
        }
        return false;
    }

    private String getDimensionName(World world) {
        if (this.ignoreWorld(world)) {
            return this.lastDimension;
        }
        this.lastDimension = "null";
        int id = world.func_201675_m().func_186058_p().func_186068_a();
        if (id != 0) {
            this.lastDimension = "DIM" + id;
        }
        return this.lastDimension;
    }

    public static ResourceLocation getDimensionKey(DimensionType dt) {
        ResourceLocation dimKey = DimensionType.func_212678_a((DimensionType)dt);
        if (dimKey == null) {
            dimKey = dt.getRegistryName();
        }
        return dimKey;
    }

    private String applyPointer(String actualMultiworld) {
        if (this.multiworldPointers.containsKey(actualMultiworld)) {
            return this.multiworldPointers.get(actualMultiworld);
        }
        return actualMultiworld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void changeWorld(World world) {
        this.pushWriterPause();
        Object object = this.loadingSync;
        synchronized (object) {
            this.waitingForWorldUpdate = true;
        }
        this.newWorld = world;
        if (world == null) {
            this.latestSpawn.clear();
            this.newWorldStringNoDimMainId = null;
            this.newWorldStringNoDimMultiworldId = null;
            this.newDimension = "null";
        } else {
            String newMultiworldId;
            Minecraft mc = Minecraft.func_71410_x();
            int dimId = world.func_201675_m().func_186058_p().func_186068_a();
            String[] newWorldArray = this.getNewWorld(mc, dimId);
            BlockPos updatedSpawn = this.latestSpawn.get(dimId);
            if (updatedSpawn != null) {
                this.usedSpawn.put(dimId, updatedSpawn);
            } else {
                this.usedSpawn.remove(dimId);
            }
            String newMainId = newWorldArray == null ? null : newWorldArray[0];
            String string = newMultiworldId = newWorldArray == null ? null : this.applyPointer(newWorldArray[1]);
            if (this.currentWorldStringNoDimMultiworldId != null && !this.currentWorldStringNoDimMultiworldId.equals(newMultiworldId) && this.playerDeathTime != -1L && System.currentTimeMillis() - this.playerDeathTime <= 1000L) {
                this.multiworldPointers.put(newMultiworldId, this.currentWorldStringNoDimMultiworldId);
                if (WorldMap.settings.debug) {
                    WorldMap.LOGGER.info("New pointer! " + newMultiworldId + " -> " + this.currentWorldStringNoDimMultiworldId);
                }
                newMultiworldId = this.currentWorldStringNoDimMultiworldId;
            }
            this.newWorldStringNoDimMainId = newMainId;
            this.newWorldStringNoDimMultiworldId = newMultiworldId;
            this.newDimension = this.getDimensionName(world);
            if (this.newDimension == null) {
                this.newDimension = "null";
            }
        }
        this.popWriterPause();
    }

    private String[] getNewWorld(Minecraft mc, int dimId) {
        String[] result = new String[2];
        if (mc.func_71401_C() != null) {
            result[0] = mc.func_71401_C().func_71270_I().replaceAll("_", "^us^") + "_%DIMENSION%";
            result[1] = "";
            if (this.isWorldMultiplayer(this.isWorldRealms(result[0]), result[0])) {
                result[0] = "^e^" + result[0];
            }
        } else {
            BlockPos dimSpawn = this.latestSpawn.get(dimId);
            result[1] = "_mw" + (dimSpawn.func_177958_n() >> 6) + "," + (dimSpawn.func_177956_o() >> 6) + "," + (dimSpawn.func_177952_p() >> 6);
            if (mc.func_147104_D() != null && dimSpawn != null) {
                String serverIP;
                String string = serverIP = WorldMap.settings.differentiateByServerAddress ? mc.func_147104_D().field_78845_b : "Any Address";
                if (serverIP.contains(":")) {
                    serverIP = serverIP.substring(0, serverIP.indexOf(":"));
                }
                result[0] = "Multiplayer_" + serverIP.replaceAll(":", "\u00a7") + "_%DIMENSION%";
            } else if (mc.func_181540_al() && WorldMap.events.getLatestRealm() != null && dimSpawn != null) {
                result[0] = "Realms_" + WorldMap.events.getLatestRealm().ownerUUID + "." + WorldMap.events.getLatestRealm().id + "_%DIMENSION%";
            } else {
                result[0] = "Multiplayer_Unknown_%DIMENSION%";
                this.latestSpawn.remove(dimId);
            }
        }
        return result;
    }

    private synchronized void checkForWorldUpdate() {
        int dimId;
        BlockPos dimSpawn;
        if (!(this.mainWorld == null || (dimSpawn = this.latestSpawn.get(dimId = this.mainWorld.func_201675_m().func_186058_p().func_186068_a())) == null || this.world != this.newWorld || this.mainWorld == this.world && dimSpawn.equals((Object)this.usedSpawn.get(dimId)))) {
            this.changeWorld(this.mainWorld);
        }
    }

    private synchronized void updateWorld() throws IOException, CommandSyntaxException {
        boolean isNewDimension;
        boolean isNewWorldMainId = this.currentWorldStringNoDimMainId == null && this.newWorldStringNoDimMainId != null || this.currentWorldStringNoDimMainId != null && !this.currentWorldStringNoDimMainId.equals(this.newWorldStringNoDimMainId);
        boolean isNewWorldMultiworldId = this.currentWorldStringNoDimMultiworldId == null && this.newWorldStringNoDimMultiworldId != null || this.currentWorldStringNoDimMultiworldId != null && !this.currentWorldStringNoDimMultiworldId.equals(this.newWorldStringNoDimMultiworldId);
        boolean isNewWorld = isNewWorldMainId || isNewWorldMultiworldId;
        boolean bl = isNewDimension = this.currentDimension == null && this.newDimension != null || this.currentDimension != null && !this.currentDimension.equals(this.newDimension);
        if (isNewWorld || isNewDimension) {
            boolean shouldDetect;
            boolean shouldResetPointers;
            this.pushRenderPause(true, true);
            this.pushWriterPause();
            String newWorldStringNoDim = this.newWorldStringNoDimMainId == null ? null : this.newWorldStringNoDimMainId + this.newWorldStringNoDimMultiworldId;
            boolean shouldClear = newWorldStringNoDim != null && (this.currentWorldStringNoDim != null || this.lastWorld == null || !this.lastWorld.equals(newWorldStringNoDim));
            boolean bl2 = shouldResetPointers = isNewWorldMainId && this.newWorldStringNoDimMainId != null && (this.currentWorldStringNoDimMainId != null || this.lastWorldMainId == null || !this.lastWorldMainId.equals(this.newWorldStringNoDimMainId));
            if (shouldResetPointers) {
                this.multiworldPointers.clear();
                this.playerDeathTime = -1L;
                if (WorldMap.settings.debug) {
                    WorldMap.LOGGER.info("Resetting multiworld pointers!");
                }
            }
            this.mapSaveLoad.getToSave().clear();
            for (List<MapRegion> dim : this.currentMapLists.values()) {
                for (MapRegion region : dim) {
                    if (region.recacheHasBeenRequested() && region.getCacheFile() != null) {
                        Files.deleteIfExists(region.getCacheFile().toPath());
                        if (WorldMap.settings.debug) {
                            WorldMap.LOGGER.info(String.format("Deleting cache for region %s because it might be outdated.", region));
                        }
                    }
                    region.setReloadHasBeenRequested(false, "world/dim change");
                    if (region.getLoadState() == 2) {
                        if (region.isBeingWritten()) {
                            this.mapSaveLoad.getToSave().add(region);
                        } else {
                            region.clearRegion();
                        }
                    } else if (region.isRefreshing()) {
                        throw new RuntimeException("Detected non-loadstate 2 region with refreshing value being true.");
                    }
                    if (!isNewWorld || !shouldClear) continue;
                    region.deleteTexturesAndBuffers();
                }
            }
            if (isNewWorld || this.currentWorldStringNoDim == null && newWorldStringNoDim != null) {
                if (shouldClear) {
                    this.mapSaveLoad.clearToCache();
                    this.currentMap.clear();
                    this.currentMapLists.clear();
                    this.detectedRegions.clear();
                    if (WorldMap.settings.debug) {
                        WorldMap.LOGGER.info("Map data cleared!");
                    }
                }
                this.lastWorld = this.currentWorldStringNoDim;
                this.lastWorldMainId = this.currentWorldStringNoDimMainId;
                this.currentWorldStringNoDim = newWorldStringNoDim;
                this.currentWorldStringNoDimMainId = this.newWorldStringNoDimMainId;
                this.currentWorldStringNoDimMultiworldId = this.newWorldStringNoDimMultiworldId;
                if (WorldMap.settings.debug) {
                    WorldMap.LOGGER.info("World changed!");
                }
            }
            this.currentDimension = this.newDimension;
            this.caveStartDetermined = false;
            this.caveStart = -1;
            this.currentWorldString = this.currentWorldStringNoDim != null ? this.currentWorldStringNoDim.replace("%DIMENSION%", this.currentDimension) : null;
            this.footprints.clear();
            this.mapSaveLoad.clearToLoad();
            this.mapSaveLoad.clearLoadRequests();
            this.mapSaveLoad.setNextToLoadByViewing(null);
            this.clearToRefresh();
            this.toProcess.clear();
            for (MapRegion region : this.getCurrentMapList(this.currentDimension)) {
                if (region.getLoadState() == 4 || region.getLoadState() == 0) continue;
                this.toProcess.add(region);
            }
            this.mapSaveLoad.updateCacheFolderList(this.mapSaveLoad.getSubFolder(this.currentWorldString));
            this.mapSaveLoad.getOldFormatSupport().loadStates(this.currentWorldString);
            this.mapWriter.resetPosition();
            this.world = this.newWorld;
            if (WorldMap.settings.debug) {
                WorldMap.LOGGER.info("World/dimension changed to: " + this.currentWorldString);
            }
            this.worldDataHandler.prepareSingleplayer(this.world, this);
            if (this.worldDataHandler.getWorldDir() == null && this.currentWorldString != null && !this.isWorldMultiplayer(this.isWorldRealms(this.currentWorldString), this.currentWorldString)) {
                this.currentWorldStringNoDim = null;
                this.currentWorldString = null;
            }
            boolean bl3 = shouldDetect = this.currentWorldString != null && this.detectedRegions.get(this.currentDimension) == null;
            if (shouldDetect) {
                this.mapSaveLoad.setRegionDetectionComplete(false);
            }
            this.popRenderPause(true, true);
            this.popWriterPause();
            if (shouldDetect) {
                this.mapSaveLoad.detectRegions();
                this.mapSaveLoad.setRegionDetectionComplete(true);
            }
        } else if (this.newWorld != this.world) {
            this.pushWriterPause();
            this.world = this.newWorld;
            this.popWriterPause();
        }
        this.waitingForWorldUpdate = false;
    }

    public void updateFootprints(World world, int step) {
        if (WorldMap.settings.footsteps) {
            if (this.footprintsTimer > 0) {
                this.footprintsTimer -= step;
            } else {
                Double[] coords = new Double[]{this.mainPlayerX, this.mainPlayerZ};
                this.footprints.add(coords);
                if (this.footprints.size() > 32) {
                    this.footprints.remove(0);
                }
                this.footprintsTimer = 20;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToRefresh(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.toRefresh;
        synchronized (arrayList) {
            if (!this.toRefresh.contains(region)) {
                this.toRefresh.add(0, region);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToRefresh(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.toRefresh;
        synchronized (arrayList) {
            this.toRefresh.remove(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearToRefresh() {
        ArrayList<MapRegion> arrayList = this.toRefresh;
        synchronized (arrayList) {
            this.toRefresh.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRefresh(World world) throws RuntimeException {
        Object object = this.loadingSync;
        synchronized (object) {
            if (!this.waitingForWorldUpdate && !this.toRefresh.isEmpty()) {
                MapRegion region = this.toRefresh.get(0);
                if (region.isRefreshing()) {
                    boolean regionLoaded;
                    MapRegion mapRegion = region;
                    synchronized (mapRegion) {
                        boolean bl = regionLoaded = region.getLoadState() == 2;
                        if (regionLoaded) {
                            if (region.hasVersion() && region.getVersion() != WorldMap.globalVersion || !region.hasVersion() && region.getInitialVersion() != WorldMap.globalVersion) {
                                region.setRecacheHasBeenRequested(true, "refresh handle");
                                region.setShouldCache(true, "refresh handle");
                            }
                            region.setVersion(WorldMap.globalVersion);
                        }
                    }
                    if (regionLoaded) {
                        region.pushWriterPause();
                        for (int i = 0; i < 8; ++i) {
                            for (int j = 0; j < 8; ++j) {
                                MapTileChunk chunk = region.getChunk(i, j);
                                if (chunk == null || chunk.getLoadState() != 2) continue;
                                if (chunk.getLoadState() != 2) {
                                    throw new RuntimeException("Trying to refresh a bad tile chunk: " + chunk.getX() + " " + chunk.getZ() + " from region " + region);
                                }
                                if (chunk.includeInSave()) {
                                    chunk.updateBuffers(world);
                                    continue;
                                }
                                region.setChunk(i, j, null);
                            }
                        }
                        region.popWriterPause();
                        if (WorldMap.settings.debug) {
                            WorldMap.LOGGER.info("Region refreshed: " + region + " " + region.getRegionX() + "_" + region.getRegionZ() + " " + this.mapWriter.getUpdateCounter());
                        }
                    }
                    MapRegion mapRegion2 = region;
                    synchronized (mapRegion2) {
                        region.setRefreshing(false);
                    }
                }
                throw new RuntimeException(String.format("Trying to refresh region %s, which is not marked as being refreshed!", region));
                this.removeToRefresh(region);
            }
        }
    }

    public boolean regionExists(int x, int z) {
        Hashtable<Integer, RegionDetection> column = this.getDetectedRegions(this.currentDimension).get(x);
        return column != null && column.containsKey(z);
    }

    public void addRegionDetection(RegionDetection regionDetection) {
        Hashtable<Integer, Hashtable<Integer, RegionDetection>> current = this.getDetectedRegions(this.currentDimension);
        Hashtable<Integer, RegionDetection> column = current.get(regionDetection.getRegionX());
        if (column == null) {
            column = new Hashtable();
            current.put(regionDetection.getRegionX(), column);
        }
        column.put(regionDetection.getRegionZ(), regionDetection);
    }

    public RegionDetection getRegionDetection(int x, int z) {
        Hashtable<Integer, RegionDetection> column = this.getDetectedRegions(this.currentDimension).get(x);
        if (column != null) {
            return column.get(z);
        }
        return null;
    }

    private void removeRegionDetection(int x, int z) {
        Hashtable<Integer, Hashtable<Integer, RegionDetection>> current = this.getDetectedRegions(this.currentDimension);
        Hashtable<Integer, RegionDetection> column = current.get(x);
        if (column != null) {
            column.remove(z);
        }
        if (column.isEmpty()) {
            current.remove(x);
        }
    }

    public Hashtable<Integer, Hashtable<Integer, RegionDetection>> getDetectedRegions(String dim) {
        Hashtable<Integer, Hashtable<Integer, RegionDetection>> current = this.detectedRegions.get(dim);
        if (current == null) {
            current = new Hashtable();
            this.detectedRegions.put(dim, current);
        }
        return current;
    }

    public List<MapRegion> getCurrentMapList(String dim) {
        List<MapRegion> current = this.currentMapLists.get(dim);
        if (current == null) {
            current = new ArrayList<MapRegion>();
            this.currentMapLists.put(dim, current);
        }
        return current;
    }

    public Hashtable<Integer, Hashtable<Integer, MapRegion>> getCurrentMap(String dim) {
        Hashtable<Integer, Hashtable<Integer, MapRegion>> current = this.currentMap.get(dim);
        if (current == null) {
            current = new Hashtable();
            this.currentMap.put(dim, current);
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMapRegion(MapRegion region) {
        Hashtable<String, Hashtable<Integer, Hashtable<Integer, MapRegion>>> hashtable = this.currentMap;
        synchronized (hashtable) {
            Hashtable<Integer, MapRegion> mapColumn = this.getCurrentMap(region.getDim()).get(region.getRegionX());
            if (mapColumn == null) {
                return;
            }
            mapColumn.remove(region.getRegionZ());
            this.getCurrentMapList(region.getDim()).remove(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapRegion getMapRegion(int regX, int regZ, boolean create) {
        Hashtable<String, Hashtable<Integer, Hashtable<Integer, MapRegion>>> hashtable = this.currentMap;
        synchronized (hashtable) {
            MapRegion region;
            Hashtable<Integer, MapRegion> mapColumn = this.getCurrentMap(this.currentDimension).get(regX);
            if (mapColumn == null) {
                if (create) {
                    mapColumn = new Hashtable();
                    this.getCurrentMap(this.currentDimension).put(regX, mapColumn);
                } else {
                    return null;
                }
            }
            if ((region = mapColumn.get(regZ)) == null) {
                if (create) {
                    region = new MapRegion(this.currentWorldString, this.currentDimension, regX, regZ);
                    RegionDetection regionDetection = this.getRegionDetection(regX, regZ);
                    if (regionDetection != null) {
                        regionDetection.transferInfoTo(region);
                        this.removeRegionDetection(regX, regZ);
                    }
                    this.getCurrentMapList(this.currentDimension).add(region);
                    mapColumn.put(regZ, region);
                } else {
                    return null;
                }
            }
            return region;
        }
    }

    public MapTileChunk getMapChunk(int chunkX, int chunkZ) {
        int regionX = chunkX >> 3;
        int regionZ = chunkZ >> 3;
        MapRegion region = this.getMapRegion(regionX, regionZ, false);
        if (region == null) {
            return null;
        }
        int localChunkX = chunkX & 7;
        int localChunkZ = chunkZ & 7;
        return region.getChunk(localChunkX, localChunkZ);
    }

    public MapTile getMapTile(int x, int z) {
        MapTileChunk tileChunk = this.getMapChunk(x >> 2, z >> 2);
        if (tileChunk == null) {
            return null;
        }
        int tileX = x & 3;
        int tileZ = z & 3;
        return tileChunk.getTile(tileX, tileZ);
    }

    public void updateWorldSpawn(BlockPos newSpawn, World world) {
        int dimId = world.func_201675_m().func_186058_p().func_186068_a();
        this.latestSpawn.put(dimId, newSpawn);
        if (WorldMap.settings.debug) {
            System.out.println("Updated spawn for dimension " + dimId + " " + newSpawn);
        }
        if (world == this.mainWorld) {
            this.spawnToRestore = null;
            this.mainWorldChangedTime = -1L;
            if (WorldMap.settings.debug) {
                WorldMap.LOGGER.info("Done waiting for main spawn.");
            }
        }
    }

    public void onPlayerDied() {
        this.playerDeathTime = System.currentTimeMillis();
    }

    public void onWorldUnload() {
        if (this.mainWorldUnloaded) {
            return;
        }
        if (WorldMap.settings.debug) {
            WorldMap.LOGGER.info("Changing worlds, pausing the world map...");
        }
        this.mainWorldUnloaded = true;
        int dimId = this.mainWorld.func_201675_m().func_186058_p().func_186068_a();
        BlockPos dimSpawn = this.latestSpawn.get(dimId);
        if (dimSpawn != null) {
            this.spawnToRestore = dimSpawn;
        }
        this.mainWorldChangedTime = -1L;
        this.changeWorld(null);
    }

    public void onClientTickStart() throws RuntimeException {
        this.checkForWorldUpdate();
        this.checkForCrashes();
        if (this.mainWorld != null && this.spawnToRestore != null && this.mainWorldChangedTime != -1L && System.currentTimeMillis() - this.mainWorldChangedTime >= 3000L) {
            if (WorldMap.settings.debug) {
                WorldMap.LOGGER.info("SPAWN SET TIME OUT");
            }
            this.updateWorldSpawn(this.spawnToRestore, this.mainWorld);
        }
    }

    public void checkForCrashes() throws RuntimeException {
        if (this.crashedBy != null) {
            throw new RuntimeException("Xaero's World Map has crashed! Please contact the author at planetminecraft.com/member/xaero96 or minecraftforum.net/members/xaero96", this.crashedBy);
        }
    }

    private void updateRenderStartTime() {
        if (this.renderStartTime == -1L) {
            this.renderStartTime = System.nanoTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushWriterPause() {
        Object object = this.writerThreadPauseSync;
        synchronized (object) {
            ++this.pauseWriting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popWriterPause() {
        Object object = this.writerThreadPauseSync;
        synchronized (object) {
            --this.pauseWriting;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushRenderPause(boolean rendering, boolean uploading) {
        Object object = this.renderThreadPauseSync;
        synchronized (object) {
            if (rendering) {
                ++this.pauseRendering;
            }
            if (uploading) {
                ++this.pauseUploading;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popRenderPause(boolean rendering, boolean uploading) {
        Object object = this.renderThreadPauseSync;
        synchronized (object) {
            if (rendering) {
                --this.pauseRendering;
            }
            if (uploading) {
                --this.pauseUploading;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushProcessorPause() {
        Object object = this.processorThreadPauseSync;
        synchronized (object) {
            ++this.pauseProcessing;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popProcessorPause() {
        Object object = this.processorThreadPauseSync;
        synchronized (object) {
            --this.pauseProcessing;
        }
    }

    public boolean isWritingPaused() {
        return this.pauseWriting > 0;
    }

    public boolean isRenderingPaused() {
        return this.pauseRendering > 0;
    }

    public boolean isUploadingPaused() {
        return this.pauseUploading > 0;
    }

    public boolean isProcessingPaused() {
        return this.pauseProcessing > 0;
    }

    public String getCurrentDimension() {
        return this.currentDimension;
    }

    public Hashtable<String, Hashtable<Integer, Hashtable<Integer, MapRegion>>> getFullMap() {
        return this.currentMap;
    }

    public ArrayList<MapRegion> getToProcess() {
        return this.toProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToProcess(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.toProcess;
        synchronized (arrayList) {
            this.toProcess.add(region);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToProcess(MapRegion region) {
        ArrayList<MapRegion> arrayList = this.toProcess;
        synchronized (arrayList) {
            this.toProcess.remove(region);
        }
    }

    public MapSaveLoad getMapSaveLoad() {
        return this.mapSaveLoad;
    }

    public World getWorld() {
        return this.world;
    }

    public Throwable getCrashedBy() {
        return this.crashedBy;
    }

    public void setCrashedBy(Throwable crashedBy) {
        if (this.crashedBy == null) {
            this.crashedBy = crashedBy;
        }
    }

    public String getCurrentWorldString() {
        return this.currentWorldString;
    }

    public MapWriter getMapWriter() {
        return this.mapWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(Runnable task) {
        ArrayList<Runnable> arrayList = this.tasks;
        synchronized (arrayList) {
            this.tasks.add(task);
        }
    }

    public MapLimiter getMapLimiter() {
        return this.mapLimiter;
    }

    public ArrayList<Double[]> getFootprints() {
        return this.footprints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestTextureDeletion(int texture) {
        ArrayList<Integer> arrayList = this.texturesToDelete;
        synchronized (arrayList) {
            this.texturesToDelete.add(texture);
        }
    }

    public ByteBufferDeallocator getBufferDeallocator() {
        return this.bufferDeallocator;
    }

    public MapTilePool getTilePool() {
        return this.tilePool;
    }

    public OverlayManager getOverlayManager() {
        return this.overlayManager;
    }

    public int getGlobalVersion() {
        return WorldMap.globalVersion;
    }

    public void setGlobalVersion(int globalVersion) {
        WorldMap.globalVersion = globalVersion;
    }

    public void incrementGlobalVersion() {
        instance.addTask(new Runnable(){

            @Override
            public void run() {
                instance.setGlobalVersion(instance.getGlobalVersion() + 1);
                if (SupportMods.minimap()) {
                    WorldMap.waypointSymbolCreator.resetChars();
                }
                instance.getMapSaveLoad().updateCacheFolderList(instance.getMapSaveLoad().getSubFolder(instance.getCurrentWorldString()));
                if (WorldMap.settings.debug) {
                    WorldMap.LOGGER.info("Version incremented to " + instance.getGlobalVersion());
                }
                try {
                    WorldMap.settings.saveSettings();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public long getRenderStartTime() {
        return this.renderStartTime;
    }

    public void resetRenderStartTime() {
        this.renderStartTime = -1L;
    }

    public Queue<Runnable> getMinecraftScheduledTasks() {
        Queue result;
        this.scheduledTasksField.setAccessible(true);
        try {
            result = (Queue)this.scheduledTasksField.get(Minecraft.func_71410_x());
        }
        catch (IllegalArgumentException e) {
            result = null;
        }
        catch (IllegalAccessException e) {
            result = null;
        }
        this.scheduledTasksField.setAccessible(false);
        return result;
    }

    public Runnable getRenderStartTimeUpdater() {
        return this.renderStartTimeUpdaterRunnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestBufferToDelete(int bufferId) {
        ArrayList<Integer> arrayList = this.buffersToDelete;
        synchronized (arrayList) {
            this.buffersToDelete.add(bufferId);
        }
    }

    public boolean isWaitingForWorldUpdate() {
        return this.waitingForWorldUpdate;
    }

    public void setWaitingForWorldUpdate(boolean waitingForWorldUpdate) {
        this.waitingForWorldUpdate = waitingForWorldUpdate;
    }

    public WorldDataHandler getWorldDataHandler() {
        return this.worldDataHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainValues() {
        Object object = this.mainStuffSync;
        synchronized (object) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player != null) {
                if (player.field_70170_p != this.mainWorld) {
                    int dimId;
                    if (this.spawnToRestore != null && this.latestSpawn.get(dimId = player.field_70170_p.func_201675_m().func_186058_p().func_186068_a()) == null) {
                        this.mainWorldChangedTime = System.currentTimeMillis();
                    }
                    this.mainWorldUnloaded = false;
                }
                this.mainWorld = player.field_70170_p;
                this.mainPlayerX = player.field_70165_t;
                this.mainPlayerY = player.field_70163_u;
                this.mainPlayerZ = player.field_70161_v;
            } else {
                if (this.mainWorld != null && !this.mainWorldUnloaded) {
                    this.onWorldUnload();
                }
                this.mainWorld = null;
            }
        }
    }

    public void updateCaveStart(double playerX, double playerZ, World world) {
        int chunkZ;
        int chunkX;
        IChunk chunk;
        if (!this.caveStartDetermined && (chunk = world.func_217353_a(chunkX = (int)Math.floor(playerX) >> 4, chunkZ = (int)Math.floor(playerZ) >> 4, ChunkStatus.field_222617_m, false)) != null && !(chunk instanceof EmptyChunk)) {
            if (world.func_72940_L() < 256 && Math.abs(chunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, 0, 0) - world.func_72940_L()) < 16) {
                this.caveStart = world.func_72940_L() - 1;
            }
            this.caveStartDetermined = true;
        }
    }

    public boolean caveStartIsDetermined() {
        return this.caveStartDetermined;
    }

    public int getCaveStart() {
        return this.caveStart;
    }

    public float getBrightness() {
        float sunBrightness = WorldMap.settings.lighting && this.caveStart == -1 ? this.world.func_72971_b(1.0f) : 1.0f;
        return 0.25f + 0.75f * sunBrightness;
    }

    public boolean isWorldRealms(String world) {
        return world.startsWith("Realms_");
    }

    public boolean isWorldMultiplayer(boolean realms, String world) {
        return realms || world.startsWith("Multiplayer_");
    }
}

