/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.common.block;

import com.mojang.datafixers.util.Either;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.extensions.IForgeDimension;

public class ComfortsBaseBlock
extends BedBlock
implements IWaterLoggable {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private final BedType type;

    public ComfortsBaseBlock(BedType type, DyeColor colorIn, Block.Properties properties) {
        super(colorIn, properties);
        this.type = type;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176472_a, (Comparable)BedPart.FOOT)).func_206870_a((IProperty)field_176471_b, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_220051_a(@Nonnull BlockState state, World worldIn, @Nonnull BlockPos pos, @Nonnull PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (state.func_177229_b((IProperty)field_176472_a) != BedPart.HEAD && (state = worldIn.func_180495_p(pos = pos.func_177972_a((Direction)state.func_177229_b((IProperty)field_185512_D)))).func_177230_c() != this) {
            return true;
        }
        IForgeDimension.SleepResult sleepResult = worldIn.field_73011_w.canSleepAt(player, pos);
        if (sleepResult != IForgeDimension.SleepResult.BED_EXPLODES) {
            if (sleepResult == IForgeDimension.SleepResult.DENY) {
                return true;
            }
            if (((Boolean)state.func_177229_b((IProperty)field_176471_b)).booleanValue()) {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("block.minecraft.bed.occupied", new Object[0]), true);
                return true;
            }
            Either player$sleepresult = player.func_213819_a(pos);
            player$sleepresult.ifLeft(result -> {
                ITextComponent text;
                switch (result) {
                    case NOT_POSSIBLE_NOW: {
                        text = this.type == BedType.HAMMOCK ? new TranslationTextComponent("block.comforts." + this.type.name + ".no_sleep", new Object[0]) : new TranslationTextComponent("block.minecraft.bed.no_sleep", new Object[0]);
                        break;
                    }
                    case TOO_FAR_AWAY: {
                        text = new TranslationTextComponent("block.comforts." + this.type.name + ".too_far_away", new Object[0]);
                        break;
                    }
                    default: {
                        text = result.func_221259_a();
                    }
                }
                player.func_146105_b(text, true);
            });
            return true;
        }
        worldIn.func_217377_a(pos, false);
        BlockPos blockpos = pos.func_177972_a(((Direction)state.func_177229_b((IProperty)field_185512_D)).func_176734_d());
        if (worldIn.func_180495_p(blockpos).func_177230_c() == this) {
            worldIn.func_217377_a(blockpos, false);
        }
        worldIn.func_217401_a(null, DamageSource.func_199683_a(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 5.0f, true, Explosion.Mode.DESTROY);
        return true;
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        BedPart bedpart = (BedPart)state.func_177229_b((IProperty)field_176472_a);
        BlockPos blockpos = pos.func_177972_a(ComfortsBaseBlock.getDirectionToOther(bedpart, (Direction)state.func_177229_b((IProperty)field_185512_D)));
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (blockstate.func_177230_c() == this && blockstate.func_177229_b((IProperty)field_176472_a) != bedpart) {
            if (((Boolean)blockstate.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
                worldIn.func_180501_a(blockpos, Blocks.field_150355_j.func_176223_P(), 35);
            } else {
                worldIn.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            }
            worldIn.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
            if (!worldIn.field_72995_K && !player.func_184812_l_()) {
                ItemStack itemstack = player.func_184614_ca();
                ComfortsBaseBlock.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)itemstack);
                ComfortsBaseBlock.func_220054_a((BlockState)blockstate, (World)worldIn, (BlockPos)blockpos, null, (Entity)player, (ItemStack)itemstack);
            }
            player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)this));
        }
        worldIn.func_217378_a(player, 2001, pos, ComfortsBaseBlock.func_196246_j((BlockState)state));
    }

    private static Direction getDirectionToOther(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.func_176734_d();
    }

    @Nonnull
    public BlockState func_196271_a(BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull IWorld worldIn, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        BlockState state = super.func_196258_a(context);
        return state == null ? null : (BlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{WATERLOGGED});
        super.func_206840_a(builder);
    }

    @Nonnull
    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    static enum BedType {
        HAMMOCK("hammock"),
        SLEEPING_BAG("sleeping_bag");

        private final String name;

        private BedType(String name) {
            this.name = name;
        }
    }
}

