/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.client.renderer;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.block.BedBlock;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.item.DyeColor;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BedPart;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import top.theillusivec4.comforts.client.model.ComfortsBaseModel;
import top.theillusivec4.comforts.common.tileentity.ComfortsBaseTileEntity;

public abstract class ComfortsBaseTileEntityRenderer<T extends ComfortsBaseTileEntity>
extends TileEntityRenderer<T> {
    private final ResourceLocation[] textures = (ResourceLocation[])Arrays.stream(DyeColor.values()).sorted(Comparator.comparingInt(DyeColor::func_196059_a)).map(color -> new ResourceLocation("comforts", "textures/entity/" + textureName + "/" + color.func_176762_d() + ".png")).toArray(ResourceLocation[]::new);
    private final ComfortsBaseModel model;
    private final float height;

    public ComfortsBaseTileEntityRenderer(String textureName, ComfortsBaseModel model, float height) {
        this.model = model;
        this.height = height;
    }

    public void render(T tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        if (destroyStage >= 0) {
            this.func_147499_a(field_178460_a[destroyStage]);
            GlStateManager.matrixMode((int)5890);
            GlStateManager.pushMatrix();
            GlStateManager.scalef((float)4.0f, (float)4.0f, (float)1.0f);
            GlStateManager.translatef((float)0.0625f, (float)0.0625f, (float)0.0625f);
            GlStateManager.matrixMode((int)5888);
        } else {
            ResourceLocation resourcelocation = this.textures[((ComfortsBaseTileEntity)((Object)tileEntityIn)).getColor().func_196059_a()];
            if (resourcelocation != null) {
                this.func_147499_a(resourcelocation);
            }
        }
        if (tileEntityIn.func_145830_o()) {
            BlockState blockstate = tileEntityIn.func_195044_w();
            this.renderPiece(blockstate.func_177229_b((IProperty)BedBlock.field_176472_a) == BedPart.HEAD, x, y, z, (Direction)blockstate.func_177229_b((IProperty)BedBlock.field_185512_D));
        } else {
            this.renderPiece(true, x, y, z, Direction.SOUTH);
            this.renderPiece(false, x, y, z - 1.0, Direction.SOUTH);
        }
        if (destroyStage >= 0) {
            GlStateManager.matrixMode((int)5890);
            GlStateManager.popMatrix();
            GlStateManager.matrixMode((int)5888);
        }
    }

    private void renderPiece(boolean isHead, double x, double y, double z, Direction direction) {
        this.model.preparePiece(isHead);
        GlStateManager.pushMatrix();
        GlStateManager.translatef((float)((float)x), (float)((float)y + this.height), (float)((float)z));
        GlStateManager.rotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.rotatef((float)(180.0f + direction.func_185119_l()), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.translatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GlStateManager.enableRescaleNormal();
        this.model.render();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }
}

