/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.comforts.client;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.entity.player.RemoteClientPlayerEntity;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import top.theillusivec4.comforts.common.block.HammockBlock;
import top.theillusivec4.comforts.common.block.SleepingBagBlock;
import top.theillusivec4.comforts.common.capability.CapabilitySleepData;

public class ClientEventHandler {
    @SubscribeEvent
    public void onPostPlayerTick(TickEvent.PlayerTickEvent evt) {
        PlayerEntity player;
        if (evt.phase == TickEvent.Phase.START && evt.side == LogicalSide.CLIENT && !(player = evt.player).func_70608_bn()) {
            CapabilitySleepData.getCapability(player).ifPresent(sleepdata -> {
                BlockPos pos = sleepdata.getAutoSleepPos();
                if (pos != null) {
                    World world = player.field_70170_p;
                    BlockState state = world.func_180495_p(pos);
                    if (world.isAreaLoaded(pos, 1) && state.func_177230_c() instanceof SleepingBagBlock) {
                        BlockRayTraceResult hit = new BlockRayTraceResult(new Vec3d(0.0, 0.0, 0.0), player.func_174811_aO(), pos, false);
                        Minecraft.func_71410_x().field_71442_b.func_217292_a((ClientPlayerEntity)player, (ClientWorld)player.field_70170_p, Hand.MAIN_HAND, hit);
                    }
                    sleepdata.setAutoSleepPos(null);
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerRenderPre(RenderPlayerEvent.Pre evt) {
        PlayerEntity player = evt.getPlayer();
        if (player instanceof RemoteClientPlayerEntity && player.func_213283_Z() == Pose.SLEEPING) {
            player.func_213374_dv().ifPresent(bedPos -> {
                Block bed = player.field_70170_p.func_180495_p(bedPos).func_177230_c();
                if (bed instanceof SleepingBagBlock) {
                    GlStateManager.translatef((float)0.0f, (float)-0.375f, (float)0.0f);
                } else if (bed instanceof HammockBlock) {
                    GlStateManager.translatef((float)0.0f, (float)-0.5f, (float)0.0f);
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerRenderPost(RenderPlayerEvent.Post evt) {
        PlayerEntity player = evt.getPlayer();
        if (player instanceof RemoteClientPlayerEntity && player.func_213283_Z() == Pose.SLEEPING) {
            player.func_213374_dv().ifPresent(bedPos -> {
                Block bed = player.field_70170_p.func_180495_p(bedPos).func_177230_c();
                if (bed instanceof SleepingBagBlock) {
                    GlStateManager.translatef((float)0.0f, (float)0.375f, (float)0.0f);
                } else if (bed instanceof HammockBlock) {
                    GlStateManager.translatef((float)0.0f, (float)0.5f, (float)0.0f);
                }
            });
        }
    }
}

