/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.util;

import com.mrcrayfish.vehicle.block.BlockRotatedObject;
import net.minecraft.block.Block;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;

public class StateHelper {
    public static Block getBlock(IWorldReader world, BlockPos pos, Direction facing, RelativeDirection dir) {
        BlockPos target = StateHelper.getBlockPosRelativeTo(world, pos, facing, dir);
        return world.func_180495_p(target).func_177230_c();
    }

    public static RelativeDirection getRotation(IWorldReader world, BlockPos pos, Direction facing, RelativeDirection dir) {
        BlockPos target = StateHelper.getBlockPosRelativeTo(world, pos, facing, dir);
        Direction other = (Direction)world.func_180495_p(target).func_177229_b((IProperty)BlockRotatedObject.DIRECTION);
        return StateHelper.getDirectionRelativeTo(facing, other);
    }

    public static boolean isAirBlock(IWorldReader world, BlockPos pos, Direction facing, RelativeDirection dir) {
        BlockPos target = StateHelper.getBlockPosRelativeTo(world, pos, facing, dir);
        return world.func_180495_p(target).func_196958_f();
    }

    private static BlockPos getBlockPosRelativeTo(IWorldReader world, BlockPos pos, Direction facing, RelativeDirection dir) {
        switch (dir) {
            case LEFT: {
                return pos.func_177972_a(facing.func_176746_e());
            }
            case RIGHT: {
                return pos.func_177972_a(facing.func_176735_f());
            }
            case UP: {
                return pos.func_177972_a(facing);
            }
            case DOWN: {
                return pos.func_177972_a(facing.func_176734_d());
            }
        }
        return pos;
    }

    private static RelativeDirection getDirectionRelativeTo(Direction thisBlock, Direction otherBlock) {
        int num = thisBlock.func_176736_b() - otherBlock.func_176736_b();
        switch (num) {
            case -3: {
                return RelativeDirection.LEFT;
            }
            case -2: {
                return RelativeDirection.UP;
            }
            case -1: {
                return RelativeDirection.RIGHT;
            }
            case 0: {
                return RelativeDirection.DOWN;
            }
            case 1: {
                return RelativeDirection.LEFT;
            }
            case 2: {
                return RelativeDirection.UP;
            }
            case 3: {
                return RelativeDirection.RIGHT;
            }
        }
        return RelativeDirection.NONE;
    }

    public static enum RelativeDirection {
        UP,
        DOWN,
        LEFT,
        RIGHT,
        NONE;

    }
}

