/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.tileentity;

import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.client.util.HermiteInterpolator;
import com.mrcrayfish.vehicle.common.entity.SyncedPlayerData;
import com.mrcrayfish.vehicle.init.ModTileEntities;
import com.mrcrayfish.vehicle.tileentity.GasPumpTankTileEntity;
import com.mrcrayfish.vehicle.tileentity.TileEntitySynced;
import com.mrcrayfish.vehicle.util.TileEntityUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class GasPumpTileEntity
extends TileEntitySynced
implements ITickableTileEntity {
    private int fuelingEntityId;
    private PlayerEntity fuelingEntity;
    private HermiteInterpolator cachedSpline;
    private boolean recentlyUsed;

    public GasPumpTileEntity() {
        super((TileEntityType)ModTileEntities.GAS_PUMP.get());
    }

    public HermiteInterpolator getCachedSpline() {
        return this.cachedSpline;
    }

    public void setCachedSpline(HermiteInterpolator cachedSpline) {
        this.cachedSpline = cachedSpline;
    }

    public boolean isRecentlyUsed() {
        return this.recentlyUsed;
    }

    public void setRecentlyUsed(boolean recentlyUsed) {
        this.recentlyUsed = recentlyUsed;
    }

    @Nullable
    public FluidTank getTank() {
        TileEntity tileEntity = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
        if (tileEntity instanceof GasPumpTankTileEntity) {
            return ((GasPumpTankTileEntity)tileEntity).getFluidTank();
        }
        return null;
    }

    public PlayerEntity getFuelingEntity() {
        return this.fuelingEntity;
    }

    public void setFuelingEntity(@Nullable PlayerEntity entity) {
        if (!this.field_145850_b.field_72995_K) {
            if (this.fuelingEntity != null) {
                SyncedPlayerData.setGasPumpPos(this.fuelingEntity, Optional.empty());
            }
            this.fuelingEntity = null;
            this.fuelingEntityId = -1;
            if (entity != null) {
                this.fuelingEntityId = entity.func_145782_y();
                SyncedPlayerData.setGasPumpPos(entity, Optional.of(this.func_174877_v()));
            }
            this.syncToClient();
        }
    }

    public void func_73660_a() {
        if (this.fuelingEntityId != -1) {
            if (this.fuelingEntity == null) {
                Entity entity = this.field_145850_b.func_73045_a(this.fuelingEntityId);
                if (entity instanceof PlayerEntity) {
                    this.fuelingEntity = (PlayerEntity)entity;
                } else if (!this.field_145850_b.field_72995_K) {
                    this.fuelingEntityId = -1;
                    this.syncFuelingEntity();
                }
            }
        } else if (this.field_145850_b.field_72995_K && this.fuelingEntity != null) {
            this.fuelingEntity = null;
        }
        if (!(this.field_145850_b.field_72995_K || this.fuelingEntity == null || !(Math.sqrt(this.fuelingEntity.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5)) > (Double)Config.SERVER.maxHoseDistance.get()) && this.fuelingEntity.func_70089_S())) {
            if (this.fuelingEntity.func_70089_S()) {
                this.field_145850_b.func_184133_a(null, this.fuelingEntity.func_180425_c(), SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            SyncedPlayerData.setGasPumpPos(this.fuelingEntity, Optional.empty());
            this.fuelingEntityId = -1;
            this.fuelingEntity = null;
            this.syncFuelingEntity();
        }
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("FuelingEntity", 3)) {
            this.fuelingEntityId = compound.func_74762_e("FuelingEntity");
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74768_a("FuelingEntity", this.fuelingEntityId);
        return super.func_189515_b(compound);
    }

    private void syncFuelingEntity() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("FuelingEntity", this.fuelingEntityId);
        TileEntityUtil.sendUpdatePacket((TileEntity)this, super.func_189515_b(compound));
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

