/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.tileentity;

import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.block.BlockFluidPipe;
import com.mrcrayfish.vehicle.init.ModTileEntities;
import com.mrcrayfish.vehicle.tileentity.TileFluidHandlerSynced;
import com.mrcrayfish.vehicle.util.FluidUtils;
import com.mrcrayfish.vehicle.util.TileEntityUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidPipeTileEntity
extends TileFluidHandlerSynced
implements ITickableTileEntity {
    protected int transferAmount;
    protected boolean[] disabledConnections;

    public FluidPipeTileEntity() {
        this((TileEntityType)ModTileEntities.FLUID_PIPE.get(), (Integer)Config.SERVER.pipeCapacity.get());
    }

    public FluidPipeTileEntity(TileEntityType<?> tileEntityType, int capacity) {
        super(tileEntityType, capacity);
        this.transferAmount = (Integer)Config.SERVER.pipeTransferAmount.get();
        this.disabledConnections = new boolean[Direction.values().length];
    }

    public static boolean[] getDisabledConnections(FluidPipeTileEntity pipe) {
        return pipe != null ? pipe.getDisabledConnections() : new boolean[Direction.values().length];
    }

    public boolean[] getDisabledConnections() {
        return this.disabledConnections;
    }

    public boolean isConnectionDisabled(Direction facing) {
        return this.disabledConnections[facing.func_176745_a()];
    }

    private void setConnectionDisabled(int indexFacing, boolean disabled) {
        this.disabledConnections[indexFacing] = disabled;
        this.syncDisabledConnections();
    }

    public void setConnectionDisabled(Direction facing, boolean disabled) {
        this.setConnectionDisabled(facing.func_176745_a(), disabled);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        if (this.tank.getFluid().isEmpty()) {
            return;
        }
        if (this.field_145850_b.func_175640_z(this.field_174879_c)) {
            return;
        }
        IFluidHandler handler = this.getConnectedFluidHandler((Direction)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockFluidPipe.DIRECTION));
        if (handler != null) {
            FluidUtils.transferFluid((IFluidHandler)this.tank, handler, this.transferAmount);
        }
    }

    @Nullable
    protected IFluidHandler getConnectedFluidHandler(Direction facing) {
        IFluidHandler handler;
        BlockPos adjacentPos = this.field_174879_c.func_177972_a(facing);
        TileEntity tileEntity = this.field_145850_b.func_175625_s(adjacentPos);
        if (tileEntity != null && (handler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d()).orElse(null)) != null) {
            BlockState adjacentState = this.field_145850_b.func_180495_p(adjacentPos);
            if (adjacentState.func_177230_c() instanceof BlockFluidPipe && (!((Boolean)adjacentState.func_177229_b((IProperty)BlockFluidPipe.CONNECTED_PIPES[facing.func_176734_d().func_176745_a()])).booleanValue() || tileEntity instanceof FluidPipeTileEntity && ((FluidPipeTileEntity)tileEntity).isConnectionDisabled(facing.func_176734_d()))) {
                return null;
            }
            return handler;
        }
        List fluidEntities = this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(adjacentPos), entity -> entity != null && entity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).isPresent());
        if (!fluidEntities.isEmpty()) {
            return (IFluidHandler)((Entity)fluidEntities.get(0)).getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
        }
        return null;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        if (compound.func_150297_b("DisabledConnections", 7)) {
            byte[] connections = compound.func_74770_j("DisabledConnections");
            for (int i = 0; i < connections.length; ++i) {
                this.disabledConnections[i] = connections[i] == 1;
            }
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        this.writeConnections(compound);
        return super.func_189515_b(compound);
    }

    private void writeConnections(CompoundNBT compound) {
        byte[] connections = new byte[this.disabledConnections.length];
        for (int i = 0; i < connections.length; ++i) {
            connections[i] = (byte)(this.disabledConnections[i] ? 1 : 0);
        }
        compound.func_74773_a("DisabledConnections", connections);
    }

    private void syncDisabledConnections() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            CompoundNBT compound = new CompoundNBT();
            this.writeConnections(compound);
            TileEntityUtil.sendUpdatePacket((TileEntity)this, super.func_189515_b(compound));
        }
    }
}

