/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.network.message;

import com.mrcrayfish.vehicle.entity.LandVehicleEntity;
import com.mrcrayfish.vehicle.entity.TrailerEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.network.message.IMessage;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageHitchTrailer
implements IMessage<MessageHitchTrailer> {
    private boolean hitch;

    public MessageHitchTrailer() {
    }

    public MessageHitchTrailer(boolean hitch) {
        this.hitch = hitch;
    }

    @Override
    public void encode(MessageHitchTrailer message, PacketBuffer buffer) {
        buffer.writeBoolean(message.hitch);
    }

    @Override
    public MessageHitchTrailer decode(PacketBuffer buffer) {
        return new MessageHitchTrailer(buffer.readBoolean());
    }

    @Override
    public void handle(MessageHitchTrailer message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null) {
                if (!(player.func_184187_bx() instanceof VehicleEntity)) {
                    return;
                }
                VehicleEntity vehicle = (VehicleEntity)player.func_184187_bx();
                if (!vehicle.canTowTrailer()) {
                    return;
                }
                if (!message.hitch) {
                    if (vehicle.getTrailer() != null) {
                        vehicle.setTrailer(null);
                        player.field_70170_p.func_184133_a(null, vehicle.func_180425_c(), SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                } else {
                    VehicleProperties properties = vehicle.getProperties();
                    Vec3d vehicleVec = vehicle.func_174791_d();
                    Vec3d towBarVec = properties.getTowBarPosition();
                    towBarVec = new Vec3d(towBarVec.field_72450_a * 0.0625, towBarVec.field_72448_b * 0.0625, towBarVec.field_72449_c * 0.0625 + properties.getBodyPosition().getZ());
                    if (vehicle instanceof LandVehicleEntity) {
                        LandVehicleEntity landVehicle = (LandVehicleEntity)vehicle;
                        vehicleVec = vehicleVec.func_178787_e(towBarVec.func_178785_b((float)Math.toRadians(-vehicle.field_70177_z + landVehicle.additionalYaw)));
                    } else {
                        vehicleVec = vehicleVec.func_178787_e(towBarVec.func_178785_b((float)Math.toRadians(-vehicle.field_70177_z)));
                    }
                    AxisAlignedBB towBarBox = new AxisAlignedBB(vehicleVec.field_72450_a, vehicleVec.field_72448_b, vehicleVec.field_72449_c, vehicleVec.field_72450_a, vehicleVec.field_72448_b, vehicleVec.field_72449_c).func_186662_g(0.25);
                    List trailers = player.field_70170_p.func_175647_a(TrailerEntity.class, vehicle.func_174813_aQ().func_186662_g(5.0), input -> input.getPullingEntity() == null);
                    for (TrailerEntity trailer : trailers) {
                        if (trailer.getPullingEntity() != null) continue;
                        Vec3d trailerVec = trailer.func_174791_d();
                        Vec3d hitchVec = new Vec3d(0.0, 0.0, -trailer.getHitchOffset() / 16.0);
                        trailerVec = trailerVec.func_178787_e(hitchVec.func_178785_b((float)Math.toRadians(-trailer.field_70177_z)));
                        AxisAlignedBB hitchBox = new AxisAlignedBB(trailerVec.field_72450_a, trailerVec.field_72448_b, trailerVec.field_72449_c, trailerVec.field_72450_a, trailerVec.field_72448_b, trailerVec.field_72449_c).func_186662_g(0.25);
                        if (!towBarBox.func_72326_a(hitchBox)) continue;
                        vehicle.setTrailer(trailer);
                        player.field_70170_p.func_184133_a(null, vehicle.func_180425_c(), SoundEvents.field_187692_g, SoundCategory.PLAYERS, 1.0f, 1.5f);
                        return;
                    }
                }
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

