/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.network.message;

import com.mrcrayfish.vehicle.VehicleMod;
import com.mrcrayfish.vehicle.network.message.IMessage;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageEntityFluid
implements IMessage<MessageEntityFluid> {
    private int entityId;
    private FluidStack stack;

    public MessageEntityFluid() {
    }

    public MessageEntityFluid(int entityId, FluidStack stack) {
        this.entityId = entityId;
        this.stack = stack;
    }

    @Override
    public void encode(MessageEntityFluid message, PacketBuffer buffer) {
        buffer.func_150787_b(message.entityId);
        buffer.func_150786_a(message.stack.writeToNBT(new CompoundNBT()));
    }

    @Override
    public MessageEntityFluid decode(PacketBuffer buffer) {
        return new MessageEntityFluid(buffer.func_150792_a(), FluidStack.loadFluidStackFromNBT((CompoundNBT)buffer.func_150793_b()));
    }

    @Override
    public void handle(MessageEntityFluid message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> VehicleMod.PROXY.syncEntityFluid(message.entityId, message.stack));
        supplier.get().setPacketHandled(true);
    }
}

