/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.network.message;

import com.mrcrayfish.vehicle.block.BlockVehicleCrate;
import com.mrcrayfish.vehicle.crafting.VehicleRecipe;
import com.mrcrayfish.vehicle.crafting.VehicleRecipes;
import com.mrcrayfish.vehicle.entity.EngineTier;
import com.mrcrayfish.vehicle.entity.EngineType;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.WheelType;
import com.mrcrayfish.vehicle.inventory.container.WorkstationContainer;
import com.mrcrayfish.vehicle.item.EngineItem;
import com.mrcrayfish.vehicle.item.WheelItem;
import com.mrcrayfish.vehicle.network.message.IMessage;
import com.mrcrayfish.vehicle.tileentity.WorkstationTileEntity;
import com.mrcrayfish.vehicle.util.InventoryUtil;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class MessageCraftVehicle
implements IMessage<MessageCraftVehicle> {
    private String vehicleId;
    private BlockPos pos;

    public MessageCraftVehicle() {
    }

    public MessageCraftVehicle(String vehicleId, BlockPos pos) {
        this.vehicleId = vehicleId;
        this.pos = pos;
    }

    @Override
    public void encode(MessageCraftVehicle message, PacketBuffer buffer) {
        buffer.func_211400_a(message.vehicleId, 128);
        buffer.func_179255_a(message.pos);
    }

    @Override
    public MessageCraftVehicle decode(PacketBuffer buffer) {
        return new MessageCraftVehicle(buffer.func_150789_c(128), buffer.func_179259_c());
    }

    @Override
    public void handle(MessageCraftVehicle message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null) {
                ItemStack engine;
                ItemStack dyeStack;
                World world = player.field_70170_p;
                if (!(player.field_71070_bA instanceof WorkstationContainer)) {
                    return;
                }
                WorkstationContainer workstation = (WorkstationContainer)player.field_71070_bA;
                if (!workstation.getPos().equals((Object)message.pos)) {
                    return;
                }
                ResourceLocation entityId = new ResourceLocation(message.vehicleId);
                if (!entityId.func_110624_b().equals("vehicle")) {
                    return;
                }
                EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(message.vehicleId));
                if (entityType == null) {
                    return;
                }
                VehicleRecipe recipe = VehicleRecipes.getRecipe(entityType, world);
                if (recipe == null) {
                    return;
                }
                for (ItemStack stack : recipe.getMaterials()) {
                    if (InventoryUtil.hasItemStack((PlayerEntity)player, stack)) continue;
                    return;
                }
                VehicleEntity vehicle = null;
                EngineType engineType = EngineType.NONE;
                Entity entity = entityType.func_200721_a(world);
                if (entity instanceof VehicleEntity) {
                    vehicle = (VehicleEntity)entity;
                }
                if (entity instanceof PoweredVehicleEntity) {
                    ItemStack wheel;
                    PoweredVehicleEntity entityPoweredVehicle = (PoweredVehicleEntity)entity;
                    engineType = entityPoweredVehicle.getEngineType();
                    WorkstationTileEntity workstationTileEntity = workstation.getTileEntity();
                    ItemStack engine2 = workstationTileEntity.func_70301_a(1);
                    if (engine2.func_190926_b() || !(engine2.func_77973_b() instanceof EngineItem)) {
                        return;
                    }
                    EngineType engineType2 = ((EngineItem)engine2.func_77973_b()).getEngineType();
                    if (entityPoweredVehicle.getEngineType() != EngineType.NONE && entityPoweredVehicle.getEngineType() != engineType2) {
                        return;
                    }
                    if (entityPoweredVehicle.canChangeWheels() && !((wheel = (ItemStack)workstationTileEntity.getInventory().get(2)).func_77973_b() instanceof WheelItem)) {
                        return;
                    }
                }
                if (vehicle == null) {
                    return;
                }
                for (ItemStack stack : recipe.getMaterials()) {
                    InventoryUtil.removeItemStack((PlayerEntity)player, stack);
                }
                WorkstationTileEntity workstationTileEntity = workstation.getTileEntity();
                int color = VehicleEntity.DYE_TO_COLOR[0];
                if (vehicle.canBeColored() && (dyeStack = (ItemStack)workstationTileEntity.getInventory().get(0)).func_77973_b() instanceof DyeItem) {
                    DyeItem dyeItem = (DyeItem)dyeStack.func_77973_b();
                    color = dyeItem.func_195962_g().getColorValue();
                    workstationTileEntity.getInventory().set(0, (Object)ItemStack.field_190927_a);
                }
                EngineTier engineTier = EngineTier.WOOD;
                if (engineType != EngineType.NONE && (engine = (ItemStack)workstationTileEntity.getInventory().get(1)).func_77973_b() instanceof EngineItem) {
                    EngineItem engineItem = (EngineItem)engine.func_77973_b();
                    engineTier = engineItem.getEngineTier();
                    workstationTileEntity.getInventory().set(1, (Object)ItemStack.field_190927_a);
                }
                int wheelColor = -1;
                WheelType wheelType = null;
                ItemStack wheel = (ItemStack)workstationTileEntity.getInventory().get(2);
                if (vehicle instanceof PoweredVehicleEntity && ((PoweredVehicleEntity)vehicle).canChangeWheels() && wheel.func_77973_b() instanceof WheelItem) {
                    CompoundNBT compound;
                    WheelItem wheelItem = (WheelItem)wheel.func_77973_b();
                    wheelType = wheelItem.getWheelType();
                    if (wheel.func_77978_p() != null && (compound = wheel.func_77978_p()).func_150297_b("Color", 3)) {
                        wheelColor = compound.func_74762_e("Color");
                    }
                    workstationTileEntity.getInventory().set(2, (Object)ItemStack.field_190927_a);
                }
                ItemStack stack = BlockVehicleCrate.create(entityId, color, engineTier, wheelType, wheelColor);
                world.func_217376_c((Entity)new ItemEntity(world, (double)message.pos.func_177958_n() + 0.5, (double)message.pos.func_177956_o() + 1.125, (double)message.pos.func_177952_p() + 0.5, stack));
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

