/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.item;

import com.mrcrayfish.vehicle.entity.EngineTier;
import com.mrcrayfish.vehicle.entity.EngineType;
import com.mrcrayfish.vehicle.item.PartItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EngineItem
extends PartItem {
    private EngineType engineType;
    private EngineTier engineTier;

    public EngineItem(EngineType engineType, EngineTier engineTier, Item.Properties properties) {
        super(properties);
        this.engineType = engineType;
        this.engineTier = engineTier;
    }

    public EngineType getEngineType() {
        return this.engineType;
    }

    public EngineTier getEngineTier() {
        return this.engineTier;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String tierName = I18n.func_135052_a((String)("vehicle.engine_tier." + this.engineTier.getTierName() + ".name"), (Object[])new Object[0]);
        tooltip.add((ITextComponent)new StringTextComponent(this.engineTier.getTierColor() + TextFormatting.BOLD.toString() + tierName));
        if (Screen.hasShiftDown()) {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + I18n.func_135052_a((String)"vehicle.engine_info.acceleration", (Object[])new Object[0]) + ": " + TextFormatting.RESET + this.engineTier.getAccelerationMultiplier() + "x"));
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + I18n.func_135052_a((String)"vehicle.engine_info.additional_max_speed", (Object[])new Object[0]) + ": " + TextFormatting.RESET + (double)this.engineTier.getAdditionalMaxSpeed() * 3.6 + "kph"));
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + I18n.func_135052_a((String)"vehicle.engine_info.fuel_consumption", (Object[])new Object[0]) + ": " + TextFormatting.RESET + this.engineTier.getFuelConsumption() + "pt"));
        } else {
            tooltip.add((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + I18n.func_135052_a((String)"vehicle.info_help", (Object[])new Object[0])));
        }
    }
}

