/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.init;

import com.mrcrayfish.vehicle.entity.EntityJack;
import com.mrcrayfish.vehicle.entity.trailer.FertilizerTrailerEntity;
import com.mrcrayfish.vehicle.entity.trailer.FluidTrailerEntity;
import com.mrcrayfish.vehicle.entity.trailer.SeederTrailerEntity;
import com.mrcrayfish.vehicle.entity.trailer.StorageTrailerEntity;
import com.mrcrayfish.vehicle.entity.trailer.VehicleEntityTrailer;
import com.mrcrayfish.vehicle.entity.vehicle.ATVEntity;
import com.mrcrayfish.vehicle.entity.vehicle.AluminumBoatEntity;
import com.mrcrayfish.vehicle.entity.vehicle.BathEntity;
import com.mrcrayfish.vehicle.entity.vehicle.BumperCarEntity;
import com.mrcrayfish.vehicle.entity.vehicle.CouchEntity;
import com.mrcrayfish.vehicle.entity.vehicle.DuneBuggyEntity;
import com.mrcrayfish.vehicle.entity.vehicle.GoKartEntity;
import com.mrcrayfish.vehicle.entity.vehicle.GolfCartEntity;
import com.mrcrayfish.vehicle.entity.vehicle.JetSkiEntity;
import com.mrcrayfish.vehicle.entity.vehicle.LawnMowerEntity;
import com.mrcrayfish.vehicle.entity.vehicle.MiniBikeEntity;
import com.mrcrayfish.vehicle.entity.vehicle.MiniBusEntity;
import com.mrcrayfish.vehicle.entity.vehicle.MopedEntity;
import com.mrcrayfish.vehicle.entity.vehicle.OffRoaderEntity;
import com.mrcrayfish.vehicle.entity.vehicle.ShoppingCartEntity;
import com.mrcrayfish.vehicle.entity.vehicle.SmartCarEntity;
import com.mrcrayfish.vehicle.entity.vehicle.SofacopterEntity;
import com.mrcrayfish.vehicle.entity.vehicle.SpeedBoatEntity;
import com.mrcrayfish.vehicle.entity.vehicle.SportsPlaneEntity;
import com.mrcrayfish.vehicle.entity.vehicle.TractorEntity;
import com.mrcrayfish.vehicle.util.EntityUtil;
import java.util.function.BiFunction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

public class ModEntities {
    public static final DeferredRegister<EntityType<?>> ENTITY_TYPES = new DeferredRegister(ForgeRegistries.ENTITIES, "vehicle");
    public static final RegistryObject<EntityType<ATVEntity>> ATV = ModEntities.registerVehicle("atv", ATVEntity::new, 1.5f, 1.0f);
    public static final RegistryObject<EntityType<DuneBuggyEntity>> DUNE_BUGGY = ModEntities.registerVehicle("dune_buggy", DuneBuggyEntity::new, 0.75f, 0.75f);
    public static final RegistryObject<EntityType<GoKartEntity>> GO_KART = ModEntities.registerVehicle("go_kart", GoKartEntity::new, 1.5f, 0.5f);
    public static final RegistryObject<EntityType<ShoppingCartEntity>> SHOPPING_CART = ModEntities.registerVehicle("shopping_cart", ShoppingCartEntity::new, 1.0f, 1.0f);
    public static final RegistryObject<EntityType<MiniBikeEntity>> MINI_BIKE = ModEntities.registerVehicle("mini_bike", MiniBikeEntity::new, 1.0f, 1.0f);
    public static final RegistryObject<EntityType<BumperCarEntity>> BUMPER_CAR = ModEntities.registerVehicle("bumper_car", BumperCarEntity::new, 1.5f, 1.0f);
    public static final RegistryObject<EntityType<JetSkiEntity>> JET_SKI = ModEntities.registerVehicle("jet_ski", JetSkiEntity::new, 1.5f, 1.0f);
    public static final RegistryObject<EntityType<SpeedBoatEntity>> SPEED_BOAT = ModEntities.registerVehicle("speed_boat", SpeedBoatEntity::new, 1.5f, 1.0f);
    public static final RegistryObject<EntityType<AluminumBoatEntity>> ALUMINUM_BOAT = ModEntities.registerVehicle("aluminum_boat", AluminumBoatEntity::new, 2.25f, 0.875f);
    public static final RegistryObject<EntityType<SmartCarEntity>> SMART_CAR = ModEntities.registerVehicle("smart_car", SmartCarEntity::new, 1.85f, 1.15f);
    public static final RegistryObject<EntityType<LawnMowerEntity>> LAWN_MOWER = ModEntities.registerVehicle("lawn_mower", LawnMowerEntity::new, 1.2f, 1.0f);
    public static final RegistryObject<EntityType<MopedEntity>> MOPED = ModEntities.registerVehicle("moped", MopedEntity::new, 1.0f, 1.0f);
    public static final RegistryObject<EntityType<SportsPlaneEntity>> SPORTS_PLANE = ModEntities.registerVehicle("sports_plane", SportsPlaneEntity::new, 3.0f, 1.6875f);
    public static final RegistryObject<EntityType<GolfCartEntity>> GOLF_CART = ModEntities.registerVehicle("golf_cart", GolfCartEntity::new, 2.0f, 1.0f);
    public static final RegistryObject<EntityType<OffRoaderEntity>> OFF_ROADER = ModEntities.registerVehicle("off_roader", OffRoaderEntity::new, 2.0f, 1.0f);
    public static final RegistryObject<EntityType<TractorEntity>> TRACTOR = ModEntities.registerVehicle("tractor", TractorEntity::new, 1.5f, 1.5f);
    public static final RegistryObject<EntityType<MiniBusEntity>> MINI_BUS = ModEntities.registerVehicle("mini_bus", MiniBusEntity::new, 2.0f, 2.0f);
    public static final RegistryObject<EntityType<VehicleEntityTrailer>> VEHICLE_TRAILER = ModEntities.registerVehicle("vehicle_trailer", VehicleEntityTrailer::new, 1.5f, 0.75f);
    public static final RegistryObject<EntityType<StorageTrailerEntity>> STORAGE_TRAILER = ModEntities.registerVehicle("storage_trailer", StorageTrailerEntity::new, 1.0f, 1.0f);
    public static final RegistryObject<EntityType<FluidTrailerEntity>> FLUID_TRAILER = ModEntities.registerVehicle("fluid_trailer", FluidTrailerEntity::new, 1.5f, 1.5f);
    public static final RegistryObject<EntityType<SeederTrailerEntity>> SEEDER = ModEntities.registerVehicle("seeder", SeederTrailerEntity::new, 1.5f, 1.0f);
    public static final RegistryObject<EntityType<FertilizerTrailerEntity>> FERTILIZER = ModEntities.registerVehicle("fertilizer", FertilizerTrailerEntity::new, 1.5f, 1.0f);
    public static final RegistryObject<EntityType<CouchEntity>> SOFA = ModEntities.registerDependent("cfm", "couch", CouchEntity::new, 1.0f, 1.0f);
    public static final RegistryObject<EntityType<BathEntity>> BATH = ModEntities.registerDependent("cfm", "bath", BathEntity::new, 1.0f, 1.0f);
    public static final RegistryObject<EntityType<SofacopterEntity>> SOFACOPTER = ModEntities.registerDependent("cfm", "sofacopter", SofacopterEntity::new, 1.0f, 1.0f);
    public static final RegistryObject<EntityType<EntityJack>> JACK = ModEntities.registerEntity("jack", EntityJack::new, 0.0f, 0.0f);

    private static <T extends Entity> RegistryObject<EntityType<T>> registerVehicle(String id, BiFunction<EntityType<T>, World, T> function, float width, float height) {
        EntityType type = EntityUtil.buildVehicleType(new ResourceLocation("vehicle", id), function, width, height);
        return ENTITY_TYPES.register(id, () -> type);
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> registerDependent(String modId, String id, BiFunction<EntityType<T>, World, T> function, float width, float height) {
        if (ModList.get().isLoaded(modId)) {
            EntityType type = EntityUtil.buildVehicleType(new ResourceLocation("vehicle", id), function, width, height);
            return ENTITY_TYPES.register(id, () -> type);
        }
        return null;
    }

    private static <T extends Entity> RegistryObject<EntityType<T>> registerEntity(String id, BiFunction<EntityType<T>, World, T> function, float width, float height) {
        EntityType type = EntityType.Builder.func_220322_a(function::apply, (EntityClassification)EntityClassification.MISC).func_220321_a(width, height).setTrackingRange(256).setUpdateInterval(1).func_200705_b().func_220320_c().setShouldReceiveVelocityUpdates(true).func_206830_a(id);
        return ENTITY_TYPES.register(id, () -> type);
    }
}

