/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity.trailer;

import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.entity.TrailerEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageAttachTrailer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class VehicleEntityTrailer
extends TrailerEntity
implements EntityRaytracer.IEntityRaytraceable {
    private static final EntityRaytracer.RayTracePart CONNECTION_BOX = new EntityRaytracer.RayTracePart(VehicleEntityTrailer.createScaledBoundingBox(-0.4375, 0.26875, 0.875, 0.4375, 0.53125, 1.5, 1.1));
    private static final Map<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList> interactionBoxMapStatic = (Map)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> {
        HashMap<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList> map = new HashMap<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList>();
        map.put(CONNECTION_BOX, EntityRaytracer.boxToTriangles(CONNECTION_BOX.getBox(), null));
        return map;
    });

    public VehicleEntityTrailer(EntityType<? extends VehicleEntityTrailer> type, World worldIn) {
        super(type, worldIn);
    }

    @Override
    public double func_70042_X() {
        return 0.5;
    }

    @Override
    public boolean canBeColored() {
        return true;
    }

    @Override
    protected boolean func_184228_n(Entity entityIn) {
        return true;
    }

    @Override
    public void func_184232_k(Entity passenger) {
        if (passenger instanceof VehicleEntity) {
            Vec3d offset = ((VehicleEntity)passenger).getProperties().getTrailerOffset().func_178785_b((float)Math.toRadians(-this.field_70177_z));
            passenger.func_70107_b(this.field_70165_t + offset.field_72450_a, this.field_70163_u + this.func_70042_X() + offset.field_72448_b, this.field_70161_v + offset.field_72449_c);
            passenger.field_70126_B = this.field_70126_B;
            passenger.field_70177_z = this.field_70177_z;
        }
    }

    @Override
    protected boolean func_184219_q(Entity passenger) {
        return passenger instanceof VehicleEntity && this.func_184188_bt().size() == 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Map<EntityRaytracer.RayTracePart, EntityRaytracer.TriangleRayTraceList> getStaticInteractionBoxMap() {
        return interactionBoxMapStatic;
    }

    @Override
    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public List<EntityRaytracer.RayTracePart> getApplicableInteractionBoxes() {
        return Collections.singletonList(CONNECTION_BOX);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawInteractionBoxes(Tessellator tessellator, BufferBuilder buffer) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean processHit(EntityRaytracer.RayTraceResultRotated result, boolean rightClick) {
        if (result.getPartHit() == CONNECTION_BOX && rightClick) {
            PacketHandler.instance.sendToServer((Object)new MessageAttachTrailer(this.func_145782_y(), Minecraft.func_71410_x().field_71439_g.func_145782_y()));
            return true;
        }
        return EntityRaytracer.IEntityRaytraceable.super.processHit(result, rightClick);
    }

    @Override
    public double getHitchOffset() {
        return -25.0;
    }
}

