/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.client.render.Wheel;
import com.mrcrayfish.vehicle.common.Seat;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.init.ModEntities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.ModList;

public class VehicleProperties {
    private static final Map<EntityType<?>, VehicleProperties> PROPERTIES_MAP = new HashMap();
    private float axleOffset;
    private float wheelOffset;
    private Vec3d heldOffset = Vec3d.field_186680_a;
    private Vec3d towBarVec = Vec3d.field_186680_a;
    private Vec3d trailerOffset = Vec3d.field_186680_a;
    private List<Wheel> wheels = new ArrayList<Wheel>();
    private PartPosition bodyPosition = PartPosition.DEFAULT;
    private PartPosition enginePosition;
    private PartPosition fuelPortPosition;
    private PartPosition fuelPortLidPosition;
    private PartPosition keyPortPosition;
    private PartPosition keyPosition;
    private PartPosition displayPosition = PartPosition.DEFAULT;
    private Vec3d frontAxelVec = null;
    private Vec3d rearAxelVec = null;
    private List<Seat> seats = new ArrayList<Seat>();

    public static void setProperties(EntityType<? extends VehicleEntity> entityType, VehicleProperties properties) {
        if (!PROPERTIES_MAP.containsKey(entityType) || ((Boolean)Config.CLIENT.reloadVehiclePropertiesEachTick.get()).booleanValue()) {
            PROPERTIES_MAP.put(entityType, properties);
        }
    }

    public static VehicleProperties getProperties(EntityType<?> entityType) {
        return PROPERTIES_MAP.get(entityType);
    }

    public static void register() {
        VehicleProperties properties = new VehicleProperties();
        properties.setBodyPosition(new PartPosition(0.0, 0.0, 0.2, 1.1));
        properties.setFuelPortPosition(new PartPosition(-16.0, 3.0, -18.0, 0.0, -90.0, 0.0, 0.25));
        properties.setHeldOffset(new Vec3d(0.0, 0.0, 0.0));
        properties.setDisplayPosition(new PartPosition(1.0));
        properties.addSeat(new Seat(new Vec3d(-7.0, 8.0, -15.0), true));
        properties.addSeat(new Seat(new Vec3d(7.0, 6.0, -15.0)));
        properties.addSeat(new Seat(new Vec3d(-7.0, 6.0, 3.0)));
        properties.addSeat(new Seat(new Vec3d(7.0, 6.0, 3.0)));
        VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.ALUMINUM_BOAT.get()), properties);
        properties = new VehicleProperties();
        properties.setAxleOffset(-1.5f);
        properties.setWheelOffset(4.375f);
        properties.setBodyPosition(new PartPosition(1.25));
        properties.setFuelPortPosition(new PartPosition(0.0, 6.55, 5.0, -90.0, 0.0, 0.0, 0.35));
        properties.setKeyPortPosition(new PartPosition(-5.0, 4.5, 6.5, -45.0, 0.0, 0.0, 0.5));
        properties.setHeldOffset(new Vec3d(4.0, 3.5, 0.0));
        properties.setTowBarPosition(new Vec3d(0.0, 0.0, -20.8));
        properties.setTrailerOffset(new Vec3d(0.0, 0.0, -0.55));
        properties.setDisplayPosition(new PartPosition(1.5));
        properties.addWheel(Wheel.Side.LEFT, Wheel.Position.FRONT, 4.0f, 10.5f, 1.85f, true, true);
        properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.FRONT, 4.0f, 10.5f, 1.85f, true, true);
        properties.addWheel(Wheel.Side.LEFT, Wheel.Position.REAR, 4.0f, -10.5f, 1.85f, true, true);
        properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.REAR, 4.0f, -10.5f, 1.85f, true, true);
        properties.setFrontAxelVec(0.0, 10.5);
        properties.setRearAxelVec(0.0, -10.5);
        properties.addSeat(new Seat(new Vec3d(0.0, 5.0, -3.0), true));
        properties.addSeat(new Seat(new Vec3d(0.0, 5.5, -12.0)));
        VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.ATV.get()), properties);
        properties = new VehicleProperties();
        properties.setAxleOffset(-1.5f);
        properties.setWheelOffset(1.5f);
        properties.setBodyPosition(new PartPosition(1.2));
        properties.setFuelPortPosition(new PartPosition(-8.0, 6.0, -8.0, 0.0, -90.0, 0.0, 0.25));
        properties.setHeldOffset(new Vec3d(6.0, 0.0, 0.0));
        properties.setTrailerOffset(new Vec3d(0.0, -0.03125, -0.5625));
        properties.setDisplayPosition(new PartPosition(1.5));
        properties.addWheel(Wheel.Side.LEFT, Wheel.Position.FRONT, 7.0f, 8.5f, 0.75f, false, true);
        properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.FRONT, 7.0f, 8.5f, 0.75f, false, true);
        properties.addWheel(Wheel.Side.LEFT, Wheel.Position.REAR, 7.0f, -8.5f, 0.75f, false, true);
        properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.REAR, 7.0f, -8.5f, 0.75f, false, true);
        properties.setFrontAxelVec(0.0, 8.5);
        properties.setRearAxelVec(0.0, -8.5);
        properties.addSeat(new Seat(new Vec3d(0.0, 1.0, -6.0), true));
        VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.BUMPER_CAR.get()), properties);
        properties = new VehicleProperties();
        properties.setAxleOffset(-2.3f);
        properties.setWheelOffset(2.5f);
        properties.setBodyPosition(new PartPosition(1.3));
        properties.setFuelPortPosition(new PartPosition(0.0, 3.0, -7.0, 0.0, 180.0, 0.0, 0.25));
        properties.setHeldOffset(new Vec3d(2.0, 0.0, 0.0));
        properties.setTrailerOffset(new Vec3d(0.0, -0.025, -0.25));
        properties.setDisplayPosition(new PartPosition(1.75));
        properties.addWheel(Wheel.Side.NONE, Wheel.Position.FRONT, 2.4f, 5.3f, 1.0f, false, false);
        properties.addWheel(Wheel.Side.LEFT, Wheel.Position.REAR, 2.4f, -5.7f, 1.0f, true, true);
        properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.REAR, 2.4f, -5.7f, 1.0f, true, true);
        properties.setFrontAxelVec(0.0, 5.3);
        properties.setRearAxelVec(0.0, -5.7);
        properties.addSeat(new Seat(new Vec3d(0.0, 2.0, -3.0), true));
        VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.DUNE_BUGGY.get()), properties);
        properties = new VehicleProperties();
        properties.setAxleOffset(-2.5f);
        properties.setWheelOffset(3.45f);
        properties.setBodyPosition(new PartPosition(1.0));
        properties.setEnginePosition(new PartPosition(0.0, 2.0, -9.0, 0.0, 180.0, 0.0, 1.2));
        properties.setHeldOffset(new Vec3d(3.0, 0.5, 0.0));
        properties.setTrailerOffset(new Vec3d(0.0, -0.03125, -0.375));
        properties.setDisplayPosition(new PartPosition(0.0, 0.0, -0.15f, 0.0, 0.0, 0.0, 1.5));
        properties.addWheel(Wheel.Side.LEFT, Wheel.Position.FRONT, 9.0f, 13.5f, 1.4f, false, true);
        properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.FRONT, 9.0f, 13.5f, 1.4f, false, true);
        properties.addWheel(Wheel.Side.LEFT, Wheel.Position.REAR, 9.0f, -8.5f, 1.4f, true, true);
        properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.REAR, 9.0f, -8.5f, 1.4f, true, true);
        properties.setFrontAxelVec(0.0, 13.5);
        properties.setRearAxelVec(0.0, -8.5);
        properties.addSeat(new Seat(new Vec3d(0.0, -2.0, -1.0), true));
        VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.GO_KART.get()), properties);
        properties = new VehicleProperties();
        properties.setAxleOffset(-0.5f);
        properties.setWheelOffset(4.45f);
        properties.setBodyPosition(new PartPosition(1.15));
        properties.setFuelPortPosition(new PartPosition(-13.0, 3.5, -6.0, 0.0, -90.0, 0.0, 0.25));
        properties.setKeyPortPosition(new PartPosition(-8.5, 2.75, 8.5, -67.5, 0.0, 0.0, 0.5));
        properties.setHeldOffset(new Vec3d(1.5, 2.5, 0.0));
        properties.setDisplayPosition(new PartPosition(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.25));
        properties.addWheel(Wheel.Side.LEFT, Wheel.Position.FRONT, 9.0f, 16.0f, 1.75f, false, true);
        properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.FRONT, 9.0f, 16.0f, 1.75f, false, true);
        properties.addWheel(Wheel.Side.LEFT, Wheel.Position.REAR, 9.0f, -12.5f, 1.75f, true, true);
        properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.REAR, 9.0f, -12.5f, 1.75f, true, true);
        properties.setFrontAxelVec(0.0, 16.0);
        properties.setRearAxelVec(0.0, -12.5);
        properties.addSeat(new Seat(new Vec3d(5.5, 5.0, -6.0), true));
        properties.addSeat(new Seat(new Vec3d(-5.5, 5.0, -6.0)));
        properties.addSeat(new Seat(new Vec3d(5.5, 5.0, -15.0), 180.0f));
        properties.addSeat(new Seat(new Vec3d(-5.5, 5.0, -15.0), 180.0f));
        VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.GOLF_CART.get()), properties);
        properties = new VehicleProperties();
        properties.setWheelOffset(2.75f);
        properties.setBodyPosition(new PartPosition(0.0, 0.0, 0.25, 0.0, 0.0, 0.0, 1.25));
        properties.setFuelPortPosition(new PartPosition(0.0, 9.25, 8.5, -90.0, 0.0, 0.0, 0.35));
        properties.setHeldOffset(new Vec3d(6.0, 0.0, 0.0));
        properties.setTrailerOffset(new Vec3d(0.0, -0.09375, -0.65));
        properties.setDisplayPosition(new PartPosition(0.0, 0.0, -0.45f, 0.0, 0.0, 0.0, 1.5));
        properties.addSeat(new Seat(new Vec3d(0.0, 5.0, 0.0), true));
        properties.addSeat(new Seat(new Vec3d(0.0, 5.0, -7.0)));
        VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.JET_SKI.get()), properties);
        properties = new VehicleProperties();
        properties.setAxleOffset(-2.0f);
        properties.setWheelOffset(2.85f);
        properties.setBodyPosition(new PartPosition(1.25));
        properties.setFuelPortPosition(new PartPosition(-4.5, 9.5, 4.0, 0.0, -90.0, 0.0, 0.2));
        properties.setKeyPortPosition(new PartPosition(-5.0, 4.5, 6.5, -45.0, 0.0, 0.0, 0.5));
        properties.setHeldOffset(new Vec3d(12.0, -1.5, 0.0));
        properties.setTowBarPosition(new Vec3d(0.0, 0.0, -20.0));
        properties.setTrailerOffset(new Vec3d(0.0, -0.01, -1.0));
        properties.setDisplayPosition(new PartPosition(1.5));
        properties.addWheel(Wheel.Side.LEFT, Wheel.Position.FRONT, 6.0f, 0.0f, 13.5f, 1.15f, false, true);
        properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.FRONT, 6.0f, 0.0f, 13.5f, 1.15f, false, true);
        properties.addWheel(Wheel.Side.LEFT, Wheel.Position.REAR, 5.0f, 0.8f, -10.7f, 1.55f, true, true);
        properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.REAR, 5.0f, 0.8f, -10.7f, 1.55f, true, true);
        properties.setFrontAxelVec(0.0, 13.5);
        properties.setRearAxelVec(0.0, -10.7);
        properties.addSeat(new Seat(new Vec3d(0.0, 7.0, -9.0), true));
        VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.LAWN_MOWER.get()), properties);
        properties = new VehicleProperties();
        properties.setAxleOffset(-1.7f);
        properties.setWheelOffset(4.0f);
        properties.setBodyPosition(new PartPosition(1.05));
        properties.setEnginePosition(new PartPosition(0.0, 1.0, 2.5, 0.0, 180.0, 0.0, 1.0));
        properties.setHeldOffset(new Vec3d(6.0, 0.0, 0.0));
        properties.setTrailerOffset(new Vec3d(0.0, -0.0625, -0.5));
        properties.setDisplayPosition(new PartPosition(0.0, 0.0, -0.1f, 0.0, 0.0, 0.0, 1.5));
        properties.addWheel(Wheel.Side.NONE, Wheel.Position.REAR, 0.0f, -6.7f, 1.65f, true, true);
        properties.addWheel(Wheel.Side.NONE, Wheel.Position.FRONT, 0.0f, -0.39375f, 13.0f, 1.65f, true, false);
        properties.setFrontAxelVec(0.0, 13.0);
        properties.setRearAxelVec(0.0, -6.7);
        properties.addSeat(new Seat(new Vec3d(0.0, 7.0, -2.0), true));
        VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.MINI_BIKE.get()), properties);
        properties = new VehicleProperties();
        properties.setAxleOffset(1.0f);
        properties.setWheelOffset(4.5f);
        properties.setBodyPosition(new PartPosition(1.3));
        properties.setFuelPortPosition(new PartPosition(-12.0, 8.0, -8.75, 0.0, -90.0, 0.0, 0.25));
        properties.setKeyPortPosition(new PartPosition(0.0, 6.75, 19.5, -67.5, 0.0, 0.0, 0.5));
        properties.setHeldOffset(new Vec3d(0.0, 3.5, 0.0));
        properties.setTowBarPosition(new Vec3d(0.0, 0.0, -33.0));
        properties.setDisplayPosition(new PartPosition(1.0));
        properties.addWheel(Wheel.Side.LEFT, Wheel.Position.FRONT, 9.0f, 0.0f, 13.5f, 1.5f, 1.9f, 1.9f, true, true);
        properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.FRONT, 9.0f, 0.0f, 13.5f, 1.5f, 1.9f, 1.9f, true, true);
        properties.addWheel(Wheel.Side.LEFT, Wheel.Position.REAR, 9.0f, 0.0f, -13.5f, 1.5f, 1.9f, 1.9f, true, true);
        properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.REAR, 9.0f, 0.0f, -13.5f, 1.5f, 1.9f, 1.9f, true, true);
        properties.setFrontAxelVec(0.0, 14.5);
        properties.setRearAxelVec(0.0, -14.5);
        properties.addSeat(new Seat(new Vec3d(4.5, 2.0, 11.0), true));
        properties.addSeat(new Seat(new Vec3d(-4.5, 2.0, 11.0)));
        properties.addSeat(new Seat(new Vec3d(4.5, 2.0, -3.0)));
        properties.addSeat(new Seat(new Vec3d(-4.5, 2.0, -3.0)));
        properties.addSeat(new Seat(new Vec3d(4.5, 2.0, -15.0)));
        VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.MINI_BUS.get()), properties);
        properties = new VehicleProperties();
        properties.setAxleOffset(-1.0f);
        properties.setWheelOffset(3.5f);
        properties.setBodyPosition(new PartPosition(1.2));
        properties.setFuelPortPosition(new PartPosition(-2.5, 4.2, -2.5, 0.0, -90.0, 0.0, 0.2));
        properties.setHeldOffset(new Vec3d(7.0, 2.0, 0.0));
        properties.setTrailerOffset(new Vec3d(0.0, -0.03125, -0.65));
        properties.setDisplayPosition(new PartPosition(0.0, 0.0, -0.25, 0.0, 0.0, 0.0, 1.5));
        properties.addWheel(Wheel.Side.NONE, Wheel.Position.REAR, 0.0f, -6.7f, 1.5f, true, true);
        properties.addWheel(Wheel.Side.NONE, Wheel.Position.FRONT, 0.0f, -0.4f, 14.5f, 1.3f, true, false);
        properties.setFrontAxelVec(0.0, 14.5);
        properties.setRearAxelVec(0.0, -6.7);
        properties.addSeat(new Seat(new Vec3d(0.0, 4.0, -2.0), true));
        VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.MOPED.get()), properties);
        properties = new VehicleProperties();
        properties.setAxleOffset(-1.0f);
        properties.setWheelOffset(5.4f);
        properties.setBodyPosition(new PartPosition(1.4));
        properties.setFuelPortPosition(new PartPosition(-12.0, 8.5, -6.5, 0.0, -90.0, 0.0, 0.25));
        properties.setKeyPortPosition(new PartPosition(0.0, 7.0, 6.2, -67.5, 0.0, 0.0, 0.5));
        properties.setHeldOffset(new Vec3d(0.0, 3.5, 0.0));
        properties.setDisplayPosition(new PartPosition(0.0, 0.0, 0.1f, 0.0, 0.0, 0.0, 1.0));
        properties.addWheel(Wheel.Side.LEFT, Wheel.Position.FRONT, 10.0f, 14.5f, 2.25f, true, true);
        properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.FRONT, 10.0f, 14.5f, 2.25f, true, true);
        properties.addWheel(Wheel.Side.LEFT, Wheel.Position.REAR, 10.0f, -14.5f, 2.25f, true, true);
        properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.REAR, 10.0f, -14.5f, 2.25f, true, true);
        properties.setFrontAxelVec(0.0, 14.5);
        properties.setRearAxelVec(0.0, -14.5);
        properties.addSeat(new Seat(new Vec3d(5.0, 4.0, -3.0), true));
        properties.addSeat(new Seat(new Vec3d(-5.0, 4.0, -3.0)));
        properties.addSeat(new Seat(new Vec3d(5.0, 11.5, -14.5)));
        properties.addSeat(new Seat(new Vec3d(-5.0, 3.5, -18.9)));
        VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.OFF_ROADER.get()), properties);
        properties = new VehicleProperties();
        properties.setAxleOffset(-1.0f);
        properties.setWheelOffset(2.0f);
        properties.setBodyPosition(new PartPosition(1.05));
        properties.setHeldOffset(new Vec3d(4.0, 9.25, 0.0));
        properties.setTrailerOffset(new Vec3d(0.0, -0.03125, -0.25));
        properties.setDisplayPosition(new PartPosition(1.45f));
        properties.addWheel(Wheel.Side.LEFT, Wheel.Position.NONE, 5.75f, -10.5f, 0.75f, false, true);
        properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.NONE, 5.75f, -10.5f, 0.75f, false, true);
        properties.addWheel(Wheel.Side.LEFT, Wheel.Position.FRONT, 4.0f, 9.5f, 0.75f, false, true);
        properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.FRONT, 4.0f, 9.5f, 0.75f, false, true);
        properties.setFrontAxelVec(0.0, 9.5);
        properties.setRearAxelVec(0.0, -10.5);
        properties.addSeat(new Seat(new Vec3d(0.0, 7.0, -4.0), true));
        VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SHOPPING_CART.get()), properties);
        properties = new VehicleProperties();
        properties.setAxleOffset(-1.7f);
        properties.setWheelOffset(3.5f);
        properties.setBodyPosition(new PartPosition(1.25));
        properties.setFuelPortPosition(new PartPosition(-9.0, 8.7, -12.3, 0.0, -90.0, 0.0, 0.25));
        properties.setHeldOffset(new Vec3d(3.0, 1.0, 0.0));
        properties.setTowBarPosition(new Vec3d(0.0, 0.0, -24.5));
        properties.setDisplayPosition(new PartPosition(1.35f));
        properties.addWheel(Wheel.Side.LEFT, Wheel.Position.FRONT, 7.0f, 12.0f, 1.5f, true, true);
        properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.FRONT, 7.0f, 12.0f, 1.5f, true, true);
        properties.addWheel(Wheel.Side.LEFT, Wheel.Position.REAR, 7.0f, -12.0f, 1.5f, false, true);
        properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.REAR, 7.0f, -12.0f, 1.5f, false, true);
        properties.setFrontAxelVec(0.0, 12.0);
        properties.setRearAxelVec(0.0, -12.0);
        properties.addSeat(new Seat(new Vec3d(0.0, 0.5, -2.0), true));
        VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SMART_CAR.get()), properties);
        properties = new VehicleProperties();
        properties.setWheelOffset(2.5f);
        properties.setBodyPosition(new PartPosition(0.0, -0.03125, 0.6875, 1.0));
        properties.setFuelPortPosition(new PartPosition(0.0, 5.25, -20.5, -90.0, 0.0, 0.0, 0.65));
        properties.setHeldOffset(new Vec3d(6.0, -0.5, 0.0));
        properties.setTrailerOffset(new Vec3d(0.0, -0.09375, -0.75));
        properties.setDisplayPosition(new PartPosition(0.0, 0.0, -0.65f, 0.0, 0.0, 0.0, 1.25));
        properties.addSeat(new Seat(new Vec3d(0.0, 0.0, 0.0), true));
        VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SPEED_BOAT.get()), properties);
        properties = new VehicleProperties();
        properties.setBodyPosition(new PartPosition(0.0, 0.6875, -0.5, 0.0, 0.0, 0.0, 1.8));
        properties.setFuelPortPosition(new PartPosition(-4.35, 4.0, -6.0, 0.0, -112.5, 0.0, 0.25));
        properties.setKeyPortPosition(new PartPosition(0.0, 3.75, 12.5, -67.5, 0.0, 0.0, 0.5));
        properties.setDisplayPosition(new PartPosition(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.85f));
        properties.addSeat(new Seat(new Vec3d(0.0, 6.0, 0.0), true));
        VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SPORTS_PLANE.get()), properties);
        properties = new VehicleProperties();
        properties.setAxleOffset(-3.0f);
        properties.setWheelOffset(5.5f);
        properties.setBodyPosition(new PartPosition(1.0));
        properties.setEnginePosition(new PartPosition(0.0, 6.0, 8.775, 0.0, 0.0, 0.0, 0.85));
        properties.setFuelPortPosition(new PartPosition(-6.0, 9.5, -0.5, 0.0, -90.0, 0.0, 0.3));
        properties.setKeyPortPosition(new PartPosition(-2.75, 12.0, -1.75, -45.0, 0.0, 0.0, 0.5));
        properties.setHeldOffset(new Vec3d(0.0, 3.5, 0.0));
        properties.setTowBarPosition(new Vec3d(0.0, 0.0, -24.5));
        properties.setDisplayPosition(new PartPosition(1.25));
        properties.addWheel(Wheel.Side.LEFT, Wheel.Position.FRONT, 8.0f, 0.0f, 14.0f, 1.5f, 2.25f, 2.25f, true, true);
        properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.FRONT, 8.0f, 0.0f, 14.0f, 1.5f, 2.25f, 2.25f, true, true);
        properties.addWheel(Wheel.Side.LEFT, Wheel.Position.REAR, 8.0f, 5.5f, -14.5f, 3.0f, 4.5f, 4.5f, true, true);
        properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.REAR, 8.0f, 5.5f, -14.5f, 3.0f, 4.5f, 4.5f, true, true);
        properties.setFrontAxelVec(0.0, 14.0);
        properties.setRearAxelVec(0.0, -14.5);
        properties.addSeat(new Seat(new Vec3d(0.0, 9.0, -14.0), true));
        VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.TRACTOR.get()), properties);
        properties = new VehicleProperties();
        properties.setBodyPosition(new PartPosition(0.0, 0.325, 0.0, 0.0, 0.0, 0.0, 1.1));
        properties.setDisplayPosition(new PartPosition(0.0, 0.0, -0.15f, 0.0, 0.0, 0.0, 1.35f));
        VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.FERTILIZER.get()), properties);
        properties = new VehicleProperties();
        properties.setBodyPosition(new PartPosition(0.0, 0.325, 0.0, 0.0, 0.0, 0.0, 1.1));
        properties.setHeldOffset(new Vec3d(0.0, 3.0, 0.0));
        properties.setDisplayPosition(new PartPosition(0.0, 0.0, -0.15f, 0.0, 0.0, 0.0, 1.35f));
        VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.FLUID_TRAILER.get()), properties);
        properties = new VehicleProperties();
        properties.setBodyPosition(new PartPosition(0.0, 0.325, 0.0, 0.0, 0.0, 0.0, 1.1));
        properties.setDisplayPosition(new PartPosition(0.0, 0.0, -0.15f, 0.0, 0.0, 0.0, 1.35f));
        VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SEEDER.get()), properties);
        properties = new VehicleProperties();
        properties.setBodyPosition(new PartPosition(0.0, 0.325, 0.0, 0.0, 0.0, 0.0, 1.1));
        properties.setTowBarPosition(new Vec3d(0.0, 0.0, -12.0));
        properties.setDisplayPosition(new PartPosition(0.0, 0.0, -0.15f, 0.0, 0.0, 0.0, 1.35f));
        VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.STORAGE_TRAILER.get()), properties);
        properties = new VehicleProperties();
        properties.setBodyPosition(new PartPosition(0.0, 0.325, 0.0, 0.0, 0.0, 0.0, 1.1));
        properties.setHeldOffset(new Vec3d(0.0, 3.0, 0.0));
        properties.setDisplayPosition(new PartPosition(0.0, 0.0, -0.15f, 0.0, 0.0, 0.0, 1.35f));
        VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.VEHICLE_TRAILER.get()), properties);
        if (ModList.get().isLoaded("cfm")) {
            properties = new VehicleProperties();
            properties.setBodyPosition(new PartPosition(1.0));
            properties.setHeldOffset(new Vec3d(4.0, 3.5, 0.0));
            properties.setTrailerOffset(new Vec3d(0.0, 0.0, -0.4375));
            properties.setDisplayPosition(new PartPosition(0.0, 0.0, -0.25, 0.0, 0.0, 0.0, 1.5));
            properties.addSeat(new Seat(new Vec3d(0.0, 0.0, 0.0), true));
            VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.BATH.get()), properties);
            properties = new VehicleProperties();
            properties.setAxleOffset(-1.5f);
            properties.setWheelOffset(5.0f);
            properties.setBodyPosition(new PartPosition(0.0, -0.0625, 0.0, 0.0, 0.0, 0.0, 1.0));
            properties.setFuelPortPosition(new PartPosition(0.0, 2.0, 8.0, 0.0, 0.0, 0.0, 0.5));
            properties.setHeldOffset(new Vec3d(2.0, 2.0, 0.0));
            properties.setTrailerOffset(new Vec3d(0.0, 0.0, -0.25));
            properties.setDisplayPosition(new PartPosition(0.0, 0.0, -0.25, 0.0, 0.0, 0.0, 1.5));
            properties.addWheel(Wheel.Side.LEFT, Wheel.Position.FRONT, 8.0f, 0.0625f, 7.0f, 1.75f, false, true);
            properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.FRONT, 8.0f, 0.0625f, 7.0f, 1.75f, false, true);
            properties.addWheel(Wheel.Side.LEFT, Wheel.Position.REAR, 8.0f, 0.0625f, -7.0f, 1.75f, true, true);
            properties.addWheel(Wheel.Side.RIGHT, Wheel.Position.REAR, 8.0f, 0.0625f, -7.0f, 1.75f, true, true);
            properties.setFrontAxelVec(0.0, 7.0);
            properties.setRearAxelVec(0.0, -7.0);
            properties.addSeat(new Seat(new Vec3d(0.0, 5.0, 0.0), true));
            VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SOFA.get()), properties);
            properties = new VehicleProperties();
            properties.setBodyPosition(new PartPosition(0.0, 0.0, 0.0625, 0.0, 0.0, 0.0, 1.0));
            properties.setFuelPortPosition(new PartPosition(0.0, 1.5, 8.0, 0.0, 0.0, 0.0, 0.45));
            properties.setKeyPortPosition(new PartPosition(-9.25, 8.0, 5.0, 0.0, 0.0, 0.0, 0.8));
            properties.setDisplayPosition(new PartPosition(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.25));
            properties.addSeat(new Seat(new Vec3d(0.0, 0.0, 0.0), true));
            VehicleProperties.setProperties((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SOFACOPTER.get()), properties);
        }
    }

    public void setAxleOffset(float axleOffset) {
        this.axleOffset = axleOffset;
    }

    public float getAxleOffset() {
        return this.axleOffset;
    }

    public void setWheelOffset(float wheelOffset) {
        this.wheelOffset = wheelOffset;
    }

    public float getWheelOffset() {
        return this.wheelOffset;
    }

    public void setHeldOffset(Vec3d heldOffset) {
        this.heldOffset = heldOffset;
    }

    public Vec3d getHeldOffset() {
        return this.heldOffset;
    }

    public void setTowBarPosition(Vec3d towBarVec) {
        this.towBarVec = towBarVec;
    }

    public Vec3d getTowBarPosition() {
        return this.towBarVec;
    }

    public void setTrailerOffset(Vec3d trailerOffset) {
        this.trailerOffset = trailerOffset;
    }

    public Vec3d getTrailerOffset() {
        return this.trailerOffset;
    }

    public void addWheel(Wheel.Side side, Wheel.Position position, float offsetX, float offsetZ, float scale, boolean particles, boolean render) {
        this.wheels.add(new Wheel(side, position, 2.0f, scale, scale, scale, offsetX, 0.0f, offsetZ, particles, render));
    }

    public void addWheel(Wheel.Side side, Wheel.Position position, float offsetX, float offsetY, float offsetZ, float scale, boolean particles, boolean render) {
        this.wheels.add(new Wheel(side, position, 2.0f, scale, scale, scale, offsetX, offsetY, offsetZ, particles, render));
    }

    public void addWheel(Wheel.Side side, Wheel.Position position, float offsetX, float offsetY, float offsetZ, float scaleX, float scaleY, float scaleZ, boolean particles, boolean render) {
        this.wheels.add(new Wheel(side, position, 2.0f, scaleX, scaleY, scaleZ, offsetX, offsetY, offsetZ, particles, render));
    }

    public List<Wheel> getWheels() {
        return this.wheels;
    }

    @Nullable
    public Wheel getFirstFrontWheel() {
        return this.wheels.stream().filter(wheel -> wheel.getPosition() == Wheel.Position.FRONT).findFirst().orElse(null);
    }

    @Nullable
    public Wheel getFirstRearWheel() {
        return this.wheels.stream().filter(wheel -> wheel.getPosition() == Wheel.Position.REAR).findFirst().orElse(null);
    }

    public void setBodyPosition(PartPosition bodyPosition) {
        this.bodyPosition = bodyPosition;
    }

    public PartPosition getBodyPosition() {
        return this.bodyPosition;
    }

    public void setEnginePosition(PartPosition enginePosition) {
        this.enginePosition = enginePosition;
    }

    public PartPosition getEnginePosition() {
        return this.enginePosition;
    }

    public void setFuelPortPosition(PartPosition fuelPortPosition) {
        this.fuelPortPosition = fuelPortPosition;
        this.fuelPortLidPosition = new PartPosition(fuelPortPosition.getX() - 6.0 * fuelPortPosition.getScale(), fuelPortPosition.getY(), fuelPortPosition.getZ() - 5.0 * fuelPortPosition.getScale(), fuelPortPosition.getRotX(), fuelPortPosition.getRotY() - 90.0, fuelPortPosition.getRotZ(), fuelPortPosition.getScale());
    }

    public PartPosition getFuelPortPosition() {
        return this.fuelPortPosition;
    }

    public void setFuelPortLidPosition(PartPosition fuelPortLidPosition) {
        this.fuelPortLidPosition = fuelPortLidPosition;
    }

    public PartPosition getFuelPortLidPosition() {
        return this.fuelPortLidPosition;
    }

    public void setKeyPortPosition(PartPosition keyPortPosition) {
        this.keyPortPosition = keyPortPosition;
        this.keyPosition = new PartPosition(keyPortPosition.getX(), keyPortPosition.getY(), keyPortPosition.getZ(), keyPortPosition.getRotX() + 90.0, 0.0, 0.0, 0.15);
    }

    public PartPosition getKeyPortPosition() {
        return this.keyPortPosition;
    }

    public void setKeyPosition(PartPosition keyPosition) {
        this.keyPosition = keyPosition;
    }

    public PartPosition getKeyPosition() {
        return this.keyPosition;
    }

    public void setDisplayPosition(PartPosition displayPosition) {
        this.displayPosition = displayPosition;
    }

    public PartPosition getDisplayPosition() {
        return this.displayPosition;
    }

    public void setFrontAxelVec(double x, double z) {
        this.frontAxelVec = new Vec3d(x, 0.0, z);
    }

    @Nullable
    public Vec3d getFrontAxelVec() {
        return this.frontAxelVec;
    }

    public void setRearAxelVec(double x, double z) {
        this.rearAxelVec = new Vec3d(x, 0.0, z);
    }

    @Nullable
    public Vec3d getRearAxelVec() {
        return this.rearAxelVec;
    }

    public void addSeat(Seat seat) {
        this.seats.add(seat);
    }

    public List<Seat> getSeats() {
        return ImmutableList.copyOf(this.seats);
    }
}

