/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.entity;

import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.tileentity.JackTileEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntityJack
extends Entity
implements IEntityAdditionalSpawnData {
    private double initialX;
    private double initialY;
    private double initialZ;
    private boolean activated = false;
    private int liftProgress;

    public EntityJack(EntityType<? extends EntityJack> type, World worldIn) {
        super(type, worldIn);
        this.func_189654_d(true);
        this.field_70145_X = true;
    }

    public EntityJack(EntityType<? extends EntityJack> type, World worldIn, BlockPos pos, double yOffset, float yaw) {
        this(type, worldIn);
        this.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + yOffset, (double)pos.func_177952_p() + 0.5);
        this.func_70101_b(yaw, 0.0f);
        this.initialX = (double)pos.func_177958_n() + 0.5;
        this.initialY = (double)pos.func_177956_o() + yOffset;
        this.initialZ = (double)pos.func_177952_p() + 0.5;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        TileEntity tileEntity;
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.func_184188_bt().size() == 0) {
            this.func_70106_y();
        }
        if (!this.func_70089_S()) {
            return;
        }
        if (!this.activated && this.func_184188_bt().size() > 0) {
            this.activated = true;
        }
        if (this.activated) {
            if (this.liftProgress < 10) {
                ++this.liftProgress;
            }
        } else if (this.liftProgress > 0) {
            --this.liftProgress;
        }
        if ((tileEntity = this.field_70170_p.func_175625_s(new BlockPos(this.initialX, this.initialY, this.initialZ))) instanceof JackTileEntity) {
            JackTileEntity jackTileEntity = (JackTileEntity)tileEntity;
            this.func_70107_b(this.initialX, this.initialY + 0.5 * ((double)jackTileEntity.liftProgress / 20.0), this.initialZ);
        }
    }

    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184188_bt().contains(passenger)) {
            passenger.field_70169_q = this.field_70165_t;
            passenger.field_70167_r = this.field_70163_u;
            passenger.field_70166_s = this.field_70161_v;
            passenger.field_70142_S = this.field_70165_t;
            passenger.field_70137_T = this.field_70163_u;
            passenger.field_70136_U = this.field_70161_v;
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_184232_k(Entity passenger) {
        if (passenger instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)passenger;
            Vec3d heldOffset = vehicle.getProperties().getHeldOffset().func_178785_b(passenger.field_70177_z * ((float)Math.PI / 180));
            vehicle.func_70107_b(this.field_70165_t - heldOffset.field_72449_c * 0.0625, this.field_70163_u - heldOffset.field_72448_b * 0.0625 - 0.125, this.field_70161_v - heldOffset.field_72450_a * 0.0625);
        }
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.initialX = compound.func_74769_h("initialX");
        this.initialY = compound.func_74769_h("initialY");
        this.initialZ = compound.func_74769_h("initialZ");
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74780_a("initialX", this.initialX);
        compound.func_74780_a("initialY", this.initialY);
        compound.func_74780_a("initialZ", this.initialZ);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeDouble(this.initialX);
        buffer.writeDouble(this.initialY);
        buffer.writeDouble(this.initialZ);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.initialX = buffer.readDouble();
        this.initialY = buffer.readDouble();
        this.initialZ = buffer.readDouble();
        this.func_70012_b(this.initialX, this.initialY, this.initialZ, this.field_70177_z, this.field_70125_A);
        this.field_70169_q = this.initialX;
        this.field_70167_r = this.initialY;
        this.field_70166_s = this.initialZ;
        this.field_70142_S = this.initialX;
        this.field_70137_T = this.initialY;
        this.field_70136_U = this.initialZ;
    }
}

