/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.crafting;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.fluid.Fluid;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class FluidEntry {
    private Fluid fluid;
    private int amount;

    public FluidEntry(Fluid fluid, int amount) {
        this.fluid = fluid;
        this.amount = amount;
    }

    public Fluid getFluid() {
        return this.fluid;
    }

    public int getAmount() {
        return this.amount;
    }

    public FluidStack createStack() {
        return new FluidStack(this.fluid, this.amount);
    }

    public static FluidEntry deserialize(JsonObject object) {
        if (!object.has("fluid") || !object.has("amount")) {
            throw new JsonSyntaxException("Invalid fluid entry, missing fluid and amount");
        }
        ResourceLocation fluidId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"fluid"));
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(fluidId);
        if (fluid == null) {
            throw new JsonSyntaxException("Invalid fluid entry, unknown fluid: " + fluidId.toString());
        }
        int amount = JSONUtils.func_151203_m((JsonObject)object, (String)"amount");
        if (amount < 1) {
            throw new JsonSyntaxException("Invalid fluid entry, amount must be more than zero");
        }
        return new FluidEntry(fluid, amount);
    }

    public void write(PacketBuffer buffer) {
        buffer.func_211400_a(this.fluid.getRegistryName().toString(), 256);
        buffer.writeInt(this.amount);
    }

    public static FluidEntry read(PacketBuffer buffer) {
        Fluid fluid = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(buffer.func_150789_c(256)));
        int amount = buffer.readInt();
        return new FluidEntry(fluid, amount);
    }
}

