/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.common;

import com.google.common.collect.ImmutableList;
import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.common.entity.HeldVehicleDataHandler;
import com.mrcrayfish.vehicle.common.entity.SyncedPlayerData;
import com.mrcrayfish.vehicle.entity.EntityJack;
import com.mrcrayfish.vehicle.entity.TrailerEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.init.ModSounds;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageThrowVehicle;
import com.mrcrayfish.vehicle.tileentity.GasPumpTileEntity;
import com.mrcrayfish.vehicle.tileentity.JackTileEntity;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CommonEvents {
    private static final List<String> IGNORE_ITEMS;
    private static final List<String> IGNORE_SOUNDS;
    private static final List<String> IGNORE_ENTITIES;

    @SubscribeEvent
    public void onMissingItem(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping missing : event.getMappings()) {
            if (!missing.key.func_110624_b().equals("vehicle") || !IGNORE_ITEMS.contains(missing.key.func_110623_a())) continue;
            missing.ignore();
        }
    }

    @SubscribeEvent
    public void onMissingSound(RegistryEvent.MissingMappings<SoundEvent> event) {
        for (RegistryEvent.MissingMappings.Mapping missing : event.getMappings()) {
            if (!missing.key.func_110624_b().equals("vehicle") || !IGNORE_SOUNDS.contains(missing.key.func_110623_a())) continue;
            missing.ignore();
        }
    }

    @SubscribeEvent
    public void onMissingEntity(RegistryEvent.MissingMappings<EntityType<?>> event) {
        for (RegistryEvent.MissingMappings.Mapping missing : event.getMappings()) {
            if (!missing.key.func_110624_b().equals("vehicle") || !IGNORE_ENTITIES.contains(missing.key.func_110623_a())) continue;
            missing.ignore();
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        if (CommonEvents.pickUpVehicle(event.getWorld(), event.getPlayer(), event.getHand(), event.getTarget())) {
            event.setCanceled(true);
        }
    }

    public static boolean pickUpVehicle(World world, PlayerEntity player, Hand hand, Entity targetEntity) {
        if (hand == Hand.MAIN_HAND && !world.field_72995_K && player.func_70093_af() && !player.func_175149_v() && ((Boolean)Config.SERVER.pickUpVehicles.get()).booleanValue()) {
            EntityType entityType;
            Entity vehicle;
            CompoundNBT tagCompound;
            Optional optional;
            if (!HeldVehicleDataHandler.isHoldingVehicle(player)) {
                if (targetEntity instanceof VehicleEntity && !targetEntity.func_184207_aI() && targetEntity.func_70089_S()) {
                    CompoundNBT tagCompound2 = new CompoundNBT();
                    String id = CommonEvents.getEntityString(targetEntity);
                    if (id != null) {
                        ((VehicleEntity)targetEntity).setTrailer(null);
                        tagCompound2.func_74778_a("id", id);
                        targetEntity.func_189511_e(tagCompound2);
                        HeldVehicleDataHandler.setHeldVehicle(player, tagCompound2);
                        targetEntity.func_70106_y();
                        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)ModSounds.PICK_UP_VEHICLE.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                        return true;
                    }
                }
            } else if (targetEntity instanceof TrailerEntity && !targetEntity.func_184207_aI() && targetEntity.func_70089_S() && (optional = EntityType.func_220327_a((String)(tagCompound = HeldVehicleDataHandler.getHeldVehicle(player)).func_74779_i("id"))).isPresent() && (vehicle = (entityType = (EntityType)optional.get()).func_200721_a(world)) instanceof VehicleEntity && ((VehicleEntity)vehicle).canMountTrailer()) {
                vehicle.func_70020_e(tagCompound);
                vehicle.func_70080_a(targetEntity.field_70165_t, targetEntity.field_70163_u, targetEntity.field_70161_v, targetEntity.field_70177_z, targetEntity.field_70125_A);
                HeldVehicleDataHandler.setHeldVehicle(player, tagCompound);
                world.func_217376_c(vehicle);
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187727_dV, SoundCategory.PLAYERS, 1.0f, 1.0f);
                vehicle.func_184220_m(targetEntity);
                return true;
            }
        }
        return false;
    }

    private RayTraceResult rayTrace(PlayerEntity player, double distance, float partialTicks, boolean includeWater) {
        Vec3d eyeVec = player.func_174824_e(partialTicks);
        Vec3d lookVec = player.func_70676_i(partialTicks);
        Vec3d combinedVec = eyeVec.func_72441_c(lookVec.field_72450_a * distance, lookVec.field_72448_b * distance, lookVec.field_72449_c * distance);
        return player.field_70170_p.func_217299_a(new RayTraceContext(eyeVec, combinedVec, RayTraceContext.BlockMode.OUTLINE, includeWater ? RayTraceContext.FluidMode.ANY : RayTraceContext.FluidMode.NONE, (Entity)player));
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() == Hand.OFF_HAND) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        World world = event.getWorld();
        if (!world.field_72995_K) {
            if (event.getFace() == Direction.UP && HeldVehicleDataHandler.isHoldingVehicle(player)) {
                BlockPos pos = event.getPos();
                TileEntity tileEntity = event.getWorld().func_175625_s(pos);
                if (tileEntity instanceof JackTileEntity) {
                    JackTileEntity jack = (JackTileEntity)tileEntity;
                    if (jack.getJack() == null) {
                        CompoundNBT tagCompound = HeldVehicleDataHandler.getHeldVehicle(player);
                        EntityType.func_220327_a((String)tagCompound.func_74779_i("id")).ifPresent(entityType -> {
                            Entity entity = entityType.func_200721_a(world);
                            if (entity instanceof VehicleEntity) {
                                entity.func_70020_e(tagCompound);
                                HeldVehicleDataHandler.setHeldVehicle(player, new CompoundNBT());
                                entity.field_70143_R = 0.0f;
                                entity.field_70177_z = (player.func_70079_am() + 90.0f) % 360.0f;
                                jack.setVehicle((VehicleEntity)entity);
                                if (jack.getJack() != null) {
                                    EntityJack entityJack = jack.getJack();
                                    entityJack.func_70098_U();
                                    entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                                }
                                world.func_217376_c(entity);
                                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187727_dV, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            }
                        });
                    }
                    event.setCanceled(true);
                    event.setCancellationResult(ActionResultType.SUCCESS);
                    return;
                }
            }
            if (player.func_70093_af() && HeldVehicleDataHandler.isHoldingVehicle(player)) {
                RayTraceResult result = this.rayTrace(player, 10.0, 0.0f, false);
                Vec3d clickedVec = result.func_216347_e();
                if (clickedVec == null || event.getFace() != Direction.UP) {
                    event.setCanceled(true);
                    return;
                }
                CompoundNBT tagCompound = HeldVehicleDataHandler.getHeldVehicle(player);
                EntityType.func_220327_a((String)tagCompound.func_74779_i("id")).ifPresent(entityType -> {
                    Entity entity = entityType.func_200721_a(player.field_70170_p);
                    if (entity instanceof VehicleEntity) {
                        entity.func_70020_e(tagCompound);
                        MinecraftServer server = world.func_73046_m();
                        if (server != null && world.func_73045_a(entity.func_145782_y()) == null) {
                            server.func_213165_a(() -> {
                                HeldVehicleDataHandler.setHeldVehicle(player, new CompoundNBT());
                                float rotation = (player.func_70079_am() + 90.0f) % 360.0f;
                                Vec3d heldOffset = ((VehicleEntity)entity).getProperties().getHeldOffset().func_178785_b((float)Math.toRadians(-player.func_70079_am()));
                                entity.func_70080_a(clickedVec.field_72450_a + heldOffset.field_72450_a * 0.0625, clickedVec.field_72448_b, clickedVec.field_72449_c + heldOffset.field_72449_c * 0.0625, rotation, 0.0f);
                                entity.field_70143_R = 0.0f;
                                world.func_217376_c(entity);
                                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187727_dV, SoundCategory.PLAYERS, 1.0f, 1.0f);
                            });
                            event.setCanceled(true);
                            event.setCancellationResult(ActionResultType.SUCCESS);
                        }
                    }
                });
            }
        } else if (HeldVehicleDataHandler.isHoldingVehicle(player)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getHand() == Hand.OFF_HAND) {
            return;
        }
        World world = event.getWorld();
        if (world.field_72995_K && (event instanceof PlayerInteractEvent.RightClickEmpty || event instanceof PlayerInteractEvent.RightClickItem)) {
            PlayerEntity player = event.getPlayer();
            float reach = (float)player.func_110148_a(PlayerEntity.REACH_DISTANCE).func_111126_e();
            reach = player.func_184812_l_() ? reach : reach - 0.5f;
            RayTraceResult result = this.rayTrace(player, reach, 0.0f, false);
            if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                return;
            }
            if (HeldVehicleDataHandler.isHoldingVehicle(player)) {
                if (player.func_70093_af()) {
                    PacketHandler.instance.sendToServer((Object)new MessageThrowVehicle());
                }
                if (event.isCancelable()) {
                    event.setCanceled(true);
                    event.setCancellationResult(ActionResultType.SUCCESS);
                }
            }
        }
    }

    @Nullable
    private static String getEntityString(Entity entity) {
        ResourceLocation resourceLocation = entity.func_200600_R().getRegistryName();
        return resourceLocation == null ? null : resourceLocation.toString();
    }

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            this.dropVehicle(player);
        }
    }

    private void dropVehicle(PlayerEntity player) {
        CompoundNBT tagCompound = HeldVehicleDataHandler.getHeldVehicle(player);
        if (!tagCompound.isEmpty()) {
            HeldVehicleDataHandler.setHeldVehicle(player, new CompoundNBT());
            EntityType.func_220327_a((String)tagCompound.func_74779_i("id")).ifPresent(entityType -> {
                Entity vehicle = entityType.func_200721_a(player.field_70170_p);
                if (vehicle instanceof VehicleEntity) {
                    vehicle.func_70020_e(tagCompound);
                    float rotation = (player.func_70079_am() + 90.0f) % 360.0f;
                    Vec3d heldOffset = ((VehicleEntity)vehicle).getProperties().getHeldOffset().func_178785_b((float)Math.toRadians(-player.func_70079_am()));
                    vehicle.func_70080_a(player.field_70165_t + heldOffset.field_72450_a * 0.0625, player.field_70163_u + (double)player.func_70047_e() + heldOffset.field_72448_b * 0.0625, player.field_70161_v + heldOffset.field_72449_c * 0.0625, rotation, 0.0f);
                    player.field_70170_p.func_217376_c(vehicle);
                }
            });
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            TileEntity tileEntity;
            Optional<BlockPos> pos;
            int trailerId;
            PlayerEntity player = event.player;
            World world = player.field_70170_p;
            if (player.func_70093_af() && (trailerId = SyncedPlayerData.getTrailer(player)) != -1) {
                Entity entity = world.func_73045_a(trailerId);
                if (entity instanceof TrailerEntity) {
                    ((TrailerEntity)entity).setPullingEntity(null);
                }
                SyncedPlayerData.setTrailer(player, -1);
            }
            if (!world.field_72995_K && player.func_175149_v()) {
                this.dropVehicle(player);
            }
            if ((pos = SyncedPlayerData.getGasPumpPos(player)).isPresent() && !((tileEntity = world.func_175625_s(pos.get())) instanceof GasPumpTileEntity)) {
                SyncedPlayerData.setGasPumpPos(player, Optional.empty());
            }
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickItem event) {
        if (SyncedPlayerData.getGasPumpPos(event.getPlayer()).isPresent()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        BlockState state = event.getWorld().func_180495_p(event.getPos());
        if (state.func_177230_c() != ModBlocks.GAS_PUMP.get() && SyncedPlayerData.getGasPumpPos(event.getPlayer()).isPresent()) {
            event.setCanceled(true);
        }
    }

    static {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)"body");
        builder.add((Object)"atv");
        builder.add((Object)"go_kart");
        IGNORE_ITEMS = builder.build();
        builder = ImmutableList.builder();
        builder.add((Object)"idle");
        builder.add((Object)"driving");
        IGNORE_SOUNDS = builder.build();
        builder = ImmutableList.builder();
        builder.add((Object)"vehicle_atv");
        builder.add((Object)"couch");
        builder.add((Object)"bath");
        IGNORE_ENTITIES = builder.build();
    }
}

