/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.vehicle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.common.Seat;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.entity.vehicle.SpeedBoatEntity;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.Vec3d;

public class RenderSpeedBoat
extends AbstractRenderVehicle<SpeedBoatEntity> {
    @Override
    public void render(SpeedBoatEntity entity, float partialTicks) {
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.SPEED_BOAT_BODY.getModel());
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.0, (double)0.215, (double)-0.125);
        GlStateManager.rotatef((float)-45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.translated((double)0.0, (double)0.02, (double)0.0);
        float wheelAngle = entity.prevWheelAngle + (entity.wheelAngle - entity.prevWheelAngle) * partialTicks;
        float wheelAngleNormal = wheelAngle / 45.0f;
        float turnRotation = wheelAngleNormal * 15.0f;
        GlStateManager.rotatef((float)turnRotation, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderUtil.renderColoredModel(SpecialModels.GO_KART_STEERING_WHEEL.getModel(), ItemCameraTransforms.TransformType.NONE, false, -1);
        GlStateManager.popMatrix();
    }

    @Override
    public void applyPlayerModel(SpeedBoatEntity entity, PlayerEntity player, PlayerModel model, float partialTicks) {
        model.field_178721_j.field_78795_f = (float)Math.toRadians(-85.0);
        model.field_178721_j.field_78796_g = (float)Math.toRadians(20.0);
        model.field_178722_k.field_78795_f = (float)Math.toRadians(-85.0);
        model.field_178722_k.field_78796_g = (float)Math.toRadians(-20.0);
        float wheelAngle = entity.prevWheelAngle + (entity.wheelAngle - entity.prevWheelAngle) * partialTicks;
        float wheelAngleNormal = wheelAngle / 45.0f;
        float turnRotation = wheelAngleNormal * 6.0f;
        model.field_178723_h.field_78795_f = (float)Math.toRadians(-65.0f - turnRotation);
        model.field_178723_h.field_78796_g = (float)Math.toRadians(-7.0);
        model.field_178724_i.field_78795_f = (float)Math.toRadians(-65.0f + turnRotation);
        model.field_178724_i.field_78796_g = (float)Math.toRadians(7.0);
    }

    @Override
    public void applyPlayerRender(SpeedBoatEntity entity, PlayerEntity player, float partialTicks) {
        int index = entity.getSeatTracker().getSeatIndex(player.func_110124_au());
        if (index != -1) {
            VehicleProperties properties = entity.getProperties();
            Seat seat = properties.getSeats().get(index);
            Vec3d seatVec = seat.getPosition().func_72441_c(0.0, (double)(properties.getAxleOffset() + properties.getWheelOffset()), 0.0).func_186678_a(properties.getBodyPosition().getScale()).func_216372_d(-1.0, 1.0, 1.0).func_186678_a(0.0625);
            double scale = 1.0666666666666667;
            double offsetX = -seatVec.field_72450_a * scale;
            double offsetY = (seatVec.field_72448_b + player.func_70033_W()) * scale + 1.5;
            double offsetZ = seatVec.field_72449_c * scale;
            GlStateManager.translated((double)offsetX, (double)offsetY, (double)offsetZ);
            float currentSpeedNormal = (entity.prevCurrentSpeed + (entity.currentSpeed - entity.prevCurrentSpeed) * partialTicks) / entity.getMaxSpeed();
            float turnAngleNormal = (entity.prevTurnAngle + (entity.turnAngle - entity.prevTurnAngle) * partialTicks) / (float)entity.getMaxTurnAngle();
            GlStateManager.rotatef((float)(turnAngleNormal * currentSpeedNormal * 15.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.rotatef((float)(-8.0f * Math.min(1.0f, currentSpeedNormal)), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.translated((double)(-offsetX), (double)(-offsetY), (double)(-offsetZ));
        }
    }

    @Override
    protected boolean shouldRenderFuelLid() {
        return false;
    }
}

