/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.vehicle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.common.Seat;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.entity.vehicle.MopedEntity;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.util.RenderUtil;
import java.util.Calendar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.model.ChestModel;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;

public class RenderMoped
extends AbstractRenderVehicle<MopedEntity> {
    private static final ResourceLocation TEXTURE_CHRISTMAS = new ResourceLocation("textures/entity/chest/christmas.png");
    private static final ResourceLocation TEXTURE_NORMAL = new ResourceLocation("textures/entity/chest/normal.png");
    private final ChestModel chest = new ChestModel();
    public final boolean isChristmas;

    public RenderMoped() {
        Calendar calendar = Calendar.getInstance();
        this.isChristmas = calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
    }

    @Override
    public void render(MopedEntity entity, float partialTicks) {
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.MOPED_BODY.getModel());
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.0, (double)-0.0625, (double)0.71875);
        GlStateManager.rotatef((float)-22.5f, (float)1.0f, (float)0.0f, (float)0.0f);
        float wheelAngle = entity.prevRenderWheelAngle + (entity.renderWheelAngle - entity.prevRenderWheelAngle) * partialTicks;
        float wheelAngleNormal = wheelAngle / 45.0f;
        float turnRotation = wheelAngleNormal * 25.0f;
        GlStateManager.rotatef((float)(turnRotation / 2.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)22.5f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.translated((double)0.0, (double)0.0, (double)-0.71875);
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.0, (double)0.835, (double)0.525);
        GlStateManager.scalef((float)0.8f, (float)0.8f, (float)0.8f);
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.MOPED_HANDLES.getModel());
        GlStateManager.popMatrix();
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)0.0, (double)-0.12, (double)0.785);
        GlStateManager.rotatef((float)-22.5f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.scalef((float)0.9f, (float)0.9f, (float)0.9f);
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.MOPED_MUD_GUARD.getModel());
        GlStateManager.popMatrix();
        if (entity.hasWheels()) {
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)0.0, (double)-0.4, (double)0.90625);
            float frontWheelSpin = entity.prevFrontWheelRotation + (entity.frontWheelRotation - entity.prevFrontWheelRotation) * partialTicks;
            if (entity.isMoving()) {
                GlStateManager.rotatef((float)(-frontWheelSpin), (float)1.0f, (float)0.0f, (float)0.0f);
            }
            GlStateManager.scalef((float)1.3f, (float)1.3f, (float)1.3f);
            RenderUtil.renderColoredModel(RenderUtil.getModel(new ItemStack((IItemProvider)ModItems.STANDARD_WHEEL.get())), ItemCameraTransforms.TransformType.NONE, false, -1);
            GlStateManager.popMatrix();
        }
        GlStateManager.popMatrix();
        if (entity.hasChest()) {
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)0.0, (double)0.25, (double)-0.65);
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            if (this.isChristmas) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE_CHRISTMAS);
            } else {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE_NORMAL);
            }
            this.chest.func_78231_a();
            GlStateManager.popMatrix();
        }
    }

    @Override
    public void applyPlayerModel(MopedEntity entity, PlayerEntity player, PlayerModel model, float partialTicks) {
        float wheelAngle = entity.prevRenderWheelAngle + (entity.renderWheelAngle - entity.prevRenderWheelAngle) * partialTicks;
        float wheelAngleNormal = wheelAngle / 45.0f;
        float turnRotation = wheelAngleNormal * 6.0f;
        model.field_178723_h.field_78795_f = (float)Math.toRadians(-75.0f - turnRotation);
        model.field_178723_h.field_78796_g = (float)Math.toRadians(7.0);
        model.field_178724_i.field_78795_f = (float)Math.toRadians(-75.0f + turnRotation);
        model.field_178724_i.field_78796_g = (float)Math.toRadians(-7.0);
        model.field_178721_j.field_78795_f = (float)Math.toRadians(-55.0);
        model.field_178722_k.field_78795_f = (float)Math.toRadians(-55.0);
    }

    @Override
    public void applyPlayerRender(MopedEntity entity, PlayerEntity player, float partialTicks) {
        int index = entity.getSeatTracker().getSeatIndex(player.func_110124_au());
        if (index != -1) {
            VehicleProperties properties = entity.getProperties();
            Seat seat = properties.getSeats().get(index);
            Vec3d seatVec = seat.getPosition().func_72441_c(0.0, (double)(properties.getAxleOffset() + properties.getWheelOffset()), 0.0).func_186678_a(properties.getBodyPosition().getScale()).func_216372_d(-1.0, 1.0, 1.0).func_186678_a(0.0625);
            double scale = 1.0666666666666667;
            double offsetX = -seatVec.field_72450_a * scale;
            double offsetY = (seatVec.field_72448_b + player.func_70033_W()) * scale + 1.5;
            double offsetZ = seatVec.field_72449_c * scale;
            GlStateManager.translated((double)offsetX, (double)offsetY, (double)offsetZ);
            float currentSpeedNormal = (entity.prevCurrentSpeed + (entity.currentSpeed - entity.prevCurrentSpeed) * partialTicks) / entity.getMaxSpeed();
            float turnAngleNormal = (entity.prevTurnAngle + (entity.turnAngle - entity.prevTurnAngle) * partialTicks) / 45.0f;
            GlStateManager.rotatef((float)(turnAngleNormal * currentSpeedNormal * 20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.translated((double)(-offsetX), (double)(-offsetY), (double)(-offsetZ));
        }
    }
}

