/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.vehicle;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderTrailer;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.trailer.FluidTrailerEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class RenderFluidTrailer
extends AbstractRenderTrailer<FluidTrailerEntity> {
    @Override
    public void render(FluidTrailerEntity entity, float partialTicks) {
        this.renderDamagedPart((VehicleEntity)entity, SpecialModels.FLUID_TRAILER.getModel());
        this.renderWheel(entity, false, -0.71875f, -0.5f, -0.15625f, 2.0f, partialTicks);
        this.renderWheel(entity, true, 0.71875f, -0.5f, -0.15625f, 2.0f, partialTicks);
        float height = 9.9f * ((float)entity.getTank().getFluidAmount() / (float)entity.getTank().getCapacity()) * 0.0625f;
        this.drawFluid(entity, entity.getTank(), -0.3875f, -0.1875f, -0.99f, 0.7625f, height, 1.67f);
    }

    private void drawFluid(FluidTrailerEntity entity, FluidTank tank, float x, float y, float z, float width, float height, float depth) {
        Fluid fluid = tank.getFluid().getFluid();
        if (fluid == Fluids.field_204541_a) {
            return;
        }
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_195424_a(fluid.getFluid().getAttributes().getStillTexture());
        if (sprite != null) {
            int waterColor = fluid.getAttributes().getColor((IEnviromentBlockReader)entity.func_130014_f_(), entity.func_180425_c());
            float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(waterColor & 0xFF) / 255.0f;
            double minU = sprite.func_94209_e();
            double maxU = Math.min(minU + ((double)sprite.func_94212_f() - minU) * (double)width, (double)sprite.func_94212_f());
            double minV = sprite.func_94206_g();
            double maxV = Math.min(minV + ((double)sprite.func_94210_h() - minV) * (double)height, (double)sprite.func_94210_h());
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            GlStateManager.disableLighting();
            GlStateManager.enableBlend();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b((double)(x + width), (double)y, (double)z).func_187315_a(maxU, minV).func_181666_a(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, (double)z).func_187315_a(minU, minV).func_181666_a(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_181675_d();
            buffer.func_181662_b((double)x, (double)(y + height), (double)z).func_187315_a(minU, maxV).func_181666_a(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_181675_d();
            buffer.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a(maxU, maxV).func_181666_a(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b((double)x, (double)y, (double)(z + depth)).func_187315_a(maxU, minV).func_181666_a(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_181675_d();
            buffer.func_181662_b((double)(x + width), (double)y, (double)(z + depth)).func_187315_a(minU, minV).func_181666_a(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_181675_d();
            buffer.func_181662_b((double)(x + width), (double)(y + height), (double)(z + depth)).func_187315_a(minU, maxV).func_181666_a(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_181675_d();
            buffer.func_181662_b((double)x, (double)(y + height), (double)(z + depth)).func_187315_a(maxU, maxV).func_181666_a(red - 0.25f, green - 0.25f, blue - 0.25f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            maxU = Math.min(minU + ((double)sprite.func_94212_f() - minU) * (double)depth, (double)sprite.func_94212_f());
            maxV = Math.min(minV + ((double)sprite.func_94210_h() - minV) * (double)width, (double)sprite.func_94210_h());
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b((double)x, (double)(y + height), (double)z).func_187315_a(maxU, minV).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b((double)x, (double)(y + height), (double)(z + depth)).func_187315_a(minU, minV).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b((double)(x + width), (double)(y + height), (double)(z + depth)).func_187315_a(minU, maxV).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a(maxU, maxV).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.disableBlend();
            GlStateManager.enableLighting();
        }
    }
}

