/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.tileentity;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.vehicle.block.BlockRotatedObject;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.tileentity.GasPumpTankTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;

public class GasPumpTankRenderer
extends TileEntityRenderer<GasPumpTankTileEntity> {
    public void render(GasPumpTankTileEntity gasPump, double x, double y, double z, float partialTicks, int destroyStage) {
        BlockState state = gasPump.func_145831_w().func_180495_p(gasPump.func_174877_v());
        if (state.func_177230_c() != ModBlocks.GAS_PUMP.get()) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        Direction facing = (Direction)state.func_177229_b((IProperty)BlockRotatedObject.DIRECTION);
        GlStateManager.translated((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.rotatef((float)((float)facing.func_176736_b() * -90.0f - 90.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translated((double)-0.5, (double)-0.5, (double)-0.5);
        float height = 11.0f * ((float)gasPump.getFluidTank().getFluidAmount() / (float)gasPump.getFluidTank().getCapacity());
        if (height > 0.0f) {
            this.drawFluid(gasPump, 0.188125f, 0.1875f, 0.25f, 0.62375f, height * 0.0625f, 0.49875f);
        }
        GlStateManager.popMatrix();
    }

    private void drawFluid(GasPumpTankTileEntity te, float x, float y, float z, float width, float height, float depth) {
        if (te.getFluidTank() == null || te.getFluidTank().getFluid() == null) {
            return;
        }
        ResourceLocation resource = te.getFluidTank().getFluid().getFluid().getAttributes().getStillTexture();
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_195424_a(resource);
        if (sprite != null) {
            double minU = sprite.func_94209_e();
            double maxU = Math.min(minU + ((double)sprite.func_94212_f() - minU) * (double)depth, (double)sprite.func_94212_f());
            double minV = sprite.func_94206_g();
            double maxV = Math.min(minV + ((double)sprite.func_94210_h() - minV) * (double)height, (double)sprite.func_94210_h());
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            int light = this.func_178459_a().func_217338_b(te.func_174877_v(), te.getFluidTank().getFluid().getFluid().getAttributes().getLuminosity());
            int lightX = light >> 16 & 0xFFFF;
            int lightY = light & 0xFFFF;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
            buffer.func_181662_b((double)(x + width), (double)y, (double)(z + depth)).func_187315_a(maxU, minV).func_187314_a(lightX, lightY).func_181666_a(0.85f, 0.85f, 0.85f, 1.0f).func_181675_d();
            buffer.func_181662_b((double)(x + width), (double)y, (double)z).func_187315_a(minU, minV).func_187314_a(lightX, lightY).func_181666_a(0.85f, 0.85f, 0.85f, 1.0f).func_181675_d();
            buffer.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a(minU, maxV).func_187314_a(lightX, lightY).func_181666_a(0.85f, 0.85f, 0.85f, 1.0f).func_181675_d();
            buffer.func_181662_b((double)(x + width), (double)(y + height), (double)(z + depth)).func_187315_a(maxU, maxV).func_187314_a(lightX, lightY).func_181666_a(0.85f, 0.85f, 0.85f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
            buffer.func_181662_b((double)x, (double)y, (double)(z + depth)).func_187315_a(maxU, minV).func_187314_a(lightX, lightY).func_181666_a(0.85f, 0.85f, 0.85f, 1.0f).func_181675_d();
            buffer.func_181662_b((double)x, (double)y, (double)z).func_187315_a(minU, minV).func_187314_a(lightX, lightY).func_181666_a(0.85f, 0.85f, 0.85f, 1.0f).func_181675_d();
            buffer.func_181662_b((double)x, (double)(y + height), (double)z).func_187315_a(minU, maxV).func_187314_a(lightX, lightY).func_181666_a(0.85f, 0.85f, 0.85f, 1.0f).func_181675_d();
            buffer.func_181662_b((double)x, (double)(y + height), (double)(z + depth)).func_187315_a(maxU, maxV).func_187314_a(lightX, lightY).func_181666_a(0.85f, 0.85f, 0.85f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            maxV = Math.min(minV + ((double)sprite.func_94210_h() - minV) * (double)width, (double)sprite.func_94210_h());
            buffer.func_181668_a(7, DefaultVertexFormats.field_181711_k);
            buffer.func_181662_b((double)x, (double)(y + height), (double)z).func_187315_a(maxU, minV).func_187314_a(lightX, lightY).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            buffer.func_181662_b((double)x, (double)(y + height), (double)(z + depth)).func_187315_a(minU, minV).func_187314_a(lightX, lightY).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            buffer.func_181662_b((double)(x + width), (double)(y + height), (double)(z + depth)).func_187315_a(minU, maxV).func_187314_a(lightX, lightY).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            buffer.func_181662_b((double)(x + width), (double)(y + height), (double)z).func_187315_a(maxU, maxV).func_187314_a(lightX, lightY).func_181666_a(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
        }
    }
}

