/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render.tileentity;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.vehicle.tileentity.FuelDrumTileEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FuelDrumRenderer
extends TileEntityRenderer<FuelDrumTileEntity> {
    public void render(FuelDrumTileEntity tileEntityIn, double x, double y, double z, float partialTicks, int destroyStage) {
        BlockRayTraceResult result;
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        if (Minecraft.func_71410_x().field_71439_g.func_70093_af() && tileEntityIn.hasFluid() && this.field_147501_a.field_190057_j != null && this.field_147501_a.field_190057_j.func_216346_c() == RayTraceResult.Type.BLOCK && (result = (BlockRayTraceResult)this.field_147501_a.field_190057_j).func_216350_a().equals((Object)tileEntityIn.func_174877_v())) {
            this.drawFluidLabel(tileEntityIn, this.field_147501_a.field_147557_n, tileEntityIn.getFluidTank());
        }
        GlStateManager.popMatrix();
    }

    private void drawFluidLabel(FuelDrumTileEntity te, FontRenderer fontRendererIn, FluidTank tank) {
        if (tank.getFluid().isEmpty()) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.enableDepthTest();
        GlStateManager.translated((double)0.5, (double)1.25, (double)0.5);
        GlStateManager.rotatef((float)(-Minecraft.func_71410_x().field_71439_g.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)Minecraft.func_71410_x().field_71439_g.field_70125_A, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.scalef((float)-0.025f, (float)-0.025f, (float)0.025f);
        float level = (float)tank.getFluidAmount() / (float)tank.getCapacity();
        double width = 30.0;
        double fuelWidth = width * (double)level;
        double remainingWidth = width - fuelWidth;
        double offsetWidth = width / 2.0;
        FluidStack stack = tank.getFluid();
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_195424_a(stack.getFluid().getAttributes().getStillTexture());
        if (sprite != null) {
            int waterColor = stack.getFluid().getAttributes().getColor((IEnviromentBlockReader)te.func_145831_w(), te.func_174877_v());
            float red = (float)(waterColor >> 16 & 0xFF) / 255.0f;
            float green = (float)(waterColor >> 8 & 0xFF) / 255.0f;
            float blue = (float)(waterColor & 0xFF) / 255.0f;
            float minU = sprite.func_94209_e();
            float maxU = sprite.func_94212_f();
            float minV = sprite.func_94206_g();
            float maxV = sprite.func_94210_h();
            float deltaV = maxV - minV;
            maxV = minV + deltaV * 4.0f * 0.0625f;
            float deltaU = maxU - minU;
            maxU = minU + deltaU * level;
            GlStateManager.disableLighting();
            GlStateManager.disableTexture();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b(-offsetWidth - 1.0, -2.0, -0.01).func_181666_a(0.5f, 0.5f, 0.5f, 1.0f).func_181675_d();
            buffer.func_181662_b(-offsetWidth - 1.0, 5.0, -0.01).func_181666_a(0.5f, 0.5f, 0.5f, 1.0f).func_181675_d();
            buffer.func_181662_b(-offsetWidth + width + 1.0, 5.0, -0.01).func_181666_a(0.5f, 0.5f, 0.5f, 1.0f).func_181675_d();
            buffer.func_181662_b(-offsetWidth + width + 1.0, -2.0, -0.01).func_181666_a(0.5f, 0.5f, 0.5f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.enableTexture();
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            GlStateManager.translated((double)0.0, (double)0.0, (double)-0.05);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buffer.func_181662_b(-offsetWidth, -1.0, 0.0).func_187315_a((double)minU, (double)maxV).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(-offsetWidth, 4.0, 0.0).func_187315_a((double)minU, (double)minV).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(-offsetWidth + fuelWidth, 4.0, 0.0).func_187315_a((double)maxU, (double)minV).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            buffer.func_181662_b(-offsetWidth + fuelWidth, -1.0, 0.0).func_187315_a((double)maxU, (double)maxV).func_181666_a(red, green, blue, 1.0f).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.disableTexture();
            buffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b(-offsetWidth + fuelWidth, -1.0, 0.0).func_181666_a(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
            buffer.func_181662_b(-offsetWidth + fuelWidth, 4.0, 0.0).func_181666_a(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
            buffer.func_181662_b(-offsetWidth + fuelWidth + remainingWidth, 4.0, 0.0).func_181666_a(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
            buffer.func_181662_b(-offsetWidth + fuelWidth + remainingWidth, -1.0, 0.0).func_181666_a(0.4f, 0.4f, 0.4f, 1.0f).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.enableTexture();
        GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
        String name = stack.getDisplayName().func_150254_d();
        int nameWidth = fontRendererIn.func_78256_a(name) / 2;
        fontRendererIn.func_211126_b(name, (float)(-nameWidth), -14.0f, -1);
        GlStateManager.enableLighting();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.enableDepthTest();
        GlStateManager.popMatrix();
    }
}

