/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.client.render.RenderVehicleWrapper;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.entity.PlaneEntity;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.math.RayTraceResult;

public class RenderPlaneWrapper<T extends PlaneEntity, R extends AbstractRenderVehicle<T>>
extends RenderVehicleWrapper<T, R> {
    public RenderPlaneWrapper(R renderVehicle) {
        super(renderVehicle);
    }

    @Override
    public void render(T entity, float partialTicks) {
        if (!entity.func_70089_S()) {
            return;
        }
        GlStateManager.pushMatrix();
        VehicleProperties properties = ((VehicleEntity)((Object)entity)).getProperties();
        PartPosition bodyPosition = properties.getBodyPosition();
        GlStateManager.rotated((double)bodyPosition.getRotX(), (double)1.0, (double)0.0, (double)0.0);
        GlStateManager.rotated((double)bodyPosition.getRotY(), (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.rotated((double)bodyPosition.getRotZ(), (double)0.0, (double)0.0, (double)1.0);
        GlStateManager.translated((double)0.0, (double)0.5, (double)0.0);
        float bodyPitch = ((PlaneEntity)((Object)entity)).prevBodyRotationX + (((PlaneEntity)((Object)entity)).bodyRotationX - ((PlaneEntity)((Object)entity)).prevBodyRotationX) * partialTicks;
        GlStateManager.rotatef((float)(-bodyPitch), (float)1.0f, (float)0.0f, (float)0.0f);
        float bodyRoll = ((PlaneEntity)((Object)entity)).prevBodyRotationZ + (((PlaneEntity)((Object)entity)).bodyRotationZ - ((PlaneEntity)((Object)entity)).prevBodyRotationZ) * partialTicks;
        GlStateManager.rotatef((float)(-bodyRoll), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.translated((double)0.0, (double)-0.5, (double)0.0);
        GlStateManager.translated((double)bodyPosition.getX(), (double)bodyPosition.getY(), (double)bodyPosition.getZ());
        GlStateManager.scalef((float)((float)bodyPosition.getScale()), (float)((float)bodyPosition.getScale()), (float)((float)bodyPosition.getScale()));
        GlStateManager.translated((double)0.0, (double)0.5, (double)0.0);
        GlStateManager.translated((double)0.0, (double)((double)properties.getAxleOffset() * 0.0625), (double)0.0);
        GlStateManager.translated((double)0.0, (double)((double)properties.getWheelOffset() * 0.0625), (double)0.0);
        this.renderVehicle.render(entity, partialTicks);
        if (((PoweredVehicleEntity)((Object)entity)).shouldRenderEngine() && ((PoweredVehicleEntity)((Object)entity)).hasEngine()) {
            IBakedModel engineModel = RenderUtil.getEngineModel(entity);
            this.renderEngine((PoweredVehicleEntity)((Object)entity), properties.getEnginePosition(), engineModel);
        }
        if (((PoweredVehicleEntity)((Object)entity)).shouldRenderFuelPort() && ((PoweredVehicleEntity)((Object)entity)).requiresFuel()) {
            PoweredVehicleEntity.FuelPortType fuelPortType = ((PoweredVehicleEntity)((Object)entity)).getFuelPortType();
            EntityRaytracer.RayTraceResultRotated result = EntityRaytracer.getContinuousInteraction();
            if (result != null && result.func_216346_c() == RayTraceResult.Type.ENTITY && result.func_216348_a() == entity && result.equalsContinuousInteraction(EntityRaytracer.FUNCTION_FUELING)) {
                this.renderPart(properties.getFuelPortPosition(), fuelPortType.getOpenModel().getModel(), ((VehicleEntity)((Object)entity)).getColor());
                if (this.renderVehicle.shouldRenderFuelLid()) {
                    // empty if block
                }
                ((PoweredVehicleEntity)((Object)entity)).playFuelPortOpenSound();
            } else {
                this.renderPart(properties.getFuelPortPosition(), fuelPortType.getClosedModel().getModel(), ((VehicleEntity)((Object)entity)).getColor());
                ((PoweredVehicleEntity)((Object)entity)).playFuelPortCloseSound();
            }
        }
        if (((PoweredVehicleEntity)((Object)entity)).isKeyNeeded()) {
            this.renderPart(properties.getKeyPortPosition(), this.renderVehicle.getKeyHoleModel().getModel(), ((VehicleEntity)((Object)entity)).getColor());
            if (!((PoweredVehicleEntity)((Object)entity)).getKeyStack().func_190926_b()) {
                this.renderKey(properties.getKeyPosition(), RenderUtil.getModel(((PoweredVehicleEntity)((Object)entity)).getKeyStack()), ((PoweredVehicleEntity)((Object)entity)).getKeyStack());
            }
        }
        GlStateManager.popMatrix();
    }
}

