/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.client.render.RenderLandVehicleWrapper;
import com.mrcrayfish.vehicle.client.render.Wheel;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.entity.LandVehicleEntity;
import com.mrcrayfish.vehicle.entity.MotorcycleEntity;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.util.math.RayTraceResult;

public class RenderMotorcycleWrapper<T extends MotorcycleEntity, R extends AbstractRenderVehicle<T>>
extends RenderLandVehicleWrapper<T, R> {
    public RenderMotorcycleWrapper(R renderVehicle) {
        super(renderVehicle);
    }

    @Override
    public void render(T entity, float partialTicks) {
        if (!entity.func_70089_S()) {
            return;
        }
        GlStateManager.pushMatrix();
        VehicleProperties properties = ((VehicleEntity)((Object)entity)).getProperties();
        PartPosition bodyPosition = properties.getBodyPosition();
        GlStateManager.rotated((double)bodyPosition.getRotX(), (double)1.0, (double)0.0, (double)0.0);
        GlStateManager.rotated((double)bodyPosition.getRotY(), (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.rotated((double)bodyPosition.getRotZ(), (double)0.0, (double)0.0, (double)1.0);
        float additionalYaw = ((MotorcycleEntity)((Object)entity)).prevAdditionalYaw + (((MotorcycleEntity)((Object)entity)).additionalYaw - ((MotorcycleEntity)((Object)entity)).prevAdditionalYaw) * partialTicks;
        GlStateManager.rotatef((float)additionalYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        float currentSpeedNormal = (((MotorcycleEntity)((Object)entity)).prevCurrentSpeed + (((MotorcycleEntity)((Object)entity)).currentSpeed - ((MotorcycleEntity)((Object)entity)).prevCurrentSpeed) * partialTicks) / ((PoweredVehicleEntity)((Object)entity)).getMaxSpeed();
        float turnAngleNormal = (((MotorcycleEntity)((Object)entity)).prevTurnAngle + (((MotorcycleEntity)((Object)entity)).turnAngle - ((MotorcycleEntity)((Object)entity)).prevTurnAngle) * partialTicks) / 45.0f;
        GlStateManager.rotatef((float)(turnAngleNormal * currentSpeedNormal * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.translated((double)bodyPosition.getX(), (double)bodyPosition.getY(), (double)bodyPosition.getZ());
        GlStateManager.scalef((float)((float)bodyPosition.getScale()), (float)((float)bodyPosition.getScale()), (float)((float)bodyPosition.getScale()));
        GlStateManager.translated((double)0.0, (double)0.5, (double)0.0);
        GlStateManager.translated((double)0.0, (double)((double)properties.getAxleOffset() * 0.0625), (double)0.0);
        GlStateManager.translated((double)0.0, (double)((double)properties.getWheelOffset() * 0.0625), (double)0.0);
        this.renderVehicle.render(entity, partialTicks);
        if (((PoweredVehicleEntity)((Object)entity)).hasWheels()) {
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)0.0, (double)-0.5, (double)0.0);
            GlStateManager.translated((double)0.0, (double)(-properties.getAxleOffset() * 0.0625f), (double)0.0);
            IBakedModel wheelModel = RenderUtil.getWheelModel(entity);
            properties.getWheels().forEach(wheel -> this.renderWheel((LandVehicleEntity)((Object)entity), (Wheel)wheel, wheelModel, partialTicks));
            GlStateManager.popMatrix();
        }
        if (((PoweredVehicleEntity)((Object)entity)).shouldRenderEngine() && ((PoweredVehicleEntity)((Object)entity)).hasEngine()) {
            IBakedModel engineModel = RenderUtil.getEngineModel(entity);
            this.renderEngine((PoweredVehicleEntity)((Object)entity), properties.getEnginePosition(), engineModel);
        }
        if (((PoweredVehicleEntity)((Object)entity)).shouldRenderFuelPort() && ((PoweredVehicleEntity)((Object)entity)).requiresFuel()) {
            PoweredVehicleEntity.FuelPortType fuelPortType = ((PoweredVehicleEntity)((Object)entity)).getFuelPortType();
            EntityRaytracer.RayTraceResultRotated result = EntityRaytracer.getContinuousInteraction();
            if (result != null && result.func_216346_c() == RayTraceResult.Type.ENTITY && result.func_216348_a() == entity && result.equalsContinuousInteraction(EntityRaytracer.FUNCTION_FUELING)) {
                this.renderPart(properties.getFuelPortPosition(), fuelPortType.getOpenModel().getModel(), ((VehicleEntity)((Object)entity)).getColor());
                if (this.renderVehicle.shouldRenderFuelLid()) {
                    // empty if block
                }
                ((PoweredVehicleEntity)((Object)entity)).playFuelPortOpenSound();
            } else {
                this.renderPart(properties.getFuelPortPosition(), fuelPortType.getClosedModel().getModel(), ((VehicleEntity)((Object)entity)).getColor());
                ((PoweredVehicleEntity)((Object)entity)).playFuelPortCloseSound();
            }
        }
        if (((PoweredVehicleEntity)((Object)entity)).isKeyNeeded()) {
            this.renderPart(properties.getKeyPortPosition(), this.renderVehicle.getKeyHoleModel().getModel(), ((VehicleEntity)((Object)entity)).getColor());
            if (!((PoweredVehicleEntity)((Object)entity)).getKeyStack().func_190926_b()) {
                this.renderKey(properties.getKeyPosition(), RenderUtil.getModel(((PoweredVehicleEntity)((Object)entity)).getKeyStack()), ((PoweredVehicleEntity)((Object)entity)).getKeyStack());
            }
        }
        GlStateManager.popMatrix();
    }
}

