/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.client.render.RenderVehicleWrapper;
import com.mrcrayfish.vehicle.client.render.Wheel;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.entity.LandVehicleEntity;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.util.RenderUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;

public class RenderLandVehicleWrapper<T extends LandVehicleEntity, R extends AbstractRenderVehicle<T>>
extends RenderVehicleWrapper<T, R> {
    public RenderLandVehicleWrapper(R renderVehicle) {
        super(renderVehicle);
    }

    @Override
    public void render(T entity, float partialTicks) {
        if (!entity.func_70089_S()) {
            return;
        }
        GlStateManager.pushMatrix();
        VehicleProperties properties = ((VehicleEntity)((Object)entity)).getProperties();
        PartPosition bodyPosition = properties.getBodyPosition();
        GlStateManager.rotated((double)bodyPosition.getRotX(), (double)1.0, (double)0.0, (double)0.0);
        GlStateManager.rotated((double)bodyPosition.getRotY(), (double)0.0, (double)1.0, (double)0.0);
        GlStateManager.rotated((double)bodyPosition.getRotZ(), (double)0.0, (double)0.0, (double)1.0);
        float additionalYaw = ((LandVehicleEntity)((Object)entity)).prevAdditionalYaw + (((LandVehicleEntity)((Object)entity)).additionalYaw - ((LandVehicleEntity)((Object)entity)).prevAdditionalYaw) * partialTicks;
        GlStateManager.rotatef((float)additionalYaw, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.translated((double)bodyPosition.getX(), (double)bodyPosition.getY(), (double)bodyPosition.getZ());
        if (((VehicleEntity)((Object)entity)).canTowTrailer()) {
            GlStateManager.pushMatrix();
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            Vec3d towBarOffset = properties.getTowBarPosition();
            GlStateManager.translated((double)(towBarOffset.field_72450_a * 0.0625), (double)(towBarOffset.field_72448_b * 0.0625 + 0.5), (double)(-towBarOffset.field_72449_c * 0.0625));
            RenderUtil.renderColoredModel(this.renderVehicle.getTowBarModel().getModel(), ItemCameraTransforms.TransformType.NONE, false, -1);
            GlStateManager.popMatrix();
        }
        GlStateManager.scalef((float)((float)bodyPosition.getScale()), (float)((float)bodyPosition.getScale()), (float)((float)bodyPosition.getScale()));
        GlStateManager.translated((double)0.0, (double)0.5, (double)0.0);
        GlStateManager.translated((double)0.0, (double)((double)properties.getAxleOffset() * 0.0625), (double)0.0);
        GlStateManager.translated((double)0.0, (double)((double)properties.getWheelOffset() * 0.0625), (double)0.0);
        this.renderVehicle.render(entity, partialTicks);
        if (((PoweredVehicleEntity)((Object)entity)).hasWheels()) {
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)0.0, (double)-0.5, (double)0.0);
            GlStateManager.translated((double)0.0, (double)(-properties.getAxleOffset() * 0.0625f), (double)0.0);
            IBakedModel wheelModel = RenderUtil.getWheelModel(entity);
            properties.getWheels().forEach(wheel -> this.renderWheel((LandVehicleEntity)((Object)entity), (Wheel)wheel, wheelModel, partialTicks));
            GlStateManager.popMatrix();
        }
        if (((PoweredVehicleEntity)((Object)entity)).shouldRenderEngine() && ((PoweredVehicleEntity)((Object)entity)).hasEngine()) {
            IBakedModel engineModel = RenderUtil.getEngineModel(entity);
            this.renderEngine((PoweredVehicleEntity)((Object)entity), properties.getEnginePosition(), engineModel);
        }
        if (((PoweredVehicleEntity)((Object)entity)).shouldRenderFuelPort() && ((PoweredVehicleEntity)((Object)entity)).requiresFuel()) {
            PoweredVehicleEntity.FuelPortType fuelPortType = ((PoweredVehicleEntity)((Object)entity)).getFuelPortType();
            EntityRaytracer.RayTraceResultRotated result = EntityRaytracer.getContinuousInteraction();
            if (result != null && result.func_216346_c() == RayTraceResult.Type.ENTITY && result.func_216348_a() == entity && result.equalsContinuousInteraction(EntityRaytracer.FUNCTION_FUELING)) {
                this.renderPart(properties.getFuelPortPosition(), fuelPortType.getOpenModel().getModel(), ((VehicleEntity)((Object)entity)).getColor());
                if (this.renderVehicle.shouldRenderFuelLid()) {
                    // empty if block
                }
                ((PoweredVehicleEntity)((Object)entity)).playFuelPortOpenSound();
            } else {
                this.renderPart(properties.getFuelPortPosition(), fuelPortType.getClosedModel().getModel(), ((VehicleEntity)((Object)entity)).getColor());
                ((PoweredVehicleEntity)((Object)entity)).playFuelPortCloseSound();
            }
        }
        if (((PoweredVehicleEntity)((Object)entity)).isKeyNeeded()) {
            this.renderPart(properties.getKeyPortPosition(), this.renderVehicle.getKeyHoleModel().getModel(), ((VehicleEntity)((Object)entity)).getColor());
            if (!((PoweredVehicleEntity)((Object)entity)).getKeyStack().func_190926_b()) {
                this.renderKey(properties.getKeyPosition(), RenderUtil.getModel(((PoweredVehicleEntity)((Object)entity)).getKeyStack()), ((PoweredVehicleEntity)((Object)entity)).getKeyStack());
            }
        }
        this.renderSteeringDebug(properties, (LandVehicleEntity)((Object)entity));
        GlStateManager.popMatrix();
    }

    private void renderSteeringDebug(VehicleProperties properties, LandVehicleEntity entity) {
        if (((Boolean)Config.CLIENT.renderSteeringDebug.get()).booleanValue() && properties.getFrontAxelVec() != null && properties.getRearAxelVec() != null) {
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)0.0, (double)-0.5, (double)0.0);
            GlStateManager.translated((double)0.0, (double)((double)(-properties.getAxleOffset()) * 0.0625), (double)0.0);
            GlStateManager.translated((double)0.0, (double)((double)(-properties.getWheelOffset()) * 0.0625), (double)0.0);
            GlStateManager.pushMatrix();
            Vec3d frontAxelVec = properties.getFrontAxelVec();
            frontAxelVec = frontAxelVec.func_186678_a(0.0625);
            GlStateManager.translated((double)frontAxelVec.field_72450_a, (double)0.0, (double)frontAxelVec.field_72449_c);
            this.renderSteeringLine(0xFFFFFF);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            frontAxelVec = properties.getFrontAxelVec();
            frontAxelVec = frontAxelVec.func_186678_a(0.0625);
            Vec3d nextFrontAxelVec = new Vec3d(0.0, 0.0, (double)(entity.getSpeed() / 20.0f)).func_178785_b(entity.renderWheelAngle * ((float)Math.PI / 180));
            frontAxelVec = frontAxelVec.func_178787_e(nextFrontAxelVec);
            GlStateManager.translated((double)frontAxelVec.field_72450_a, (double)0.0, (double)frontAxelVec.field_72449_c);
            this.renderSteeringLine(0xFFDD00);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            Vec3d rearAxelVec = properties.getRearAxelVec();
            rearAxelVec = rearAxelVec.func_186678_a(0.0625);
            GlStateManager.translated((double)rearAxelVec.field_72450_a, (double)0.0, (double)rearAxelVec.field_72449_c);
            this.renderSteeringLine(0xFFFFFF);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            frontAxelVec = properties.getFrontAxelVec();
            frontAxelVec = frontAxelVec.func_186678_a(0.0625);
            nextFrontAxelVec = new Vec3d(0.0, 0.0, (double)(entity.getSpeed() / 20.0f)).func_178785_b(entity.renderWheelAngle * ((float)Math.PI / 180));
            frontAxelVec = frontAxelVec.func_178787_e(nextFrontAxelVec);
            Vec3d rearAxelVec2 = properties.getRearAxelVec();
            rearAxelVec2 = rearAxelVec2.func_186678_a(0.0625);
            double deltaYaw = Math.toDegrees(Math.atan2(rearAxelVec2.field_72449_c - frontAxelVec.field_72449_c, rearAxelVec2.field_72450_a - frontAxelVec.field_72450_a)) + 90.0;
            if (entity.isRearWheelSteering()) {
                deltaYaw += 180.0;
            }
            rearAxelVec2 = rearAxelVec2.func_178787_e(Vec3d.func_189986_a((float)0.0f, (float)((float)deltaYaw)).func_186678_a((double)(entity.getSpeed() / 20.0f)));
            GlStateManager.translated((double)rearAxelVec2.field_72450_a, (double)0.0, (double)rearAxelVec2.field_72449_c);
            this.renderSteeringLine(0xFFDD00);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            Vec3d nextFrontAxelVec2 = new Vec3d(0.0, 0.0, (double)(entity.getSpeed() / 20.0f)).func_178785_b(entity.wheelAngle * ((float)Math.PI / 180));
            nextFrontAxelVec2 = nextFrontAxelVec2.func_178787_e(properties.getFrontAxelVec().func_186678_a(0.0625));
            Vec3d nextRearAxelVec = new Vec3d(0.0, 0.0, (double)(entity.getSpeed() / 20.0f));
            nextRearAxelVec = nextRearAxelVec.func_178787_e(properties.getRearAxelVec().func_186678_a(0.0625));
            Vec3d nextVehicleVec = nextFrontAxelVec2.func_178787_e(nextRearAxelVec).func_186678_a(0.5);
            nextVehicleVec = nextVehicleVec.func_178788_d(properties.getFrontAxelVec().func_178787_e(properties.getRearAxelVec()).func_186678_a(0.0625).func_186678_a(0.5));
            GlStateManager.pushMatrix();
            this.renderSteeringLine(0xFFFFFF);
            GlStateManager.popMatrix();
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)nextVehicleVec.field_72450_a, (double)0.0, (double)nextVehicleVec.field_72449_c);
            this.renderSteeringLine(0xFFDD00);
            GlStateManager.popMatrix();
            GlStateManager.popMatrix();
            GlStateManager.popMatrix();
        }
    }

    private void renderSteeringLine(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GlStateManager.disableTexture();
        GlStateManager.lineWidth((float)Math.max(2.0f, (float)Minecraft.func_71410_x().field_195558_d.func_198109_k() / 1920.0f * 2.0f));
        GlStateManager.disableLighting();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        buffer.func_181662_b(0.0, 0.0, 0.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        buffer.func_181662_b(0.0, 2.0, 0.0).func_181666_a(red, green, blue, 1.0f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.enableLighting();
        GlStateManager.enableTexture();
    }

    protected void renderWheel(LandVehicleEntity vehicle, Wheel wheel, IBakedModel model, float partialTicks) {
        if (!wheel.shouldRender()) {
            return;
        }
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)((double)wheel.getOffsetX() * 0.0625 * (double)wheel.getSide().offset), (double)((double)wheel.getOffsetY() * 0.0625), (double)((double)wheel.getOffsetZ() * 0.0625));
        if (wheel.getPosition() == Wheel.Position.FRONT) {
            float wheelAngle = vehicle.prevRenderWheelAngle + (vehicle.renderWheelAngle - vehicle.prevRenderWheelAngle) * partialTicks;
            GlStateManager.rotatef((float)wheelAngle, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        if (vehicle.isMoving()) {
            GlStateManager.rotatef((float)(-wheel.getWheelRotation(vehicle, partialTicks)), (float)1.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.translated((double)((double)(wheel.getWidth() * wheel.getScaleX() / 2.0f) * 0.0625 * (double)wheel.getSide().offset), (double)0.0, (double)0.0);
        GlStateManager.scalef((float)wheel.getScaleX(), (float)wheel.getScaleY(), (float)wheel.getScaleZ());
        if (wheel.getSide() == Wheel.Side.RIGHT) {
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        RenderUtil.renderColoredModel(model, ItemCameraTransforms.TransformType.NONE, false, vehicle.getWheelColor());
        GlStateManager.popMatrix();
    }
}

