/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.client.ControllerEvents;
import com.mrcrayfish.vehicle.client.ISpecialModel;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.common.entity.PartPosition;
import com.mrcrayfish.vehicle.common.entity.SyncedPlayerData;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.init.ModEntities;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.item.JerryCanItem;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageFuelVehicle;
import com.mrcrayfish.vehicle.network.message.MessageInteractKey;
import com.mrcrayfish.vehicle.network.message.MessagePickupVehicle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="vehicle", value={Dist.CLIENT})
public class EntityRaytracer {
    private static boolean initialized;
    private static final Map<EntityType<? extends IEntityRaytraceable>, Map<RayTracePart, TriangleRayTraceList>> entityRaytraceTrianglesStatic;
    private static final Map<EntityType<? extends IEntityRaytraceable>, Map<RayTracePart, TriangleRayTraceList>> entityRaytraceTrianglesDynamic;
    private static final Map<EntityType<? extends IEntityRaytraceable>, Map<RayTracePart, TriangleRayTraceList>> entityRaytraceTriangles;
    private static final Map<EntityType<? extends IEntityRaytraceable>, Pair<Float, Float>> entityCrateScalesAndOffsets;
    private static final Pair<Float, Float> SCALE_AND_OFFSET_DEFAULT;
    public static final String PART_NAME = "nameRaytrace";
    private static RayTraceResultRotated continuousInteraction;
    private static Object continuousInteractionObject;
    private static int continuousInteractionTickCounter;
    public static final Function<RayTraceResultRotated, Hand> FUNCTION_FUELING;

    public static void clearDataForReregistration() {
        entityRaytraceTrianglesStatic.clear();
        entityRaytraceTrianglesDynamic.clear();
        entityRaytraceTriangles.clear();
        entityCrateScalesAndOffsets.clear();
        initialized = false;
    }

    @Nullable
    public static RayTraceResultRotated getContinuousInteraction() {
        return continuousInteraction;
    }

    @Nullable
    public static Object getContinuousInteractionObject() {
        return continuousInteractionObject;
    }

    private static void registerEntitiesStatic() {
        ArrayList<MatrixTransformation> aluminumBoatTransformGlobal = new ArrayList<MatrixTransformation>();
        EntityRaytracer.createBodyTransforms(aluminumBoatTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.ALUMINUM_BOAT.get()));
        HashMap aluminumBoatParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.ALUMINUM_BOAT_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)aluminumBoatParts, aluminumBoatTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createFuelablePartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.ALUMINUM_BOAT.get()), SpecialModels.FUEL_DOOR_CLOSED, aluminumBoatParts, aluminumBoatTransformGlobal);
        EntityRaytracer.registerEntityStatic((EntityType)ModEntities.ALUMINUM_BOAT.get(), aluminumBoatParts);
        ArrayList atvTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(atvTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.ATV.get()));
        HashMap atvParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.ATV_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)atvParts, (List<MatrixTransformation>)atvTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.ATV_HANDLES, (HashMap<RayTracePart, List<MatrixTransformation>>)atvParts, (List<MatrixTransformation>)atvTransformGlobal, MatrixTransformation.createTranslation(0.0, 0.3375f, 0.25), MatrixTransformation.createRotation(-45.0, 1.0, 0.0, 0.0), MatrixTransformation.createTranslation(0.0, -0.025f, 0.0));
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.TOW_BAR, (HashMap<RayTracePart, List<MatrixTransformation>>)atvParts, MatrixTransformation.createRotation(180.0, 0.0, 1.0, 0.0), MatrixTransformation.createTranslation(0.0, 0.5, 1.05f));
        EntityRaytracer.createFuelablePartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.ATV.get()), SpecialModels.SMALL_FUEL_DOOR_CLOSED, atvParts, atvTransformGlobal);
        EntityRaytracer.createKeyPortTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.ATV.get()), atvParts, atvTransformGlobal);
        EntityRaytracer.registerEntityStatic((EntityType)ModEntities.ATV.get(), atvParts);
        ArrayList bumperCarTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(bumperCarTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.BUMPER_CAR.get()));
        HashMap bumperCarParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.BUMPER_CAR_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)bumperCarParts, (List<MatrixTransformation>)bumperCarTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<RayTracePart, List<MatrixTransformation>>)bumperCarParts, (List<MatrixTransformation>)bumperCarTransformGlobal, MatrixTransformation.createTranslation(0.0, 0.2f, 0.0), MatrixTransformation.createRotation(-45.0, 1.0, 0.0, 0.0), MatrixTransformation.createTranslation(0.0, -0.02f, 0.0), MatrixTransformation.createScale(0.9f));
        EntityRaytracer.createFuelablePartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.BUMPER_CAR.get()), SpecialModels.FUEL_DOOR_CLOSED, bumperCarParts, bumperCarTransformGlobal);
        EntityRaytracer.registerEntityStatic((EntityType)ModEntities.BUMPER_CAR.get(), bumperCarParts);
        ArrayList duneBuggyTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(duneBuggyTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.DUNE_BUGGY.get()));
        HashMap duneBuggyParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.DUNE_BUGGY_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)duneBuggyParts, (List<MatrixTransformation>)duneBuggyTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.DUNE_BUGGY_HANDLES, (HashMap<RayTracePart, List<MatrixTransformation>>)duneBuggyParts, (List<MatrixTransformation>)duneBuggyTransformGlobal, MatrixTransformation.createTranslation(0.0, 0.0, -0.0046875f));
        EntityRaytracer.createFuelablePartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.DUNE_BUGGY.get()), SpecialModels.FUEL_DOOR_CLOSED, duneBuggyParts, duneBuggyTransformGlobal);
        EntityRaytracer.registerEntityStatic((EntityType)ModEntities.DUNE_BUGGY.get(), duneBuggyParts);
        ArrayList goKartTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(goKartTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.GO_KART.get()));
        HashMap goKartParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.GO_KART_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)goKartParts, (List<MatrixTransformation>)goKartTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<RayTracePart, List<MatrixTransformation>>)goKartParts, (List<MatrixTransformation>)goKartTransformGlobal, MatrixTransformation.createTranslation(0.0, 0.09f, 0.49f), MatrixTransformation.createRotation(-45.0, 1.0, 0.0, 0.0), MatrixTransformation.createTranslation(0.0, -0.02f, 0.0), MatrixTransformation.createScale(0.9f));
        EntityRaytracer.createPartTransforms((Item)ModItems.WOOD_SMALL_ENGINE.get(), VehicleProperties.getProperties((EntityType)ModEntities.GO_KART.get()).getEnginePosition(), (HashMap<RayTracePart, List<MatrixTransformation>>)goKartParts, (List<MatrixTransformation>)goKartTransformGlobal, FUNCTION_FUELING);
        EntityRaytracer.registerEntityStatic((EntityType)ModEntities.GO_KART.get(), goKartParts);
        ArrayList jetSkiTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(jetSkiTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.JET_SKI.get()));
        HashMap jetSkiParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.JET_SKI_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)jetSkiParts, (List<MatrixTransformation>)jetSkiTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.ATV_HANDLES, (HashMap<RayTracePart, List<MatrixTransformation>>)jetSkiParts, (List<MatrixTransformation>)jetSkiTransformGlobal, MatrixTransformation.createTranslation(0.0, 0.375, 0.25), MatrixTransformation.createRotation(-45.0, 1.0, 0.0, 0.0), MatrixTransformation.createTranslation(0.0, 0.02f, 0.0));
        EntityRaytracer.createFuelablePartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.JET_SKI.get()), SpecialModels.SMALL_FUEL_DOOR_CLOSED, jetSkiParts, jetSkiTransformGlobal);
        EntityRaytracer.registerEntityStatic((EntityType)ModEntities.JET_SKI.get(), jetSkiParts);
        ArrayList lawnMowerTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(lawnMowerTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.LAWN_MOWER.get()));
        HashMap lawnMowerParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.LAWN_MOWER_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)lawnMowerParts, (List<MatrixTransformation>)lawnMowerTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<RayTracePart, List<MatrixTransformation>>)lawnMowerParts, (List<MatrixTransformation>)lawnMowerTransformGlobal, MatrixTransformation.createTranslation(0.0, 0.4f, -0.15f), MatrixTransformation.createRotation(-45.0, 1.0, 0.0, 0.0), MatrixTransformation.createScale(0.9f));
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.TOW_BAR, (HashMap<RayTracePart, List<MatrixTransformation>>)lawnMowerParts, MatrixTransformation.createRotation(180.0, 0.0, 1.0, 0.0), MatrixTransformation.createTranslation(0.0, 0.5, 0.6f));
        EntityRaytracer.createFuelablePartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.LAWN_MOWER.get()), SpecialModels.FUEL_DOOR_CLOSED, lawnMowerParts, lawnMowerTransformGlobal);
        EntityRaytracer.registerEntityStatic((EntityType)ModEntities.LAWN_MOWER.get(), lawnMowerParts);
        ArrayList miniBikeTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(miniBikeTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.MINI_BIKE.get()));
        HashMap miniBikeParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.MINI_BIKE_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)miniBikeParts, (List<MatrixTransformation>)miniBikeTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.MINI_BIKE_HANDLES, (HashMap<RayTracePart, List<MatrixTransformation>>)miniBikeParts, (List<MatrixTransformation>)miniBikeTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createPartTransforms((Item)ModItems.WOOD_SMALL_ENGINE.get(), VehicleProperties.getProperties((EntityType)ModEntities.MINI_BIKE.get()).getEnginePosition(), (HashMap<RayTracePart, List<MatrixTransformation>>)miniBikeParts, (List<MatrixTransformation>)miniBikeTransformGlobal, FUNCTION_FUELING);
        EntityRaytracer.registerEntityStatic((EntityType)ModEntities.MINI_BIKE.get(), miniBikeParts);
        ArrayList mopedTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(mopedTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.MOPED.get()));
        HashMap mopedParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.MOPED_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)mopedParts, (List<MatrixTransformation>)mopedTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.MOPED_HANDLES, (HashMap<RayTracePart, List<MatrixTransformation>>)mopedParts, (List<MatrixTransformation>)mopedTransformGlobal, MatrixTransformation.createTranslation(0.0, -0.0625, 0.0), MatrixTransformation.createTranslation(0.0, 0.835f, 0.525f), MatrixTransformation.createScale(0.8f));
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.MOPED_MUD_GUARD, (HashMap<RayTracePart, List<MatrixTransformation>>)mopedParts, (List<MatrixTransformation>)mopedTransformGlobal, MatrixTransformation.createTranslation(0.0, -0.0625, 0.0), MatrixTransformation.createTranslation(0.0, -0.12f, 0.785f), MatrixTransformation.createRotation(-22.5, 1.0, 0.0, 0.0), MatrixTransformation.createScale(0.9f));
        EntityRaytracer.createFuelablePartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.MOPED.get()), SpecialModels.FUEL_DOOR_CLOSED, mopedParts, mopedTransformGlobal);
        EntityRaytracer.registerEntityStatic((EntityType)ModEntities.MOPED.get(), mopedParts);
        ArrayList cartTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(cartTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SHOPPING_CART.get()));
        HashMap cartParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.SHOPPING_CART_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)cartParts, (List<MatrixTransformation>)cartTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.registerEntityStatic((EntityType)ModEntities.SHOPPING_CART.get(), cartParts);
        ArrayList smartCarTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(smartCarTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SMART_CAR.get()));
        HashMap smartCarParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.SMART_CAR_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)smartCarParts, (List<MatrixTransformation>)smartCarTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<RayTracePart, List<MatrixTransformation>>)smartCarParts, (List<MatrixTransformation>)smartCarTransformGlobal, MatrixTransformation.createTranslation(0.0, 0.2f, 0.3f), MatrixTransformation.createRotation(-67.5, 1.0, 0.0, 0.0), MatrixTransformation.createTranslation(0.0, -0.02f, 0.0), MatrixTransformation.createScale(0.9f));
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.TOW_BAR, (HashMap<RayTracePart, List<MatrixTransformation>>)smartCarParts, MatrixTransformation.createRotation(180.0, 0.0, 1.0, 0.0), MatrixTransformation.createTranslation(0.0, 0.5, 1.35f));
        EntityRaytracer.createFuelablePartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SMART_CAR.get()), SpecialModels.FUEL_DOOR_CLOSED, smartCarParts, smartCarTransformGlobal);
        EntityRaytracer.registerEntityStatic((EntityType)ModEntities.SMART_CAR.get(), smartCarParts);
        ArrayList speedBoatTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(speedBoatTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SPEED_BOAT.get()));
        HashMap speedBoatParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.SPEED_BOAT_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)speedBoatParts, (List<MatrixTransformation>)speedBoatTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<RayTracePart, List<MatrixTransformation>>)speedBoatParts, (List<MatrixTransformation>)speedBoatTransformGlobal, MatrixTransformation.createTranslation(0.0, 0.215f, -0.125), MatrixTransformation.createRotation(-45.0, 1.0, 0.0, 0.0), MatrixTransformation.createTranslation(0.0, 0.02f, 0.0));
        EntityRaytracer.createFuelablePartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SPEED_BOAT.get()), SpecialModels.FUEL_DOOR_CLOSED, speedBoatParts, speedBoatTransformGlobal);
        EntityRaytracer.registerEntityStatic((EntityType)ModEntities.SPEED_BOAT.get(), speedBoatParts);
        ArrayList sportsPlaneTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(sportsPlaneTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SPORTS_PLANE.get()));
        HashMap sportsPlaneParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.SPORTS_PLANE, (HashMap<RayTracePart, List<MatrixTransformation>>)sportsPlaneParts, (List<MatrixTransformation>)sportsPlaneTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createFuelablePartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SPORTS_PLANE.get()), SpecialModels.FUEL_DOOR_CLOSED, sportsPlaneParts, sportsPlaneTransformGlobal);
        EntityRaytracer.createKeyPortTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SPORTS_PLANE.get()), sportsPlaneParts, sportsPlaneTransformGlobal);
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.SPORTS_PLANE_WING, (HashMap<RayTracePart, List<MatrixTransformation>>)sportsPlaneParts, (List<MatrixTransformation>)sportsPlaneTransformGlobal, MatrixTransformation.createTranslation(0.0, -0.1875, 0.5), MatrixTransformation.createRotation(180.0, 0.0, 0.0, 1.0), MatrixTransformation.createTranslation(0.875, 0.0625, 0.0), MatrixTransformation.createRotation(5.0, 1.0, 0.0, 0.0));
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.SPORTS_PLANE_WING, (HashMap<RayTracePart, List<MatrixTransformation>>)sportsPlaneParts, (List<MatrixTransformation>)sportsPlaneTransformGlobal, MatrixTransformation.createTranslation(0.875, -0.1875, 0.5), MatrixTransformation.createRotation(-5.0, 1.0, 0.0, 0.0));
        sportsPlaneTransformGlobal.add(MatrixTransformation.createTranslation(0.0, -0.5, 0.0));
        sportsPlaneTransformGlobal.add(MatrixTransformation.createScale(0.85f));
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.SPORTS_PLANE_WHEEL_COVER, (HashMap<RayTracePart, List<MatrixTransformation>>)sportsPlaneParts, (List<MatrixTransformation>)sportsPlaneTransformGlobal, MatrixTransformation.createTranslation(0.0, -0.1875, 1.5));
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.SPORTS_PLANE_LEG, (HashMap<RayTracePart, List<MatrixTransformation>>)sportsPlaneParts, (List<MatrixTransformation>)sportsPlaneTransformGlobal, MatrixTransformation.createTranslation(0.0, -0.1875, 1.5));
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.SPORTS_PLANE_WHEEL_COVER, (HashMap<RayTracePart, List<MatrixTransformation>>)sportsPlaneParts, (List<MatrixTransformation>)sportsPlaneTransformGlobal, MatrixTransformation.createTranslation(-0.46875, -0.1875, 0.125));
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.SPORTS_PLANE_LEG, (HashMap<RayTracePart, List<MatrixTransformation>>)sportsPlaneParts, (List<MatrixTransformation>)sportsPlaneTransformGlobal, MatrixTransformation.createTranslation(-0.46875, -0.1875, 0.125), MatrixTransformation.createRotation(-100.0, 0.0, 1.0, 0.0));
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.SPORTS_PLANE_WHEEL_COVER, (HashMap<RayTracePart, List<MatrixTransformation>>)sportsPlaneParts, (List<MatrixTransformation>)sportsPlaneTransformGlobal, MatrixTransformation.createTranslation(0.46875, -0.1875, 0.125));
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.SPORTS_PLANE_LEG, (HashMap<RayTracePart, List<MatrixTransformation>>)sportsPlaneParts, (List<MatrixTransformation>)sportsPlaneTransformGlobal, MatrixTransformation.createTranslation(0.46875, -0.1875, 0.125), MatrixTransformation.createRotation(100.0, 0.0, 1.0, 0.0));
        EntityRaytracer.registerEntityStatic((EntityType)ModEntities.SPORTS_PLANE.get(), sportsPlaneParts);
        ArrayList golfCartTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(golfCartTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.GOLF_CART.get()));
        HashMap golfCartParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.GOLF_CART_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)golfCartParts, (List<MatrixTransformation>)golfCartTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<RayTracePart, List<MatrixTransformation>>)golfCartParts, (List<MatrixTransformation>)golfCartTransformGlobal, MatrixTransformation.createTranslation(-0.345f, 0.425f, 0.1f), MatrixTransformation.createRotation(-45.0, 1.0, 0.0, 0.0), MatrixTransformation.createTranslation(0.0, -0.02f, 0.0), MatrixTransformation.createScale(0.95f));
        EntityRaytracer.createFuelablePartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.GOLF_CART.get()), SpecialModels.FUEL_DOOR_CLOSED, golfCartParts, golfCartTransformGlobal);
        EntityRaytracer.createKeyPortTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.GOLF_CART.get()), golfCartParts, golfCartTransformGlobal);
        EntityRaytracer.registerEntityStatic((EntityType)ModEntities.GOLF_CART.get(), golfCartParts);
        ArrayList offRoaderTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(offRoaderTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.OFF_ROADER.get()));
        HashMap offRoaderParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.OFF_ROADER_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)offRoaderParts, (List<MatrixTransformation>)offRoaderTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<RayTracePart, List<MatrixTransformation>>)offRoaderParts, (List<MatrixTransformation>)offRoaderTransformGlobal, MatrixTransformation.createTranslation(-0.3125, 0.35f, 0.2f), MatrixTransformation.createRotation(-45.0, 1.0, 0.0, 0.0), MatrixTransformation.createTranslation(0.0, -0.02f, 0.0), MatrixTransformation.createScale(0.75));
        EntityRaytracer.createFuelablePartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.OFF_ROADER.get()), SpecialModels.FUEL_DOOR_CLOSED, offRoaderParts, offRoaderTransformGlobal);
        EntityRaytracer.createKeyPortTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.OFF_ROADER.get()), offRoaderParts, offRoaderTransformGlobal);
        EntityRaytracer.registerEntityStatic((EntityType)ModEntities.OFF_ROADER.get(), offRoaderParts);
        ArrayList tractorTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(tractorTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.TRACTOR.get()));
        HashMap tractorParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.TRACTOR, (HashMap<RayTracePart, List<MatrixTransformation>>)tractorParts, (List<MatrixTransformation>)tractorTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<RayTracePart, List<MatrixTransformation>>)tractorParts, (List<MatrixTransformation>)tractorTransformGlobal, MatrixTransformation.createTranslation(0.0, 0.66f, -0.475f), MatrixTransformation.createRotation(-67.5, 1.0, 0.0, 0.0), MatrixTransformation.createTranslation(0.0, -0.02f, 0.0), MatrixTransformation.createScale(0.9f));
        EntityRaytracer.createFuelablePartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.TRACTOR.get()), SpecialModels.FUEL_DOOR_CLOSED, tractorParts, tractorTransformGlobal);
        EntityRaytracer.createKeyPortTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.TRACTOR.get()), tractorParts, tractorTransformGlobal);
        EntityRaytracer.registerEntityStatic((EntityType)ModEntities.TRACTOR.get(), tractorParts);
        ArrayList miniBusTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(miniBusTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.MINI_BUS.get()));
        HashMap miniBusParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.MINI_BUS_BODY, (HashMap<RayTracePart, List<MatrixTransformation>>)miniBusParts, (List<MatrixTransformation>)miniBusTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.GO_KART_STEERING_WHEEL, (HashMap<RayTracePart, List<MatrixTransformation>>)miniBusParts, (List<MatrixTransformation>)miniBusTransformGlobal, MatrixTransformation.createTranslation(-0.2825f, 0.225f, 1.0625), MatrixTransformation.createRotation(-67.5, 1.0, 0.0, 0.0), MatrixTransformation.createTranslation(0.0, -0.02f, 0.0), MatrixTransformation.createScale(0.75));
        EntityRaytracer.createFuelablePartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.MINI_BUS.get()), SpecialModels.FUEL_DOOR_CLOSED, miniBusParts, miniBusTransformGlobal);
        EntityRaytracer.createKeyPortTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.MINI_BUS.get()), miniBusParts, miniBusTransformGlobal);
        EntityRaytracer.registerEntityStatic((EntityType)ModEntities.MINI_BUS.get(), miniBusParts);
        if (ModList.get().isLoaded("cfm")) {
            ArrayList bathTransformGlobal = Lists.newArrayList();
            EntityRaytracer.createBodyTransforms(bathTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.BATH.get()));
            HashMap bathParts = Maps.newHashMap();
            EntityRaytracer.createTransformListForPart((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("cfm:bath")), (HashMap<RayTracePart, List<MatrixTransformation>>)bathParts, (List<MatrixTransformation>)bathTransformGlobal, MatrixTransformation.createRotation(90.0, 0.0, 1.0, 0.0));
            EntityRaytracer.registerEntityStatic((EntityType)ModEntities.BATH.get(), bathParts);
            ArrayList couchTransformGlobal = Lists.newArrayList();
            EntityRaytracer.createBodyTransforms(couchTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SOFA.get()));
            HashMap couchParts = Maps.newHashMap();
            EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.RAINBOW_SOFA, (HashMap<RayTracePart, List<MatrixTransformation>>)couchParts, (List<MatrixTransformation>)couchTransformGlobal, MatrixTransformation.createRotation(90.0, 0.0, 1.0, 0.0), MatrixTransformation.createTranslation(0.0, 0.0625, 0.0));
            EntityRaytracer.registerEntityStatic((EntityType)ModEntities.SOFA.get(), couchParts);
            ArrayList sofacopterTransformGlobal = Lists.newArrayList();
            EntityRaytracer.createBodyTransforms(sofacopterTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SOFACOPTER.get()));
            HashMap sofacopterParts = Maps.newHashMap();
            EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.RED_SOFA, (HashMap<RayTracePart, List<MatrixTransformation>>)sofacopterParts, (List<MatrixTransformation>)sofacopterTransformGlobal, MatrixTransformation.createRotation(90.0, 0.0, 1.0, 0.0));
            EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.SOFA_HELICOPTER_ARM, (HashMap<RayTracePart, List<MatrixTransformation>>)sofacopterParts, (List<MatrixTransformation>)sofacopterTransformGlobal, MatrixTransformation.createTranslation(0.0, 0.5, 0.0));
            EntityRaytracer.createFuelablePartTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SOFACOPTER.get()), SpecialModels.FUEL_DOOR_CLOSED, sofacopterParts, sofacopterTransformGlobal);
            EntityRaytracer.createKeyPortTransforms((EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SOFACOPTER.get()), sofacopterParts, sofacopterTransformGlobal);
            EntityRaytracer.registerEntityStatic((EntityType)ModEntities.SOFACOPTER.get(), sofacopterParts);
        }
        ArrayList trailerVehicleTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(trailerVehicleTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.VEHICLE_TRAILER.get()));
        HashMap trailerVehicleParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.VEHICLE_TRAILER, (HashMap<RayTracePart, List<MatrixTransformation>>)trailerVehicleParts, (List<MatrixTransformation>)trailerVehicleTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.registerEntityStatic((EntityType)ModEntities.VEHICLE_TRAILER.get(), trailerVehicleParts);
        ArrayList trailerStorageTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(trailerStorageTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.STORAGE_TRAILER.get()));
        HashMap trailerStorageParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.STORAGE_TRAILER, (HashMap<RayTracePart, List<MatrixTransformation>>)trailerStorageParts, (List<MatrixTransformation>)trailerStorageTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.registerEntityStatic((EntityType)ModEntities.STORAGE_TRAILER.get(), trailerStorageParts);
        ArrayList seederTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(seederTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.SEEDER.get()));
        HashMap seederParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.SEEDER_TRAILER, (HashMap<RayTracePart, List<MatrixTransformation>>)seederParts, (List<MatrixTransformation>)seederTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.registerEntityStatic((EntityType)ModEntities.SEEDER.get(), seederParts);
        ArrayList fertilizerTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(fertilizerTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.FERTILIZER.get()));
        HashMap fertilizerParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.FERTILIZER_TRAILER, (HashMap<RayTracePart, List<MatrixTransformation>>)fertilizerParts, (List<MatrixTransformation>)fertilizerTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.registerEntityStatic((EntityType)ModEntities.FERTILIZER.get(), fertilizerParts);
        ArrayList trailerFluidTransformGlobal = Lists.newArrayList();
        EntityRaytracer.createBodyTransforms(trailerFluidTransformGlobal, (EntityType<? extends VehicleEntity>)((EntityType)ModEntities.FLUID_TRAILER.get()));
        HashMap trailerFluidParts = Maps.newHashMap();
        EntityRaytracer.createTransformListForPart((ISpecialModel)SpecialModels.FLUID_TRAILER, (HashMap<RayTracePart, List<MatrixTransformation>>)trailerFluidParts, (List<MatrixTransformation>)trailerFluidTransformGlobal, new MatrixTransformation[0]);
        EntityRaytracer.registerEntityStatic((EntityType)ModEntities.FLUID_TRAILER.get(), trailerFluidParts);
    }

    private static void registerEntitiesDynamic() {
    }

    public static void createBodyTransforms(List<MatrixTransformation> transforms, EntityType<? extends VehicleEntity> entityType) {
        VehicleProperties properties = VehicleProperties.getProperties(entityType);
        PartPosition bodyPosition = properties.getBodyPosition();
        transforms.add(MatrixTransformation.createRotation(bodyPosition.getRotX(), 1.0, 0.0, 0.0));
        transforms.add(MatrixTransformation.createRotation(bodyPosition.getRotY(), 0.0, 1.0, 0.0));
        transforms.add(MatrixTransformation.createRotation(bodyPosition.getRotZ(), 0.0, 0.0, 1.0));
        transforms.add(MatrixTransformation.createTranslation((float)bodyPosition.getX(), (float)bodyPosition.getY(), (float)bodyPosition.getZ()));
        transforms.add(MatrixTransformation.createScale((float)bodyPosition.getScale()));
        transforms.add(MatrixTransformation.createTranslation(0.0, 0.5, 0.0));
        transforms.add(MatrixTransformation.createTranslation(0.0, properties.getAxleOffset() * 0.0625f, 0.0));
        transforms.add(MatrixTransformation.createTranslation(0.0, properties.getWheelOffset() * 0.0625f, 0.0));
    }

    public static void createPartTransforms(ISpecialModel model, PartPosition partPosition, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal) {
        ArrayList transforms = Lists.newArrayList();
        transforms.addAll(transformsGlobal);
        transforms.add(MatrixTransformation.createTranslation((float)partPosition.getX() * 0.0625f, (float)partPosition.getY() * 0.0625f, (float)partPosition.getZ() * 0.0625f));
        transforms.add(MatrixTransformation.createTranslation(0.0, -0.5, 0.0));
        transforms.add(MatrixTransformation.createScale((float)partPosition.getScale()));
        transforms.add(MatrixTransformation.createTranslation(0.0, 0.5, 0.0));
        transforms.add(MatrixTransformation.createRotation(partPosition.getRotX(), 1.0, 0.0, 0.0));
        transforms.add(MatrixTransformation.createRotation(partPosition.getRotY(), 0.0, 1.0, 0.0));
        transforms.add(MatrixTransformation.createRotation(partPosition.getRotZ(), 0.0, 0.0, 1.0));
        EntityRaytracer.createTransformListForPart(model, parts, (List<MatrixTransformation>)transforms, new MatrixTransformation[0]);
    }

    public static void createPartTransforms(ISpecialModel model, PartPosition partPosition, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal, Function<RayTraceResultRotated, Hand> function) {
        ArrayList transforms = Lists.newArrayList();
        transforms.addAll(transformsGlobal);
        transforms.add(MatrixTransformation.createTranslation((float)partPosition.getX() * 0.0625f, (float)partPosition.getY() * 0.0625f, (float)partPosition.getZ() * 0.0625f));
        transforms.add(MatrixTransformation.createTranslation(0.0, -0.5, 0.0));
        transforms.add(MatrixTransformation.createScale((float)partPosition.getScale()));
        transforms.add(MatrixTransformation.createTranslation(0.0, 0.5, 0.0));
        transforms.add(MatrixTransformation.createRotation(partPosition.getRotX(), 1.0, 0.0, 0.0));
        transforms.add(MatrixTransformation.createRotation(partPosition.getRotY(), 0.0, 1.0, 0.0));
        transforms.add(MatrixTransformation.createRotation(partPosition.getRotZ(), 0.0, 0.0, 1.0));
        EntityRaytracer.createTransformListForPart(model, parts, (List<MatrixTransformation>)transforms, function, new MatrixTransformation[0]);
    }

    public static void createPartTransforms(Item part, PartPosition partPosition, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal, Function<RayTraceResultRotated, Hand> function) {
        ArrayList transforms = Lists.newArrayList();
        transforms.addAll(transformsGlobal);
        transforms.add(MatrixTransformation.createTranslation((float)partPosition.getX() * 0.0625f, (float)partPosition.getY() * 0.0625f, (float)partPosition.getZ() * 0.0625f));
        transforms.add(MatrixTransformation.createTranslation(0.0, -0.5, 0.0));
        transforms.add(MatrixTransformation.createScale((float)partPosition.getScale()));
        transforms.add(MatrixTransformation.createTranslation(0.0, 0.5, 0.0));
        transforms.add(MatrixTransformation.createRotation(partPosition.getRotX(), 1.0, 0.0, 0.0));
        transforms.add(MatrixTransformation.createRotation(partPosition.getRotY(), 0.0, 1.0, 0.0));
        transforms.add(MatrixTransformation.createRotation(partPosition.getRotZ(), 0.0, 0.0, 1.0));
        EntityRaytracer.createTransformListForPart(new ItemStack((IItemProvider)part), parts, (List<MatrixTransformation>)transforms, function, new MatrixTransformation[0]);
    }

    public static void createPartTransforms(double xPixel, double yPixel, double zPixel, Vec3d rotation, double scale, List<MatrixTransformation> transforms) {
        transforms.add(MatrixTransformation.createTranslation(xPixel * 0.0625, yPixel * 0.0625, zPixel * 0.0625));
        transforms.add(MatrixTransformation.createTranslation(0.0, -0.5, 0.0));
        transforms.add(MatrixTransformation.createScale(scale));
        transforms.add(MatrixTransformation.createTranslation(0.0, 0.5, 0.0));
        if (rotation.field_72450_a != 0.0) {
            transforms.add(MatrixTransformation.createRotation(rotation.field_72450_a, 1.0, 0.0, 0.0));
        }
        if (rotation.field_72448_b != 0.0) {
            transforms.add(MatrixTransformation.createRotation(rotation.field_72448_b, 0.0, 1.0, 0.0));
        }
        if (rotation.field_72449_c != 0.0) {
            transforms.add(MatrixTransformation.createRotation(rotation.field_72449_c, 0.0, 0.0, 1.0));
        }
    }

    public static void createFuelablePartTransforms(Item part, double xMeters, double yMeters, double zMeters, double xPixel, double yPixel, double zPixel, Vec3d rotation, double scale, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal) {
        ArrayList partTransforms = Lists.newArrayList();
        partTransforms.add(MatrixTransformation.createTranslation((float)xMeters, (float)yMeters, (float)zMeters));
        EntityRaytracer.createPartTransforms(xPixel, yPixel, zPixel, rotation, scale, partTransforms);
        transformsGlobal.addAll(partTransforms);
        EntityRaytracer.createTransformListForPart(new ItemStack((IItemProvider)part), parts, transformsGlobal, FUNCTION_FUELING, new MatrixTransformation[0]);
    }

    public static void createFuelablePartTransforms(EntityType<? extends VehicleEntity> entityType, ISpecialModel model, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal) {
        PartPosition fuelPortPosition = VehicleProperties.getProperties(entityType).getFuelPortPosition();
        EntityRaytracer.createPartTransforms(model, fuelPortPosition, parts, transformsGlobal, FUNCTION_FUELING);
    }

    public static void createFuelablePartTransforms(Item part, double xMeters, double yMeters, double zMeters, double xPixel, double yPixel, double zPixel, double rotation, double scale, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal) {
        ArrayList partTransforms = Lists.newArrayList();
        partTransforms.add(MatrixTransformation.createTranslation((float)xMeters, (float)yMeters, (float)zMeters));
        EntityRaytracer.createPartTransforms(xPixel, yPixel, zPixel, new Vec3d(0.0, (double)((float)rotation), 0.0), scale, partTransforms);
        transformsGlobal.addAll(partTransforms);
        EntityRaytracer.createTransformListForPart(new ItemStack((IItemProvider)part), parts, transformsGlobal, FUNCTION_FUELING, new MatrixTransformation[0]);
    }

    public static void createKeyPortTransforms(EntityType<? extends VehicleEntity> entityType, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal) {
        PartPosition keyPortPosition = VehicleProperties.getProperties(entityType).getKeyPortPosition();
        EntityRaytracer.createPartTransforms(SpecialModels.KEY_HOLE, keyPortPosition, parts, transformsGlobal);
    }

    public static void createTransformListForPart(ItemStack part, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal, @Nullable Function<RayTraceResultRotated, Hand> continuousInteraction, MatrixTransformation ... transforms) {
        ArrayList transformsAll = Lists.newArrayList();
        transformsAll.addAll(transformsGlobal);
        transformsAll.addAll(Arrays.asList(transforms));
        parts.put(new RayTracePart<Hand>(part, continuousInteraction), transformsAll);
    }

    public static void createTransformListForPart(ItemStack part, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal, MatrixTransformation ... transforms) {
        EntityRaytracer.createTransformListForPart(part, parts, transformsGlobal, null, transforms);
    }

    public static void createTransformListForPart(Item part, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal, MatrixTransformation ... transforms) {
        EntityRaytracer.createTransformListForPart(new ItemStack((IItemProvider)part), parts, transformsGlobal, transforms);
    }

    public static void createTransformListForPart(ISpecialModel model, HashMap<RayTracePart, List<MatrixTransformation>> parts, MatrixTransformation ... transforms) {
        EntityRaytracer.createTransformListForPart(model, parts, (List<MatrixTransformation>)Lists.newArrayList(), transforms);
    }

    public static void createTransformListForPart(Item part, HashMap<RayTracePart, List<MatrixTransformation>> parts, MatrixTransformation ... transforms) {
        EntityRaytracer.createTransformListForPart(part, parts, (List<MatrixTransformation>)Lists.newArrayList(), transforms);
    }

    public static void createTransformListForPart(ISpecialModel model, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal, @Nullable Function<RayTraceResultRotated, Hand> continuousInteraction, MatrixTransformation ... transforms) {
        ArrayList transformsAll = Lists.newArrayList();
        transformsAll.addAll(transformsGlobal);
        transformsAll.addAll(Arrays.asList(transforms));
        parts.put(new RayTracePart<Hand>(model, continuousInteraction), transformsAll);
    }

    public static void createTransformListForPart(ISpecialModel model, HashMap<RayTracePart, List<MatrixTransformation>> parts, List<MatrixTransformation> transformsGlobal, MatrixTransformation ... transforms) {
        EntityRaytracer.createTransformListForPart(model, parts, transformsGlobal, null, transforms);
    }

    public static void init() {
        EntityRaytracer.clearDataForReregistration();
        EntityRaytracer.registerEntitiesDynamic();
        EntityRaytracer.registerEntitiesStatic();
        for (EntityType<? extends IEntityRaytraceable> entityType : entityRaytraceTriangles.keySet()) {
            float min = 0.0f;
            float max = 0.0f;
            Entity entity = entityType.func_200721_a((World)Minecraft.func_71410_x().field_71441_e);
            for (Map.Entry<RayTracePart, TriangleRayTraceList> entry : entityRaytraceTriangles.get(entityType).entrySet()) {
                for (TriangleRayTrace triangle : entity == null ? entry.getValue().getTriangles() : entry.getValue().getTriangles(entry.getKey(), entity)) {
                    float[] data = triangle.getData();
                    for (int i = 0; i < data.length; i += 3) {
                        float x = data[i];
                        float y = data[i + 1];
                        float z = data[i + 2];
                        if (x < min) {
                            min = x;
                        }
                        if (y < min) {
                            min = y;
                        }
                        if (z < min) {
                            min = z;
                        }
                        if (x > max) {
                            max = x;
                        }
                        if (y > max) {
                            max = y;
                        }
                        if (!(z > max)) continue;
                        max = z;
                    }
                }
            }
            float range = max - min;
            entityCrateScalesAndOffsets.put(entityType, (Pair<Float, Float>)new ImmutablePair((Object)Float.valueOf(1.0f / (range * 1.25f)), (Object)Float.valueOf(-(min + range * 0.5f))));
        }
        initialized = true;
    }

    private static <T extends VehicleEntity> void registerEntityStatic(EntityType<T> entityType, Map<RayTracePart, List<MatrixTransformation>> transforms) {
        HashMap partTriangles = Maps.newHashMap();
        for (Map.Entry<RayTracePart, List<MatrixTransformation>> entryPart : transforms.entrySet()) {
            RayTracePart part = entryPart.getKey();
            Matrix4d matrix = new Matrix4d();
            matrix.setIdentity();
            for (MatrixTransformation tranform : entryPart.getValue()) {
                tranform.transform(matrix);
            }
            EntityRaytracer.finalizePartStackMatrix(matrix);
            partTriangles.put(part, new TriangleRayTraceList(EntityRaytracer.generateTriangles(EntityRaytracer.getModel(part), matrix)));
        }
        entityRaytraceTrianglesStatic.put(entityType, partTriangles);
        HashMap<RayTracePart, TriangleRayTraceList> partTrianglesCopy = new HashMap<RayTracePart, TriangleRayTraceList>(partTriangles);
        Map<RayTracePart, TriangleRayTraceList> partTrianglesAll = entityRaytraceTriangles.get(entityType);
        if (partTrianglesAll != null) {
            partTrianglesCopy.putAll(partTrianglesAll);
        }
        entityRaytraceTriangles.put(entityType, partTrianglesCopy);
    }

    private static <T extends VehicleEntity> void registerEntityDynamic(EntityType<T> entityType, Map<RayTracePart, BiFunction<RayTracePart, Entity, Matrix4d>> matrixFactories) {
        HashMap partTriangles = Maps.newHashMap();
        for (Map.Entry<RayTracePart, BiFunction<RayTracePart, Entity, Matrix4d>> entryPart : matrixFactories.entrySet()) {
            RayTracePart part = entryPart.getKey();
            partTriangles.put(part, new TriangleRayTraceList(EntityRaytracer.generateTriangles(EntityRaytracer.getModel(part), null), entryPart.getValue()));
        }
        entityRaytraceTrianglesDynamic.put(entityType, partTriangles);
        entityRaytraceTriangles.put(entityType, partTriangles);
    }

    public static Pair<Float, Float> getCrateScaleAndOffset(Class<? extends Entity> raytraceClass) {
        Pair<Float, Float> scaleAndOffset = entityCrateScalesAndOffsets.get(raytraceClass);
        return scaleAndOffset == null ? SCALE_AND_OFFSET_DEFAULT : scaleAndOffset;
    }

    private static IBakedModel getModel(RayTracePart part) {
        if (part.model != null) {
            return part.model.getModel();
        }
        return Minecraft.func_71410_x().func_175599_af().func_184393_a(part.partStack, null, (LivingEntity)Minecraft.func_71410_x().field_71439_g);
    }

    private static List<TriangleRayTrace> generateTriangles(IBakedModel model, @Nullable Matrix4d matrix) {
        ArrayList triangles = Lists.newArrayList();
        try {
            Random random = new Random();
            random.setSeed(42L);
            EntityRaytracer.generateTriangles(model.func_200117_a(null, null, random), matrix, triangles);
            for (Direction facing : Direction.values()) {
                random.setSeed(42L);
                EntityRaytracer.generateTriangles(model.func_200117_a(null, facing, random), matrix, triangles);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return triangles;
    }

    private static void generateTriangles(List<BakedQuad> list, @Nullable Matrix4d matrix, List<TriangleRayTrace> triangles) {
        for (BakedQuad quad : list) {
            int size = DefaultVertexFormats.field_176600_a.func_181719_f();
            int[] data = quad.func_178209_a();
            float[] triangle1 = new float[9];
            float[] triangle2 = new float[9];
            triangle1[0] = Float.intBitsToFloat(data[0]);
            triangle1[1] = Float.intBitsToFloat(data[1]);
            triangle1[2] = Float.intBitsToFloat(data[2]);
            triangle1[3] = triangle2[6] = Float.intBitsToFloat(data[size]);
            triangle1[4] = triangle2[7] = Float.intBitsToFloat(data[size + 1]);
            triangle1[5] = triangle2[8] = Float.intBitsToFloat(data[size + 2]);
            triangle2[0] = Float.intBitsToFloat(data[size *= 2]);
            triangle2[1] = Float.intBitsToFloat(data[size + 1]);
            triangle2[2] = Float.intBitsToFloat(data[size + 2]);
            size = (int)((double)size * 1.5);
            triangle1[6] = triangle2[3] = Float.intBitsToFloat(data[size]);
            triangle1[7] = triangle2[4] = Float.intBitsToFloat(data[size + 1]);
            triangle1[8] = triangle2[5] = Float.intBitsToFloat(data[size + 2]);
            EntityRaytracer.transformTriangleAndAdd(triangle1, matrix, triangles);
            EntityRaytracer.transformTriangleAndAdd(triangle2, matrix, triangles);
        }
    }

    private static void transformTriangleAndAdd(float[] triangle, @Nullable Matrix4d matrix, List<TriangleRayTrace> triangles) {
        triangles.add(new TriangleRayTrace(matrix != null ? EntityRaytracer.getTransformedTriangle(triangle, matrix) : triangle));
    }

    private static float[] getTransformedTriangle(float[] triangle, Matrix4d matrix) {
        float[] triangleNew = new float[9];
        for (int i = 0; i < 9; i += 3) {
            Vector4d vec = new Vector4d((double)triangle[i], (double)triangle[i + 1], (double)triangle[i + 2], 1.0);
            matrix.transform((Tuple4d)vec);
            triangleNew[i] = (float)vec.x;
            triangleNew[i + 1] = (float)vec.y;
            triangleNew[i + 2] = (float)vec.z;
        }
        return triangleNew;
    }

    public static void finalizePartStackMatrix(Matrix4d matrix) {
        MatrixTransformation.createTranslation(-0.5, -0.5, -0.5).transform(matrix);
    }

    public static void interactWithEntity(IEntityRaytraceable entity, EntityRayTraceResult result) {
        Minecraft.func_71410_x().field_71442_b.func_187097_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (Entity)entity, Hand.MAIN_HAND);
        Minecraft.func_71410_x().field_71442_b.func_187102_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (Entity)entity, result, Hand.MAIN_HAND);
    }

    @SubscribeEvent
    public static void raytraceEntitiesContinuously(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if ((!initialized || ((Boolean)Config.CLIENT.reloadRayTracerEachTick.get()).booleanValue()) && Minecraft.func_71410_x().field_71441_e != null) {
            EntityRaytracer.init();
        }
        if (continuousInteraction == null || Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        RayTraceResultRotated result = EntityRaytracer.raytraceEntities(continuousInteraction.isRightClick());
        if (result == null || result.func_216348_a() != continuousInteraction.func_216348_a() || result.getPartHit() != continuousInteraction.getPartHit()) {
            continuousInteraction = null;
            continuousInteractionTickCounter = 0;
            return;
        }
        continuousInteractionObject = result.performContinuousInteraction();
        if (continuousInteractionObject == null) {
            continuousInteraction = null;
            continuousInteractionTickCounter = 0;
        } else {
            ++continuousInteractionTickCounter;
        }
    }

    @SubscribeEvent
    public static void onMouseEvent(InputEvent.RawMouseEvent event) {
        boolean leftClick;
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_213279_p != null || mc.field_71462_r != null) {
            return;
        }
        boolean rightClick = event.getButton() == 1;
        boolean bl = leftClick = event.getButton() == 0;
        if (!((rightClick || ((Boolean)Config.CLIENT.enabledLeftClick.get()).booleanValue() && leftClick) && event.getAction() != 0)) {
            return;
        }
        if (EntityRaytracer.performRayTrace(rightClick)) {
            event.setCanceled(true);
        }
    }

    public static boolean performRayTrace(boolean rightClick) {
        RayTraceResultRotated result = EntityRaytracer.raytraceEntities(rightClick);
        if (result != null) {
            continuousInteractionObject = result.performContinuousInteraction();
            if (continuousInteractionObject != null) {
                continuousInteraction = result;
                continuousInteractionTickCounter = 1;
            }
            return true;
        }
        return false;
    }

    @Nullable
    private static RayTraceResultRotated raytraceEntities(boolean rightClick) {
        double eyeDistance;
        float reach = Minecraft.func_71410_x().field_71442_b.func_78757_d();
        Vec3d eyeVec = Minecraft.func_71410_x().field_71439_g.func_174824_e(1.0f);
        Vec3d forwardVec = eyeVec.func_178787_e(Minecraft.func_71410_x().field_71439_g.func_70676_i(1.0f).func_186678_a((double)reach));
        AxisAlignedBB box = new AxisAlignedBB(eyeVec, eyeVec).func_186662_g((double)reach);
        RayTraceResultRotated lookObject = null;
        double distanceShortest = Double.MAX_VALUE;
        for (Entity entity2 : Minecraft.func_71410_x().field_71441_e.func_175647_a(VehicleEntity.class, box, entity -> entity instanceof IEntityRaytraceable)) {
            double distance;
            RayTraceResultRotated lookObjectPutative;
            if (!entityRaytraceTrianglesDynamic.containsKey(entity2.func_200600_R()) && !entityRaytraceTrianglesStatic.containsKey(entity2.func_200600_R()) || (lookObjectPutative = EntityRaytracer.rayTraceEntityRotated((IEntityRaytraceable)entity2, eyeVec, forwardVec, reach, rightClick)) == null || !((distance = lookObjectPutative.getDistanceToEyes()) < distanceShortest)) continue;
            lookObject = lookObjectPutative;
            distanceShortest = distance;
        }
        if (lookObject != null && (eyeDistance = lookObject.getDistanceToEyes()) <= (double)reach) {
            Vec3d hit = forwardVec;
            RayTraceResult result = Minecraft.func_71410_x().field_71476_x;
            boolean bypass = entityRaytraceTrianglesStatic.keySet().contains(lookObject.func_216348_a().func_200600_R());
            if (bypass && result != null && result.func_216346_c() != RayTraceResult.Type.MISS) {
                AxisAlignedBB boxMC = null;
                if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
                    boxMC = lookObject.func_216348_a().func_174813_aQ();
                } else if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
                    BlockPos pos = ((BlockRayTraceResult)result).func_216350_a();
                    boxMC = lookObject.func_216348_a().field_70170_p.func_180495_p(pos).func_196954_c((IBlockReader)lookObject.func_216348_a().field_70170_p, pos).func_197752_a();
                }
                boolean bl = bypass = boxMC != null && boxMC.func_72318_a(eyeVec);
            }
            if (!bypass && result != null && result.func_216346_c() != RayTraceResult.Type.MISS) {
                if (result.func_216346_c() == RayTraceResult.Type.ENTITY && ((EntityRayTraceResult)result).func_216348_a() == lookObject.func_216348_a()) {
                    bypass = true;
                } else {
                    hit = result.func_216347_e();
                }
            }
            if ((bypass || eyeDistance < hit.func_72438_d(eyeVec)) && ((IEntityRaytraceable)lookObject.func_216348_a()).processHit(lookObject, rightClick)) {
                return lookObject;
            }
        }
        return null;
    }

    @Nullable
    public static RayTraceResultRotated rayTraceEntityRotated(IEntityRaytraceable boxProvider, Vec3d eyeVec, Vec3d forwardVec, double reach, boolean rightClick) {
        boolean isDynamic;
        Entity entity = (Entity)boxProvider;
        Vec3d pos = entity.func_174791_d();
        double angle = Math.toRadians(-entity.field_70177_z);
        Vec3d eyeVecRotated = EntityRaytracer.rotateVecXZ(eyeVec, angle, pos);
        Vec3d forwardVecRotated = EntityRaytracer.rotateVecXZ(forwardVec, angle, pos);
        float[] eyes = new float[]{(float)eyeVecRotated.field_72450_a, (float)eyeVecRotated.field_72448_b, (float)eyeVecRotated.field_72449_c};
        Vec3d look = forwardVecRotated.func_178788_d(eyeVecRotated).func_72432_b().func_186678_a(reach);
        float[] direction = new float[]{(float)look.field_72450_a, (float)look.field_72448_b, (float)look.field_72449_c};
        RayTraceResultTriangle lookBox = null;
        RayTraceResultTriangle lookPart = null;
        double distanceShortest = Double.MAX_VALUE;
        List<RayTracePart> boxesApplicable = boxProvider.getApplicableInteractionBoxes();
        List<RayTracePart> partsNonApplicable = boxProvider.getNonApplicableParts();
        lookBox = EntityRaytracer.raytracePartTriangles(entity, pos, eyeVecRotated, lookBox, distanceShortest, eyes, direction, boxesApplicable, false, boxProvider.getDynamicInteractionBoxMap());
        distanceShortest = EntityRaytracer.updateShortestDistance(lookBox, distanceShortest);
        lookPart = EntityRaytracer.raytracePartTriangles(entity, pos, eyeVecRotated, lookPart, distanceShortest, eyes, direction, partsNonApplicable, true, entityRaytraceTrianglesDynamic.get(entity.func_200600_R()));
        distanceShortest = EntityRaytracer.updateShortestDistance(lookPart, distanceShortest);
        boolean bl = isDynamic = lookBox != null || lookPart != null;
        if (!isDynamic) {
            lookBox = EntityRaytracer.raytracePartTriangles(entity, pos, eyeVecRotated, lookBox, distanceShortest, eyes, direction, boxesApplicable, false, boxProvider.getStaticInteractionBoxMap());
            distanceShortest = EntityRaytracer.updateShortestDistance(lookBox, distanceShortest);
            lookPart = EntityRaytracer.raytracePartTriangles(entity, pos, eyeVecRotated, lookPart, distanceShortest, eyes, direction, partsNonApplicable, true, entityRaytraceTrianglesStatic.get(entity.func_200600_R()));
        }
        if (lookPart != null) {
            return new RayTraceResultRotated(entity, EntityRaytracer.rotateVecXZ(lookPart.getHit(), -angle, pos), lookPart.getDistance(), lookPart.getPart(), rightClick);
        }
        return lookBox == null ? null : new RayTraceResultRotated(entity, EntityRaytracer.rotateVecXZ(lookBox.getHit(), -angle, pos), lookBox.getDistance(), lookBox.getPart(), rightClick);
    }

    private static double updateShortestDistance(RayTraceResultTriangle lookObject, double distanceShortest) {
        if (lookObject != null) {
            distanceShortest = lookObject.getDistance();
        }
        return distanceShortest;
    }

    private static RayTraceResultTriangle raytracePartTriangles(Entity entity, Vec3d pos, Vec3d eyeVecRotated, RayTraceResultTriangle lookPart, double distanceShortest, float[] eyes, float[] direction, @Nullable List<RayTracePart> partsApplicable, boolean invalidateParts, Map<RayTracePart, TriangleRayTraceList> parts) {
        if (parts != null) {
            for (Map.Entry<RayTracePart, TriangleRayTraceList> entry : parts.entrySet()) {
                if (partsApplicable != null && invalidateParts == partsApplicable.contains(entry.getKey())) continue;
                RayTracePart part = entry.getKey();
                for (TriangleRayTrace triangle : entry.getValue().getTriangles(part, entity)) {
                    double distance;
                    RayTraceResultTriangle lookObjectPutative = RayTraceResultTriangle.calculateIntercept(eyes, direction, pos, triangle.getData(), part);
                    if (lookObjectPutative == null || !((distance = lookObjectPutative.calculateAndSaveDistance(eyeVecRotated)) < distanceShortest)) continue;
                    lookPart = lookObjectPutative;
                    distanceShortest = distance;
                }
            }
        }
        return lookPart;
    }

    private static Vec3d rotateVecXZ(Vec3d vec, double angle, Vec3d rotationPoint) {
        double x = rotationPoint.field_72450_a + Math.cos(angle) * (vec.field_72450_a - rotationPoint.field_72450_a) - Math.sin(angle) * (vec.field_72449_c - rotationPoint.field_72449_c);
        double z = rotationPoint.field_72449_c + Math.sin(angle) * (vec.field_72450_a - rotationPoint.field_72450_a) + Math.cos(angle) * (vec.field_72449_c - rotationPoint.field_72449_c);
        return new Vec3d(x, vec.field_72448_b, z);
    }

    public static <T extends VehicleEntity> void renderRaytraceElements(T entity, double x, double y, double z, float yaw) {
        if (((Boolean)Config.CLIENT.renderOutlines.get()).booleanValue()) {
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)x, (double)y, (double)z);
            GlStateManager.rotatef((float)(-yaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.enableBlend();
            GlStateManager.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.lineWidth((float)2.0f);
            GlStateManager.disableTexture();
            GlStateManager.disableLighting();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buffer = tessellator.func_178180_c();
            EntityRaytracer.renderRaytraceTriangles(entity, tessellator, buffer, entityRaytraceTrianglesStatic);
            EntityRaytracer.renderRaytraceTriangles(entity, tessellator, buffer, entityRaytraceTrianglesDynamic);
            ((IEntityRaytraceable)((Object)entity)).drawInteractionBoxes(tessellator, buffer);
            GlStateManager.enableLighting();
            GlStateManager.enableTexture();
            GlStateManager.disableBlend();
            GlStateManager.popMatrix();
        }
    }

    private static <T extends VehicleEntity> void renderRaytraceTriangles(T entity, Tessellator tessellator, BufferBuilder buffer, Map<EntityType<? extends IEntityRaytraceable>, Map<RayTracePart, TriangleRayTraceList>> entityTriangles) {
        Map<RayTracePart, TriangleRayTraceList> map = entityTriangles.get(entity.func_200600_R());
        if (map != null) {
            List<RayTracePart> partsNonApplicable = ((IEntityRaytraceable)((Object)entity)).getNonApplicableParts();
            for (Map.Entry<RayTracePart, TriangleRayTraceList> entry : map.entrySet()) {
                if (partsNonApplicable != null && partsNonApplicable.contains(entry.getKey())) continue;
                for (TriangleRayTrace triangle : entry.getValue().getTriangles(entry.getKey(), entity)) {
                    triangle.draw(tessellator, buffer, 1.0f, 0.0f, 0.0f, 0.4f);
                }
            }
        }
    }

    public static TriangleRayTraceList boxToTriangles(AxisAlignedBB box, @Nullable BiFunction<RayTracePart, Entity, Matrix4d> matrixFactory) {
        ArrayList triangles = Lists.newArrayList();
        EntityRaytracer.getTrianglesFromQuadAndAdd(triangles, box.field_72340_a, box.field_72337_e, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72339_c, box.field_72336_d, box.field_72338_b, box.field_72339_c, box.field_72340_a, box.field_72338_b, box.field_72339_c);
        EntityRaytracer.getTrianglesFromQuadAndAdd(triangles, box.field_72336_d, box.field_72337_e, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f, box.field_72336_d, box.field_72338_b, box.field_72334_f, box.field_72336_d, box.field_72338_b, box.field_72339_c);
        EntityRaytracer.getTrianglesFromQuadAndAdd(triangles, box.field_72336_d, box.field_72337_e, box.field_72334_f, box.field_72340_a, box.field_72337_e, box.field_72334_f, box.field_72340_a, box.field_72338_b, box.field_72334_f, box.field_72336_d, box.field_72338_b, box.field_72334_f);
        EntityRaytracer.getTrianglesFromQuadAndAdd(triangles, box.field_72340_a, box.field_72337_e, box.field_72334_f, box.field_72340_a, box.field_72337_e, box.field_72339_c, box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72340_a, box.field_72338_b, box.field_72334_f);
        EntityRaytracer.getTrianglesFromQuadAndAdd(triangles, box.field_72340_a, box.field_72337_e, box.field_72334_f, box.field_72336_d, box.field_72337_e, box.field_72334_f, box.field_72336_d, box.field_72337_e, box.field_72339_c, box.field_72340_a, box.field_72337_e, box.field_72339_c);
        EntityRaytracer.getTrianglesFromQuadAndAdd(triangles, box.field_72336_d, box.field_72338_b, box.field_72334_f, box.field_72340_a, box.field_72338_b, box.field_72334_f, box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72338_b, box.field_72339_c);
        return new TriangleRayTraceList(triangles, matrixFactory);
    }

    public static TriangleRayTraceList boxToTriangles(AxisAlignedBB box) {
        return EntityRaytracer.boxToTriangles(box, null);
    }

    private static void getTrianglesFromQuadAndAdd(List<TriangleRayTrace> triangles, double ... data) {
        int size = 3;
        float[] triangle1 = new float[9];
        float[] triangle2 = new float[9];
        triangle1[0] = (float)data[0];
        triangle1[1] = (float)data[1];
        triangle1[2] = (float)data[2];
        triangle1[3] = triangle2[6] = (float)data[size];
        triangle1[4] = triangle2[7] = (float)data[size + 1];
        triangle1[5] = triangle2[8] = (float)data[size + 2];
        triangle2[0] = (float)data[size *= 2];
        triangle2[1] = (float)data[size + 1];
        triangle2[2] = (float)data[size + 2];
        size = (int)((double)size * 1.5);
        triangle1[6] = triangle2[3] = (float)data[size];
        triangle1[7] = triangle2[4] = (float)data[size + 1];
        triangle1[8] = triangle2[5] = (float)data[size + 2];
        EntityRaytracer.transformTriangleAndAdd(triangle1, null, triangles);
        EntityRaytracer.transformTriangleAndAdd(triangle2, null, triangles);
    }

    static {
        entityRaytraceTrianglesStatic = Maps.newHashMap();
        entityRaytraceTrianglesDynamic = Maps.newHashMap();
        entityRaytraceTriangles = new HashMap<EntityType<? extends IEntityRaytraceable>, Map<RayTracePart, TriangleRayTraceList>>();
        entityCrateScalesAndOffsets = new HashMap<EntityType<? extends IEntityRaytraceable>, Pair<Float, Float>>();
        SCALE_AND_OFFSET_DEFAULT = new ImmutablePair((Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.0f));
        FUNCTION_FUELING = rayTraceResult -> {
            PoweredVehicleEntity poweredVehicle;
            Entity entity;
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (SyncedPlayerData.getGasPumpPos((PlayerEntity)player).isPresent() && ControllerEvents.isRightClicking() && (entity = rayTraceResult.func_216348_a()) instanceof PoweredVehicleEntity && (poweredVehicle = (PoweredVehicleEntity)entity).requiresFuel() && poweredVehicle.getCurrentFuel() < poweredVehicle.getFuelCapacity()) {
                if (continuousInteractionTickCounter % 2 == 0) {
                    PacketHandler.instance.sendToServer((Object)new MessageFuelVehicle(rayTraceResult.func_216348_a().func_145782_y(), Hand.MAIN_HAND));
                    poweredVehicle.fuelVehicle((PlayerEntity)player, Hand.MAIN_HAND);
                }
                return Hand.MAIN_HAND;
            }
            for (Hand hand : Hand.values()) {
                int fuel;
                PoweredVehicleEntity poweredVehicle2;
                Entity entity2;
                ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_184586_b(hand);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof JerryCanItem) || !ControllerEvents.isRightClicking() || !((entity2 = rayTraceResult.func_216348_a()) instanceof PoweredVehicleEntity) || !(poweredVehicle2 = (PoweredVehicleEntity)entity2).requiresFuel() || !(poweredVehicle2.getCurrentFuel() < poweredVehicle2.getFuelCapacity()) || (fuel = ((JerryCanItem)stack.func_77973_b()).getCurrentFuel(stack)) <= 0) continue;
                if (continuousInteractionTickCounter % 2 == 0) {
                    PacketHandler.instance.sendToServer((Object)new MessageFuelVehicle(entity2.func_145782_y(), hand));
                }
                return hand;
            }
            return null;
        };
    }

    public static interface IEntityRaytraceable {
        @OnlyIn(value=Dist.CLIENT)
        default public boolean processHit(RayTraceResultRotated result, boolean rightClick) {
            boolean isContinuous;
            if (result.getPartHit().getModel() == SpecialModels.KEY_HOLE) {
                PacketHandler.instance.sendToServer((Object)new MessageInteractKey((Entity)this));
                return true;
            }
            Minecraft mc = Minecraft.func_71410_x();
            boolean bl = isContinuous = result.partHit.getContinuousInteraction() != null;
            if (isContinuous || mc.field_71476_x == null || mc.field_71476_x.func_216346_c() != RayTraceResult.Type.ENTITY || ((EntityRayTraceResult)mc.field_71476_x).func_216348_a() != this) {
                boolean notRiding;
                ClientPlayerEntity player = mc.field_71439_g;
                boolean bl2 = notRiding = player.func_184187_bx() != this;
                if (!rightClick && notRiding) {
                    mc.field_71442_b.func_78764_a((PlayerEntity)player, (Entity)this);
                    return true;
                }
                if (result.getPartHit().model != null || result.getPartHit().partStack != null) {
                    if (notRiding) {
                        if (player.func_70093_af() && !player.func_175149_v()) {
                            PacketHandler.instance.sendToServer((Object)new MessagePickupVehicle((Entity)this));
                            return true;
                        }
                        if (!isContinuous) {
                            EntityRaytracer.interactWithEntity(this, result);
                        }
                    }
                    return notRiding;
                }
            }
            return false;
        }

        @OnlyIn(value=Dist.CLIENT)
        default public Map<RayTracePart, TriangleRayTraceList> getStaticInteractionBoxMap() {
            return Maps.newHashMap();
        }

        @OnlyIn(value=Dist.CLIENT)
        default public Map<RayTracePart, TriangleRayTraceList> getDynamicInteractionBoxMap() {
            return Maps.newHashMap();
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        default public List<RayTracePart> getApplicableInteractionBoxes() {
            return null;
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        default public List<RayTracePart> getNonApplicableParts() {
            return null;
        }

        @OnlyIn(value=Dist.CLIENT)
        default public void drawInteractionBoxes(Tessellator tessellator, BufferBuilder buffer) {
        }
    }

    public static class RayTraceResultRotated
    extends EntityRayTraceResult {
        private final RayTracePart partHit;
        private final double distanceToEyes;
        private final boolean rightClick;

        private RayTraceResultRotated(Entity entityHit, Vec3d hitVec, double distanceToEyes, RayTracePart partHit, boolean rightClick) {
            super(entityHit, hitVec);
            this.distanceToEyes = distanceToEyes;
            this.partHit = partHit;
            this.rightClick = rightClick;
        }

        public RayTracePart getPartHit() {
            return this.partHit;
        }

        public double getDistanceToEyes() {
            return this.distanceToEyes;
        }

        public boolean isRightClick() {
            return this.rightClick;
        }

        public Object performContinuousInteraction() {
            return this.partHit.getContinuousInteraction() == null ? null : this.partHit.getContinuousInteraction().apply(this);
        }

        public <R> boolean equalsContinuousInteraction(Function<RayTraceResultRotated, R> function) {
            return function.equals(this.partHit.getContinuousInteraction());
        }
    }

    public static class RayTracePart<R> {
        private final ItemStack partStack;
        private final AxisAlignedBB partBox;
        private final ISpecialModel model;
        private final Function<RayTraceResultRotated, R> continuousInteraction;

        public RayTracePart(ItemStack partStack, @Nullable Function<RayTraceResultRotated, R> continuousInteraction) {
            this(partStack, null, null, continuousInteraction);
        }

        public RayTracePart(AxisAlignedBB partBox, @Nullable Function<RayTraceResultRotated, R> continuousInteraction) {
            this(ItemStack.field_190927_a, partBox, null, continuousInteraction);
        }

        public RayTracePart(ISpecialModel model, @Nullable Function<RayTraceResultRotated, R> continuousInteraction) {
            this(ItemStack.field_190927_a, null, model, continuousInteraction);
        }

        public RayTracePart(AxisAlignedBB partBox) {
            this(ItemStack.field_190927_a, partBox, null, null);
        }

        private RayTracePart(ItemStack partStack, @Nullable AxisAlignedBB partBox, @Nullable ISpecialModel model, @Nullable Function<RayTraceResultRotated, R> continuousInteraction) {
            this.partStack = partStack;
            this.partBox = partBox;
            this.model = model;
            this.continuousInteraction = continuousInteraction;
        }

        public ItemStack getStack() {
            return this.partStack;
        }

        @Nullable
        public AxisAlignedBB getBox() {
            return this.partBox;
        }

        @Nullable
        public ISpecialModel getModel() {
            return this.model;
        }

        public Function<RayTraceResultRotated, R> getContinuousInteraction() {
            return this.continuousInteraction;
        }
    }

    private static class RayTraceResultTriangle {
        private static final float EPSILON = 1.0E-6f;
        private final float x;
        private final float y;
        private final float z;
        private final RayTracePart part;
        private double distance;

        public RayTraceResultTriangle(RayTracePart part, float x, float y, float z) {
            this.part = part;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Vec3d getHit() {
            return new Vec3d((double)this.x, (double)this.y, (double)this.z);
        }

        public RayTracePart getPart() {
            return this.part;
        }

        public double calculateAndSaveDistance(Vec3d eyeVec) {
            this.distance = eyeVec.func_72438_d(this.getHit());
            return this.distance;
        }

        public double getDistance() {
            return this.distance;
        }

        public static RayTraceResultTriangle calculateIntercept(float[] eyes, float[] direction, Vec3d posEntity, float[] data, RayTracePart part) {
            float[] vec0 = new float[]{data[0] + (float)posEntity.field_72450_a, data[1] + (float)posEntity.field_72448_b, data[2] + (float)posEntity.field_72449_c};
            float[] vec1 = new float[]{data[3] + (float)posEntity.field_72450_a, data[4] + (float)posEntity.field_72448_b, data[5] + (float)posEntity.field_72449_c};
            float[] vec2 = new float[]{data[6] + (float)posEntity.field_72450_a, data[7] + (float)posEntity.field_72448_b, data[8] + (float)posEntity.field_72449_c};
            float[] edge1 = new float[3];
            float[] edge2 = new float[3];
            float[] tvec = new float[3];
            float[] pvec = new float[3];
            float[] qvec = new float[3];
            RayTraceResultTriangle.subtract(edge1, vec1, vec0);
            RayTraceResultTriangle.subtract(edge2, vec2, vec0);
            RayTraceResultTriangle.crossProduct(pvec, direction, edge2);
            float det = RayTraceResultTriangle.dotProduct(edge1, pvec);
            if (det <= -1.0E-6f || det >= 1.0E-6f) {
                float inv_det = 1.0f / det;
                RayTraceResultTriangle.subtract(tvec, eyes, vec0);
                float u = RayTraceResultTriangle.dotProduct(tvec, pvec) * inv_det;
                if (u >= 0.0f && u <= 1.0f) {
                    RayTraceResultTriangle.crossProduct(qvec, tvec, edge1);
                    float v = RayTraceResultTriangle.dotProduct(direction, qvec) * inv_det;
                    if (v >= 0.0f && u + v <= 1.0f && inv_det * RayTraceResultTriangle.dotProduct(edge2, qvec) > 1.0E-6f) {
                        return new RayTraceResultTriangle(part, edge1[0] * u + edge2[0] * v + vec0[0], edge1[1] * u + edge2[1] * v + vec0[1], edge1[2] * u + edge2[2] * v + vec0[2]);
                    }
                }
            }
            return null;
        }

        private static void crossProduct(float[] result, float[] v1, float[] v2) {
            result[0] = v1[1] * v2[2] - v1[2] * v2[1];
            result[1] = v1[2] * v2[0] - v1[0] * v2[2];
            result[2] = v1[0] * v2[1] - v1[1] * v2[0];
        }

        private static float dotProduct(float[] v1, float[] v2) {
            return v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
        }

        private static void subtract(float[] result, float[] v1, float[] v2) {
            result[0] = v1[0] - v2[0];
            result[1] = v1[1] - v2[1];
            result[2] = v1[2] - v2[2];
        }
    }

    public static class TriangleRayTraceList {
        private final List<TriangleRayTrace> triangles;
        private final BiFunction<RayTracePart, Entity, Matrix4d> matrixFactory;

        public TriangleRayTraceList(List<TriangleRayTrace> triangles) {
            this(triangles, null);
        }

        public TriangleRayTraceList(List<TriangleRayTrace> triangles, @Nullable BiFunction<RayTracePart, Entity, Matrix4d> matrixFactory) {
            this.triangles = triangles;
            this.matrixFactory = matrixFactory;
        }

        public List<TriangleRayTrace> getTriangles(RayTracePart part, Entity entity) {
            if (this.matrixFactory != null) {
                ArrayList triangles = Lists.newArrayList();
                Matrix4d matrix = this.matrixFactory.apply(part, entity);
                for (TriangleRayTrace triangle : this.triangles) {
                    triangles.add(new TriangleRayTrace(EntityRaytracer.getTransformedTriangle(triangle.getData(), matrix)));
                }
                return triangles;
            }
            return this.triangles;
        }

        public List<TriangleRayTrace> getTriangles() {
            return this.triangles;
        }
    }

    public static class TriangleRayTrace {
        private final float[] data;

        public TriangleRayTrace(float[] data) {
            this.data = data;
        }

        public float[] getData() {
            return this.data;
        }

        public void draw(Tessellator tessellator, BufferBuilder buffer, float red, float green, float blue, float alpha) {
            buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
            buffer.func_181662_b((double)this.data[6], (double)this.data[7], (double)this.data[8]).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b((double)this.data[0], (double)this.data[1], (double)this.data[2]).func_181666_a(red, green, blue, alpha).func_181675_d();
            buffer.func_181662_b((double)this.data[3], (double)this.data[4], (double)this.data[5]).func_181666_a(red, green, blue, alpha).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    public static class MatrixTransformation {
        private final MatrixTransformationType type;
        private double x;
        private double y;
        private double z;
        private double angle;

        public MatrixTransformation(MatrixTransformationType type, double x, double y, double z) {
            this.type = type;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public MatrixTransformation(MatrixTransformationType type, double x, double y, double z, double angle) {
            this(type, x, y, z);
            this.angle = angle;
        }

        public static MatrixTransformation createTranslation(double x, double y, double z) {
            return new MatrixTransformation(MatrixTransformationType.TRANSLATION, x, y, z);
        }

        public static MatrixTransformation createRotation(double angle, double x, double y, double z) {
            return new MatrixTransformation(MatrixTransformationType.ROTATION, x, y, z, angle);
        }

        public static MatrixTransformation createScale(double x, double y, double z) {
            return new MatrixTransformation(MatrixTransformationType.SCALE, x, y, z);
        }

        public static MatrixTransformation createScale(double xyz) {
            return new MatrixTransformation(MatrixTransformationType.SCALE, xyz, xyz, xyz);
        }

        public void transform(Matrix4d matrix) {
            Matrix4d temp = new Matrix4d();
            switch (this.type) {
                case ROTATION: {
                    temp.set(new AxisAngle4d(this.x, this.y, this.z, (double)((float)Math.toRadians(this.angle))));
                    break;
                }
                case TRANSLATION: {
                    temp.set(new Vector3d(this.x, this.y, this.z));
                    break;
                }
                case SCALE: {
                    Vector3d scaleVec = new Vector3d(this.x, this.y, this.z);
                    temp.setIdentity();
                    temp.m00 = scaleVec.x;
                    temp.m11 = scaleVec.y;
                    temp.m22 = scaleVec.z;
                }
            }
            matrix.mul(temp);
        }

        private static enum MatrixTransformationType {
            TRANSLATION,
            ROTATION,
            SCALE;

        }
    }
}

