/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client;

import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Action;
import com.mrcrayfish.controllable.event.AvailableActionsEvent;
import com.mrcrayfish.controllable.event.ControllerEvent;
import com.mrcrayfish.controllable.event.RenderPlayerPreviewEvent;
import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.entity.HelicopterEntity;
import com.mrcrayfish.vehicle.entity.LandVehicleEntity;
import com.mrcrayfish.vehicle.entity.PlaneEntity;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageHitchTrailer;
import com.mrcrayfish.vehicle.proxy.ClientProxy;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
public class ControllerEvents {
    @SubscribeEvent
    public void onButtonInput(ControllerEvent.ButtonInput event) {
        if (event.getState()) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (player == null) {
                return;
            }
            switch (event.getButton()) {
                case 0: {
                    if (!(player.func_184187_bx() instanceof PoweredVehicleEntity)) break;
                    event.setCanceled(true);
                    break;
                }
                case 2: {
                    if (Minecraft.func_71410_x().field_71462_r != null || !(player.func_184187_bx() instanceof VehicleEntity)) break;
                    VehicleEntity vehicle = (VehicleEntity)player.func_184187_bx();
                    if (vehicle.canTowTrailer()) {
                        PacketHandler.instance.sendToServer((Object)new MessageHitchTrailer(vehicle.getTrailer() == null));
                    }
                    event.setCanceled(true);
                    break;
                }
                case 4: {
                    if (!(player.func_184187_bx() instanceof VehicleEntity)) break;
                    player.field_70177_z = player.func_184187_bx().field_70177_z;
                    player.field_70125_A = 15.0f;
                    event.setCanceled(true);
                    break;
                }
                case 9: 
                case 10: {
                    if (!(player.func_184187_bx() instanceof VehicleEntity)) break;
                    event.setCanceled(true);
                    break;
                }
                case 11: 
                case 12: {
                    if (!((Boolean)Config.CLIENT.useTriggers.get()).booleanValue() || !(player.func_184187_bx() instanceof VehicleEntity)) break;
                    event.setCanceled(true);
                    break;
                }
            }
        }
    }

    @SubscribeEvent
    public void onControllerMove(ControllerEvent.Move event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184187_bx() instanceof VehicleEntity) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onAvailableActions(AvailableActionsEvent event) {
        Entity entity;
        Map availableActions = event.getActions();
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player.func_184187_bx() instanceof VehicleEntity && mc.field_71462_r == null) {
            availableActions.remove(10);
            availableActions.remove(9);
            availableActions.remove(12);
            availableActions.remove(11);
            availableActions.remove(7);
            availableActions.remove(2);
            availableActions.remove(14);
            availableActions.put(7, new Action("Exit Vehicle", Action.Side.LEFT));
            if (((Boolean)Config.CLIENT.useTriggers.get()).booleanValue()) {
                availableActions.put(12, new Action("Accelerate", Action.Side.RIGHT));
            } else {
                availableActions.put(0, new Action("Accelerate", Action.Side.RIGHT));
            }
            VehicleEntity vehicle = (VehicleEntity)player.func_184187_bx();
            if (vehicle instanceof PoweredVehicleEntity) {
                int button;
                int n = button = (Boolean)Config.CLIENT.useTriggers.get() != false ? 11 : 1;
                if (((PoweredVehicleEntity)vehicle).getSpeed() > 0.05f) {
                    availableActions.put(button, new Action("Brake", Action.Side.RIGHT));
                } else {
                    availableActions.put(button, new Action("Reverse", Action.Side.RIGHT));
                }
            }
            if (vehicle instanceof LandVehicleEntity) {
                availableActions.put(10, new Action("Drift", Action.Side.RIGHT));
            } else if (vehicle instanceof PlaneEntity) {
                availableActions.put(10, new Action("Pull Up", Action.Side.RIGHT));
                availableActions.put(9, new Action("Pull Down", Action.Side.RIGHT));
            } else if (vehicle instanceof HelicopterEntity) {
                availableActions.put(10, new Action("Increase Elevation", Action.Side.RIGHT));
                availableActions.put(9, new Action("Decreased Elevation", Action.Side.RIGHT));
            }
        } else if (player.func_184187_bx() == null && mc.field_71476_x != null && mc.field_71476_x.func_216346_c() == RayTraceResult.Type.ENTITY && (entity = ((EntityRayTraceResult)mc.field_71476_x).func_216348_a()) instanceof VehicleEntity) {
            availableActions.put(11, new Action("Ride Vehicle", Action.Side.RIGHT));
        }
    }

    @SubscribeEvent
    public void onRenderPlayerPreview(RenderPlayerPreviewEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.func_184187_bx() instanceof VehicleEntity) {
            event.setCanceled(true);
        }
    }

    public static boolean isRightClicking() {
        boolean isRightClicking = GLFW.glfwGetMouseButton((long)Minecraft.func_71410_x().field_195558_d.func_198092_i(), (int)1) == 1;
        return isRightClicking |= ClientProxy.controllableLoaded && Controllable.getController() != null && Controllable.getController().getLTriggerValue() != 0.0f;
    }
}

