/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mrcrayfish.obfuscate.client.event.PlayerModelEvent;
import com.mrcrayfish.obfuscate.client.event.RenderItemEvent;
import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.client.EntityRaytracer;
import com.mrcrayfish.vehicle.client.SpecialModels;
import com.mrcrayfish.vehicle.client.render.AbstractRenderVehicle;
import com.mrcrayfish.vehicle.client.render.VehicleRenderRegistry;
import com.mrcrayfish.vehicle.common.entity.SyncedPlayerData;
import com.mrcrayfish.vehicle.entity.PoweredVehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleEntity;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.init.ModSounds;
import com.mrcrayfish.vehicle.item.SprayCanItem;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.network.message.MessageCycleSeats;
import com.mrcrayfish.vehicle.network.message.MessageHitchTrailer;
import com.mrcrayfish.vehicle.proxy.ClientProxy;
import com.mrcrayfish.vehicle.util.RenderUtil;
import java.awt.Color;
import java.text.DecimalFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEvents {
    private int lastSlot = -1;
    private int originalPerspective = -1;
    private double fuelingHandOffset;
    private int tickCounter;
    private boolean fueling;
    private double offsetPrev;
    private double offsetPrevPrev;
    private boolean shouldRenderNozzle;

    @SubscribeEvent
    public void onEntityMount(EntityMountEvent event) {
        if (((Boolean)Config.CLIENT.autoPerspective.get()).booleanValue() && event.getWorldObj().field_72995_K && event.getEntityMounting().equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            if (event.isMounting()) {
                Entity entity = event.getEntityBeingMounted();
                if (entity instanceof VehicleEntity) {
                    this.originalPerspective = Minecraft.func_71410_x().field_71474_y.field_74320_O;
                    Minecraft.func_71410_x().field_71474_y.field_74320_O = 1;
                }
            } else if (this.originalPerspective != -1) {
                Minecraft.func_71410_x().field_71474_y.field_74320_O = this.originalPerspective;
                this.originalPerspective = -1;
            }
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        Entity entity;
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (((Boolean)Config.CLIENT.autoPerspective.get()).booleanValue() && (entity = Minecraft.func_71410_x().field_71439_g.func_184187_bx()) instanceof VehicleEntity && Minecraft.func_71410_x().field_71474_y.field_151457_aa.func_151470_d()) {
            this.originalPerspective = -1;
        }
        if (ClientProxy.KEY_CYCLE_SEATS.func_151468_f() && event.getAction() == 1 && Minecraft.func_71410_x().field_71439_g.func_184187_bx() instanceof VehicleEntity) {
            PacketHandler.instance.sendToServer((Object)new MessageCycleSeats());
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        Entity entity;
        ClientPlayerEntity player;
        Minecraft mc;
        if (((Boolean)Config.CLIENT.enabledSpeedometer.get()).booleanValue() && event.phase == TickEvent.Phase.END && (mc = Minecraft.func_71410_x()).func_195544_aj() && !mc.field_71474_y.field_74319_N && (player = mc.field_71439_g) != null && (entity = player.func_184187_bx()) instanceof PoweredVehicleEntity) {
            PoweredVehicleEntity vehicle = (PoweredVehicleEntity)entity;
            String speed = new DecimalFormat("0.0").format(vehicle.getKilometersPreHour());
            mc.field_71466_p.func_175063_a(TextFormatting.BOLD + "BPS: " + TextFormatting.YELLOW + speed, 10.0f, 10.0f, Color.WHITE.getRGB());
            if (vehicle.requiresFuel()) {
                DecimalFormat format = new DecimalFormat("0.0");
                String fuel = format.format(vehicle.getCurrentFuel()) + "/" + format.format(vehicle.getFuelCapacity());
                mc.field_71466_p.func_175063_a(TextFormatting.BOLD + "Fuel: " + TextFormatting.YELLOW + fuel, 10.0f, 25.0f, Color.WHITE.getRGB());
            }
        }
    }

    @SubscribeEvent
    public void onFovUpdate(FOVUpdateEvent event) {
        Entity ridingEntity = Minecraft.func_71410_x().field_71439_g.func_184187_bx();
        if (ridingEntity instanceof VehicleEntity) {
            event.setNewfov(1.0f);
        }
    }

    @SubscribeEvent
    public void onPreRender(PlayerModelEvent.Render.Pre event) {
        VehicleEntity vehicle;
        AbstractRenderVehicle<?> render;
        PlayerEntity player = event.getPlayer();
        Entity ridingEntity = player.func_184187_bx();
        if (ridingEntity instanceof VehicleEntity && (render = VehicleRenderRegistry.getRender((EntityType<? extends VehicleEntity>)(vehicle = (VehicleEntity)ridingEntity).func_200600_R())) != null) {
            render.applyPlayerRender(vehicle, player, event.getPartialTicks());
        }
    }

    @SubscribeEvent
    public void onSetupAngles(PlayerModelEvent.SetupAngles.Post event) {
        VehicleEntity vehicle;
        AbstractRenderVehicle<?> render;
        PlayerEntity player = event.getPlayer();
        if (player.equals((Object)Minecraft.func_71410_x().field_71439_g) && Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
            return;
        }
        Entity ridingEntity = player.func_184187_bx();
        PlayerModel model = event.getModelPlayer();
        if (SyncedPlayerData.getGasPumpPos(player).isPresent()) {
            boolean rightHanded;
            boolean bl = rightHanded = player.func_184591_cq() == HandSide.RIGHT;
            if (rightHanded) {
                model.field_178723_h.field_78795_f = (float)Math.toRadians(-20.0);
                model.field_178723_h.field_78796_g = (float)Math.toRadians(0.0);
                model.field_178723_h.field_78808_h = (float)Math.toRadians(0.0);
            } else {
                model.field_178724_i.field_78795_f = (float)Math.toRadians(-20.0);
                model.field_178724_i.field_78796_g = (float)Math.toRadians(0.0);
                model.field_178724_i.field_78808_h = (float)Math.toRadians(0.0);
            }
            return;
        }
        if (player.func_184187_bx() != null) {
            ItemStack leftItem;
            boolean rightHanded = player.func_184591_cq() == HandSide.RIGHT;
            ItemStack rightItem = rightHanded ? player.func_184614_ca() : player.func_184592_cb();
            ItemStack itemStack = leftItem = rightHanded ? player.func_184592_cb() : player.func_184614_ca();
            if (!rightItem.func_190926_b() && rightItem.func_77973_b() instanceof SprayCanItem) {
                ClientEvents.copyModelAngles(model.field_78116_c, model.field_178723_h);
                model.field_178723_h.field_78795_f = (float)((double)model.field_178723_h.field_78795_f + Math.toRadians(-80.0));
            }
            if (!leftItem.func_190926_b() && leftItem.func_77973_b() instanceof SprayCanItem) {
                model.field_178724_i.func_217177_a(model.field_78116_c);
                model.field_178724_i.field_78795_f = (float)((double)model.field_178724_i.field_78795_f + Math.toRadians(-80.0));
            }
        }
        if (ridingEntity != null && ridingEntity instanceof VehicleEntity && (render = VehicleRenderRegistry.getRender((EntityType<? extends VehicleEntity>)(vehicle = (VehicleEntity)ridingEntity).func_200600_R())) != null) {
            render.applyPlayerModel(vehicle, player, (PlayerModel<AbstractClientPlayerEntity>)model, event.getPartialTicks());
            return;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void copyModelAngles(RendererModel source, RendererModel dest) {
        dest.field_78795_f = source.field_78795_f;
        dest.field_78796_g = source.field_78796_g;
        dest.field_78808_h = source.field_78808_h;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (event.phase == TickEvent.Phase.END && player != null) {
            int slot;
            if (((Boolean)Config.CLIENT.reloadVehiclePropertiesEachTick.get()).booleanValue()) {
                VehicleProperties.register();
            }
            if (this.lastSlot != (slot = player.field_71071_by.field_70461_c)) {
                this.lastSlot = slot;
                if (!player.field_71071_by.func_70448_g().func_190926_b() && player.field_71071_by.func_70448_g().func_77973_b() instanceof SprayCanItem) {
                    SprayCanItem sprayCan = (SprayCanItem)player.field_71071_by.func_70448_g().func_77973_b();
                    float pitch = 0.85f + 0.15f * sprayCan.getRemainingSprays(player.field_71071_by.func_70448_g());
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)((SoundEvent)ModSounds.SPRAY_CAN_SHAKE.get()), (float)pitch, (float)0.75f));
                }
            }
            if (player.func_184187_bx() == null) {
                this.originalPerspective = -1;
            }
            ++this.tickCounter;
            EntityRaytracer.RayTraceResultRotated result = EntityRaytracer.getContinuousInteraction();
            if (result != null && result.equalsContinuousInteraction(EntityRaytracer.FUNCTION_FUELING)) {
                if (!this.fueling) {
                    this.tickCounter = 0;
                    this.fueling = true;
                }
            } else {
                this.fueling = false;
            }
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderSpecificHandEvent event) {
        ClientPlayerEntity player;
        if (event.getHand() == Hand.OFF_HAND && this.fuelingHandOffset > -1.0) {
            GlStateManager.rotatef((float)25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.translated((double)0.0, (double)(-0.35 - this.fuelingHandOffset), (double)0.2);
        }
        if (event.getItemStack().func_190926_b() || event.getItemStack().func_77973_b() instanceof SprayCanItem) {
            // empty if block
        }
        this.fuelingHandOffset = -1.0;
        EntityRaytracer.RayTraceResultRotated result = EntityRaytracer.getContinuousInteraction();
        if (result != null && result.equalsContinuousInteraction(EntityRaytracer.FUNCTION_FUELING) && event.getHand() == EntityRaytracer.getContinuousInteractionObject()) {
            double offset = Math.sin((double)((float)this.tickCounter + Minecraft.func_71410_x().func_184121_ak()) * 0.4) * 0.01;
            if (this.offsetPrev > this.offsetPrevPrev && this.offsetPrev > offset) {
                Minecraft.func_71410_x().field_71439_g.func_184185_a((SoundEvent)ModSounds.LIQUID_GLUG.get(), 0.3f, 1.0f);
            }
            this.offsetPrevPrev = this.offsetPrev;
            this.offsetPrev = offset;
            GlStateManager.translated((double)0.0, (double)(0.35 + offset), (double)-0.2);
            GlStateManager.rotatef((float)-25.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            if (event.getHand() == Hand.MAIN_HAND) {
                this.fuelingHandOffset = offset;
            }
        }
        if (SyncedPlayerData.getGasPumpPos((PlayerEntity)(player = Minecraft.func_71410_x().field_71439_g)).isPresent()) {
            if (event.getSwingProgress() > 0.0f) {
                this.shouldRenderNozzle = true;
            }
            if (event.getHand() == Hand.MAIN_HAND && this.shouldRenderNozzle) {
                if (event.getSwingProgress() > 0.0f && (double)event.getSwingProgress() <= 0.25) {
                    return;
                }
                GlStateManager.pushMatrix();
                boolean mainHand = event.getHand() == Hand.MAIN_HAND;
                HandSide handSide = mainHand ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
                int handOffset = handSide == HandSide.RIGHT ? 1 : -1;
                GlStateManager.translated((double)((double)handOffset * 0.65), (double)-0.27, (double)-0.72);
                GlStateManager.rotatef((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                RenderUtil.renderColoredModel(SpecialModels.NOZZLE.getModel(), ItemCameraTransforms.TransformType.NONE, false, -1);
                GlStateManager.popMatrix();
                event.setCanceled(true);
            }
        } else {
            this.shouldRenderNozzle = false;
        }
    }

    @SubscribeEvent
    public void onRenderThirdPerson(RenderItemEvent.Held.Pre event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof PlayerEntity && SyncedPlayerData.getGasPumpPos((PlayerEntity)entity).isPresent()) {
            event.setCanceled(true);
            return;
        }
        if (event.getItem().func_190926_b() || event.getItem().func_77973_b() instanceof SprayCanItem) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onModelRenderPost(PlayerModelEvent.Render.Post event) {
        PlayerEntity entity = event.getPlayer();
        if (SyncedPlayerData.getGasPumpPos(entity).isPresent()) {
            GlStateManager.pushMatrix();
            if (event.getModelPlayer().field_217114_e) {
                GlStateManager.translated((double)0.0, (double)0.75, (double)0.0);
                GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            }
            GlStateManager.pushMatrix();
            if (entity.func_70093_af()) {
                GlStateManager.translated((double)0.0, (double)0.2, (double)0.0);
            }
            event.getModelPlayer().func_187073_a(0.0625f, entity.func_184591_cq());
            GlStateManager.rotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.rotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            boolean leftHanded = entity.func_184591_cq() == HandSide.LEFT;
            GlStateManager.translated((double)((double)(leftHanded ? -1 : 1) / 16.0), (double)0.125, (double)-0.625);
            GlStateManager.translated((double)0.0, (double)-0.5625, (double)0.359375);
            RenderUtil.renderColoredModel(SpecialModels.NOZZLE.getModel(), ItemCameraTransforms.TransformType.NONE, false, -1);
            GlStateManager.popMatrix();
            GlStateManager.popMatrix();
        }
    }

    @SubscribeEvent
    public void renderCustomBlockHighlights(DrawBlockHighlightEvent.HighlightBlock event) {
    }

    private void boxRenderGlStart() {
    }

    private void boxRenderGlEnd() {
    }

    @SubscribeEvent
    public void setLiquidFogDensity(EntityViewRenderEvent.FogDensity event) {
        event.getInfo().getBlockAtCamera();
    }

    @SubscribeEvent
    public void onJump(InputEvent.KeyInputEvent event) {
        if (event.getAction() == 1 && event.getKey() == Minecraft.func_71410_x().field_71474_y.field_151444_V.getKey().func_197937_c()) {
            VehicleEntity vehicle;
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if (Minecraft.func_71410_x().field_71462_r == null && player.func_184187_bx() instanceof VehicleEntity && (vehicle = (VehicleEntity)player.func_184187_bx()).canTowTrailer()) {
                PacketHandler.instance.sendToServer((Object)new MessageHitchTrailer(vehicle.getTrailer() == null));
            }
        }
    }
}

