/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.vehicle;

import com.mrcrayfish.vehicle.Config;
import com.mrcrayfish.vehicle.block.BlockVehicleCrate;
import com.mrcrayfish.vehicle.common.CommonEvents;
import com.mrcrayfish.vehicle.common.ItemLookup;
import com.mrcrayfish.vehicle.common.entity.HeldVehicleDataHandler;
import com.mrcrayfish.vehicle.entity.CustomDataSerializers;
import com.mrcrayfish.vehicle.entity.EngineTier;
import com.mrcrayfish.vehicle.entity.VehicleProperties;
import com.mrcrayfish.vehicle.entity.WheelType;
import com.mrcrayfish.vehicle.init.ModBlocks;
import com.mrcrayfish.vehicle.init.ModContainers;
import com.mrcrayfish.vehicle.init.ModEntities;
import com.mrcrayfish.vehicle.init.ModFluids;
import com.mrcrayfish.vehicle.init.ModItems;
import com.mrcrayfish.vehicle.init.ModLootFunctions;
import com.mrcrayfish.vehicle.init.ModRecipeSerializers;
import com.mrcrayfish.vehicle.init.ModSounds;
import com.mrcrayfish.vehicle.init.ModTileEntities;
import com.mrcrayfish.vehicle.item.JerryCanItem;
import com.mrcrayfish.vehicle.item.SprayCanItem;
import com.mrcrayfish.vehicle.network.PacketHandler;
import com.mrcrayfish.vehicle.proxy.ClientProxy;
import com.mrcrayfish.vehicle.proxy.Proxy;
import com.mrcrayfish.vehicle.proxy.ServerProxy;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="vehicle")
public class VehicleMod {
    public static final Proxy PROXY = (Proxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    public static final ItemGroup CREATIVE_TAB = new ItemGroup("tabVehicle"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)ModItems.WOOD_SMALL_ENGINE.get());
        }

        public void func_78018_a(NonNullList<ItemStack> items) {
            super.func_78018_a(items);
            items.forEach(stack -> {
                if (stack.func_77973_b() instanceof JerryCanItem) {
                    JerryCanItem jerryCan = (JerryCanItem)stack.func_77973_b();
                    jerryCan.fill((ItemStack)stack, jerryCan.getCapacity((ItemStack)stack));
                } else if (stack.func_77973_b() instanceof SprayCanItem) {
                    SprayCanItem sprayCan = (SprayCanItem)stack.func_77973_b();
                    sprayCan.refill((ItemStack)stack);
                }
            });
            BlockVehicleCrate.REGISTERED_CRATES.forEach(resourceLocation -> {
                CompoundNBT blockEntityTag = new CompoundNBT();
                blockEntityTag.func_74778_a("Vehicle", resourceLocation.toString());
                blockEntityTag.func_74768_a("EngineTier", EngineTier.WOOD.ordinal());
                blockEntityTag.func_74768_a("WheelType", WheelType.STANDARD.ordinal());
                CompoundNBT itemTag = new CompoundNBT();
                itemTag.func_218657_a("BlockEntityTag", (INBT)blockEntityTag);
                ItemStack stack = new ItemStack((IItemProvider)ModBlocks.VEHICLE_CRATE.get());
                stack.func_77982_d(itemTag);
                items.add((Object)stack);
            });
        }
    };

    public VehicleMod() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBlocks.BLOCKS.register(eventBus);
        ModItems.ITEMS.register(eventBus);
        ModEntities.ENTITY_TYPES.register(eventBus);
        ModTileEntities.TILE_ENTITY_TYPES.register(eventBus);
        ModContainers.CONTAINER_TYPES.register(eventBus);
        ModSounds.SOUNDS.register(eventBus);
        ModRecipeSerializers.RECIPE_SERIALIZERS.register(eventBus);
        ModFluids.FLUIDS.register(eventBus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.serverSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.clientSpec);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCommonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        MinecraftForge.EVENT_BUS.register((Object)new CommonEvents());
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        PacketHandler.register();
        CustomDataSerializers.register();
        HeldVehicleDataHandler.register();
        VehicleProperties.register();
        ItemLookup.init();
        ModLootFunctions.register();
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        PROXY.setupClient();
    }
}

