/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.core;

import biomesoplenty.common.command.BOPCommand;
import biomesoplenty.core.ClientProxy;
import biomesoplenty.core.CommonProxy;
import biomesoplenty.init.ModBiomes;
import biomesoplenty.init.ModCompatibility;
import biomesoplenty.init.ModConfig;
import biomesoplenty.init.ModEntities;
import biomesoplenty.init.ModVanillaCompat;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.command.CommandSource;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.ServerProperties;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="biomesoplenty")
public class BiomesOPlenty {
    public static final String MOD_ID = "biomesoplenty";
    public static BiomesOPlenty instance;
    public static CommonProxy proxy;
    public static Logger logger;

    public BiomesOPlenty() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::dedicatedServerSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadComplete);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        ModConfig.setup();
    }

    public void dedicatedServerSetup(FMLDedicatedServerSetupEvent event) {
        ServerProperties serverProperties = ((DedicatedServer)event.getServerSupplier().get()).func_213221_d_();
        if (((Boolean)ModConfig.ServerConfig.useWorldType.get()).booleanValue()) {
            logger.info(String.format("Injecting biomesoplenty world type into server.properties. Original value: %s", serverProperties.field_219023_q.func_211888_a()));
            serverProperties.field_73672_b.setProperty("level-type", MOD_ID);
            serverProperties.field_219023_q = ModBiomes.worldType;
        } else {
            logger.info("Biomes O' Plenty is installed on this server but generation is disabled.");
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        ModBiomes.setup();
        ModVanillaCompat.setup();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        ModEntities.registerRendering();
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        proxy.init();
        ModCompatibility.setup();
    }

    public void serverStarting(FMLServerStartingEvent evt) {
        logger.info("Registering BoP commands...");
        new BOPCommand((CommandDispatcher<CommandSource>)evt.getCommandDispatcher());
    }

    static {
        proxy = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        logger = LogManager.getLogger((String)MOD_ID);
    }
}

