/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.util.biome;

import biomesoplenty.common.world.BOPWorldSettings;
import biomesoplenty.core.BiomesOPlenty;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;

public class BiomeUtil {
    public static int getBiomeSize(World world) {
        return BOPWorldSettings.BiomeSize.MEDIUM.getValue();
    }

    public static BlockPos spiralOutwardsLookingForBiome(World world, Biome biomeToFind, double startX, double startZ) {
        int sampleSpacing = 4 << BiomeUtil.getBiomeSize(world);
        int maxDist = sampleSpacing * 100;
        return BiomeUtil.spiralOutwardsLookingForBiome(world, biomeToFind, startX, startZ, maxDist, sampleSpacing);
    }

    public static BlockPos spiralOutwardsLookingForBiome(World world, Biome biomeToFind, double startX, double startZ, int maxDist, int sampleSpace) {
        if (maxDist <= 0 || sampleSpace <= 0) {
            throw new IllegalArgumentException("maxDist and sampleSpace must be positive");
        }
        BiomeProvider chunkManager = world.func_72863_F().func_201711_g().func_202090_b();
        double a = (double)sampleSpace / Math.sqrt(Math.PI);
        double b = 2.0 * Math.sqrt(Math.PI);
        double x = 0.0;
        double z = 0.0;
        double dist = 0.0;
        int n = 0;
        String biomeName = world.field_72995_K ? biomeToFind.func_205403_k().getString() : "biome";
        n = 0;
        while (dist < (double)maxDist) {
            double rootN = Math.sqrt(n);
            dist = a * rootN;
            x = startX + dist * Math.sin(b * rootN);
            Biome[] biomesAtSample = chunkManager.func_201537_a((int)x, (int)(z = startZ + dist * Math.cos(b * rootN)), 1, 1, false);
            if (biomesAtSample[0] == biomeToFind) {
                BiomesOPlenty.logger.info("Found " + biomeName + " after " + n + " samples, spaced " + sampleSpace + " blocks apart at (" + (int)x + "," + (int)z + ") distance " + (int)dist);
                return new BlockPos((int)x, 0, (int)z);
            }
            ++n;
        }
        BiomesOPlenty.logger.info("Failed to find " + biomeName + " gave up after " + n + " samples, spaced " + sampleSpace + " blocks apart distance " + (int)dist);
        return null;
    }
}

