/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.api.enums;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.INoiseRandom;
import net.minecraftforge.common.BiomeManager;

public enum BOPClimates {
    ICE_CAP(BiomeManager.BiomeType.ICY),
    TUNDRA(BiomeManager.BiomeType.ICY),
    WET_BOREAL(BiomeManager.BiomeType.COOL),
    DRY_BOREAL(BiomeManager.BiomeType.COOL),
    WET_TEMPERATE(BiomeManager.BiomeType.COOL),
    DRY_TEMPERATE(BiomeManager.BiomeType.WARM),
    COOL_TEMPERATE(BiomeManager.BiomeType.COOL),
    WARM_TEMPERATE(BiomeManager.BiomeType.WARM),
    SUBTROPICAL(BiomeManager.BiomeType.WARM),
    TROPICAL(BiomeManager.BiomeType.DESERT),
    MEDITERRANEAN(BiomeManager.BiomeType.WARM),
    SAVANNA(BiomeManager.BiomeType.DESERT),
    HOT_DESERT(BiomeManager.BiomeType.DESERT),
    WASTELAND(null),
    NETHER(null);

    public final BiomeManager.BiomeType biomeType;
    private int totalBiomesWeight;
    private int totalIslandBiomesWeight;
    private ArrayList<WeightedBiomeEntry> landBiomes = Lists.newArrayList();
    private ArrayList<WeightedBiomeEntry> islandBiomes = Lists.newArrayList();
    private static BOPClimates[] values;
    private static final BOPClimates[] climateMapping;

    private BOPClimates(BiomeManager.BiomeType biomeType) {
        this.biomeType = biomeType;
    }

    public BOPClimates addBiome(int weight, Biome biome) {
        return this.addBiome(new WeightedBiomeEntry(weight, biome));
    }

    public BOPClimates addBiome(WeightedBiomeEntry biomeEntry) {
        this.totalBiomesWeight += biomeEntry.weight;
        this.landBiomes.add(biomeEntry);
        return this;
    }

    public BOPClimates addIslandBiome(int weight, Biome biome) {
        return this.addIslandBiome(new WeightedBiomeEntry(weight, biome));
    }

    public BOPClimates addIslandBiome(WeightedBiomeEntry biomeEntry) {
        this.totalIslandBiomesWeight += biomeEntry.weight;
        this.islandBiomes.add(biomeEntry);
        return this;
    }

    public Biome getRandomBiome(INoiseRandom context, Biome fallback) {
        WeightedBiomeEntry item;
        if (this.totalBiomesWeight == 0) {
            return fallback;
        }
        int weight = context.func_202696_a(this.totalBiomesWeight);
        Iterator<WeightedBiomeEntry> iterator = this.landBiomes.iterator();
        do {
            item = iterator.next();
        } while ((weight -= item.weight) >= 0);
        return item.biome;
    }

    public Biome getRandomIslandBiome(INoiseRandom context, Biome fallback) {
        WeightedBiomeEntry item;
        if (this.totalIslandBiomesWeight == 0) {
            return fallback;
        }
        int weight = context.func_202696_a(this.totalIslandBiomesWeight);
        Iterator<WeightedBiomeEntry> iterator = this.islandBiomes.iterator();
        do {
            item = iterator.next();
        } while ((weight -= item.weight) >= 0);
        return item.biome;
    }

    public Biome getRandomOceanBiome(INoiseRandom context, boolean deep) {
        return deep ? Biomes.field_150575_M : Biomes.field_76771_b;
    }

    public ImmutableList<WeightedBiomeEntry> getLandBiomes() {
        return ImmutableList.copyOf(this.landBiomes);
    }

    public ImmutableList<WeightedBiomeEntry> getIslandBiomes() {
        return ImmutableList.copyOf(this.islandBiomes);
    }

    public static BOPClimates lookup(int i) {
        return values[i];
    }

    public static int[] getClimateMappingInts() {
        int[] out = new int[108];
        for (int i = 0; i < 108; ++i) {
            out[i] = climateMapping[i].ordinal();
        }
        return out;
    }

    public static void printWeights() {
        for (BOPClimates climate : BOPClimates.values()) {
            for (WeightedBiomeEntry entry : climate.landBiomes) {
                System.out.println(climate.name() + " " + entry.biome.func_205403_k() + " " + entry.weight);
            }
        }
    }

    static {
        ICE_CAP.addBiome(10, Biomes.field_76774_n);
        TUNDRA.addBiome(10, Biomes.field_150584_S).addBiome(7, Biomes.field_76770_e);
        WET_BOREAL.addBiome(10, Biomes.field_76768_g);
        DRY_BOREAL.addBiome(5, Biomes.field_150578_U);
        WET_TEMPERATE.addBiome(5, Biomes.field_150585_R).addBiome(7, Biomes.field_76780_h);
        DRY_TEMPERATE.addBiome(7, Biomes.field_150583_P);
        COOL_TEMPERATE.addBiome(10, Biomes.field_76767_f);
        WARM_TEMPERATE.addBiome(10, Biomes.field_76772_c);
        SUBTROPICAL.addBiome(1, Biomes.field_203615_U);
        TROPICAL.addBiome(15, Biomes.field_76782_w);
        MEDITERRANEAN.addBiome(1, Biomes.field_76772_c);
        SAVANNA.addBiome(10, Biomes.field_150588_X);
        HOT_DESERT.addBiome(15, Biomes.field_76769_d).addBiome(10, Biomes.field_150608_ab);
        WASTELAND.addBiome(1, Biomes.field_76769_d);
        NETHER.addBiome(10, Biomes.field_76778_j);
        values = BOPClimates.values();
        climateMapping = new BOPClimates[]{WET_BOREAL, TUNDRA, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, ICE_CAP, TUNDRA, DRY_BOREAL, WET_BOREAL, WET_BOREAL, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, TUNDRA, DRY_BOREAL, DRY_BOREAL, WET_TEMPERATE, WET_BOREAL, WET_BOREAL, WET_BOREAL, WET_BOREAL, WET_BOREAL, DRY_BOREAL, DRY_BOREAL, DRY_BOREAL, DRY_BOREAL, DRY_BOREAL, DRY_TEMPERATE, WET_TEMPERATE, WET_TEMPERATE, WET_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, DRY_TEMPERATE, DRY_TEMPERATE, DRY_TEMPERATE, WET_TEMPERATE, WET_TEMPERATE, WET_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, COOL_TEMPERATE, DRY_TEMPERATE, DRY_TEMPERATE, DRY_TEMPERATE, SUBTROPICAL, SUBTROPICAL, SUBTROPICAL, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, SAVANNA, SAVANNA, SAVANNA, TROPICAL, TROPICAL, SUBTROPICAL, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, WARM_TEMPERATE, SAVANNA, HOT_DESERT, HOT_DESERT, TROPICAL, TROPICAL, SUBTROPICAL, SUBTROPICAL, MEDITERRANEAN, MEDITERRANEAN, MEDITERRANEAN, MEDITERRANEAN, SAVANNA, SAVANNA, HOT_DESERT, HOT_DESERT, TROPICAL, TROPICAL, TROPICAL, SUBTROPICAL, MEDITERRANEAN, MEDITERRANEAN, MEDITERRANEAN, MEDITERRANEAN, SAVANNA, HOT_DESERT, HOT_DESERT, WASTELAND};
    }

    public static class WeightedBiomeEntry {
        public final int weight;
        public final Biome biome;

        public WeightedBiomeEntry(int weight, Biome biome) {
            this.weight = weight;
            this.biome = biome;
        }
    }
}

