/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.module;

import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.world.config.BiomeTypeConfig;
import vazkii.quark.world.gen.structure.BigDungeonStructure;

@LoadModule(category=ModuleCategory.WORLD)
public class BigDungeonModule
extends Module {
    public static Structure<NoFeatureConfig> structure;
    @Config(description="The chance that a big dungeon spawn candidate will be allowed to spawn. 0.2 is 20%, which is the same as the Pillager Outpost.")
    public static double spawnChance;
    @Config
    public static String lootTable;
    @Config
    public static int maxRooms;
    @Config
    public static double chestChance;
    @Config
    public static BiomeTypeConfig biomeTypes;

    @Override
    public void construct() {
        structure = new BigDungeonStructure();
        RegistryHelper.register(structure);
    }

    @Override
    public void setup() {
        if (this.enabled) {
            for (Biome b : ForgeRegistries.BIOMES.getValues()) {
                if (biomeTypes.canSpawn(b)) {
                    b.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, Biome.func_222280_a(structure, (IFeatureConfig)IFeatureConfig.field_202429_e, (Placement)Placement.field_215022_h, (IPlacementConfig)IPlacementConfig.field_202468_e));
                }
                b.func_201865_a(structure, (IFeatureConfig)NoFeatureConfig.field_202429_e);
            }
        }
    }

    static {
        spawnChance = 0.1;
        lootTable = "minecraft:chests/simple_dungeon";
        maxRooms = 10;
        chestChance = 0.5;
        biomeTypes = new BiomeTypeConfig(true, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.BEACH, BiomeDictionary.Type.NETHER, BiomeDictionary.Type.END);
    }
}

