/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.client.model;

import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.util.math.MathHelper;
import vazkii.quark.world.entity.FrogEntity;

public class FrogModel
extends EntityModel<FrogEntity> {
    public final RendererModel headTop;
    public final RendererModel headBottom;
    public final RendererModel body;
    public final RendererModel rightArm;
    public final RendererModel leftArm;
    public final RendererModel rightEye;
    public final RendererModel leftEye;

    public FrogModel() {
        this.field_78090_t = 64;
        this.field_78089_u = 32;
        this.rightArm = new RendererModel((Model)this, 33, 7);
        this.rightArm.field_78809_i = true;
        this.rightArm.func_78793_a(6.5f, 22.0f, 1.0f);
        this.rightArm.func_78790_a(-1.0f, -1.0f, -5.0f, 3, 3, 6, 0.0f);
        this.leftArm = new RendererModel((Model)this, 33, 7);
        this.leftArm.func_78793_a(-6.5f, 22.0f, 1.0f);
        this.leftArm.func_78790_a(-2.0f, -1.0f, -5.0f, 3, 3, 6, 0.0f);
        this.body = new RendererModel((Model)this, 0, 7);
        this.body.func_78793_a(0.0f, 20.0f, 0.0f);
        this.body.func_78790_a(-5.5f, -3.0f, 0.0f, 11, 7, 11, 0.0f);
        this.headTop = new RendererModel((Model)this, 0, 0);
        this.headTop.func_78793_a(0.0f, 18.0f, 0.0f);
        this.headTop.func_78790_a(-5.5f, -1.0f, -5.0f, 11, 2, 5, 0.0f);
        this.headBottom = new RendererModel((Model)this, 32, 0);
        this.headBottom.func_78793_a(0.0f, 18.0f, 0.0f);
        this.headBottom.func_78790_a(-5.5f, 1.0f, -5.0f, 11, 2, 5, 0.0f);
        this.rightEye = new RendererModel((Model)this, 0, 0);
        this.rightEye.field_78809_i = true;
        this.rightEye.func_78793_a(0.0f, 18.0f, 0.0f);
        this.rightEye.func_78790_a(1.5f, -1.5f, -4.0f, 1, 1, 1, 0.0f);
        this.leftEye = new RendererModel((Model)this, 0, 0);
        this.leftEye.func_78793_a(0.0f, 18.0f, 0.0f);
        this.leftEye.func_78790_a(-2.5f, -1.5f, -4.0f, 1, 1, 1, 0.0f);
    }

    public void setLivingAnimations(FrogEntity frog, float limbSwing, float limbSwingAmount, float partialTickTime) {
        int rawTalkTime = frog.getTalkTime();
        this.headBottom.field_78795_f = 0.02617994f;
        if (rawTalkTime != 0) {
            float talkTime = (float)rawTalkTime - partialTickTime;
            int speed = 10;
            this.headBottom.field_78795_f = (float)((double)this.headBottom.field_78795_f + 0.39269908169872414 * (double)(1.0f - MathHelper.func_76134_b((float)(talkTime * (float)Math.PI * 2.0f / (float)speed))));
        }
    }

    public void setRotationAngles(FrogEntity frog, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        this.rightArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 2.0f / 3.0f)) * 1.0f * limbSwingAmount;
        this.leftArm.field_78795_f = MathHelper.func_76134_b((float)(limbSwing * 2.0f / 3.0f)) * 1.0f * limbSwingAmount;
        this.rightEye.field_78795_f = this.leftEye.field_78795_f = (this.headTop.field_78795_f = headPitch * (float)Math.PI / 180.0f);
        this.headBottom.field_78795_f += headPitch * (float)Math.PI / 180.0f;
    }

    public void render(FrogEntity frog, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        GlStateManager.pushMatrix();
        float sizeModifier = frog.getSizeModifier();
        GlStateManager.translated((double)0.0, (double)(1.5 - (double)sizeModifier * 1.5), (double)0.0);
        GlStateManager.scalef((float)sizeModifier, (float)sizeModifier, (float)sizeModifier);
        if (this.field_217114_e) {
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)0.0, (double)0.6, (double)0.0);
            GlStateManager.scaled((double)0.625, (double)0.625, (double)0.625);
        }
        this.headTop.func_78785_a(scale);
        this.headBottom.func_78785_a(scale);
        this.rightEye.func_78785_a(scale);
        this.leftEye.func_78785_a(scale);
        if (this.field_217114_e) {
            GlStateManager.popMatrix();
            GlStateManager.scaled((double)0.5, (double)0.5, (double)0.5);
            GlStateManager.translated((double)0.0, (double)1.5, (double)0.0);
        }
        this.rightArm.func_78785_a(scale);
        this.leftArm.func_78785_a(scale);
        this.body.func_78785_a(scale);
        GlStateManager.popMatrix();
    }
}

