/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tools.module;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.base.module.Config;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.tools.client.render.PickarangRenderer;
import vazkii.quark.tools.entity.PickarangEntity;
import vazkii.quark.tools.item.PickarangItem;

@LoadModule(category=ModuleCategory.TOOLS)
public class PickarangModule
extends Module {
    public static EntityType<PickarangEntity> pickarangType;
    @Config(description="How long it takes before the pickarang starts returning to the player if it doesn't hit anything.")
    public static int timeout;
    @Config(description="2 is Iron, 3 is Diamond.")
    public static int harvestLevel;
    @Config(description="Set to -1 to have the Pickarang be unbreakable.")
    public static int durability;
    @Config(description="22.5 is ender chests, 25.0 is monster boxes, 50 is obsidian. Most things are below 5.")
    public static double maxHardness;
    @Config(description="Set this to true to use the recipe without the Heart of Diamond, even if the Heart of Diamond is enabled.", flag="pickarang_never_uses_heart")
    public static boolean neverUseHeartOfDiamond;
    @Config(description="Set this to true to disable the short cooldown between throwing pickarangs.")
    public static boolean noCooldown;
    public static Item pickarang;
    private static final ThreadLocal<PickarangEntity> ACTIVE_PICKARANG;

    @Override
    public void construct() {
        pickarangType = EntityType.Builder.func_220322_a(PickarangEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.4f, 0.4f).setTrackingRange(80).setUpdateInterval(3).setShouldReceiveVelocityUpdates(true).setCustomClientFactory((spawnEntity, world) -> new PickarangEntity((EntityType<? extends PickarangEntity>)pickarangType, (World)world)).func_206830_a("pickarang");
        RegistryHelper.register(pickarangType, (String)"pickarang");
        Item.Properties properties = new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78040_i).addToolType(ToolType.PICKAXE, harvestLevel).addToolType(ToolType.AXE, harvestLevel).addToolType(ToolType.SHOVEL, harvestLevel);
        if (durability > 0) {
            properties.func_200918_c(durability);
        }
        pickarang = new PickarangItem("pickarang", this, properties);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        RenderingRegistry.registerEntityRenderingHandler(PickarangEntity.class, PickarangRenderer::new);
    }

    public static void setActivePickarang(PickarangEntity pickarang) {
        ACTIVE_PICKARANG.set(pickarang);
    }

    public static DamageSource createDamageSource(PlayerEntity player) {
        PickarangEntity pickarang = ACTIVE_PICKARANG.get();
        if (pickarang == null) {
            return null;
        }
        return new IndirectEntityDamageSource("player", (Entity)pickarang, (Entity)player).func_76349_b();
    }

    static {
        timeout = 20;
        harvestLevel = 3;
        durability = 800;
        maxHardness = 20.0;
        neverUseHeartOfDiamond = false;
        noCooldown = false;
        ACTIVE_PICKARANG = new ThreadLocal();
    }
}

